/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

public abstract class KernelBase {
    public int width;
    public int offset;

    protected KernelBase(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Kernel width must be greater than zero not " + width);
        }
        this.width = width;
        this.offset = width / 2;
    }

    protected KernelBase(int width, int offset) {
        if (width <= 0) {
            throw new IllegalArgumentException("Kernel width must be greater than zero not " + width);
        }
        if (offset < 0 || offset >= width) {
            throw new IllegalArgumentException("The offset must be inside the kernel's bounds. o=" + offset + " w=" + width);
        }
        this.width = width;
        this.offset = offset;
    }

    protected KernelBase() {
    }

    public int getWidth() {
        return this.width;
    }

    public int getRadius() {
        return this.width / 2;
    }

    public int getOffset() {
        return this.offset;
    }

    public abstract int getDimension();

    public abstract boolean isInteger();

    public abstract <T extends KernelBase> T copy();
}

