/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import boofcv.struct.Point3dRgbI_F64;
import georegression.struct.point.Point3D_F64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class PlyCodec_F64 {
    public static void saveAscii(List<Point3D_F64> cloud, Writer outputWriter) throws IOException {
        outputWriter.write("ply\n");
        outputWriter.write("format ascii 1.0\n");
        outputWriter.write("comment Created using BoofCV!\n");
        outputWriter.write("element vertex " + cloud.size() + "\nproperty float x\nproperty float y\nproperty float z\nend_header\n");
        for (int i = 0; i < cloud.size(); ++i) {
            Point3D_F64 p = cloud.get(i);
            outputWriter.write(String.format("%f %f %f\n", p.x, p.y, p.z));
        }
        outputWriter.flush();
    }

    public static void read(Reader inputReader, FastQueue<Point3D_F64> output) throws IOException {
        BufferedReader reader = new BufferedReader(inputReader);
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Missing first line");
        }
        if (line.compareToIgnoreCase("ply") != 0) {
            throw new IOException("Expected PLY at start of file");
        }
        int vertexCount = -1;
        boolean ascii = false;
        line = PlyCodec_F64.readNextPly(reader, true);
        while (line != null && !line.equals("end_header")) {
            String[] words = line.split("\\s+");
            if (words.length == 1) {
                throw new IOException("Expected more than one word");
            }
            if (line.startsWith("format")) {
                ascii = words[1].equals("ascii");
            } else if (line.startsWith("element")) {
                if (words[1].equals("vertex")) {
                    vertexCount = Integer.parseInt(words[2]);
                }
            } else if (!words[0].equals("property")) {
                throw new IOException("Unknown header element");
            }
            line = PlyCodec_F64.readNextPly(reader, true);
        }
        if (vertexCount == -1) {
            throw new IOException("File is missing vertex count");
        }
        if (!ascii) {
            throw new IllegalArgumentException("Currently only ASCII format is supported");
        }
        output.growArray(((Point3D_F64[])output.data).length + vertexCount);
        for (int i = 0; i < vertexCount; ++i) {
            line = PlyCodec_F64.readNextPly(reader, true);
            String[] words = line.split("\\s+");
            Point3D_F64 p = output.grow();
            p.x = Double.parseDouble(words[0]);
            p.y = Double.parseDouble(words[1]);
            p.z = Double.parseDouble(words[2]);
        }
    }

    private static String readNextPly(BufferedReader reader, boolean failIfNull) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("comment")) {
                line = reader.readLine();
                continue;
            }
            return line;
        }
        if (failIfNull) {
            throw new IOException("Unexpected end of file");
        }
        return null;
    }

    public static void saveAsciiRgbI(List<Point3dRgbI_F64> cloud, Writer outputWriter) throws IOException {
        outputWriter.write("ply\n");
        outputWriter.write("format ascii 1.0\n");
        outputWriter.write("comment Created using BoofCV!\n");
        outputWriter.write("element vertex " + cloud.size() + "\nproperty float x\nproperty float y\nproperty float z\nproperty uchar red\nproperty uchar green\nproperty uchar blue\nend_header\n");
        for (int i = 0; i < cloud.size(); ++i) {
            Point3dRgbI_F64 p = cloud.get(i);
            int r = p.rgb >> 16 & 0xFF;
            int g = p.rgb >> 8 & 0xFF;
            int b = p.rgb & 0xFF;
            outputWriter.write(String.format("%f %f %f %d %d %d\n", p.x, p.y, p.z, r, g, b));
        }
        outputWriter.flush();
    }

    public static void readRgbI(Reader inputReader, FastQueue<Point3dRgbI_F64> output) throws IOException {
        BufferedReader reader = new BufferedReader(inputReader);
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Missing first line");
        }
        if (line.compareToIgnoreCase("ply") != 0) {
            throw new IOException("Expected PLY at start of file");
        }
        int vertexCount = -1;
        boolean ascii = false;
        boolean rgb = false;
        line = PlyCodec_F64.readNextPly(reader, true);
        while (line != null && !line.equals("end_header")) {
            String[] words = line.split("\\s+");
            if (words.length == 1) {
                throw new IOException("Expected more than one word");
            }
            if (line.startsWith("format")) {
                ascii = words[1].equals("ascii");
            } else if (line.startsWith("element")) {
                if (words[1].equals("vertex")) {
                    vertexCount = Integer.parseInt(words[2]);
                }
            } else if (words[0].equals("property")) {
                if (words[2].equals("red")) {
                    rgb = true;
                }
            } else {
                throw new IOException("Unknown header element");
            }
            line = PlyCodec_F64.readNextPly(reader, true);
        }
        if (vertexCount == -1) {
            throw new IOException("File is missing vertex count");
        }
        if (!ascii) {
            throw new IllegalArgumentException("Currently only ASCII format is supported");
        }
        output.growArray(((Point3dRgbI_F64[])output.data).length + vertexCount);
        for (int i = 0; i < vertexCount; ++i) {
            line = PlyCodec_F64.readNextPly(reader, true);
            String[] words = line.split("\\s+");
            if (words.length != (rgb ? 6 : 3)) {
                throw new IOException("unexpected number of words. " + line);
            }
            Point3dRgbI_F64 p = output.grow();
            p.x = Double.parseDouble(words[0]);
            p.y = Double.parseDouble(words[1]);
            p.z = Double.parseDouble(words[2]);
            if (!rgb) continue;
            int r = Integer.parseInt(words[3]);
            int g = Integer.parseInt(words[4]);
            int b = Integer.parseInt(words[3]);
            p.rgb = r << 16 | g << 8 | b;
        }
    }
}

