/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points;

import boofcv.io.points.impl.PlyCodec_F32;
import boofcv.io.points.impl.PlyCodec_F64;
import boofcv.struct.Point3dRgbI_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nullable;
import org.ddogleg.struct.FastQueue;

public class PointCloudIO {
    public static void save3D32F(Format format, List<Point3D_F32> cloud, Writer writer) throws IOException {
        switch (format) {
            case PLY_ASCII: {
                PlyCodec_F32.saveAscii(cloud, writer);
                break;
            }
            case PLY_BINARY: {
                throw new IllegalArgumentException("Not yet supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + (Object)((Object)format));
            }
        }
    }

    public static void save3D64F(Format format, List<Point3D_F64> cloud, Writer writer) throws IOException {
        switch (format) {
            case PLY_ASCII: {
                PlyCodec_F64.saveAscii(cloud, writer);
                break;
            }
            case PLY_BINARY: {
                throw new IllegalArgumentException("Not yet supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + (Object)((Object)format));
            }
        }
    }

    public static void save3DRgbI64F(Format format, List<Point3dRgbI_F64> cloud, Writer writer) throws IOException {
        switch (format) {
            case PLY_ASCII: {
                PlyCodec_F64.saveAsciiRgbI(cloud, writer);
                break;
            }
            case PLY_BINARY: {
                throw new IllegalArgumentException("Not yet supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + (Object)((Object)format));
            }
        }
    }

    public static FastQueue<Point3D_F32> load3D32F(Format format, Reader reader, @Nullable FastQueue<Point3D_F32> storage) throws IOException {
        if (storage == null) {
            storage = new FastQueue<Point3D_F32>(Point3D_F32.class, true);
        }
        switch (format) {
            case PLY_ASCII: {
                PlyCodec_F32.read(reader, storage);
                break;
            }
            case PLY_BINARY: {
                throw new IllegalArgumentException("Not yet supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + (Object)((Object)format));
            }
        }
        return storage;
    }

    public static FastQueue<Point3D_F64> load3D64F(Format format, Reader reader, @Nullable FastQueue<Point3D_F64> storage) throws IOException {
        if (storage == null) {
            storage = new FastQueue<Point3D_F64>(Point3D_F64.class, true);
        }
        switch (format) {
            case PLY_ASCII: {
                PlyCodec_F64.read(reader, storage);
                break;
            }
            case PLY_BINARY: {
                throw new IllegalArgumentException("Not yet supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + (Object)((Object)format));
            }
        }
        return storage;
    }

    public static FastQueue<Point3dRgbI_F64> load3DRgb64F(Format format, Reader reader, @Nullable FastQueue<Point3dRgbI_F64> storage) throws IOException {
        if (storage == null) {
            storage = new FastQueue<Point3dRgbI_F64>(Point3dRgbI_F64.class, true);
        }
        switch (format) {
            case PLY_ASCII: {
                PlyCodec_F64.readRgbI(reader, storage);
                break;
            }
            case PLY_BINARY: {
                throw new IllegalArgumentException("Not yet supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + (Object)((Object)format));
            }
        }
        return storage;
    }

    public static enum Format {
        PLY_ASCII,
        PLY_BINARY;

    }
}

