/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii.impl;

import boofcv.alg.transform.ii.SparseIntegralGradient_NoBorder;
import boofcv.struct.image.GrayF32;
import boofcv.struct.sparse.GradientValue_F32;

public class SparseIntegralGradient_NoBorder_F32
extends SparseIntegralGradient_NoBorder<GrayF32, GradientValue_F32> {
    private GradientValue_F32 ret = new GradientValue_F32();

    @Override
    public void setWidth(double width) {
        super.setWidth(width);
        this.x0 = this.y0 = -this.r - 1;
        this.x1 = this.y1 = this.r;
    }

    @Override
    public GradientValue_F32 compute(int x, int y) {
        int horizontalOffset = x - this.r - 1;
        int indexSrc1 = ((GrayF32)this.input).startIndex + (y - this.r - 1) * ((GrayF32)this.input).stride + horizontalOffset;
        int indexSrc2 = indexSrc1 + this.r * ((GrayF32)this.input).stride;
        int indexSrc3 = indexSrc2 + ((GrayF32)this.input).stride;
        int indexSrc4 = indexSrc3 + this.r * ((GrayF32)this.input).stride;
        float p0 = ((GrayF32)this.input).data[indexSrc1];
        float p1 = ((GrayF32)this.input).data[indexSrc1 + this.r];
        float p2 = ((GrayF32)this.input).data[indexSrc1 + this.r + 1];
        float p3 = ((GrayF32)this.input).data[indexSrc1 + this.w];
        float p11 = ((GrayF32)this.input).data[indexSrc2];
        float p4 = ((GrayF32)this.input).data[indexSrc2 + this.w];
        float p10 = ((GrayF32)this.input).data[indexSrc3];
        float p5 = ((GrayF32)this.input).data[indexSrc3 + this.w];
        float p9 = ((GrayF32)this.input).data[indexSrc4];
        float p8 = ((GrayF32)this.input).data[indexSrc4 + this.r];
        float p7 = ((GrayF32)this.input).data[indexSrc4 + this.r + 1];
        float p6 = ((GrayF32)this.input).data[indexSrc4 + this.w];
        float left = p8 - p9 - p1 + p0;
        float right = p6 - p7 - p3 + p2;
        float top = p4 - p11 - p3 + p0;
        float bottom = p6 - p9 - p5 + p10;
        this.ret.x = right - left;
        this.ret.y = bottom - top;
        return this.ret;
    }

    @Override
    public Class<GradientValue_F32> getGradientType() {
        return GradientValue_F32.class;
    }
}

