/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.alg.geo.robust.ModelMatcherMultiview;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.factory.geo.ConfigEssential;
import boofcv.factory.geo.ConfigFundamental;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;
import java.io.PrintStream;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.Stoppable;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;

public class PairwiseImageMatching<T extends ImageBase<T>>
implements Stoppable {
    private volatile boolean stopRequested = false;
    protected double MIN_ASSOCIATE_FRACTION = 0.05;
    protected int MIN_FEATURE_ASSOCIATED = 30;
    protected DetectDescribePoint<T, TupleDesc> detDesc;
    protected AssociateDescription<TupleDesc> associate;
    protected PairwiseImageGraph graph = new PairwiseImageGraph();
    protected ConfigRansac configRansac = new ConfigRansac();
    protected ConfigEssential configEssential = new ConfigEssential();
    protected ConfigFundamental configFundamental = new ConfigFundamental();
    protected FastQueue<AssociatedPair> pairs = new FastQueue<AssociatedPair>(AssociatedPair.class, true);
    protected ModelMatcherMultiview<DMatrixRMaj, AssociatedPair> ransacEssential;
    protected ModelMatcher<DMatrixRMaj, AssociatedPair> ransacFundamental;
    protected PrintStream verbose;
    protected int verboseLevel;

    public PairwiseImageMatching(DetectDescribePoint<T, TupleDesc> detDesc, AssociateDescription<TupleDesc> associate) {
        this();
        this.detDesc = detDesc;
        this.associate = associate;
    }

    protected PairwiseImageMatching() {
        this.configRansac.inlierThreshold = 2.5;
        this.configRansac.maxIterations = 4000;
    }

    protected void declareModelFitting() {
        this.ransacEssential = FactoryMultiViewRobust.essentialRansac(this.configEssential, this.configRansac);
        this.ransacFundamental = FactoryMultiViewRobust.fundamentalRansac(this.configFundamental, this.configRansac);
    }

    public void configure(int minFeatureAssociate, double minFeatureAssociateFraction) {
        this.MIN_ASSOCIATE_FRACTION = minFeatureAssociateFraction;
        this.MIN_FEATURE_ASSOCIATED = minFeatureAssociate;
    }

    public void addCamera(String cameraName) {
        this.addCamera(cameraName, null, null);
    }

    public void addCamera(String cameraName, Point2Transform2_F64 pixelToNorm, CameraPinhole pinhole) {
        this.graph.cameras.put(cameraName, new PairwiseImageGraph.Camera(cameraName, pixelToNorm, pinhole));
    }

    public void addImage(T image, String cameraName) {
        Point2D_F64 p;
        int i;
        PairwiseImageGraph.View view = new PairwiseImageGraph.View(this.graph.nodes.size(), new FastQueue<TupleDesc>(TupleDesc.class, true){

            @Override
            protected TupleDesc createInstance() {
                return PairwiseImageMatching.this.detDesc.createDescription();
            }
        });
        view.camera = this.graph.cameras.get(cameraName);
        if (view.camera == null) {
            throw new IllegalArgumentException("Must have added the camera first");
        }
        view.index = this.graph.nodes.size();
        this.graph.nodes.add(view);
        this.detDesc.detect(image);
        view.descriptions.growArray(this.detDesc.getNumberOfFeatures());
        view.observationPixels.growArray(this.detDesc.getNumberOfFeatures());
        for (i = 0; i < this.detDesc.getNumberOfFeatures(); ++i) {
            p = this.detDesc.getLocation(i);
            view.descriptions.grow().setTo(this.detDesc.getDescription(i));
            view.observationPixels.grow().set(p);
        }
        if (view.camera.pixelToNorm == null) {
            return;
        }
        view.observationNorm.growArray(this.detDesc.getNumberOfFeatures());
        for (i = 0; i < view.observationPixels.size; ++i) {
            p = view.observationPixels.get(i);
            view.camera.pixelToNorm.compute(p.x, p.y, view.observationNorm.grow());
        }
        if (this.verbose != null) {
            this.verbose.println("Detected Features: " + this.detDesc.getNumberOfFeatures());
        }
    }

    public boolean process() {
        if (this.graph.nodes.size() < 2) {
            return false;
        }
        this.stopRequested = false;
        this.declareModelFitting();
        for (int i = 0; i < this.graph.nodes.size(); ++i) {
            if (this.verbose != null) {
                this.verbose.print("Matching node " + i + " -> ");
            }
            this.associate.setSource(this.graph.nodes.get((int)i).descriptions);
            for (int j = i + 1; j < this.graph.nodes.size(); ++j) {
                this.associate.setDestination(this.graph.nodes.get((int)j).descriptions);
                this.associate.associate();
                if (this.associate.getMatches().size < this.MIN_FEATURE_ASSOCIATED) continue;
                boolean connected = this.connectViews(this.graph.nodes.get(i), this.graph.nodes.get(j), this.associate.getMatches());
                if (this.verbose != null) {
                    if (connected) {
                        this.verbose.print("+");
                    } else {
                        this.verbose.print("-");
                    }
                }
                if (!this.stopRequested) continue;
                return false;
            }
            if (this.verbose == null) continue;
            this.verbose.println();
        }
        return this.graph.edges.size() >= 1;
    }

    public PairwiseImageGraph getGraph() {
        return this.graph;
    }

    protected boolean connectViews(PairwiseImageGraph.View viewA, PairwiseImageGraph.View viewB, FastQueue<AssociatedIndex> matches) {
        double fractionB;
        int inliersEpipolar;
        PairwiseImageGraph.Motion edge = new PairwiseImageGraph.Motion();
        CameraPinhole pinhole0 = viewA.camera.pinhole;
        CameraPinhole pinhole1 = viewB.camera.pinhole;
        if (pinhole0 != null && pinhole1 != null) {
            this.ransacEssential.setIntrinsic(0, pinhole0);
            this.ransacEssential.setIntrinsic(1, pinhole1);
            if (!this.fitEpipolar(matches, viewA.observationNorm.toList(), viewB.observationNorm.toList(), this.ransacEssential, edge)) {
                if (this.verbose != null && this.verboseLevel >= 1) {
                    this.verbose.println(" fit essential failed");
                }
                return false;
            }
            edge.metric = true;
            inliersEpipolar = this.ransacEssential.getMatchSet().size();
            edge.F.set((DMatrixD1)this.ransacEssential.getModelParameters());
        } else if (this.fitEpipolar(matches, viewA.observationPixels.toList(), viewB.observationPixels.toList(), this.ransacFundamental, edge)) {
            edge.metric = false;
            inliersEpipolar = this.ransacFundamental.getMatchSet().size();
            edge.F.set(this.ransacFundamental.getModelParameters());
        } else {
            if (this.verbose != null && this.verboseLevel >= 1) {
                this.verbose.println(" fit fundamental failed");
            }
            return false;
        }
        if (inliersEpipolar < this.MIN_FEATURE_ASSOCIATED) {
            if (this.verbose != null && this.verboseLevel >= 1) {
                this.verbose.println(" too too few inliers. " + inliersEpipolar + " min=" + this.MIN_FEATURE_ASSOCIATED + " obsA=" + viewA.observationNorm.size + " obsB=" + viewB.observationNorm.size);
            }
            return false;
        }
        double fractionA = (double)inliersEpipolar / (double)viewA.descriptions.size;
        if (fractionA < this.MIN_ASSOCIATE_FRACTION | (fractionB = (double)inliersEpipolar / (double)viewB.descriptions.size) < this.MIN_ASSOCIATE_FRACTION) {
            return false;
        }
        edge.viewSrc = viewA;
        edge.viewDst = viewB;
        edge.index = this.graph.edges.size();
        viewA.connections.add(edge);
        viewB.connections.add(edge);
        this.graph.edges.add(edge);
        return true;
    }

    boolean fitEpipolar(FastQueue<AssociatedIndex> matches, List<Point2D_F64> pointsA, List<Point2D_F64> pointsB, ModelMatcher<?, AssociatedPair> ransac, PairwiseImageGraph.Motion edge) {
        this.pairs.resize(matches.size);
        for (int i = 0; i < matches.size; ++i) {
            AssociatedIndex a = matches.get(i);
            this.pairs.get((int)i).p1.set(pointsA.get(a.src));
            this.pairs.get((int)i).p2.set(pointsB.get(a.dst));
        }
        if (!ransac.process(this.pairs.toList())) {
            return false;
        }
        int N = ransac.getMatchSet().size();
        for (int i = 0; i < N; ++i) {
            AssociatedIndex a = matches.get(ransac.getInputIndex(i));
            edge.associated.add(a.copy());
        }
        return true;
    }

    @Override
    public void requestStop() {
        this.stopRequested = true;
    }

    @Override
    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public Class<TupleDesc> getDescriptionType() {
        return this.detDesc.getDescriptionType();
    }

    public ConfigEssential getConfigEssential() {
        return this.configEssential;
    }

    public ConfigFundamental getConfigFundamental() {
        return this.configFundamental;
    }

    public ConfigRansac getConfigRansac() {
        return this.configRansac;
    }

    public void reset() {
        this.graph = new PairwiseImageGraph();
    }

    public void setVerbose(PrintStream verbose, int level) {
        this.verbose = verbose;
        this.verboseLevel = level;
    }
}

