/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc.impl;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_F64;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.border.ImageBorder_S64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;

public class ImplImageMiscOps {
    public static <T extends GrayI8<T>> void growBorder(T src, ImageBorder_S32<T> border, int borderX0, int borderY0, int borderX1, int borderY1, T dst) {
        int x;
        int idxDst;
        int y;
        dst.reshape(src.width + borderX0 + borderX1, src.height + borderY0 + borderY1);
        border.setImage(src);
        ImageMiscOps.copy(0, 0, borderX0, borderY0, src.width, src.height, src, dst);
        for (y = 0; y < borderY0; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = (byte)border.get(x - borderX0, y - borderY0);
            }
        }
        for (y = 0; y < borderY1; ++y) {
            idxDst = dst.startIndex + (dst.height - borderY1 + y) * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = (byte)border.get(x - borderX0, src.height + y);
            }
        }
        for (y = borderY0; y < dst.height - borderY1; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < borderX0; ++x) {
                dst.data[idxDst++] = (byte)border.get(x - borderX0, y - borderY0);
            }
            idxDst = dst.startIndex + y * dst.stride + src.width + borderX0;
            for (x = 0; x < borderX1; ++x) {
                dst.data[idxDst++] = (byte)border.get(src.width + x, y - borderY0);
            }
        }
    }

    public static <T extends GrayI16<T>> void growBorder(T src, ImageBorder_S32<T> border, int borderX0, int borderY0, int borderX1, int borderY1, T dst) {
        int x;
        int idxDst;
        int y;
        dst.reshape(src.width + borderX0 + borderX1, src.height + borderY0 + borderY1);
        border.setImage(src);
        ImageMiscOps.copy(0, 0, borderX0, borderY0, src.width, src.height, src, dst);
        for (y = 0; y < borderY0; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = (short)border.get(x - borderX0, y - borderY0);
            }
        }
        for (y = 0; y < borderY1; ++y) {
            idxDst = dst.startIndex + (dst.height - borderY1 + y) * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = (short)border.get(x - borderX0, src.height + y);
            }
        }
        for (y = borderY0; y < dst.height - borderY1; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < borderX0; ++x) {
                dst.data[idxDst++] = (short)border.get(x - borderX0, y - borderY0);
            }
            idxDst = dst.startIndex + y * dst.stride + src.width + borderX0;
            for (x = 0; x < borderX1; ++x) {
                dst.data[idxDst++] = (short)border.get(src.width + x, y - borderY0);
            }
        }
    }

    public static void growBorder(GrayS32 src, ImageBorder_S32 border, int borderX0, int borderY0, int borderX1, int borderY1, GrayS32 dst) {
        int x;
        int idxDst;
        int y;
        dst.reshape(src.width + borderX0 + borderX1, src.height + borderY0 + borderY1);
        border.setImage(src);
        ImageMiscOps.copy(0, 0, borderX0, borderY0, src.width, src.height, src, dst);
        for (y = 0; y < borderY0; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, y - borderY0);
            }
        }
        for (y = 0; y < borderY1; ++y) {
            idxDst = dst.startIndex + (dst.height - borderY1 + y) * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, src.height + y);
            }
        }
        for (y = borderY0; y < dst.height - borderY1; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < borderX0; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, y - borderY0);
            }
            idxDst = dst.startIndex + y * dst.stride + src.width + borderX0;
            for (x = 0; x < borderX1; ++x) {
                dst.data[idxDst++] = border.get(src.width + x, y - borderY0);
            }
        }
    }

    public static void growBorder(GrayS64 src, ImageBorder_S64 border, int borderX0, int borderY0, int borderX1, int borderY1, GrayS64 dst) {
        int x;
        int idxDst;
        int y;
        dst.reshape(src.width + borderX0 + borderX1, src.height + borderY0 + borderY1);
        border.setImage(src);
        ImageMiscOps.copy(0, 0, borderX0, borderY0, src.width, src.height, src, dst);
        for (y = 0; y < borderY0; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, y - borderY0);
            }
        }
        for (y = 0; y < borderY1; ++y) {
            idxDst = dst.startIndex + (dst.height - borderY1 + y) * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, src.height + y);
            }
        }
        for (y = borderY0; y < dst.height - borderY1; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < borderX0; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, y - borderY0);
            }
            idxDst = dst.startIndex + y * dst.stride + src.width + borderX0;
            for (x = 0; x < borderX1; ++x) {
                dst.data[idxDst++] = border.get(src.width + x, y - borderY0);
            }
        }
    }

    public static void growBorder(GrayF32 src, ImageBorder_F32 border, int borderX0, int borderY0, int borderX1, int borderY1, GrayF32 dst) {
        int x;
        int idxDst;
        int y;
        dst.reshape(src.width + borderX0 + borderX1, src.height + borderY0 + borderY1);
        border.setImage(src);
        ImageMiscOps.copy(0, 0, borderX0, borderY0, src.width, src.height, src, dst);
        for (y = 0; y < borderY0; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, y - borderY0);
            }
        }
        for (y = 0; y < borderY1; ++y) {
            idxDst = dst.startIndex + (dst.height - borderY1 + y) * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, src.height + y);
            }
        }
        for (y = borderY0; y < dst.height - borderY1; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < borderX0; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, y - borderY0);
            }
            idxDst = dst.startIndex + y * dst.stride + src.width + borderX0;
            for (x = 0; x < borderX1; ++x) {
                dst.data[idxDst++] = border.get(src.width + x, y - borderY0);
            }
        }
    }

    public static void growBorder(GrayF64 src, ImageBorder_F64 border, int borderX0, int borderY0, int borderX1, int borderY1, GrayF64 dst) {
        int x;
        int idxDst;
        int y;
        dst.reshape(src.width + borderX0 + borderX1, src.height + borderY0 + borderY1);
        border.setImage(src);
        ImageMiscOps.copy(0, 0, borderX0, borderY0, src.width, src.height, src, dst);
        for (y = 0; y < borderY0; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, y - borderY0);
            }
        }
        for (y = 0; y < borderY1; ++y) {
            idxDst = dst.startIndex + (dst.height - borderY1 + y) * dst.stride;
            for (x = 0; x < dst.width; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, src.height + y);
            }
        }
        for (y = borderY0; y < dst.height - borderY1; ++y) {
            idxDst = dst.startIndex + y * dst.stride;
            for (x = 0; x < borderX0; ++x) {
                dst.data[idxDst++] = border.get(x - borderX0, y - borderY0);
            }
            idxDst = dst.startIndex + y * dst.stride + src.width + borderX0;
            for (x = 0; x < borderX1; ++x) {
                dst.data[idxDst++] = border.get(src.width + x, y - borderY0);
            }
        }
    }
}

