/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.struct.geo.AssociatedPair;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class DistanceHomographySq
implements DistanceFromModel<Homography2D_F64, AssociatedPair> {
    Homography2D_F64 model;
    Point2D_F64 expected = new Point2D_F64();

    @Override
    public void setModel(Homography2D_F64 model) {
        this.model = model;
    }

    @Override
    public double computeDistance(AssociatedPair pt) {
        HomographyPointOps_F64.transform(this.model, pt.p1, this.expected);
        return this.expected.distance2(pt.p2);
    }

    @Override
    public void computeDistance(List<AssociatedPair> points, double[] distance) {
        for (int i = 0; i < points.size(); ++i) {
            AssociatedPair p = points.get(i);
            HomographyPointOps_F64.transform(this.model, p.p1, this.expected);
            distance[i] = this.expected.distance2(p.p2);
        }
    }

    @Override
    public Class<AssociatedPair> getPointType() {
        return AssociatedPair.class;
    }

    @Override
    public Class<Homography2D_F64> getModelType() {
        return Homography2D_F64.class;
    }
}

