/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.filter.binary.ComputeOtsu;
import boofcv.alg.filter.binary.ThresholdBlock;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedS32;
import java.util.Arrays;

public class ThresholdBlockOtsu
implements ThresholdBlock.BlockProcessor<GrayU8, InterleavedS32> {
    int[] histogram = new int[256];
    ComputeOtsu otsu;
    protected int blockWidth;
    protected int blockHeight;
    protected boolean thresholdFromLocalBlocks;

    public ThresholdBlockOtsu(boolean otsu2, double tuning, double scale, boolean down) {
        this.otsu = new ComputeOtsu(otsu2, tuning, down, scale);
    }

    @Override
    public InterleavedS32 createStats() {
        return new InterleavedS32(1, 1, 256);
    }

    @Override
    public void init(int blockWidth, int blockHeight, boolean thresholdFromLocalBlocks) {
        this.blockWidth = blockWidth;
        this.blockHeight = blockHeight;
        this.thresholdFromLocalBlocks = thresholdFromLocalBlocks;
    }

    @Override
    public void computeBlockStatistics(int x0, int y0, int width, int height, int indexStats, GrayU8 input, InterleavedS32 stats) {
        Arrays.fill(stats.data, indexStats, indexStats + 256, 0);
        for (int y = 0; y < height; ++y) {
            int indexInput = input.startIndex + (y0 + y) * input.stride + x0;
            int end = indexInput + width;
            while (indexInput < end) {
                int n = indexStats + (input.data[indexInput++] & 0xFF);
                stats.data[n] = stats.data[n] + 1;
            }
        }
    }

    @Override
    public void thresholdBlock(int blockX0, int blockY0, GrayU8 input, InterleavedS32 stats, GrayU8 output) {
        byte b;
        byte a;
        int blockY1;
        int blockX1;
        int y1;
        int x0 = blockX0 * this.blockWidth;
        int y0 = blockY0 * this.blockHeight;
        int x1 = blockX0 == stats.width - 1 ? input.width : (blockX0 + 1) * this.blockWidth;
        int n = y1 = blockY0 == stats.height - 1 ? input.height : (blockY0 + 1) * this.blockHeight;
        if (this.thresholdFromLocalBlocks) {
            blockX1 = Math.min(stats.width - 1, blockX0 + 1);
            blockY1 = Math.min(stats.height - 1, blockY0 + 1);
            blockX0 = Math.max(0, blockX0 - 1);
            blockY0 = Math.max(0, blockY0 - 1);
        } else {
            blockX1 = blockX0;
            blockY1 = blockY0;
        }
        Arrays.fill(this.histogram, 0, this.histogram.length, 0);
        for (int y = blockY0; y <= blockY1; ++y) {
            for (int x = blockX0; x <= blockX1; ++x) {
                int indexStats = stats.getIndex(x, y, 0);
                for (int i = 0; i < 256; ++i) {
                    int n2 = i;
                    this.histogram[n2] = this.histogram[n2] + stats.data[indexStats + i];
                }
            }
        }
        int total = 0;
        for (int i = 0; i < this.histogram.length; ++i) {
            total += this.histogram[i];
        }
        this.otsu.compute(this.histogram, this.histogram.length, total);
        if (this.otsu.down) {
            a = 1;
            b = 0;
        } else {
            a = 0;
            b = 1;
        }
        for (int y = y0; y < y1; ++y) {
            int indexInput = input.startIndex + y * input.stride + x0;
            int indexOutput = output.startIndex + y * output.stride + x0;
            int end = indexOutput + (x1 - x0);
            while (indexOutput < end) {
                output.data[indexOutput] = (double)(input.data[indexInput] & 0xFF) <= this.otsu.threshold ? a : b;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    @Override
    public ThresholdBlock.BlockProcessor<GrayU8, InterleavedS32> copy() {
        return new ThresholdBlockOtsu(this.otsu.isUseOtsu2(), this.otsu.getTuning(), this.otsu.getScale(), this.otsu.down);
    }
}

