/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.geo.h.HomographyDirectLinearTransform;
import boofcv.alg.geo.robust.GenerateHomographyLinear;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedPair3D;
import georegression.struct.ConvertFloatType;
import georegression.struct.homography.Homography2D_F32;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.transform.homography.HomographyPointOps_F32;
import georegression.transform.homography.HomographyPointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrixRMaj;

public class QrCodeBinaryGridToPixel {
    ModelGenerator<Homography2D_F64, AssociatedPair> generator = new GenerateHomographyLinear(true);
    HomographyDirectLinearTransform dlt = new HomographyDirectLinearTransform(true);
    FastQueue<AssociatedPair> storagePairs2D = new FastQueue<AssociatedPair>(AssociatedPair.class, true);
    FastQueue<AssociatedPair3D> storagePairs3D = new FastQueue<AssociatedPair3D>(AssociatedPair3D.class, true);
    List<AssociatedPair> pairs2D = new ArrayList<AssociatedPair>();
    FastQueue<Point2D_F64> adjustments = new FastQueue<Point2D_F64>(Point2D_F64.class, true);
    Homography2D_F64 H = new Homography2D_F64();
    Homography2D_F64 Hinv = new Homography2D_F64();
    Homography2D_F32 Hinv32 = new Homography2D_F32();
    Homography2D_F32 H32 = new Homography2D_F32();
    Point2D_F64 tmp64 = new Point2D_F64();
    boolean adjustWithFeatures;

    public void setTransformFromSquare(Polygon2D_F64 square) {
        this.adjustWithFeatures = false;
        this.storagePairs2D.reset();
        this.pairs2D.clear();
        this.set(0.0f, 0.0f, square, 0);
        this.set(0.0f, 7.0f, square, 1);
        this.set(7.0f, 7.0f, square, 2);
        this.set(7.0f, 0.0f, square, 3);
        this.computeTransform();
    }

    public void setTransformFromLinesSquare(QrCode qr) {
        this.storagePairs2D.reset();
        this.storagePairs3D.reset();
        this.set(0.0f, 7.0f, qr.ppCorner, 1);
        this.set(7.0f, 7.0f, qr.ppCorner, 2);
        this.set(7.0f, 0.0f, qr.ppCorner, 3);
        this.setLine(0.0f, 7.0f, 0.0f, 14.0f, qr.ppCorner, 1, qr.ppRight, 0);
        this.setLine(7.0f, 7.0f, 7.0f, 14.0f, qr.ppCorner, 2, qr.ppRight, 3);
        this.setLine(7.0f, 7.0f, 14.0f, 7.0f, qr.ppCorner, 2, qr.ppDown, 1);
        this.setLine(7.0f, 0.0f, 14.0f, 0.0f, qr.ppCorner, 3, qr.ppDown, 0);
        DMatrixRMaj HH = new DMatrixRMaj(3, 3);
        this.dlt.process(this.storagePairs2D.toList(), this.storagePairs3D.toList(), null, HH);
        this.H.set(HH);
        this.H.invert(this.Hinv);
        ConvertFloatType.convert(this.Hinv, this.Hinv32);
        ConvertFloatType.convert(this.H, this.H32);
    }

    public void addAllFeatures(QrCode qr) {
        this.adjustWithFeatures = false;
        this.storagePairs2D.reset();
        this.pairs2D.clear();
        int N = qr.getNumberOfModules();
        this.set(0.0f, 0.0f, qr.ppCorner, 0);
        this.set(0.0f, 7.0f, qr.ppCorner, 1);
        this.set(7.0f, 7.0f, qr.ppCorner, 2);
        this.set(7.0f, 0.0f, qr.ppCorner, 3);
        this.set(0.0f, N - 7, qr.ppRight, 0);
        this.set(0.0f, N, qr.ppRight, 1);
        this.set(7.0f, N, qr.ppRight, 2);
        this.set(7.0f, N - 7, qr.ppRight, 3);
        this.set(N - 7, 0.0f, qr.ppDown, 0);
        this.set(N - 7, 7.0f, qr.ppDown, 1);
        this.set(N, 7.0f, qr.ppDown, 2);
        this.set(N, 0.0f, qr.ppDown, 3);
        for (int i = 0; i < qr.alignment.size; ++i) {
            QrCode.Alignment a = qr.alignment.get(i);
            AssociatedPair p = this.storagePairs2D.grow();
            p.set(a.pixel.x, a.pixel.y, (float)a.moduleX + 0.5f, (float)a.moduleY + 0.5f);
            this.pairs2D.add(p);
        }
    }

    public void removeOutsideCornerFeatures() {
        if (this.pairs2D.size() != this.storagePairs2D.size) {
            throw new RuntimeException("This can only be called when all the features have been added");
        }
        this.pairs2D.remove(11);
        this.pairs2D.remove(5);
        this.pairs2D.remove(0);
    }

    public boolean removeFeatureWithLargestError() {
        int selected = -1;
        double largestError = 0.0;
        for (int i = 0; i < this.pairs2D.size(); ++i) {
            AssociatedPair p = this.pairs2D.get(i);
            HomographyPointOps_F64.transform(this.Hinv, p.p2.x, p.p2.y, this.tmp64);
            double dx = this.tmp64.x - p.p1.x;
            double dy = this.tmp64.y - p.p1.y;
            double error = dx * dx + dy * dy;
            if (!(error > largestError)) continue;
            largestError = error;
            selected = i;
        }
        if (selected != -1 && largestError > 4.0) {
            this.pairs2D.remove(selected);
            return true;
        }
        return false;
    }

    public void computeTransform() {
        this.generator.generate(this.pairs2D, this.H);
        this.H.invert(this.Hinv);
        ConvertFloatType.convert(this.Hinv, this.Hinv32);
        ConvertFloatType.convert(this.H, this.H32);
        this.adjustments.reset();
        if (this.adjustWithFeatures) {
            for (int i = 0; i < this.pairs2D.size(); ++i) {
                AssociatedPair p = this.pairs2D.get(i);
                Point2D_F64 a = this.adjustments.grow();
                HomographyPointOps_F64.transform(this.Hinv, p.p2.x, p.p2.y, this.tmp64);
                a.x = p.p1.x - this.tmp64.x;
                a.y = p.p1.y - this.tmp64.y;
            }
        }
    }

    private void set(float row, float col, Polygon2D_F64 polygon, int corner) {
        AssociatedPair p = this.storagePairs2D.grow();
        Point2D_F64 c = polygon.get(corner);
        p.set(c.x, c.y, col, row);
        this.pairs2D.add(p);
    }

    private void setLine(float row0, float col0, float row1, float col1, Polygon2D_F64 polygon0, int corner0, Polygon2D_F64 polygon1, int corner1) {
        AssociatedPair3D p = this.storagePairs3D.grow();
        Point2D_F64 c0 = polygon0.get(corner0);
        Point2D_F64 c1 = polygon1.get(corner1);
        p.set(c1.x - c0.x, c1.y - c0.y, 0.0, col1 - col0, row1 - row0, 0.0);
        p.p1.divideIP(p.p1.norm());
        p.p2.divideIP(p.p2.norm());
    }

    public final void imageToGrid(float x, float y, Point2D_F32 grid) {
        HomographyPointOps_F32.transform(this.H32, x, y, grid);
    }

    public final void imageToGrid(double x, double y, Point2D_F64 grid) {
        HomographyPointOps_F64.transform(this.H, x, y, grid);
    }

    public final void gridToImage(float row, float col, Point2D_F32 pixel) {
        HomographyPointOps_F32.transform(this.Hinv32, col, row, pixel);
        if (this.adjustWithFeatures) {
            int closest = -1;
            double best = Double.MAX_VALUE;
            for (int i = 0; i < this.pairs2D.size(); ++i) {
                double d = this.pairs2D.get((int)i).p2.distance2(col, row);
                if (!(d < best)) continue;
                best = d;
                closest = i;
            }
            Point2D_F64 adj = this.adjustments.get(closest);
            pixel.x = (float)((double)pixel.x + adj.x);
            pixel.y = (float)((double)pixel.y + adj.y);
        }
    }

    public void setAdjustWithFeatures(boolean adjustWithFeatures) {
        this.adjustWithFeatures = adjustWithFeatures;
    }

    public void setHomographyInv(Homography2D_F64 Hinv) {
        this.Hinv.set(Hinv);
        ConvertFloatType.convert(Hinv, this.Hinv32);
    }
}

