/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.alg.filter.convolve.GConvolveImageOps;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.misc.PixelMath;
import boofcv.alg.transform.pyramid.PyramidOps;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.image.GrayF32;

public class SiftScaleSpace {
    GrayF32[] octaveImages;
    GrayF32[] differenceOfGaussian;
    double sigma0;
    int firstOctave;
    int lastOctave;
    int numScales;
    double levelK;
    Kernel1D_F32 kernelSigma0;
    Kernel1D_F32[] kernelSigmaToK;
    GrayF32 input;
    int currentOctave;
    GrayF32 tempBlur;
    GrayF32 tempImage0;
    GrayF32 tempImage1;
    InterpolatePixelS<GrayF32> interp = FactoryInterpolation.bilinearPixelS(GrayF32.class, BorderType.EXTENDED);

    public SiftScaleSpace(int firstOctave, int lastOctave, int numScales, double sigma0) {
        if (lastOctave <= firstOctave) {
            throw new IllegalArgumentException("Last octave must be more than the first octave");
        }
        if (numScales < 1) {
            throw new IllegalArgumentException("Number of scales must be >= 1");
        }
        this.firstOctave = firstOctave;
        this.lastOctave = lastOctave;
        this.numScales = numScales;
        this.sigma0 = sigma0;
        this.octaveImages = new GrayF32[numScales + 3];
        this.differenceOfGaussian = new GrayF32[numScales + 2];
        for (int i = 1; i < this.octaveImages.length; ++i) {
            this.octaveImages[i] = new GrayF32(1, 1);
            this.differenceOfGaussian[i - 1] = new GrayF32(1, 1);
        }
        this.tempImage0 = new GrayF32(1, 1);
        this.tempImage1 = new GrayF32(1, 1);
        this.tempBlur = new GrayF32(1, 1);
        this.levelK = Math.pow(2.0, 1.0 / (double)numScales);
        Class kernelType = FactoryKernel.getKernelType(GrayF32.class, 1);
        this.kernelSigma0 = (Kernel1D_F32)FactoryKernelGaussian.gaussian(kernelType, sigma0, -1);
        this.kernelSigmaToK = new Kernel1D_F32[numScales + 2];
        for (int i = 1; i < numScales + 3; ++i) {
            double before = this.computeSigmaScale(0, i - 1);
            double sigma = before * Math.sqrt(this.levelK - 1.0);
            this.kernelSigmaToK[i - 1] = (Kernel1D_F32)FactoryKernelGaussian.gaussian(kernelType, sigma, -1);
        }
    }

    public double computeSigmaScale(int scale) {
        return this.computeSigmaScale(this.currentOctave, scale);
    }

    public double computeSigmaScale(int octave, int scale) {
        return this.sigma0 * Math.pow(2.0, (double)octave + (double)scale / (double)this.numScales);
    }

    public void initialize(GrayF32 input) {
        this.input = input;
        this.currentOctave = this.firstOctave;
        if (this.firstOctave < 0) {
            PyramidOps.scaleImageUp(input, this.tempImage1, -2 * this.firstOctave, this.interp);
            this.tempImage0.reshape(this.tempImage1.width, this.tempImage1.height);
            this.applyGaussian(this.tempImage1, this.tempImage0, this.kernelSigma0);
        } else {
            this.tempImage0.reshape(input.width, input.height);
            this.applyGaussian(input, this.tempImage0, this.kernelSigma0);
            for (int i = 0; i < this.firstOctave; ++i) {
                this.tempImage1.reshape(this.tempImage0.width, this.tempImage0.height);
                this.applyGaussian(this.tempImage0, this.tempImage1, this.kernelSigma0);
                PyramidOps.scaleDown2(this.tempImage1, this.tempImage0);
            }
        }
        this.computeOctaveScales();
    }

    public boolean computeNextOctave() {
        ++this.currentOctave;
        if (this.currentOctave > this.lastOctave) {
            return false;
        }
        if (this.octaveImages[this.numScales].width <= 5 || this.octaveImages[this.numScales].height <= 5) {
            return false;
        }
        PyramidOps.scaleDown2(this.octaveImages[this.numScales], this.tempImage0);
        this.computeOctaveScales();
        return true;
    }

    private void computeOctaveScales() {
        int i;
        this.octaveImages[0] = this.tempImage0;
        for (i = 1; i < this.numScales + 3; ++i) {
            this.octaveImages[i].reshape(this.tempImage0.width, this.tempImage0.height);
            this.applyGaussian(this.octaveImages[i - 1], this.octaveImages[i], this.kernelSigmaToK[i - 1]);
        }
        for (i = 1; i < this.numScales + 3; ++i) {
            this.differenceOfGaussian[i - 1].reshape(this.tempImage0.width, this.tempImage0.height);
            PixelMath.subtract(this.octaveImages[i], this.octaveImages[i - 1], this.differenceOfGaussian[i - 1]);
        }
    }

    public GrayF32 getImageScale(int scaleIndex) {
        return this.octaveImages[scaleIndex];
    }

    public GrayF32 getDifferenceOfGaussian(int dogIndex) {
        return this.differenceOfGaussian[dogIndex];
    }

    void applyGaussian(GrayF32 input, GrayF32 output, Kernel1D kernel) {
        this.tempBlur.reshape(input.width, input.height);
        GConvolveImageOps.horizontalNormalized(kernel, input, this.tempBlur);
        GConvolveImageOps.verticalNormalized(kernel, this.tempBlur, output);
    }

    public int getNumScales() {
        return this.numScales;
    }

    public int getNumScaleImages() {
        return this.numScales + 3;
    }

    public int getCurrentOctave() {
        return this.currentOctave;
    }

    public int getTotalOctaves() {
        return this.lastOctave - this.firstOctave + 1;
    }

    public double pixelScaleCurrentToInput() {
        return Math.pow(2.0, this.currentOctave);
    }
}

