/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerBase;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerBox;
import boofcv.concurrency.BoofConcurrency;
import boofcv.concurrency.IWorkArrays;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;

public class ImplSsdCorner_S16_MT
extends ImplSsdCornerBox<GrayS16, GrayS32> {
    private IWorkArrays work = new IWorkArrays();
    private ImplSsdCornerBase.CornerIntensity_S32 intensity;

    public ImplSsdCorner_S16_MT(int windowRadius, ImplSsdCornerBase.CornerIntensity_S32 intensity) {
        super(windowRadius, GrayS32.class);
        this.intensity = intensity;
    }

    @Override
    protected void setImageShape(int imageWidth, int imageHeight) {
        super.setImageShape(imageWidth, imageHeight);
        this.work.reset(imageWidth);
    }

    @Override
    protected void horizontal() {
        short[] dataX = ((GrayS16)this.derivX).data;
        short[] dataY = ((GrayS16)this.derivY).data;
        int[] hXX = ((GrayS32)this.horizXX).data;
        int[] hXY = ((GrayS32)this.horizXY).data;
        int[] hYY = ((GrayS32)this.horizYY).data;
        int imgHeight = ((GrayS16)this.derivX).getHeight();
        int imgWidth = ((GrayS16)this.derivX).getWidth();
        int windowWidth = this.radius * 2 + 1;
        int radp1 = this.radius + 1;
        BoofConcurrency.loopFor(0, imgHeight, row -> {
            short dy;
            short dx;
            int pix;
            int end = pix + windowWidth;
            int totalXX = 0;
            int totalXY = 0;
            int totalYY = 0;
            int indexX = ((GrayS16)this.derivX).startIndex + row * ((GrayS16)this.derivX).stride;
            int indexY = ((GrayS16)this.derivY).startIndex + row * ((GrayS16)this.derivY).stride;
            for (pix = row * imgWidth; pix < end; ++pix) {
                dx = dataX[indexX++];
                dy = dataY[indexY++];
                totalXX += dx * dx;
                totalXY += dx * dy;
                totalYY += dy * dy;
            }
            hXX[pix - radp1] = totalXX;
            hXY[pix - radp1] = totalXY;
            hYY[pix - radp1] = totalYY;
            end = row * imgWidth + imgWidth;
            while (pix < end) {
                dx = dataX[indexX - windowWidth];
                dy = dataY[indexY - windowWidth];
                totalXX -= dx * dx;
                totalXY -= dx * dy;
                totalYY -= dy * dy;
                dx = dataX[indexX];
                dy = dataY[indexY];
                hXX[pix - this.radius] = totalXX += dx * dx;
                hXY[pix - this.radius] = totalXY += dx * dy;
                hYY[pix - this.radius] = totalYY += dy * dy;
                ++pix;
                ++indexX;
                ++indexY;
            }
        });
    }

    @Override
    protected void vertical(GrayF32 intensity) {
        int[] hXX = ((GrayS32)this.horizXX).data;
        int[] hXY = ((GrayS32)this.horizXY).data;
        int[] hYY = ((GrayS32)this.horizYY).data;
        float[] inten = intensity.data;
        int imgHeight = ((GrayS32)this.horizXX).getHeight();
        int imgWidth = ((GrayS32)this.horizXX).getWidth();
        int kernelWidth = this.radius * 2 + 1;
        int startX = this.radius;
        int endX = imgWidth - this.radius;
        int backStep = kernelWidth * imgWidth;
        BoofConcurrency.loopBlocks(this.radius, imgHeight - this.radius, (y0, y1) -> {
            int srcIndex;
            int destIndex;
            int[] tempXX = this.work.pop();
            int[] tempXY = this.work.pop();
            int[] tempYY = this.work.pop();
            for (int x = startX; x < endX; ++x) {
                destIndex = imgWidth * y0 + x;
                int totalXX = 0;
                int totalXY = 0;
                int totalYY = 0;
                int indexEnd = srcIndex + imgWidth * kernelWidth;
                for (srcIndex = x + (y0 - this.radius) * imgWidth; srcIndex < indexEnd; srcIndex += imgWidth) {
                    totalXX += hXX[srcIndex];
                    totalXY += hXY[srcIndex];
                    totalYY += hYY[srcIndex];
                }
                tempXX[x] = totalXX;
                tempXY[x] = totalXY;
                tempYY[x] = totalYY;
                inten[destIndex] = this.intensity.compute(totalXX, totalXY, totalYY);
                destIndex += imgWidth;
            }
            for (int y = y0 + 1; y < y1; ++y) {
                srcIndex = (y + this.radius) * imgWidth + startX;
                destIndex = y * imgWidth + startX;
                int x = startX;
                while (x < endX) {
                    int totalXX = tempXX[x] - hXX[srcIndex - backStep];
                    tempXX[x] = totalXX += hXX[srcIndex];
                    int totalXY = tempXY[x] - hXY[srcIndex - backStep];
                    tempXY[x] = totalXY += hXY[srcIndex];
                    int totalYY = tempYY[x] - hYY[srcIndex - backStep];
                    tempYY[x] = totalYY += hYY[srcIndex];
                    inten[destIndex] = this.intensity.compute(totalXX, totalXY, totalYY);
                    ++x;
                    ++srcIndex;
                    ++destIndex;
                }
            }
            this.work.recycle(tempXX);
            this.work.recycle(tempXY);
            this.work.recycle(tempYY);
        });
    }
}

