/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import boofcv.alg.distort.brown.LensDistortionBrown;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.alg.distort.spherical.EquirectangularDistortBase_F32;
import boofcv.alg.distort.universal.LensDistortionUniversalOmni;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point2Transform3_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;

public class CameraToEquirectangular_F32
extends EquirectangularDistortBase_F32 {
    public void setCameraModel(CameraPinholeBrown camera) {
        Point2Transform2_F32 pixelToNormalized = new LensDistortionBrown(camera).undistort_F32(true, false);
        this.setCameraModel(camera.width, camera.height, pixelToNormalized);
    }

    public void setCameraModel(CameraPinhole camera) {
        Point2Transform2_F32 pixelToNormalized = new LensDistortionPinhole(camera).undistort_F32(true, false);
        this.setCameraModel(camera.width, camera.height, pixelToNormalized);
    }

    public void setCameraModel(CameraUniversalOmni camera) {
        Point2Transform3_F32 pixelToSpherical = new LensDistortionUniversalOmni(camera).undistortPtoS_F32();
        this.setCameraModel(camera.width, camera.height, pixelToSpherical);
    }

    public void setCameraModel(int width, int height, Point2Transform2_F32 pixelToNormalized) {
        this.declareVectors(width, height);
        Point2D_F32 norm = new Point2D_F32();
        for (int pixelY = 0; pixelY < height; ++pixelY) {
            int index = pixelY * width;
            for (int pixelX = 0; pixelX < width; ++pixelX) {
                pixelToNormalized.compute(pixelX, pixelY, norm);
                Point3D_F32 v = this.vectors[index++];
                v.set(norm.x, norm.y, 1.0f);
            }
        }
    }

    public void setCameraModel(int width, int height, Point2Transform3_F32 pixelToNSpherical) {
        this.declareVectors(width, height);
        for (int pixelY = 0; pixelY < height; ++pixelY) {
            int index = pixelY * width;
            for (int pixelX = 0; pixelX < width; ++pixelX) {
                pixelToNSpherical.compute(pixelX, pixelY, this.vectors[index++]);
            }
        }
    }

    public CameraToEquirectangular_F32 copyConcurrent() {
        CameraToEquirectangular_F32 out = new CameraToEquirectangular_F32();
        out.setConcurrent(this);
        return out;
    }
}

