/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.mls;

import boofcv.alg.distort.mls.TypeDeformMLS;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.struct.point.Point2D_F32;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F32;
import org.ejml.data.FMatrix2x2;

public class ImageDeformPointMLS_F32
implements Point2Transform2_F32 {
    FastQueue<Control> controls = new FastQueue<Control>(Control.class, true);
    int gridRows;
    int gridCols;
    FastQueue<Cache> grid = new FastQueue<Cache>(Cache.class, true);
    float alpha = 1.5f;
    float scaleX;
    float scaleY;
    Model model;

    public ImageDeformPointMLS_F32(TypeDeformMLS type) {
        switch (type) {
            case AFFINE: {
                this.model = new AffineModel();
                break;
            }
            case SIMILARITY: {
                this.model = new SimilarityModel();
                break;
            }
            case RIGID: {
                this.model = new RigidModel();
                break;
            }
            default: {
                throw new RuntimeException("Unknown model type " + (Object)((Object)type));
            }
        }
    }

    protected ImageDeformPointMLS_F32() {
    }

    public void reset() {
        this.controls.reset();
    }

    public void configure(int width, int height, int gridRows, int gridCols) {
        int s = Math.max(width, height);
        this.scaleX = (float)s / (float)(gridCols - 1);
        this.scaleY = (float)s / (float)(gridRows - 1);
        if (gridRows > gridCols) {
            this.scaleY /= (float)(gridCols - 1) / (float)(gridRows - 1);
        } else {
            this.scaleX /= (float)(gridRows - 1) / (float)(gridCols - 1);
        }
        this.gridRows = gridRows;
        this.gridCols = gridCols;
        this.grid.resize(gridCols * gridRows);
        this.reset();
    }

    public int addControl(float x, float y) {
        Control c = this.controls.grow();
        c.q.set(x, y);
        this.setUndistorted(this.controls.size() - 1, x, y);
        return this.controls.size() - 1;
    }

    public void setUndistorted(int which, float x, float y) {
        if (this.scaleX <= 0.0f || this.scaleY <= 0.0f) {
            throw new IllegalArgumentException("Must call configure first");
        }
        this.controls.get((int)which).p.set(x / this.scaleX, y / this.scaleY);
    }

    public int add(float srcX, float srcY, float dstX, float dstY) {
        int which = this.addControl(srcX, srcY);
        this.setUndistorted(which, dstX, dstY);
        return which;
    }

    public void setDistorted(int which, float x, float y) {
        this.controls.get((int)which).q.set(x, y);
    }

    public void fixateUndistorted() {
        if (this.controls.size() < 2) {
            throw new RuntimeException("Not enough control points specified.  Found " + this.controls.size());
        }
        for (int row = 0; row < this.gridRows; ++row) {
            for (int col = 0; col < this.gridCols; ++col) {
                Cache cache = this.getGrid(row, col);
                cache.weights.resize(this.controls.size);
                cache.A.resize(this.controls.size);
                cache.A_s.resize(this.controls.size());
                float v_x = col;
                float v_y = row;
                this.computeWeights(cache, v_x, v_y);
                this.computeAverageP(cache);
                this.model.computeCache(cache, v_x, v_y);
            }
        }
    }

    public void fixateDistorted() {
        for (int row = 0; row < this.gridRows; ++row) {
            for (int col = 0; col < this.gridCols; ++col) {
                Cache cache = this.getGrid(row, col);
                this.computeAverageQ(cache);
                this.model.computeDeformed(cache, col, row);
            }
        }
    }

    void computeAverageP(Cache cache) {
        float[] weights = cache.weights.data;
        cache.aveP.set(0.0f, 0.0f);
        for (int i = 0; i < this.controls.size(); ++i) {
            Control c = this.controls.get(i);
            float w = weights[i];
            cache.aveP.x += c.p.x * w;
            cache.aveP.y += c.p.y * w;
        }
        cache.aveP.x /= cache.totalWeight;
        cache.aveP.y /= cache.totalWeight;
    }

    void computeAverageQ(Cache cache) {
        float[] weights = cache.weights.data;
        cache.aveQ.set(0.0f, 0.0f);
        for (int i = 0; i < this.controls.size(); ++i) {
            Control c = this.controls.get(i);
            float w = weights[i];
            cache.aveQ.x += c.q.x * w;
            cache.aveQ.y += c.q.y * w;
        }
        cache.aveQ.x /= cache.totalWeight;
        cache.aveQ.y /= cache.totalWeight;
    }

    void computeWeights(Cache cache, float v_x, float v_y) {
        float[] weights = cache.weights.data;
        float totalWeight = 0.0f;
        for (int i = 0; i < this.controls.size(); ++i) {
            Control c = this.controls.get(i);
            float d2 = c.p.distance2(v_x, v_y);
            if (d2 == 0.0f) {
                for (int j = 0; j < this.controls.size(); ++j) {
                    weights[j] = i == j ? 1.0f : 0.0f;
                }
                totalWeight = 1.0f;
                break;
            }
            weights[i] = 1.0f / (float)Math.pow(d2, this.alpha);
            totalWeight += weights[i];
        }
        cache.totalWeight = totalWeight;
    }

    @Override
    public void compute(float x, float y, Point2D_F32 out) {
        this.interpolateDeformedPoint(x / this.scaleX, y / this.scaleY, out);
    }

    @Override
    public ImageDeformPointMLS_F32 copyConcurrent() {
        ImageDeformPointMLS_F32 out = new ImageDeformPointMLS_F32();
        out.controls = this.controls;
        out.gridRows = this.gridRows;
        out.gridCols = this.gridCols;
        out.grid = this.grid;
        out.model = this.model;
        out.scaleX = this.scaleX;
        out.scaleY = this.scaleY;
        out.alpha = this.alpha;
        return out;
    }

    void interpolateDeformedPoint(float v_x, float v_y, Point2D_F32 deformed) {
        int x0 = (int)v_x;
        int y0 = (int)v_y;
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        if (x1 >= this.gridCols) {
            x1 = this.gridCols - 1;
        }
        if (y1 >= this.gridRows) {
            y1 = this.gridRows - 1;
        }
        float ax = v_x - (float)x0;
        float ay = v_y - (float)y0;
        float w00 = (1.0f - ax) * (1.0f - ay);
        float w01 = ax * (1.0f - ay);
        float w11 = ax * ay;
        float w10 = (1.0f - ax) * ay;
        Point2D_F32 d00 = this.getGrid((int)y0, (int)x0).deformed;
        Point2D_F32 d01 = this.getGrid((int)y0, (int)x1).deformed;
        Point2D_F32 d10 = this.getGrid((int)y1, (int)x0).deformed;
        Point2D_F32 d11 = this.getGrid((int)y1, (int)x1).deformed;
        deformed.set(0.0f, 0.0f);
        deformed.x += w00 * d00.x;
        deformed.x += w01 * d01.x;
        deformed.x += w11 * d11.x;
        deformed.x += w10 * d10.x;
        deformed.y += w00 * d00.y;
        deformed.y += w01 * d01.y;
        deformed.y += w11 * d11.y;
        deformed.y += w10 * d10.y;
    }

    Cache getGrid(int row, int col) {
        return ((Cache[])this.grid.data)[row * this.gridCols + col];
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public static class Control {
        Point2D_F32 p = new Point2D_F32();
        Point2D_F32 q = new Point2D_F32();
    }

    private static interface Model {
        public void computeCache(Cache var1, float var2, float var3);

        public void computeDeformed(Cache var1, float var2, float var3);
    }

    public static class Cache {
        Point2D_F32 deformed = new Point2D_F32();
        GrowQueue_F32 weights = new GrowQueue_F32();
        float totalWeight;
        GrowQueue_F32 A = new GrowQueue_F32();
        Point2D_F32 aveP = new Point2D_F32();
        Point2D_F32 aveQ = new Point2D_F32();
        FastQueue<FMatrix2x2> A_s = new FastQueue<FMatrix2x2>(FMatrix2x2.class, true);
        float mu;
    }

    public class RigidModel
    extends SimilarityModel {
        @Override
        public void computeDeformed(Cache cache, float v_x, float v_y) {
            float fr_x = 0.0f;
            float fr_y = 0.0f;
            for (int i = 0; i < ImageDeformPointMLS_F32.this.controls.size(); ++i) {
                Control c = ImageDeformPointMLS_F32.this.controls.get(i);
                float hat_q_x = c.q.x - cache.aveQ.x;
                float hat_q_y = c.q.y - cache.aveQ.y;
                FMatrix2x2 A = cache.A_s.get(i);
                fr_x += hat_q_x * A.a11 + hat_q_y * A.a21;
                fr_y += hat_q_x * A.a12 + hat_q_y * A.a22;
            }
            float v_avep_x = v_x - cache.aveP.x;
            float v_avep_y = v_y - cache.aveP.y;
            float norm_fr = (float)Math.sqrt(fr_x * fr_x + fr_y * fr_y);
            float norm_vp = (float)Math.sqrt(v_avep_x * v_avep_x + v_avep_y * v_avep_y);
            if (norm_fr == 0.0f && norm_vp == 0.0f) {
                cache.deformed.x = cache.aveQ.x;
                cache.deformed.y = cache.aveQ.y;
            } else {
                float scale = norm_vp / norm_fr;
                cache.deformed.x = ImageDeformPointMLS_F32.this.scaleX * fr_x * scale + cache.aveQ.x;
                cache.deformed.y = ImageDeformPointMLS_F32.this.scaleY * fr_y * scale + cache.aveQ.y;
            }
        }
    }

    public class SimilarityModel
    implements Model {
        @Override
        public void computeCache(Cache cache, float v_x, float v_y) {
            float[] weights = cache.weights.data;
            cache.mu = 0.0f;
            for (int i = 0; i < ImageDeformPointMLS_F32.this.controls.size(); ++i) {
                Control c = ImageDeformPointMLS_F32.this.controls.get(i);
                float w = weights[i];
                float hat_p_x = c.p.x - cache.aveP.x;
                float hat_p_y = c.p.y - cache.aveP.y;
                cache.mu += w * (hat_p_x * hat_p_x + hat_p_y * hat_p_y);
                float v_ps_x = v_x - cache.aveP.x;
                float v_ps_y = v_y - cache.aveP.y;
                FMatrix2x2 A = cache.A_s.get(i);
                A.a11 = w * (hat_p_x * v_ps_x + hat_p_y * v_ps_y);
                A.a12 = w * (hat_p_x * v_ps_y - hat_p_y * v_ps_x);
                A.a21 = -A.a12;
                A.a22 = A.a11;
            }
            if (cache.mu == 0.0f) {
                cache.mu = 1.0f;
            }
        }

        @Override
        public void computeDeformed(Cache cache, float v_x, float v_y) {
            Point2D_F32 deformed = cache.deformed;
            deformed.set(0.0f, 0.0f);
            int N = cache.A_s.size;
            for (int i = 0; i < N; ++i) {
                Control c = ImageDeformPointMLS_F32.this.controls.get(i);
                FMatrix2x2 A = cache.A_s.get(i);
                float hat_q_x = c.q.x - cache.aveQ.x;
                float hat_q_y = c.q.y - cache.aveQ.y;
                deformed.x += hat_q_x * A.a11 + hat_q_y * A.a21;
                deformed.y += hat_q_x * A.a12 + hat_q_y * A.a22;
            }
            deformed.x = deformed.x / cache.mu + cache.aveQ.x;
            deformed.y = deformed.y / cache.mu + cache.aveQ.y;
        }
    }

    public class AffineModel
    implements Model {
        @Override
        public void computeCache(Cache cache, float v_x, float v_y) {
            float[] weights = cache.weights.data;
            float inner00 = 0.0f;
            float inner01 = 0.0f;
            float inner11 = 0.0f;
            for (int i = 0; i < ImageDeformPointMLS_F32.this.controls.size(); ++i) {
                Control c = ImageDeformPointMLS_F32.this.controls.get(i);
                float w = weights[i];
                float hat_p_x = c.p.x - cache.aveP.x;
                float hat_p_y = c.p.y - cache.aveP.y;
                inner00 += hat_p_x * hat_p_x * w;
                inner01 += hat_p_y * hat_p_x * w;
                inner11 += hat_p_y * hat_p_y * w;
            }
            float det = inner00 * inner11 - inner01 * inner01;
            if ((double)det == 0.0) {
                if (inner00 == 0.0f && inner11 == 0.0f) {
                    det = 1.0f;
                } else {
                    throw new RuntimeException("Insufficient number of or geometric diversity in control points");
                }
            }
            float inv00 = inner11 / det;
            float inv01 = -inner01 / det;
            float inv11 = inner00 / det;
            float v_m_ap_x = v_x - cache.aveP.x;
            float v_m_ap_y = v_y - cache.aveP.y;
            float tmp0 = v_m_ap_x * inv00 + v_m_ap_y * inv01;
            float tmp1 = v_m_ap_x * inv01 + v_m_ap_y * inv11;
            for (int i = 0; i < ImageDeformPointMLS_F32.this.controls.size(); ++i) {
                Control c = ImageDeformPointMLS_F32.this.controls.get(i);
                float hat_p_x = c.p.x - cache.aveP.x;
                float hat_p_y = c.p.y - cache.aveP.y;
                cache.A.data[i] = (tmp0 * hat_p_x + tmp1 * hat_p_y) * weights[i];
            }
        }

        @Override
        public void computeDeformed(Cache cache, float v_x, float v_y) {
            Point2D_F32 deformed = cache.deformed;
            deformed.set(0.0f, 0.0f);
            int N = cache.A.size;
            for (int i = 0; i < N; ++i) {
                Control c = ImageDeformPointMLS_F32.this.controls.get(i);
                float a = cache.A.data[i];
                deformed.x += a * (c.q.x - cache.aveQ.x);
                deformed.y += a * (c.q.y - cache.aveQ.y);
            }
            deformed.x += cache.aveQ.x;
            deformed.y += cache.aveQ.y;
        }
    }
}

