/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.triangulate;

import boofcv.abst.geo.RefineTriangulateProjective;
import boofcv.alg.geo.triangulate.ResidualsTriangulateProjective;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ejml.data.DMatrixRMaj;

public class TriangulateRefineProjectiveLS
implements RefineTriangulateProjective {
    ResidualsTriangulateProjective func = new ResidualsTriangulateProjective();
    UnconstrainedLeastSquares<DMatrixRMaj> minimizer;
    double[] param = new double[4];
    int maxIterations;
    double convergenceTol;

    public TriangulateRefineProjectiveLS(double convergenceTol, int maxIterations) {
        this.convergenceTol = convergenceTol;
        this.maxIterations = maxIterations;
        this.minimizer = FactoryOptimization.levenbergMarquardt(null, false);
    }

    @Override
    public boolean process(List<Point2D_F64> observations, List<DMatrixRMaj> cameraMatrices, Point4D_F64 worldPt, Point4D_F64 refinedPt) {
        this.func.setObservations(observations, cameraMatrices);
        this.minimizer.setFunction(this.func, null);
        this.param[0] = worldPt.x;
        this.param[1] = worldPt.y;
        this.param[2] = worldPt.z;
        this.param[3] = worldPt.w;
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)observations.size());
        for (int i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        double[] found = this.minimizer.getParameters();
        refinedPt.x = found[0];
        refinedPt.y = found[1];
        refinedPt.z = found[2];
        refinedPt.w = found[3];
        return true;
    }
}

