/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.blur;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.concurrency.WorkArrays;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public class BlurStorageFilter<T extends ImageBase<T>>
implements BlurFilter<T> {
    private BlurOperation operation;
    private double sigmaX;
    private double sigmaY;
    private int radiusX;
    private int radiusY;
    private T storage;
    ImageType<T> inputType;
    WorkArrays workArray;
    ImageBorder<T> border = null;

    public BlurStorageFilter(String functionName, ImageType<T> inputType, int radius) {
        this(functionName, inputType, -1.0, radius, -1.0, radius);
    }

    public BlurStorageFilter(String functionName, ImageType<T> inputType, int radiusX, int radiusY) {
        this(functionName, inputType, -1.0, radiusX, -1.0, radiusY);
    }

    public BlurStorageFilter(String functionName, ImageType<T> inputType, double sigmaX, int radiusX, double sigmaY, int radiusY) {
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.sigmaX = sigmaX;
        this.sigmaY = sigmaY;
        this.inputType = inputType;
        if (functionName.equals("mean")) {
            this.operation = new MeanOperation();
            this.createStorage();
        } else if (functionName.equals("gaussian")) {
            this.operation = new GaussianOperation();
            this.createStorage();
        } else if (functionName.equals("median")) {
            if (radiusX != radiusY) {
                throw new IllegalArgumentException("Median currently only supports equal radius");
            }
            this.operation = new MedianOperator();
        } else {
            throw new IllegalArgumentException("Unknown function " + functionName);
        }
        this.workArray = GeneralizedImageOps.createWorkArray(inputType);
    }

    private void createStorage() {
        this.storage = this.inputType.getFamily() == ImageType.Family.PLANAR ? GeneralizedImageOps.createSingleBand(this.inputType.getImageClass(), 1, 1) : this.inputType.createImage(1, 1);
    }

    public ImageBorder<T> getBorder() {
        return this.border;
    }

    public void setBorder(ImageBorder<T> border) {
        this.border = border;
    }

    @Override
    public int getRadius() {
        return this.radiusX;
    }

    @Override
    public void setRadius(int radius) {
        this.radiusX = radius;
        this.radiusY = radius;
    }

    @Override
    public void process(T input, T output) {
        if (this.storage != null) {
            ((ImageBase)this.storage).reshape(((ImageBase)output).width, ((ImageBase)output).height);
        }
        this.operation.process((ImageBase)input, (ImageBase)output);
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }

    @Override
    public ImageType<T> getOutputType() {
        return this.inputType;
    }

    private class MedianOperator
    implements BlurOperation {
        private MedianOperator() {
        }

        @Override
        public void process(ImageBase input, ImageBase output) {
            GBlurImageOps.median(input, output, BlurStorageFilter.this.radiusX, BlurStorageFilter.this.workArray);
        }
    }

    private class GaussianOperation
    implements BlurOperation {
        private GaussianOperation() {
        }

        @Override
        public void process(ImageBase input, ImageBase output) {
            GBlurImageOps.gaussian(input, output, BlurStorageFilter.this.sigmaX, BlurStorageFilter.this.radiusX, BlurStorageFilter.this.sigmaY, BlurStorageFilter.this.radiusY, BlurStorageFilter.this.storage);
        }
    }

    private class MeanOperation
    implements BlurOperation {
        private MeanOperation() {
        }

        @Override
        public void process(ImageBase input, ImageBase output) {
            GBlurImageOps.mean(input, output, BlurStorageFilter.this.radiusX, BlurStorageFilter.this.radiusY, BlurStorageFilter.this.border, BlurStorageFilter.this.storage, BlurStorageFilter.this.workArray);
        }
    }

    private static interface BlurOperation {
        public void process(ImageBase var1, ImageBase var2);
    }
}

