/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.dense;

import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.alg.feature.dense.BaseDenseHog;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DescribeImageDenseHoG<T extends ImageBase<T>>
implements DescribeImageDense<T, TupleDesc_F64> {
    BaseDenseHog<T> hog;

    public DescribeImageDenseHoG(BaseDenseHog<T> hog) {
        this.hog = hog;
    }

    @Override
    public void process(T input) {
        this.hog.setInput(input);
        this.hog.process();
        FastQueue<Point2D_I32> locations = this.hog.getLocations();
        int rx = this.hog.getRegionWidthPixelX() / 2;
        int ry = this.hog.getRegionWidthPixelY() / 2;
        for (int i = 0; i < locations.size(); ++i) {
            Point2D_I32 p = locations.get(i);
            p.x += rx;
            p.y += ry;
        }
    }

    @Override
    public List<TupleDesc_F64> getDescriptions() {
        return this.hog.getDescriptions().toList();
    }

    @Override
    public List<Point2D_I32> getLocations() {
        return this.hog.getLocations().toList();
    }

    @Override
    public ImageType<T> getImageType() {
        return this.hog.getImageType();
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return this.hog.createDescription();
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }
}

