/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.ReflectClass;
import org.eclipse.swt.tools.internal.ReflectItem;
import org.eclipse.swt.tools.internal.ReflectParameter;
import org.eclipse.swt.tools.internal.ReflectType;

public class ReflectMethod
extends ReflectItem
implements JNIMethod {
    Method method;
    ReflectType returnType;
    ReflectType returnType64;
    ReflectType[] paramTypes;
    ReflectType[] paramTypes64;
    ReflectClass declaringClass;
    Boolean unique;

    public ReflectMethod(ReflectClass declaringClass, Method method, String source, CompilationUnit unit) {
        this.method = method;
        this.declaringClass = declaringClass;
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        this.returnType64 = this.returnType = new ReflectType(returnType);
        this.paramTypes = new ReflectType[paramTypes.length];
        this.paramTypes64 = new ReflectType[paramTypes.length];
        int i = 0;
        while (i < this.paramTypes.length) {
            this.paramTypes[i] = this.paramTypes64[i] = new ReflectType(paramTypes[i]);
            ++i;
        }
        boolean changes = false;
        if ((method.getModifiers() & 0x100) != 0 && !(changes = this.canChange64(returnType))) {
            int i2 = 0;
            while (i2 < paramTypes.length && !changes) {
                changes |= this.canChange64(paramTypes[i2]);
                ++i2;
            }
        }
        if (changes && new File(declaringClass.sourcePath).exists()) {
            MethodDeclaration node;
            String name = method.getName();
            TypeDeclaration type = (TypeDeclaration)unit.types().get(0);
            MethodDeclaration decl = null;
            MethodDeclaration[] methods = type.getMethods();
            int i3 = 0;
            while (i3 < methods.length && decl == null) {
                List parameters;
                node = methods[i3];
                if (node.getName().getIdentifier().equals(name) && declaringClass.getSimpleName(returnType).equals(node.getReturnType2().toString()) && (parameters = node.parameters()).size() == paramTypes.length) {
                    decl = node;
                    int j = 0;
                    while (j < paramTypes.length) {
                        if (!declaringClass.getSimpleName(paramTypes[j]).equals(((SingleVariableDeclaration)parameters.get(j)).getType().toString())) {
                            decl = null;
                            break;
                        }
                        ++j;
                    }
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < paramTypes.length) {
                if (this.canChange64(paramTypes[i3])) {
                    Class<?> clazz = paramTypes[i3];
                    SingleVariableDeclaration node2 = (SingleVariableDeclaration)decl.parameters().get(i3);
                    String s = source.substring(node2.getStartPosition(), node2.getStartPosition() + node2.getLength());
                    if (clazz == Integer.TYPE && s.indexOf("int /*long*/") != -1) {
                        this.paramTypes64[i3] = new ReflectType(Long.TYPE);
                    } else if (clazz == int[].class && (s.indexOf("int /*long*/") != -1 || s.indexOf("int[] /*long[]*/") != -1)) {
                        this.paramTypes64[i3] = new ReflectType(long[].class);
                    } else if (clazz == Float.TYPE && s.indexOf("float /*double*/") != -1) {
                        this.paramTypes64[i3] = new ReflectType(Double.TYPE);
                    } else if (clazz == float[].class && (s.indexOf("float /*double*/") != -1 || s.indexOf("float[] /*double[]*/") != -1)) {
                        this.paramTypes64[i3] = new ReflectType(double[].class);
                    } else if (clazz == Long.TYPE && s.indexOf("long /*int*/") != -1) {
                        this.paramTypes[i3] = new ReflectType(Integer.TYPE);
                    } else if (clazz == long[].class && (s.indexOf("long /*int*/") != -1 || s.indexOf("long[] /*int[]*/") != -1)) {
                        this.paramTypes[i3] = new ReflectType(int[].class);
                    } else if (clazz == Double.TYPE && s.indexOf("double /*float*/") != -1) {
                        this.paramTypes[i3] = new ReflectType(Float.TYPE);
                    } else if (clazz == double[].class && (s.indexOf("double /*float*/") != -1 || s.indexOf("double[] /*float[]*/") != -1)) {
                        this.paramTypes[i3] = new ReflectType(float[].class);
                    }
                }
                ++i3;
            }
            if (this.canChange64(returnType)) {
                Class<?> clazz = returnType;
                node = decl.getReturnType2();
                String s = source.substring(node.getStartPosition(), decl.getName().getStartPosition());
                if (clazz == Integer.TYPE && s.indexOf("int /*long*/") != -1) {
                    this.returnType64 = new ReflectType(Long.TYPE);
                } else if (clazz == int[].class && (s.indexOf("int /*long*/") != -1 || s.indexOf("int[] /*long[]*/") != -1)) {
                    this.returnType64 = new ReflectType(long[].class);
                } else if (clazz == Float.TYPE && s.indexOf("float /*double*/") != -1) {
                    this.returnType64 = new ReflectType(Double.TYPE);
                } else if (clazz == float[].class && (s.indexOf("float /*double*/") != -1 || s.indexOf("float[] /*double[]*/") != -1)) {
                    this.returnType64 = new ReflectType(double[].class);
                } else if (clazz == Long.TYPE && s.indexOf("long /*int*/") != -1) {
                    this.returnType = new ReflectType(Integer.TYPE);
                } else if (clazz == long[].class && (s.indexOf("long /*int*/") != -1 || s.indexOf("long[] /*int[]*/") != -1)) {
                    this.returnType = new ReflectType(int[].class);
                } else if (clazz == Double.TYPE && s.indexOf("double /*float*/") != -1) {
                    this.returnType = new ReflectType(Float.TYPE);
                } else if (clazz == double[].class && (s.indexOf("double /*float*/") != -1 || s.indexOf("double[] /*float[]*/") != -1)) {
                    this.returnType = new ReflectType(float[].class);
                }
            }
        }
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReflectMethod)) {
            return false;
        }
        return ((ReflectMethod)obj).method.equals(this.method);
    }

    @Override
    public JNIClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isNativeUnique() {
        if (this.unique != null) {
            return this.unique;
        }
        boolean result = true;
        String name = this.getName();
        JNIMethod[] methods = this.declaringClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            JNIMethod mth = methods[i];
            if ((mth.getModifiers() & 0x100) != 0 && this != mth && !this.equals(mth) && name.equals(mth.getName())) {
                result = false;
                break;
            }
            ++i;
        }
        this.unique = result;
        return result;
    }

    @Override
    public JNIType[] getParameterTypes() {
        return this.paramTypes;
    }

    @Override
    public JNIType[] getParameterTypes64() {
        return this.paramTypes64;
    }

    @Override
    public JNIParameter[] getParameters() {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        JNIParameter[] result = new ReflectParameter[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            result[i] = new ReflectParameter(this, i);
            ++i;
        }
        return result;
    }

    @Override
    public JNIType getReturnType() {
        return this.returnType;
    }

    @Override
    public JNIType getReturnType64() {
        return this.returnType64;
    }

    @Override
    public String getAccessor() {
        return (String)this.getParam("accessor");
    }

    @Override
    public String getExclude() {
        return (String)this.getParam("exclude");
    }

    @Override
    public String getMetaData() {
        MetaData metaData = this.declaringClass.metaData;
        String className = this.getDeclaringClass().getSimpleName();
        String key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this);
        String value = metaData.getMetaData(key, null);
        if (value == null) {
            key = String.valueOf(className) + "_" + this.method.getName();
            value = metaData.getMetaData(key, null);
        }
        if (value == null) {
            JNIType[] paramTypes = this.getParameterTypes();
            if (ReflectMethod.convertTo32Bit(paramTypes, true)) {
                key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this, paramTypes);
                value = metaData.getMetaData(key, null);
            }
            if (value == null && ReflectMethod.convertTo32Bit(paramTypes = this.getParameterTypes(), false)) {
                key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this, paramTypes);
                value = metaData.getMetaData(key, null);
            }
        }
        if (value == null && this.method.getName().startsWith("_") && (value = metaData.getMetaData(key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this).substring(2), null)) == null) {
            key = String.valueOf(className) + "_" + this.method.getName().substring(1);
            value = metaData.getMetaData(key, null);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public void setAccessor(String str) {
        this.setParam("accessor", str);
    }

    @Override
    public void setExclude(String str) {
        this.setParam("exclude", str);
    }

    @Override
    public void setMetaData(String value) {
        String className = this.declaringClass.getSimpleName();
        String key = this.isNativeUnique() ? String.valueOf(className) + "_" + this.method.getName() : String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this);
        this.declaringClass.metaData.setMetaData(key, value);
    }

    public String toString() {
        return this.method.toString();
    }
}

