(function(){
    var suiviprev = angular.module("suiviprev", []);

	suiviprev.factory('SuiviPrevAccessor', ['DashAPI', 'model',
		function (DashAPI, model) {
			var accessor = {
				suiviPrevsBase : function (callback, error){
					if(model.suiviPrevs().baseFetched){
						if (callback) callback(model.suiviPrevs().base);
					}else{
						DashAPI.get('/dashboard/suiviprev/ws/baseSuiviPrev', function(res){
							if (res && res.data) {
								if (res.data.success===false) {
									error(res.data.ms);
								} else {
									model.suiviPrevs().baseFetched = true;
									model.suiviPrevs().base = res.data;
									if (callback) callback(model.suiviPrevs().base);
								}
							}
						}, error);
					}
				},
				suiviPrevsText : function (callback, error){
					if(model.suiviPrevs().textFetched){
						if (callback) callback(model.suiviPrevs().text);
					}else{
						DashAPI.get('/dashboard/suiviprev/ws/clientSuiviPrevText', function(res){
							if (res && res.data) {
								if (res.data.success===false) {
									error(res.data.ms);
								} else {
									model.suiviPrevs().textFetched = true;
									model.suiviPrevs().text = res.data;
									if (callback) callback(model.suiviPrevs().text);
								}
							}
						}, error);
					}
				},
				suiviPrevsProf : function (idProf, callback, error){
					if(model.suiviPrevs().profFetched){
						if (callback) callback(model.suiviPrevs().prof);
					}else{
						DashAPI.get('/dashboard/suiviprev/ws/profSuiviPrev?idProf=' + idProf, function(res){
							if (res && res.data) {
								if (res.data.success===false) {
									error(res.data.ms);
								} else {
									model.suiviPrevs().profFetched = true;
									model.suiviPrevs().prof = res.data;
									if (callback) callback(model.suiviPrevs().prof);
								}
							}
						}, error);
					}
				},
				suiviPrevsPat : function (idPat, callback, error){
					if (model.suiviPrevs().pat[idPat]) {
						if (callback) callback(model.suiviPrevs().pat[idPat]);
					} else {
						DashAPI.get('/dashboard/suiviprev/ws/patSuiviPrev?idPat=' + idPat, function(res){
							if (res && res.data) {
								if (res.data.success===false) {
									error(res.data.ms);
								} else {
									model.suiviPrevs().pat[idPat] = res.data;
									if (callback) callback(res.data);
								}
							}
						}, error);
					}
				},
				suiviPrevsPatDone : function (idPat, callback, error){
					DashAPI.get('/dashboard/suiviprev/ws/patDoneSuiviPrev?idPat=' + idPat, function(res){
						if (res && res.data) {
							if (res.data.success===false) {
								error(res.data.ms);
							} else {
								callback(res.data);
							}
						}
					}, error);
				},
				suiviPrevPatProf : function (data, callback, error){
					return DashAPI.get("/dashboard/suiviprev/ws/suiviPrevPatProf?idPat=" + data.idPat + "&idProf=" + data.idProf, function(res){
						if (res && res.data) {
							if (res.data.success===false) {
								error(res.data.ms);
							} else {
								callback(res);
							}
						}
					}, error);
                },
                saveSuiviPat: function(sp, callback, error){
                    return DashAPI.post('/dashboard/suiviprev/ws/saveSuiviPat', sp, callback, error);
                },
                saveSuiviProf: function(sp, callback, error){
                	return DashAPI.post('/dashboard/suiviprev/ws/saveSuiviProf', sp, callback, error);
                },
                saveAdminRappelAutoText: function(sp, callback, error){
                	return DashAPI.post('/dashboard/suiviprev/ws/saveAdminRappelAutoText', sp, callback, error);
                },
                saveSuiviPatDone: function(sp, callback, error){
                    return DashAPI.post('/dashboard/suiviprev/ws/saveSuiviPatDone', sp, callback, error);
                }
			};
			accessor.suiviPrevsBase();
			if (model.user().profil && model.user().profil.id) {
				accessor.suiviPrevsProf(model.user().profil.id);
			}
			if (model.user().isAdmin) {
				accessor.suiviPrevsText();				
			}
			return accessor;
	}]);


	suiviprev.directive('addSuiviPrev',['SuiviPrevAccessor','model','$filter', 'ModificationStatus', 'patientShowTitles',
								function(SuiviPrevAccessor, model, $filter, ModificationStatus, patientShowTitles){
		return {
			restrict: 'EA',
			link: function(scope, element, attrs){
				
				scope.patientShowTitles = patientShowTitles;
				scope.showSuiviPrev=false;
				scope.showSuiviPrevBase=false;
				scope.showSuiviPrevProf=false;
				scope.isActiveShowRappelAutoPat = true;
				if (scope.item.activeSuiviPrevDone) delete scope.item.activeSuiviPrevDone;
					//scope.item.suiviPrev = {};
					//angular.copy(_.findWhere(scope.suiviPrevs.base, {id:scope.item.idSuiviPrev }), scope.item.suiviPrev);

				scope.showRappelAutoProf = function () {
					return scope.item.suiviPrev && scope.item.suiviPrev.canSendRappelAuto === true ? true : false;
				};
				scope.showRappelAutoPat = function () {
					return scope.showRappelAutoProf()===true && scope.item.suiviProf && scope.item.suiviProf.rappelAutoMois !== undefined && scope.item.suiviProf.rappelAutoMois > -1 && scope.itemaction.patient().treatingProfessionnal===model.user().profil.id;
				};
				
				scope.suiviPrevs = {};
				
				scope.suiviStatus = [{val: 0, name: $filter("translate")('INCLURE_DS_SUIVIS')}, {val: 1, name: $filter("translate")('RETIRER_DES_SUIVIS')}, {val: 2, name: $filter("translate")('INCLURE_MEME_SI_PROF_EXCLU')}];
				
				function getSuivPrevBaseAndProf() {
					SuiviPrevAccessor.suiviPrevsBase(function(data) {
						scope.suiviPrevs.base = data;
						assignSuiviPrevBaseToSumm();
						if (model.user().profil && model.user().profil.id) {
							SuiviPrevAccessor.suiviPrevsProf(model.user().profil.id, function(data1) {
								scope.suiviPrevs.prof = data1;
								assignSuiviPrevProfToSumm();
							}, function(err) {
								console.log(err);
							});
						}
					}, function(err) {
						console.log(err);
					});
				}

				getSuivPrevBaseAndProf();
				
				scope.addSuiviPrevPat = function(sp) {
					if (sp.suiviPat==undefined || sp.suiviPat.idSuiviPrev==undefined) {
						sp.suiviPat = {
							idPatient: sp.idPatient,
							idSuiviPrev: sp.idSuiviPrev,
							idProfessionnal: model.user().profil.id,
							hasLifeStyleRiskfact: false,
							hasFamilyHxRiskfact: false,
							activatedDate: OfysUtils.localDateFrom1970(),
							usage: 0,
							isDeleted: false,
							modificationStatus: ModificationStatus.STATUS_NEW,
							note: ''
						}
					}
				}
				function isActiveShowRappelAutoPat(sp) {
					return sp==undefined || sp.rappelAutoMois!=-1;
				}
				scope.toggleActiveRappelAutoPat = function(sp) {
					if (isActiveShowRappelAutoPat(sp)) {
						if (sp.rappelAutoMois != -1) sp.rappelAutoMois = -1;
						scope.isActiveShowRappelAutoPat = false;
					} else {
						if (sp.rappelAutoMois!==undefined) delete sp.rappelAutoMois;
						scope.isActiveShowRappelAutoPat = true;
					}
				}
				scope.changeRappelAutoMoisPat = function(sp) {
					scope.isActiveShowRappelAutoPat = isActiveShowRappelAutoPat(sp);
				}
				
				function assignSuiviPrevBaseToSumm() {
					scope.item.suiviPrev = {};
					angular.copy(_.findWhere(scope.suiviPrevs.base, {id:scope.item.idSuiviPrev }), scope.item.suiviPrev);
				}
				function assignSuiviPrevProfToSumm() {
					scope.item.suiviProf = {};
					if (scope.item.idSuiviPrevProf) {
						angular.copy(_.findWhere(scope.suiviPrevs.prof, {id:scope.item.idSuiviPrevProf}), scope.item.suiviProf);
					} else {
						angular.copy(_.findWhere(scope.suiviPrevs.prof, {idSuiviPrev:scope.item.idSuiviPrev }), scope.item.suiviProf);				
					}
				}
				function assignSuiviPrevPatToSumm() {
					if (scope.item.idSuiviPrevPat) {
						scope.item.suiviPat = {};
						angular.copy(_.findWhere(scope.suiviPrevs.pat, {id:scope.item.idSuiviPrevPat}), scope.item.suiviPat);
					}
					scope.isActiveShowRappelAutoPat = isActiveShowRappelAutoPat(scope.item.suiviPat);
				}
				function assignSuiviPrevPatDoneToSumm() {
					if (scope.item.idSuiviPrevPatDone) {
						scope.item.suiviPrevPatDone = {};
						angular.copy(_.findWhere(scope.suiviPrevs.patdone, {id:scope.item.idSuiviPrevPatDone }), scope.item.suiviPrevPatDone);
						scope.item.suiviPrevPatDone.doneDateStr = scope.item.suiviPrevPatDone ? OfysUtils.daysFrom1970ToStr(scope.item.suiviPrevPatDone.doneDate).replace('-01-01','') : "";
					}
					if (scope.item.isEditing===true) {
						scope.item.activeSuiviPrevDone = scope.item.suiviPrevPatDone;
						scope.item.activeSuiviPrevDone.doneDateStr = scope.item.activeSuiviPrevDone ? OfysUtils.daysFrom1970ToStr(scope.item.activeSuiviPrevDone.doneDate).replace('-01-01','') : "";
					} else {
						addSuiviPrevPatDone();
					}
				}
				function assignSuiviPrevToSumm(isDeleting) {
					if (scope.item.idSuiviPrevPat) {
						scope.item.suiviPat = {};
						angular.copy(_.findWhere(scope.suiviPrevs.pat, {id:scope.item.idSuiviPrevPat}), scope.item.suiviPat);
					}
					scope.isActiveShowRappelAutoPat = isActiveShowRappelAutoPat(scope.suiviPat);
					
					scope.item.suiviProf = {};
					if (scope.item.idSuiviPrevProf) {
						angular.copy(_.findWhere(scope.suiviPrevs.prof, {id:scope.item.idSuiviPrevProf}), scope.item.suiviProf);
					} else {
						angular.copy(_.findWhere(scope.suiviPrevs.prof, {idSuiviPrev:scope.item.idSuiviPrev }), scope.item.suiviProf);				
					}
					if (scope.item.idSuiviPrevPatDone) {
						scope.item.suiviPrevPatDone = {};
						angular.copy(_.findWhere(scope.suiviPrevs.patdone, {id:scope.item.idSuiviPrevPatDone }), scope.item.suiviPrevPatDone);
					}
					scope.item.suiviPrev = {};
					angular.copy(_.findWhere(scope.suiviPrevs.base, {id:scope.item.idSuiviPrev }), scope.item.suiviPrev);
					//scope.item.suiviPrevPatDoneAll = _.filter(scope.suiviPrevs.patdone, function(s){ return s.idSuiviPrev=scope.item.idSuiviPrev; });
					if (scope.item.isEditing===true) {
						scope.item.activeSuiviPrevDone = scope.item.suiviPrevPatDone;
						scope.item.activeSuiviPrevDone.doneDateStr = scope.item.activeSuiviPrevDone ? OfysUtils.daysFrom1970ToStr(scope.item.activeSuiviPrevDone.doneDate).replace('-01-01','') : "";
					} else if (isDeleting!==true && scope.itemaction.isDeleting==true) {
						scope.showSuiviPrev = true;
						scope.options.showDetails=false;	// cacher detail au besoin.
						scope.showSuiviPrevBase=false;
						scope.showSuiviPrevProf=false;
						scope.showSuiviPrevPat=true;
						if (scope.item.suiviPat==undefined || scope.item.suiviPat.idSuiviPrev==undefined) {
							scope.addSuiviPrevPat(scope.item);							
						}
						scope.item.suiviPat.usage = 1;	// retirer
					} else {
						addSuiviPrevPatDone();
					}
				}
								
				function addSuiviPrevPatDone() {
					if (scope.item.activeSuiviPrevDone == undefined) {								
						scope.item.activeSuiviPrevDone = {
							//idPatient: scope.itemaction.patient().id,
							idPatient: scope.item.idPatient,
							idSuiviPrev: scope.item.idSuiviPrev,
							idSuiviPrevPat: scope.item.idSuiviPrevPat,
							idSuiviPrevProf: scope.item.idSuiviPrevProf,
							idProfessionnal: model.user().profil.id,
							doneDate: OfysUtils.localDateFrom1970(),
							doneDateStr: moment().format(OfysUtils.DATEFORMAT), 
							modificationStatus: ModificationStatus.STATUS_NEW,
							isDeleted: false,
						};					
					}
				}
				scope.nextSuiviDate = function(sp) {
					if (sp.folMonths==9999) return $filter("translate")("NEED_ONLY_ONCE");
					if (sp.activeSuiviPrevDone && sp.activeSuiviPrevDone.doneDate != sp.nextScheduledDate) {
						sp.nextScheduledDate = sp.activeSuiviPrevDone.doneDate + (30.4375 * sp.folMonths) + 1;
					}
					if (sp.nextScheduledDate) {
						return OfysUtils.daysFrom1970ToStr(sp.nextScheduledDate);
					}
					if (sp.activeSuiviPrevDone) {
						if (sp.activeSuiviPrevDone.doneDateStr) {
							sp.activeSuiviPrevDone.doneDate = OfysUtils.stringToLocalDate(sp.activeSuiviPrevDone.doneDateStr);
						}
						if (sp.activeSuiviPrevDone.doneDate) {
							return OfysUtils.daysFrom1970ToStr(sp.activeSuiviPrevDone.doneDate + (30.4375 * sp.folMonths) + 1);
						}
					}
					return undefined;
				}
								
				if (scope.itemaction && scope.itemaction.patient().id) {
					if (scope.itemaction.patient().viewbag == undefined) scope.itemaction.patient().viewbag = {};
					scope.item.isEditing = scope.itemaction.isEditing;
					if (scope.itemaction.patient().viewbag.suiviPrevsPat==undefined) {
						// scope.item est un CSummarySuiviPrev
						SuiviPrevAccessor.suiviPrevsPat(scope.itemaction.patient().id, function(data) {
							scope.itemaction.patient().viewbag.suiviPrevsPat = data;
							scope.suiviPrevs.pat = data;
							assignSuiviPrevPatToSumm();
							SuiviPrevAccessor.suiviPrevsPatDone(scope.itemaction.patient().id, function(data1) {
								scope.itemaction.patient().viewbag.suiviPrevsPatDone = data1;
								scope.suiviPrevs.patdone = data1;
								assignSuiviPrevPatDoneToSumm();
							}, function(err) {
								console.log(err);
							});
						}, function(err) {
							console.log(err);
						});
					} else {
						scope.suiviPrevs.pat = scope.itemaction.patient().viewbag.suiviPrevsPat;
						scope.suiviPrevs.patdone = scope.itemaction.patient().viewbag.suiviPrevsPatDone;
						assignSuiviPrevPatToSumm();
						assignSuiviPrevPatDoneToSumm();
					}
				}
				
				function setValuesToSummarySuiviPrev(d, sp) {
					scope.item.suiviPrevPatDone = d;
					scope.item.activeSuiviPrevDone = d;
					scope.item.activeSuiviPrevDone.doneDateStr = OfysUtils.daysFrom1970ToStr(d.doneDate).replace('-01-01','');
					scope.item.idSuiviPrevPatDone = d.id;
					scope.item.doneIdSuiviPrev = d.id;
					scope.item.idProfessionnal = d.idProfessionnal;
					scope.item.doneDate = d.doneDate;
					scope.item.nextScheduledDate = sp.folMonths==9999 ? undefined : d.doneDate  + (30.4375 * sp.folMonths) + 1;
					scope.item.note = d.note;					
					scope.item.toDo = false;	//faudrait probablement pas considérer que done ici; faudrait le confirmer selon la date...
				}
				scope.saveSuiviPrevPatDone = function(sp) {
					if (sp.activeSuiviPrevDone==undefined && sp.lastData && sp.lastData.doneDate) {
						// called from patient.js 
						addSuiviPrevPatDone();
						sp.activeSuiviPrevDone.doneDate = sp.lastData.doneDate;
						sp.activeSuiviPrevDone.note = sp.lastData.note;
						sp.nextScheduledDate = sp.folMonths==9999 ? undefined : sp.activeSuiviPrevDone.doneDate + (30.4375 * sp.folMonths) + 1;
					} else {
						sp.activeSuiviPrevDone.doneDate = OfysUtils.stringToLocalDate(sp.activeSuiviPrevDone.doneDateStr);
					}
					if (sp.activeSuiviPrevDone.modificationStatus==undefined || sp.activeSuiviPrevDone.modificationStatus==ModificationStatus.STATUS_NEUTRAL) {
						sp.activeSuiviPrevDone.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					SuiviPrevAccessor.saveSuiviPatDone(sp.activeSuiviPrevDone, function(d) {
						var idx = _.findIndex(scope.suiviPrevs.patdone, function(a){ return a.id==d.id;})
						if (idx!=-1) {
							if (d.isDeleted) {
								scope.suiviPrevs.patdone.splice(idx, 1);
								if (scope.item.suiviPrevPatDone) delete scope.item.suiviPrevPatDone;
								if (scope.item.activeSuiviPrevDone) delete scope.item.activeSuiviPrevDone;
								if (scope.item.idSuiviPrevPatDone) delete scope.item.idSuiviPrevPatDone;
								if (scope.item.doneIdSuiviPrev) delete scope.item.doneIdSuiviPrev;
								if (scope.item.doneIdSuiviPrevProf) delete scope.item.doneIdSuiviPrevProf;
								if (scope.item.doneIdSuiviPrevPat) delete scope.item.doneIdSuiviPrevPat;
								if (scope.item.idProfessionnal) delete scope.item.idProfessionnal;
								if (scope.item.doneDate) delete scope.item.doneDate;
								if (scope.item.note) delete scope.item.note;
								scope.item.toDo = true;
							} else {
								scope.suiviPrevs.patdone[idx] = d;
//								var idx1 = _.findIndex(scope.item.suiviPrevPatDoneAll, function(a){ return a.id==d.id;});
//								if (idx1!=-1) {scope.item.suiviPrevPatDoneAll[idx1] = d;}
								setValuesToSummarySuiviPrev(d, sp);
							}
						} else {
							if (scope.suiviPrevs.patdone==undefined) {
								scope.suiviPrevs.patdone = [];								
							}
							scope.suiviPrevs.patdone.push(d);
//							scope.item.suiviPrevPatDoneAll.push(d);
							setValuesToSummarySuiviPrev(d, sp);
						}
						model.patientSumUpdated(true);
					}, function(err) {
						console.log(err);
					});					
				}
				
				scope.resetSuiviPrevPatDone = function(sp) {
					if (sp.activeSuiviPrevDone) {
						delete sp.activeSuiviPrevDone;
					}
				}
				
				scope.saveSuiviPrevPat = function(sp) {
					if (sp.suiviPat.modificationStatus==undefined || sp.suiviPat.modificationStatus==ModificationStatus.STATUS_NEUTRAL) {
						sp.suiviPat.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					sp.suiviPat.targetGtAge = OfysUtils.isEmpty(sp.suiviPat.targetGtAge)?undefined:sp.suiviPat.targetGtAge;
					sp.suiviPat.targetLtAge = OfysUtils.isEmpty(sp.suiviPat.targetLtAge)?undefined:sp.suiviPat.targetLtAge;
					sp.suiviPat.specFolMonths = OfysUtils.isEmpty(sp.suiviPat.specFolMonths)?undefined:sp.suiviPat.specFolMonths;					
					sp.suiviPat.rappelAutoMois = OfysUtils.isEmpty(sp.suiviPat.rappelAutoMois)?undefined:sp.suiviPat.rappelAutoMois;
					sp.suiviPat.rappelAutoText = OfysUtils.isEmpty(sp.suiviPat.rappelAutoText)?undefined:sp.suiviPat.rappelAutoText;

					SuiviPrevAccessor.saveSuiviPat(sp.suiviPat, function(d) {
						var idx = _.findIndex(scope.suiviPrevs.pat, function(a){ return a.id==d.id;})
						if (d.deactivatedDate) {
							if (idx!=-1) {scope.suiviPrevs.pat.splice(idx, 1);}
							if (sp.suiviPat) {delete sp.suiviPat;}
							if (sp.idSuiviPrevPat) {delete sp.idSuiviPrevPat;}
						} else {
							if (idx!=-1) {
								scope.suiviPrevs.pat[idx] = d;
							} else {
								scope.suiviPrevs.pat.push(d);								
							}
							sp.suiviPat = {}; angular.copy(d, sp.suiviPat);
							sp.idSuiviPrevPat = d.id;
						}
						scope.toggleSuiviPrevPat();
						model.patientSumUpdated(true);
					}, function(err) {
						console.log(err);
					});					
				}
				
				scope.saveSuiviPrevProf = function(sp) {
					if (sp.suiviProf.modificationStatus==undefined || sp.suiviProf.modificationStatus==ModificationStatus.STATUS_NEUTRAL) {
						sp.suiviProf.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					sp.suiviProf.targetGtAge = OfysUtils.isEmpty(sp.suiviProf.targetGtAge)?undefined:sp.suiviProf.targetGtAge;
					sp.suiviProf.targetLtAge = OfysUtils.isEmpty(sp.suiviProf.targetLtAge)?undefined:sp.suiviProf.targetLtAge;
					sp.suiviProf.folMonths = OfysUtils.isEmpty(sp.suiviProf.folMonths)?undefined:sp.suiviProf.folMonths;
					sp.suiviProf.targetGtAgeWithRiskFact = OfysUtils.isEmpty(sp.suiviProf.targetGtAgeWithRiskFact)?undefined:sp.suiviProf.targetGtAgeWithRiskFact;
					sp.suiviProf.targetLtAgeWithRiskFact = OfysUtils.isEmpty(sp.suiviProf.targetLtAgeWithRiskFact)?undefined:sp.suiviProf.targetLtAgeWithRiskFact;
					sp.suiviProf.folMonthsWithRiskFact = OfysUtils.isEmpty(sp.suiviProf.folMonthsWithRiskFact)?undefined:sp.suiviProf.folMonthsWithRiskFact;
					
					sp.suiviProf.idProfessionnal = model.user().profil.id;
					SuiviPrevAccessor.saveSuiviProf(sp.suiviProf, function(d) {
						var idx = _.findIndex(scope.suiviPrevs.prof, function(a){ return a.id==d.id;})
						if (d.deactivatedDate) {
							if (idx!=-1) {scope.suiviPrevs.prof.splice(idx, 1);}
							if (sp.suiviProf) {delete sp.suiviProf;}
							if (sp.idSuiviPrevProf) {delete sp.idSuiviPrevProf;}
						} else {
							if (idx!=-1) {
								scope.suiviPrevs.prof[idx] = d;
							} else {
								scope.suiviPrevs.prof.push(d);								
							}
							sp.suiviProf = {}; angular.copy(d, sp.suiviProf);
							sp.idSuiviPrevProf = d.id;		
						}
						scope.toggleSuiviPrevProf();
						model.patientSumUpdated(true);
					}, function(err) {
						console.log(err);
					});					
				}
				
				scope.delSuiviPrevPatDone = function(sp) {
					if (sp.activeSuiviPrevDone==undefined) {return;}
					if (sp.activeSuiviPrevDone.id==undefined) {
						delete sp.activeSuiviPrevDone;
						return;
					}
					sp.activeSuiviPrevDone.isDeleted =true;
					scope.saveSuiviPrevPatDone(sp);
				}
				
				scope.delSuiviPrevPat = function(sp) {
					if (sp.suiviPat==undefined) {return;}
					if (sp.suiviPat.id==undefined) {
						delete sp.suiviPat;
						return;
					}
					sp.suiviPat.deactivatedDate = OfysUtils.localDateFrom1970()-1;
					scope.saveSuiviPrevPat(sp);
				}
				scope.undelSuiviPrevPat = function(sp) {
					scope.toggleSuiviPrevPat();
				}
				scope.cancelSuiviPrevPat = function(sp) {
					if (sp.suiviPat && sp.suiviPat.id) {
						var spid = sp.suiviPat.id;
						sp.suiviPat = {}; angular.copy(_.findWhere(scope.suiviPrevs.pat, {id:spid}), sp.suiviPat);
						// annulation de modifidcation. 
					} else {
						delete sp.suiviPat;
					}
					scope.toggleSuiviPrevPat();
				}

				scope.toggleSuiviPrev = function() {
					scope.showSuiviPrev = !scope.showSuiviPrev;
					if (scope.itemaction.isDeleting==true) {
						assignSuiviPrevToSumm(true);
					}
					scope.options.showDetails=false;	// cacher detail au besoin.
				}
				scope.toggleSuiviPrevBase = function() {
					if (scope.showSuiviPrevBase===true) {
						scope.showSuiviPrevBase=false;
					} else {
						scope.showSuiviPrevProf=false;
						scope.showSuiviPrevPat=false;
						scope.showSuiviPrevBase=true;
					}
				}
				scope.toggleSuiviPrevProf = function() {
					if (scope.showSuiviPrevProf===true) {
						scope.showSuiviPrevProf=false;
					} else {
						scope.showSuiviPrevBase=false;
						scope.showSuiviPrevPat=false;
						scope.showSuiviPrevProf=true;
					}
				}
				scope.toggleSuiviPrevPat = function() {
					if (scope.showSuiviPrevPat===true) {
						scope.showSuiviPrevPat=false;
					} else {
						scope.showSuiviPrevBase=false;
						scope.showSuiviPrevProf=false;
						scope.showSuiviPrevPat=true;
					}
				}
				
				scope.hasNoSuiviPat = function(sp) {
					return sp.suiviPat==undefined || sp.suiviPat.idSuiviPrev==undefined
				}				
				scope.hasNoSuiviProf = function(sp) {
					return sp.suiviProf==undefined || sp.suiviProf.idSuiviPrev==undefined
				}
				scope.addSuiviPrevProf = function(sp) {
					if (sp.suiviProf==undefined || sp.suiviProf.idSuiviPrev==undefined) {
						sp.suiviProf = {
							idSuiviPrev: sp.idSuiviPrev,
							idProfessionnal:model.user().profil.id,
							activatedDate: OfysUtils.localDateFrom1970(),
							modificationStatus: ModificationStatus.STATUS_NEW,
							doNotUse:false
						};
					}
				}
				scope.delSuiviPrevProf = function(sp) {
					if (sp.suiviProf==undefined) return;
					if (sp.suiviProf.id==undefined) {
						delete sp.suiviProf;
						return;
					}
					sp.suiviProf.deactivatedDate = OfysUtils.localDateFrom1970()-1;
					scope.saveSuiviPrevProf(sp);
				}
				scope.cancelSuiviPrevProf = function(sp) {
					if (sp.suiviProf && sp.suiviProf.id) {
						var spid = sp.suiviProf.id;
						sp.suiviProf = {}; angular.copy(_.findWhere(scope.suiviPrevs.prof, {id:spid}), sp.suiviProf);
						// annulation de modifidcation. 
					} else {
						delete sp.suiviProf;
					}
					scope.toggleSuiviPrevProf();
				}
				
				scope.dateDynaOptions = angular.copy({
					hasCalendar: false,
					acceptFutureDate: false,
				});
				
				function init(){
				}

				init();
			}
		}
	}]);


	suiviprev.directive('suiviPrevData',['SuiviPrevAccessor','model','$filter', 'ModificationStatus', 'patientShowTitles',
								function(SuiviPrevAccessor, model, $filter, ModificationStatus, patientShowTitles){
		return {
			restrict: 'EA',
			link: function(scope, element, attrs){
				
				scope.model = model;
				scope.patientShowTitles = patientShowTitles;
				scope.showSuiviPrevBase=false;
				scope.showSuiviPrevProf=false;
				scope.showProfRappelAutoText=true;
				scope.showAdminRappelAutoText=false;
				
				scope.showRappelAutoProf = function () {
					return scope.suiviPrevBase && scope.suiviPrevBase.canSendRappelAuto === true ? true : false;
				};
				scope.showSuiviPrevPat=false;
				scope.showRappelAutoPat = function () {
					return scope.showRappelAutoProf()===true && scope.suiviPrevBase.suiviProf && scope.suiviPrevBase.suiviProf.rappelAutoMois !== undefined && scope.suiviPrevBase.suiviProf.rappelAutoMois > -1 && scope.itemaction.patient().treatingProfessionnal===model.user().profil.id;
				};
				// pour tester
				// model.user().isAdmin = true;
				// fin test
				scope.suiviPrevs = {};
				scope.suiviPrevBase = scope.item;
				scope.suiviPrevBase.idPatient= scope.itemaction.patient().id
				
				scope.suiviStatus = [{val: 0, name: $filter("translate")('INCLURE_DS_SUIVIS')}, {val: 1, name: $filter("translate")('RETIRER_DES_SUIVIS')}, {val: 2, name: $filter("translate")('INCLURE_MEME_SI_PROF_EXCLU')}];
				
				function getSuivPrevBaseProfAndText() {
					SuiviPrevAccessor.suiviPrevsBase(function(data) {
						scope.suiviPrevs.base = data;
						if (model.user().profil && model.user().profil) {
							SuiviPrevAccessor.suiviPrevsProf(model.user().profil.id, function(data1) {
								scope.suiviPrevs.prof = data1;
								scope.suiviPrevBase.suiviProf = {};
								angular.copy(_.findWhere(data1, {idSuiviPrev:scope.suiviPrevBase.id}), scope.suiviPrevBase.suiviProf);
								scope.isActiveShowRappelAutoProf = isActiveShowRappelAutoProf(scope.suiviPrevBase.suiviProf);
							}, function(err) {
								console.log(err);
							});
						}
						if (model.user().isAdmin) {
							SuiviPrevAccessor.suiviPrevsText(function(data1) {
								scope.suiviPrevs.text = data1;
								scope.suiviPrevBase.clientText = {};
								angular.copy(_.findWhere(data1, {idSuiviPrev:scope.suiviPrevBase.id}), scope.suiviPrevBase.clientText);
							}, function(err) {
								console.log(err);
							});
						}
						
					}, function(err) {
						console.log(err);
					});
				}
				
				function isActiveShowRappelAutoProf(sp) {
					return sp!==undefined && sp.rappelAutoMois!==undefined;
				}
				scope.toggleActiveRappelAutoProf = function(sp) {
					if (isActiveShowRappelAutoProf(sp)) {
						if (sp.rappelAutoMois) delete sp.rappelAutoMois;
						scope.isActiveShowRappelAutoProf = false;
					} else {
						sp.rappelAutoMois = 3;
						scope.isActiveShowRappelAutoProf = true;
					}
				}
				scope.changeRappelAutoMoisProf = function(sp) {
					scope.isActiveShowRappelAutoProf = isActiveShowRappelAutoProf(sp);
				}
				
				getSuivPrevBaseProfAndText();

				if (scope.itemaction && scope.itemaction.patient().id) {
					if (scope.itemaction.patient().viewbag == undefined) scope.itemaction.patient().viewbag = {};
					if (scope.itemaction.patient().viewbag.suiviPrevsPat==undefined) {
						// scope.item est un CSummarySuiviPrev
						SuiviPrevAccessor.suiviPrevsPat(scope.itemaction.patient().id, function(d) {
							scope.suiviPrevs.pat = d;
							scope.itemaction.patient().viewbag.suiviPrevsPat = d;
							scope.suiviPrevBase.suiviPat = {};
							angular.copy(_.findWhere(d, {idSuiviPrev:scope.suiviPrevBase.id}), scope.suiviPrevBase.suiviPat);
							scope.isActiveShowRappelAutoPat = isActiveShowRappelAutoPat(scope.suiviPrevBase.suiviPat);
						}, function(err) {
							console.log(err);
						});
					} else {
						scope.suiviPrevs.pat = scope.itemaction.patient().viewbag.suiviPrevsPat;
						scope.suiviPrevBase.suiviPat = {};
						angular.copy(_.findWhere(scope.itemaction.patient().viewbag.suiviPrevsPat, {idSuiviPrev:scope.suiviPrevBase.id}), scope.suiviPrevBase.suiviPat);
						scope.isActiveShowRappelAutoPat = isActiveShowRappelAutoPat(scope.suiviPrevBase.suiviPat);
					}
				}
				function isActiveShowRappelAutoPat(sp) {
					return sp==undefined || sp.rappelAutoMois!=-1;
				}
				scope.toggleActiveRappelAutoPat = function(sp) {
					if (isActiveShowRappelAutoPat(sp)) {
						if (sp.rappelAutoMois != -1) sp.rappelAutoMois = -1;
						scope.isActiveShowRappelAutoPat = false;
					} else {
						if (sp.rappelAutoMois!==undefined) delete sp.rappelAutoMois;
						scope.isActiveShowRappelAutoPat = true;
					}
				}
				scope.changeRappelAutoMoisPat = function(sp) {
					scope.isActiveShowRappelAutoPat = isActiveShowRappelAutoPat(sp);
				}
				
				scope.addSuiviPrevPat = function(sp) {
					if (sp.suiviPat==undefined || sp.suiviPat.idSuiviPrev==undefined) {
						sp.suiviPat = {
							idPatient: sp.idPatient,
							idSuiviPrev: sp.id,
							idProfessionnal: model.user().profil.id,
							hasLifeStyleRiskfact: false,
							hasFamilyHxRiskfact: false,
							activatedDate: OfysUtils.localDateFrom1970(),
							usage: 0,
							isDeleted: false,
							modificationStatus: ModificationStatus.STATUS_NEW,
							note: ''
						}
					}
				}

				scope.saveSuiviPrevPat = function(sp) {
					if (sp.suiviPat.modificationStatus==undefined || sp.suiviPat.modificationStatus==ModificationStatus.STATUS_NEUTRAL) {
						sp.suiviPat.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					sp.suiviPat.targetGtAge = OfysUtils.isEmpty(sp.suiviPat.targetGtAge)?undefined:sp.suiviPat.targetGtAge;
					sp.suiviPat.targetLtAge = OfysUtils.isEmpty(sp.suiviPat.targetLtAge)?undefined:sp.suiviPat.targetLtAge;
					sp.suiviPat.specFolMonths = OfysUtils.isEmpty(sp.suiviPat.specFolMonths)?undefined:sp.suiviPat.specFolMonths;
					
					sp.suiviPat.rappelAutoMois = OfysUtils.isEmpty(sp.suiviPat.rappelAutoMois)?undefined:sp.suiviPat.rappelAutoMois;
					sp.suiviPat.rappelAutoText = OfysUtils.isEmpty(sp.suiviPat.rappelAutoText)?undefined:sp.suiviPat.rappelAutoText;

					SuiviPrevAccessor.saveSuiviPat(sp.suiviPat, function(d) {
						var idx = _.findIndex(scope.suiviPrevs.pat, function(a){ return a.id==d.id;})
						if (d.deactivatedDate) {
							if (idx!=-1) {scope.suiviPrevs.pat.splice(idx, 1);}
							if (sp.suiviPat) {delete sp.suiviPat;}
						} else {
							if (idx!=-1) {
								scope.suiviPrevs.pat[idx] = d;
							} else {
								scope.suiviPrevs.pat.push(d);								
							}
							sp.suiviPat = {}; angular.copy(d, sp.suiviPat);
						}
						scope.toggleSuiviPrevPat();
						model.patientSumUpdated(true);
					}, function(err) {
						console.log(err);
					});					
				}
				
				scope.saveSuiviPrevProf = function(sp) {
					if (sp.suiviProf.modificationStatus==undefined || sp.suiviProf.modificationStatus==ModificationStatus.STATUS_NEUTRAL) {
						sp.suiviProf.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					sp.suiviProf.targetGtAge = OfysUtils.isEmpty(sp.suiviProf.targetGtAge)?undefined:sp.suiviProf.targetGtAge;
					sp.suiviProf.targetLtAge = OfysUtils.isEmpty(sp.suiviProf.targetLtAge)?undefined:sp.suiviProf.targetLtAge;
					sp.suiviProf.folMonths = OfysUtils.isEmpty(sp.suiviProf.folMonths)?undefined:sp.suiviProf.folMonths;
					sp.suiviProf.targetGtAgeWithRiskFact = OfysUtils.isEmpty(sp.suiviProf.targetGtAgeWithRiskFact)?undefined:sp.suiviProf.targetGtAgeWithRiskFact;
					sp.suiviProf.targetLtAgeWithRiskFact = OfysUtils.isEmpty(sp.suiviProf.targetLtAgeWithRiskFact)?undefined:sp.suiviProf.targetLtAgeWithRiskFact;
					sp.suiviProf.folMonthsWithRiskFact = OfysUtils.isEmpty(sp.suiviProf.folMonthsWithRiskFact)?undefined:sp.suiviProf.folMonthsWithRiskFact;

					sp.suiviProf.rappelAutoMois = OfysUtils.isEmpty(sp.suiviProf.rappelAutoMois)?undefined:sp.suiviProf.rappelAutoMois;
					sp.suiviProf.rappelAutoText = OfysUtils.isEmpty(sp.suiviProf.rappelAutoText)?undefined:sp.suiviProf.rappelAutoText;

					sp.suiviProf.idProfessionnal = model.user().profil.id;
					SuiviPrevAccessor.saveSuiviProf(sp.suiviProf, function(d) {
						var idx = _.findIndex(scope.suiviPrevs.prof, function(a){ return a.id==d.id;})
						if (d.deactivatedDate) {
							if (idx!=-1) {scope.suiviPrevs.prof.splice(idx, 1);}
							if (sp.suiviProf) {delete sp.suiviProf;}
						} else {
							if (idx!=-1) {
								scope.suiviPrevs.prof[idx] = d;
							} else {
								scope.suiviPrevs.prof.push(d);								
							}
							sp.suiviProf = {}; angular.copy(d, sp.suiviProf);
						}
						scope.toggleSuiviPrevProf();
						model.patientSumUpdated(true);
					}, function(err) {
						console.log(err);
					});					
				}

				scope.saveAdminRappelAutoText = function(sp) {
					// SVP prendre RV avec l'IPS.
					if (sp.clientText.idSuiviPrev==undefined) {
						sp.clientText.idSuiviPrev = sp.id;
						sp.clientText.modificationStatus = ModificationStatus.STATUS_NEW;
					}
					if (sp.clientText.modificationStatus==undefined || sp.clientText.modificationStatus==ModificationStatus.STATUS_NEUTRAL) {
						sp.clientText.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					if (OfysUtils.isEmpty(sp.clientText.rappelAutoText)) {
						sp.clientText.rappelAutoText = undefined;
						sp.clientText.modificationStatus = ModificationStatus.STATUS_DELETED;
					}
					SuiviPrevAccessor.saveAdminRappelAutoText(sp.clientText, function(d) {
						var idx = _.findIndex(scope.suiviPrevs.text, function(a){ return a.id==d.id;})
						if (idx!=-1) {
							scope.suiviPrevs.text[idx] = d;
						} else {
							scope.suiviPrevs.text.push(d);
						}
						sp.clientText.modificationStatus=ModificationStatus.STATUS_NEUTRAL;
						sp.clientText.id = d.id;
						sp.clientText.version = d.version;
						scope.toggleProfRappelAutoText();
					}, function(err) {
						console.log(err);
					});					
				}
				scope.delAdminRappelAutoText = function(sp) {
					if (sp.clientText==undefined) {return;}
					if (sp.clientText.id==undefined) {
						delete sp.clientText;
						return;
					}
					sp.clientText.rappelAutoText = undefined;
					sp.clientText.modificationStatus = ModificationStatus.STATUS_DELETED;
					scope.saveAdminRappelAutoText(sp);
				}
				scope.cancelAdminRappelAutoText = function(sp) {
					if (sp.clientText && sp.clientText.id) {
						var spid = sp.clientText.id; sp.clientText = {};
						angular.copy(_.findWhere(scope.suiviPrevs.text, {id:spid}), sp.clientText);
					} else {
						delete sp.clientText;
					}
					scope.toggleProfRappelAutoText();
				}

				scope.delSuiviPrevPat = function(sp) {
					if (sp.suiviPat==undefined) {return;}
					if (sp.suiviPat.id==undefined) {
						delete sp.suiviPat;
						return;
					}
					sp.suiviPat.deactivatedDate = OfysUtils.localDateFrom1970()-1;
					scope.saveSuiviPrevPat(sp);
				}
				scope.undelSuiviPrevPat = function(sp) {
					scope.toggleSuiviPrevPat();
				}
				scope.cancelSuiviPrevPat = function(sp) {
					// annulation de modifidcation. 
					if (sp.suiviPat && sp.suiviPat.id) {
						var spid = sp.suiviPat.id; sp.suiviPat = {};
						angular.copy(_.findWhere(scope.suiviPrevs.pat, {id:spid}), sp.suiviPat);
					} else {
						delete sp.suiviPat;
					}
					scope.toggleSuiviPrevPat();
				}

				scope.toggleSuiviPrevBase = function() {
					if (scope.showSuiviPrevBase===true) {
						scope.showSuiviPrevBase=false;
					} else {
						scope.options.showDetails=false;	// cacher detail au besoin.
						scope.showSuiviPrevProf=false;
						scope.showSuiviPrevPat=false;
						scope.showSuiviPrevBase=true;
					}
				}
				scope.toggleSuiviPrevProf = function() {
					if (scope.showSuiviPrevProf===true) {
						scope.showSuiviPrevProf=false;
					} else {
						scope.options.showDetails=false;	// cacher detail au besoin.
						scope.showSuiviPrevBase=false;
						scope.showSuiviPrevPat=false;
						scope.showSuiviPrevProf=true;
					}
				}
				scope.toggleSuiviPrevPat = function() {
					if (scope.showSuiviPrevPat===true) {
						scope.showSuiviPrevPat=false;
					} else {
						scope.options.showDetails=false;	// cacher detail au besoin.
						scope.showSuiviPrevBase=false;
						scope.showSuiviPrevProf=false;
						scope.showSuiviPrevPat=true;
					}
				}
				scope.toggleProfRappelAutoText = function() {
					if (scope.showProfRappelAutoText!==true) {
						scope.showProfRappelAutoText=true;
						scope.showAdminRappelAutoText=false;						
					}
				}
				scope.toggleAdminRappelAutoText = function() {
					if (scope.showAdminRappelAutoText!==true) {
						scope.showAdminRappelAutoText=true;
						scope.showProfRappelAutoText=false;
					}
				}
				
				scope.hasNoSuiviPat = function(sp) {
					return sp.suiviPat==undefined || sp.suiviPat.idSuiviPrev==undefined;
				}				
				scope.hasNoSuiviProf = function(sp) {
					return sp.suiviProf==undefined || sp.suiviProf.idSuiviPrev==undefined;
				}				
				scope.hasNoAdminRappelAutoText = function() {
					return scope.suiviPrevBase.clientText==undefined || scope.suiviPrevBase.clientText.idSuiviPrev==undefined;
				}				

				scope.addSuiviPrevProf = function(sp) {
					if (sp.suiviProf==undefined || sp.suiviProf.idSuiviPrev==undefined) {
						sp.suiviProf = {
							idSuiviPrev: sp.id,
							idProfessionnal:model.user().profil.id,
							activatedDate: OfysUtils.localDateFrom1970(),
							modificationStatus: ModificationStatus.STATUS_NEW,
							doNotUse:false
						};
					}
				}
				scope.delSuiviPrevProf = function(sp) {
					if (sp.suiviProf==undefined) return;
					if (sp.suiviProf.id==undefined) {
						delete sp.suiviProf;
						return;
					} else if (sp.suiviProf.modificationStatus==undefined) {
						sp.suiviProf.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					sp.suiviProf.deactivatedDate = OfysUtils.localDateFrom1970()-1;
					scope.saveSuiviPrevProf(sp);
				}				
				scope.cancelSuiviPrevProf = function(sp) {
					if (sp.suiviProf && sp.suiviProf.id) {
						var spid = sp.suiviProf.id; sp.suiviProf = {};
						angular.copy(_.findWhere(scope.suiviPrevs.prof, {id:spid}), sp.suiviProf);
					} else {
						delete sp.suiviProf;
					}
					scope.toggleSuiviPrevProf();
				}
				
				scope.dateDynaOptions = angular.copy({
					hasCalendar: false,
					acceptFutureDate: false,
				});
				
				function init(){
				}

				init();
			}
		}
	}]);


})()