(function(){
	var pref = angular.module('pref', ['ngSanitize']);
	pref.factory('PrefAccessor', ['DashAPI','$filter',
	                            function(DashAPI, $filter ) {

		var accessor = {
			utils : {
			},
			browserSettings: {
				'list_qv_size': '1',
			},
			loadInitialBrowserSettings: function () {
				var settings = Object.keys(this.browserSettings);
				for (var i = 0; i < settings.length; i++){
					if(localStorage.getItem(settings[i]) != undefined){
						this.browserSettings[settings[i]] = localStorage.getItem(settings[i])
					}
				}
			},
			setBrowserProp: function (key,value) {
				this.browserSettings[key] = value;
				localStorage.setItem(key, value);
			},
			getUserSettings : function (keys, callback, error){
				DashAPI.get("/dashboard/pref/ws/getUserSetting?keys="+ keys, callback, error);
			},
			setUserSettings : function (keysdatapair, callback, error){
				DashAPI.get("/dashboard/pref/ws/setUserSetting?keysdatapair="+ keysdatapair, callback, error);
			},
			saveUserPref : function (data, callback, error){
				return DashAPI.post("/dashboard/pref/ws/user/savePref", data, callback, error);
			},
			saveClientPref : function (data, callback, error){
				return DashAPI.post("/dashboard/pref/ws/global/savePref", data, callback, error);
			},
			getUserProp : function (data, callback, error){
				DashAPI.post("/dashboard/pref/ws/user/get", data, callback, error);
			},
			contextSite: function(callback, error){
				DashAPI.get('/dashboard/pref/ws/contextSite', callback, error);
			},
			setContextSite: function(data, callback, error){
				DashAPI.post('/dashboard/pref/ws/contextSite',data, callback, error);
			},
			getGlobalProp : function (data, callback, error){
				DashAPI.post("/dashboard/pref/ws/global/get", data, callback, error);
			},
			setUserProp : function (data, callback, error){
				DashAPI.post("/dashboard/pref/ws/user/set", data, callback, error);
			},
			setGlobalProp : function (data, callback, error){
				DashAPI.post("/dashboard/pref/ws/global/set", data, callback, error);
			},
			restartJetty : function (q, callback, error){
				DashAPI.post("/dashboard/pref/ws/jetty_restart", q, callback, error);
			},
			getPrefs: function (callback, error) {
				return DashAPI.get('/dashboard/pref/ws/getPrefs', callback, error);
			},
			getPersonGroups: function(callback, error){
				return DashAPI.get('/dashboard/pref/ws/findPersonGroups', callback, error)
			},
			savePersonGroups: function(data, callback, error){
				return DashAPI.post('/dashboard/pref/ws/savePersonGroups', data, callback, error)
			},
			getWebLinks : function (q, callback, error){
				//If linkId is not provided, null or 0, the whole list of weblink in ofys are added.
				var url = "/dashboard/pref/ws/getWebLinks" + (q ? "?linkId=" + q : "");
				DashAPI.get(url, callback, error);
			}
		}
		accessor.loadInitialBrowserSettings();
		return accessor;
	}]);

	pref.controller('WorksiteSettingsController', ['$scope', 'model', 'PrefAccessor', '$log', 'Store',
		function($scope, model, PrefAccessor, $log, Store){
		$scope.siteSettings = {}
		$scope.workSites = angular.copy(Store.sites.filter.workSites.list()).map(function(e){
			e.isCurrent = function(site){
				if(site){
					var currSite = this;
					model.user().session.setWorkSite(currSite);
					PrefAccessor.setContextSite({site: currSite.id}, function(){ }, function(e){
						$log.error("Failed to set the site with id "+ currSite);
					});
				}
				return model.user().session.site === this.id;
			}
			return e;
		});

		$scope.activateAllFilters = function(){
			model.prefSettings("user_settings_SiteAppointments", true);
			model.prefSettings("user_settings_SiteLaboDocs", true);
			model.prefSettings("user_settings_SitePatients", true);
			model.prefSettings("user_settings_SiteMessages", true);
			model.prefSettings("user_settings_SiteTasks", true);
		}
		$scope.desactivateAllFilters = function(){
			model.prefSettings("user_settings_SiteAppointments", false);
			model.prefSettings("user_settings_SiteLaboDocs", false);
			model.prefSettings("user_settings_SitePatients", false);
			model.prefSettings("user_settings_SiteMessages", false);
			model.prefSettings("user_settings_SiteTasks", false);
		}

		model.addPrefSettings([
			'SiteAppointments',
			'SiteLaboDocs',
			'SitePatients',
			'SiteMessages',
			'SiteTasks',
		], $scope.siteSettings, 'user_settings_');
	}]);

	pref.controller('UserSettingsController', ['$scope', 'model','DashAPI','$http','SessionWatch','$filter',
	                                  function($scope, model, DashAPI, $http, SessionWatch, $filter){
		$scope.userSettings= {};
		model.addPrefSettings(['ShowAllLabs'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowRecPos'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowSuggPos'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['AlwaysShowOtherProv'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowMoreDemoData'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowAllProfsInAppt'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowCanceledAppt'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowAllProfsInLaboDoc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ExcludeMySeenLaboDoc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowProfsReplacedInLaboDoc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['SearchMdProvNB'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['SetSeenAuto'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['AlwaysAddBilling'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['AddSvInEnc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['AddMesuresInEnc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['AddConclusionInEnc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['DirectPrint'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['PrintRxDevSep'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['NoShowSignWarning'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['ShowSummaryDxInEnc'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['labOneLine'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['docOneLine'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['showLaboDocComments'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['UseNewPDFViewer'], $scope.userSettings, 'user_settings_');
		model.addPrefSettings(['labodoc_savenext'], $scope.userSettings, '');
		model.addPrefSettings(['labo_hide_header'], $scope.userSettings, '');
		model.addPrefSettings(['medNoteTypeSoap'], $scope.userSettings, 'user_settings_');

		this.logout = function () {
			DashAPI.get("/dashboard/Login/ws/logout", function (res) {
				model.logout();
				//console.log(res);
			}, function (err) {
				console.log(err);
			});
		}

		$scope.isDownloading = false;
		this.assist = function() {
			if ($scope.isDownloading===false) {
				$scope.isDownloading=true;
				 if (model.isWeb()) {
					 var app = OfysUtils.isMac===true ? 'AnyDesk.dmg' : (OfysUtils.isWin===true ? 'AnyDesk.exe' : undefined);
					 // SEE https://stackoverflow.com/questions/43262121/trying-to-use-fetch-and-pass-in-mode-no-cors
					 if (app) {
						 //var proxyUrl = 'https://cors-anywhere.herokuapp.com/',
						 //targetUrl = 'https://www.ofys.ca/tv/' + app;
						 targetUrl = 'https://ofys.net/download/tv/' + app;
						 //fetch(proxyUrl+targetUrl)
						 fetch(targetUrl)
						 .then(function(resp) {
							 return resp.blob()
							})
						 .then(function(blob) {
							 var url = window.URL.createObjectURL(blob);
							 var a = document.createElement('a');
							 a.style.display = 'none';
							 a.href = url;
							 // the filename you want
							 a.download = app;
							 document.body.appendChild(a);
							 a.click();
							 window.URL.revokeObjectURL(url);
							 $scope.isDownloading = false;
							model.notice().success($filter('translate')('DOWNLOAD_SUCCESS'));
						 })
						 .catch(function(err) {
							 $scope.isDownloading = false;
							 alert('Erreur / Error!\n' + err);
						 });
					 }
				 } else {
					 DashAPI.get("/dashboard/Login/ws/assist", function (res) {
						 $scope.isDownloading = false;
					 }, function (err) {
						 $scope.isDownloading = false;
						 console.log(err);
					 });
				 }
			}
		};
		this.lockSession = function () {
			DashAPI.get("/dashboard/Login/ws/logout", function (res) {
				SessionWatch.status = 'EXPIRED';
			}, function (err) {
				console.log(err);
			});
		}
		$scope.isWeb = model.isWeb();
		this.toggleLang = function () {
			DashAPI.updateLanguage(DashAPI.lang === 'fr'? 'en': 'fr');
			// this is a get call since updateLanguages sets the cookie, this calls also updates the locale server side.
			$http.get('/dashboard/User/ws/lang');
			model.translationUpdate("translation", true);
		}
	}]);

	pref.controller('PreferencesController', ['$scope', 'model', '$filter','PrefAccessor', 'QValidation',
	                                  function($scope, model, $filter, prefAccessor, QValidation){
		
		$scope.isReady = false
		
		$scope.activePanels = [];
		$scope.prefList = [
			{name:'Preferences', sections:[
				{code: 'client', name: 'clientPref'},
				{code: 'user', name: 'userPref'},
			]},
			{name:'prefOther', sections:[
				{code: 'personGroup', name: 'personGroup'}
			]}
		]
		
		$scope.chosenPref = $scope.prefList[0].sections[0];
		
		function init(){
			prefAccessor.getPrefs(function(res){
				$scope.updateClientsPref(res.clientPreferences)
				$scope.userPrefs = res.userPreferences;
				$scope.userPrefsOrig = angular.copy($scope.userPrefs);
				model.actUpdated(true);
				$scope.isReady = true;
			})
			model.callDashBoardCount();
		}
		
		function getColorString(color){
			return "rgb("+color.join(", ")+")";
		}
		
		$scope.updateClientsPref = function(res){
			$scope.clientPrefs = res;
			updateCLientColors();
			$scope.clientPrefsOrig = angular.copy($scope.clientPrefs);
		}
		
		function updateCLientColors(){
			$scope.colorApptList = [];
			$scope.colorPatList = [];
			$scope.colorCalendarList = [];
			$scope.colorDayList = [];
			for(var propName in $scope.clientPrefs){
				if(propName.includes("color") && propName.substr(propName.length - 3) !== "Str"){
					$scope.clientPrefs[propName + "Str"] =  getColorString($scope.clientPrefs[propName]);
					if(propName.includes("Appointment") && !propName.includes("Status")) $scope.colorApptList.push(propName);
					else if(propName.includes("Patient")) $scope.colorPatList.push(propName);
					else if(propName.includes("Calendar")) $scope.colorCalendarList.push(propName);
					else if(propName.includes("Day")) $scope.colorDayList.push(propName);
				}
			}
			for(let i=0; i<$scope.clientPrefs.appointmentPeriodTypes.length; i++){
				$scope.clientPrefs.appointmentPeriodTypes[i].colorStr = getColorString($scope.clientPrefs.appointmentPeriodTypes[i].color);
			}
			for(let i=0; i<$scope.clientPrefs.appointmentTypes.length; i++){
				$scope.clientPrefs.appointmentTypes[i].colorStr = getColorString($scope.clientPrefs.appointmentTypes[i].color);
			}
		}
		
		$scope.isActive = function(pref){
			return $scope.chosenPref == pref;
		}
		
		$scope.selectPrefToEdit = function(pref){
			QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
				if(successful){
					$scope.chosenPref = pref;
				}
			});
		}
		
		init();
		
	}]);
	
	pref.directive('clientPrefs', ['model', 'ModificationStatus', '$filter', 'PrefAccessor', 'FlView', 'QValidation', 'QConfirm',
										'DashWebSocket', 'PatientFormService', '$q', '$translate',
	                               function(model, ModificationStatus, $filter, prefAccessor, FlView, QValidation, QConfirm,
	                               			DashWebSocket, PatientFormService, $q, $translate){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/settings/client_prefs.html?v=ay',
			link: function(scope, element, attrs){
				
				scope.prescriptionPrintFormatClient = angular.copy(Object.values(model.enums().prescriptionPrintFormat));
				scope.currency = angular.copy(Object.values(model.enums().currency));
				
				scope.isAdmin = model.user().isAdmin;
				
				scope.inactiveFilter = {
					apptType:{
						actif: {val:true, name:'profActives', code: "actif"},
						inactif: {val:false, name:'profInactives', code: "inactif"},
						all: {val:false, name:'All', code: "all"}
					},
					scheduleType:{
						actif: {val:true, name:'profActives', code: "actif"},
						inactif: {val:false, name:'profInactives', code: "inactif"},
						all: {val:false, name:'All', code: "all"}
					}
				}
				scope.activeFilterAppt = scope.inactiveFilter.apptType["actif"];
				scope.activeFilterSchedule = scope.inactiveFilter.scheduleType["actif"];
				
				scope.showItem = function(item){
					let show = true;
					if((scope.activeFilterAppt.code === "actif" && item.className === "CAppointmentType") || 
							(scope.activeFilterSchedule.code === "actif" && item.className === "CAppointmentPeriodType")){
						show = !item.isDeleted
					}else if((scope.activeFilterAppt.code === "inactif" && item.className === "CAppointmentType") || 
							(scope.activeFilterSchedule.code === "inactif" && item.className === "CAppointmentPeriodType")){
						show = item.isDeleted
					}
					return show;
				}
				
				scope.isDefault = function(apptType){
					return apptType && apptType.isDefault;
				}
				
				scope.getName = function(apptType){
					var name = "";
					if ($translate.use()=='en') {
	                    name = (apptType.english ? apptType.english : apptType.french);
	                }else{
						name = (apptType.french ? apptType.french : apptType.english);
					}
	                return name;
				}
				
				scope.updateDom = function(){
					model.actUpdated(true);
				}
				
				var isFormDirty = false;
				scope.formDirty = function(){
					var dirty = scope.isDirty || (scope.clientPrefForm && scope.clientPrefForm.$dirty);
					if(isFormDirty !== dirty){
						if(dirty){
							registerDirty();
						}else{
							unregisterDirty();
						}
					}
					isFormDirty = dirty;
					return isFormDirty;
				};
				
				var registeredDirtyId;
				function registerDirty(){
					registeredDirtyId = "userpref";
					QValidation.registerDirty(registeredDirtyId, scope.saveClientPref, function(){
						return true;
					});
				}

				function unregisterDirty(){
					if(registeredDirtyId){
						QValidation.unregisterDirty(registeredDirtyId);
						registeredDirtyId = undefined;
					}
				}
				
				scope.openUrl = function(v){
					if(model.isWeb()){
						var win = window.open(v, '_blank');
						win.focus();
					}else{
						DashWebSocket.send({url: "/dashboard", data:{url:v}});
					}
				}
				
				scope.cpicker = {
					options : {
						format:"rgb",
						alpha: false,
						case: ['upper', 'lower'],
						disabled: !scope.isAdmin,
					}
				}
				scope.cpickerDisabled = {
					options : {
						format:"rgb",
						alpha: false,
						case: ['upper', 'lower'],
						swatchOnly: true,
						disabled: true
					}
				}
				
				var cpickerOptionsList = {};
				var periodTypeCPickerOptionsList = {};
				
				scope.getCPickerOptions = function(name){
					if(!cpickerOptionsList[name]){
						cpickerOptionsList[name] = angular.copy(scope.cpicker);
					}
					return cpickerOptionsList[name].options;
				}
				
				scope.getPeriodTypeCPickerOptions = function(id){
					if(!periodTypeCPickerOptionsList[id]){
						periodTypeCPickerOptionsList[id] = angular.copy(scope.cpicker);
					}
					return periodTypeCPickerOptionsList[id].options;
				}
				
				scope.getColorList = function(name){
					let list = [];
					if(name === 'day'){
						list = scope.colorDayList;
					}else if(name === 'appt'){
						list =  scope.colorApptList;
					}else if(name === 'calendar'){
						list = scope.colorCalendarList;
					}else if(name === 'pat'){
						list = scope.colorPatList
					}
					return list;
				}
				
				scope.getNamePeriodType = function(period, lang){
					return (period.id ? "id_" + period.id : "tempId_" + period.tempId) + "_" + lang;
				}
				
				var tempId = 1;
				scope.addNewPeriodType = function(){
					var periodType = {
						tempId: tempId,
						canHaveAppointment: true,
						isDefault: false,
						isDeleted: false,
						colorStr: 'rgb(255,255,255)',
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED
					}
					tempId++;
					scope.clientPrefs.appointmentPeriodTypes.push(periodType);
					scope.isDirty = true;
					model.actUpdated(true);
				}
				
				scope.removeNewPeriodType = function(periodType){
					let i = scope.clientPrefs.appointmentPeriodTypes.findIndex((e) => e == periodType);
					scope.clientPrefs.appointmentPeriodTypes.splice(i, 1);
					model.actUpdated(true);
				}
				
				scope.addNewApptType = function(){
					var apptType = {
						status: ['NO_AUTO_COMM'],
						isDeleted: false,
						duree: 0,
						colorStr: 'rgb(255,255,255)',
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED
					}
					scope.editApptType(apptType);
				}
				
				scope.editApptType = function(apptType){
					rvType = {
						onSite: apptType.status.includes("ON_SITE"),
						telmed: apptType.status.includes("TELMED"),
						byPhone: apptType.status.includes("BY_PHONE")
					}
					commRestriction = {
						noAutoComm: apptType.status.includes("NO_AUTO_COMM"),
						noComm: apptType.status.includes("NO_COMM")
					}
					other = {
						toDo: apptType.status.includes("IS_TODO")
					}
					
					var viewOptions = {
						templateUrl: "/dashboard/resources/ofys/settings/appttype_edit.html?v=ay",
						id: apptType.id,
						apptType: angular.copy(apptType),
						rvType: rvType,
						commRestriction: commRestriction,
						other: other,
						cpickerFlview:{
							options : {
								format:"rgb",
								alpha: false,
								case: ['upper', 'lower']
							}
						},
						rvTypeChange: function(type, state){
							if(state){
								if(type === "onSite"){
									rvType.telmed = false;
									rvType.byPhone = false;
								}else if(type === "telmed"){
									rvType.onSite = false;
									rvType.byPhone = false;
								}else if(type === "byPhone"){
									rvType.onSite = false;
									rvType.telmed = false;
								}
							}
						},
						noCommChange: function(state, type){
							if(state){
								if(type === "toDo"){
//									rvType.telmed = false;
//									rvType.byPhone = false;
//									rvType.onSite = false;
									commRestriction.noComm = false;
									commRestriction.noAutoComm = false;
								}else if(type === "noComm"){
									other.toDo = false;
									commRestriction.noAutoComm = false;
								}else if(type === "noAutoComm"){
									commRestriction.noComm = false;
									other.toDo = false;
								}
							}
						},
						lstProf: $filter('orderBy')(model.store.profs.filter.treating.list(), ['lastName', 'firstName']),
						checkIfNew: function(resDefData){
							return apptType.modificationStatus == ModificationStatus.STATUS_NEW_UPDATED;
						},
//						openDurationTitle: function(){
//							let qconfirmOption = {
//								title: $filter('translate')('durationApptTitle'),
//								qconfirm:{hideCancel: true, hideNo:true}
//							}
//							QConfirm.open(qconfirmOption, {windowClass:'top-modal'})
//						},
						validateName: function(){
							isValid = false;
							if(this.apptType.french || this.apptType.english){
								if(!this.apptType.french)this.apptType.french = this.apptType.english;
								if(!this.apptType.english)this.apptType.english = this.apptType.french;
								isValid = true;
							}
							return isValid;
						},
						validateCode: function(){
							isValid = false;
							if(this.apptType.code){
								isValid = !scope.clientPrefs.appointmentTypes.some(function(e){
									return e.code == this.apptType.code && ((!this.apptType.tempId && !this.id)
											|| (this.id && this.id != e.id)
											|| (this.apptType.tempId && this.apptType.tempId != e.tempId))
								}.bind(this));
							}
							return isValid;
						},
						fl: {},
						ok: function(e, obj){
							let hasName = this.validateName();
							let uniqueCode = this.validateCode();
							if(this.apptTypeFrm && this.apptTypeFrm.$valid && hasName && uniqueCode){
								scope.isDirty = true;
								this.apptType.status = []
								if(rvType.onSite)this.apptType.status.push("ON_SITE");
								if(rvType.telmed)this.apptType.status.push("TELMED");
								if(rvType.byPhone)this.apptType.status.push("BY_PHONE");
								if(commRestriction.noAutoComm)this.apptType.status.push("NO_AUTO_COMM");
								if(commRestriction.noComm)this.apptType.status.push("NO_COMM");
								if(other.toDo)this.apptType.status.push("IS_TODO");
								if(this.id){
									let i = scope.clientPrefs.appointmentTypes.findIndex(e => e.id==this.id);
									scope.clientPrefs.appointmentTypes.splice(i, 1, this.apptType);
								}else if(this.apptType.tempId){
									let i = scope.clientPrefs.appointmentTypes.findIndex(e => e.tempId==this.apptType.tempId);
									scope.clientPrefs.appointmentTypes.splice(i, 1, this.apptType);
								}else{
									this.apptType.tempId = tempId,
									tempId++
									scope.clientPrefs.appointmentTypes.push(this.apptType);
								}
								this.fl.cancel();
								model.actUpdated(true);
							}else{
								this.fl.frm.errorMsgs = PatientFormService.getFormErrors(this.fl.frm)
								if(!hasName){
									this.fl.frm.errorMsgs.push({
									    msg: $filter('translate')('errorEnterName'),
									    type: "error",
									});
								}
								if(!uniqueCode){
									this.fl.frm.errorMsgs.push({
									    msg: $filter('translate')('errorDuplicatedCode'),
									    type: "error",
									});
								}
								model.actUpdated(true);
							}
						},
					}
					FlView.open(viewOptions, {windowClass:'top-modal1', backdrop:'static'}).then(function(){});
				}
				
				scope.saveClientPref = function(){
					if(presaveValidation()){
						prepareForSave()
						return prefAccessor.saveClientPref(scope.clientPrefs, function(res){
							delete cpickerOptionsList;
							cpickerOptionsList = {}
							scope.updateClientsPref(res)
							scope.clientPrefForm && scope.clientPrefForm.$setPristine();
							model.notice().success($filter('translate')("SaveSuccess"));
							scope.clientPrefForm.$dirty = false;
							scope.isDirty = false;
							model.actUpdated(true);
						})
					}else{
						var msg = errorclientPrefForm[0];
						model.notice().fail($filter('translate')(msg));
						return $q(function(resolve, reject) {
							model.actUpdated(true);
							reject($filter('translate')(msg));
						});
					}
				}
				
				scope.cancelChange = function(){
					let qconfirmOption = {
						title: $filter('translate')('UnsavedChanges')
					}
					QConfirm.open(qconfirmOption, {windowClass:'top-modal'}).then(function(save){
						if(save){
							scope.saveClientPref ()
						}else{
							scope.clientPrefs = angular.copy(scope.clientPrefsOrig);
							scope.isDirty = false;
							scope.clientPrefForm && scope.clientPrefForm.$setPristine();
							if (scope.clientPrefForm) scope.clientPrefForm.$dirty = false;
							model.actUpdated(true);
						}
					})
				}
				
				var errorclientPrefForm= []
				function presaveValidation(){
					error = []
					if(scope.clientPrefForm && scope.clientPrefForm.$valid){
						return true;
					}
					if(scope.clientPrefForm && scope.clientPrefForm.$error 
							&& scope.clientPrefForm.$error.required && scope.clientPrefForm.$error.required.length > 0){
						let errorList = []
						scope.clientPrefForm.$error.required.forEach((e) => errorList.push(e.$name.split('_')));
						for(let i = 0; i < errorList.length; i++){
							let index = scope.clientPrefs.appointmentPeriodTypes.findIndex(e => e[errorList[i][0]] == errorList[i][1]);
							if(errorList[i][2] == 'fr' && scope.clientPrefs.appointmentPeriodTypes[index].english){
								scope.clientPrefs.appointmentPeriodTypes[index].french = scope.clientPrefs.appointmentPeriodTypes[index].english;
							}else if(errorList[i][2] == 'en' && scope.clientPrefs.appointmentPeriodTypes[index].french){
								scope.clientPrefs.appointmentPeriodTypes[index].english = scope.clientPrefs.appointmentPeriodTypes[index].french;
							}else{
								errorclientPrefForm.push('ClientPrefSaveInvalidForm');
							}
						}
					}
					if(scope.clientPrefForm && scope.clientPrefForm.$error 
							&& scope.clientPrefForm.$error.maxlength && scope.clientPrefForm.$error.maxlength.length > 0){
						errorclientPrefForm.push('MaxlengthName');
					}
					if(error.length > 0){
						return false
					}
					return true;	
				}
				
				function prepareForSave(){
					for(var propName in scope.clientPrefs){
						if(propName.includes("color") && scope.clientPrefs[propName + "Str"]){
							scope.clientPrefs[propName] = getColorFromString(scope.clientPrefs[propName + "Str"]);
						}
					}
					for(let i=0; i<scope.clientPrefs.appointmentPeriodTypes.length; i++){
						if(scope.clientPrefs.appointmentPeriodTypes[i].colorStr){
							scope.clientPrefs.appointmentPeriodTypes[i].color = getColorFromString(scope.clientPrefs.appointmentPeriodTypes[i].colorStr);
						}
					}
					for(let i=0; i<scope.clientPrefs.appointmentTypes.length; i++){
						if(scope.clientPrefs.appointmentTypes[i].colorStr){
							scope.clientPrefs.appointmentTypes[i].color = getColorFromString(scope.clientPrefs.appointmentTypes[i].colorStr);
						}
					}
				}
				
				function getColorFromString(c){
					return c.slice(c.indexOf("(")+1, c.indexOf(")")).split(",").map(i=>parseInt(i.trim()));
				}
			}
		}
	}]);
	
	pref.directive('userPrefs', ['model', 'ModificationStatus', '$filter', 'PrefAccessor', 'QValidation',
	                               function(model, ModificationStatus, $filter, prefAccessor, QValidation){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/settings/user_prefs.html?v=ay',
			link: function(scope, element, attrs){
				
				scope.prescriptionPrintFormatUser = angular.copy(Object.values(model.enums().prescriptionPrintFormat))
				scope.prescriptionPrintFormatUser.push({value: -1, type:"none", i18n: $filter('translate')('sameAsTheClinic')})
				scope.prescriptionDrugNameFormat = Object.values(model.enums().prescriptionDrugNameFormat)
				
				var isFormDirty = false;
				scope.formDirty = function(){
					var dirty = scope.isDirty || (scope.userPrefForm && scope.userPrefForm.$dirty);
					if(isFormDirty !== dirty){
						if(dirty){
							registerDirty();
						}else{
							unregisterDirty();
						}
					}
					isFormDirty = dirty;
					return isFormDirty;
				};
				
				var registeredDirtyId;
				function registerDirty(){
					registeredDirtyId = "userpref";
					QValidation.registerDirty(registeredDirtyId, scope.saveUserPref, function(){
						return true;
					});
				}

				function unregisterDirty(){
					if(registeredDirtyId){
						QValidation.unregisterDirty(registeredDirtyId);
						registeredDirtyId = undefined;
					}
				}
				
				scope.saveUserPref = function(){
					if(scope.userPrefForm && scope.userPrefForm.$valid){
						return prefAccessor.saveUserPref(scope.userPrefs, function(res){
							scope.userPrefs = res;
							scope.userPrefsOrig = angular.copy(scope.userPrefs);
							scope.userPrefForm && scope.userPrefForm.$setPristine();
							model.notice().success($filter('translate')("SaveSuccess"));
							model.actUpdated(true);
						}, function(res){
							model.notice().fail($filter('translate')(res.msg));
						})
					}else{
						var msg = 'PatientSaveInvalidForm';
						model.notice().fail($filter('translate')(msg));
						return $q(function(resolve, reject) {
							reject($filter('translate')(msg));
						});
					}
				}
				
				scope.cancelChange = function(){
					let qconfirmOption = {
						title: $filter('translate')('UnsavedChanges')
					}
					QConfirm.open(qconfirmOption, {windowClass:'top-modal'}).then(function(save){
						if(save){
							scope.saveUserPref()
						}else{
							scope.userPrefs = angular.copy(scope.userPrefsOrig);
							scope.userPrefForm && scope.userPrefForm.$setPristine();
							model.actUpdated(true);
						}
					})
				}
			}
		}
	}]);

})();