(function browserNotCompatible() {
  ua = navigator.userAgent;
  /* MSIE used to detect old browsers and Trident used to newer ones*/
  var is_ie = ua.indexOf("MSIE ") > -1 || ua.indexOf("Trident/") > -1;
  if(is_ie){
		alert("Ce navigateur n'est pas supporté. Pour la meilleure expérience avec Ofys Pro, utiliser Google Chrome.")
	}
  return is_ie;
})()

function b64EncodeUnicode(str) {
	return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, function(match, p1) {
		return String.fromCharCode(parseInt(p1, 16));
	}));
}
/*!
 * Utility functions for sort, object conversion e.t.c
 */

/**
 * Utility Object with helper functions and values
 */
var OfysUtils = OfysUtils || {};

(function(){

	var utils = angular.module('infodataUtils', []);
	var popoverOverlayCount = 0;


	utils.factory('utils',['$http','$templateCache', '$compile','$interpolate','$log', 
		function($http, $templateCache, $compile,$interpolate, $log){
		var service = {
			isTemplateLoaded: function(url){
				return !!$templateCache.get(url);
			},
			//Fetch template form server side if it does not exist
			//in template cache and adds it to template cache
			//Returns true
			getTemplate: function(url, callback, error){
				var html = $templateCache.get(url);
				if(angular.isDefined(html)){
					if(callback)callback(html);
					return html;
				}else{
					$http.get(url).then(function(res){
						$templateCache.put(url, res.data);
						if(callback) callback(res.data);
					}, error);
				}
			},
			//The template should already exist in the $templateCache
			getTemplateAndCompileSync: function(scope, url){
				var html = $templateCache.get(url);
				if(angular.isDefined(html)){
					return $compile(html)(scope);
				}
				console.log("error")
				$log.error("The requested template "+ url +" was not found in the template cache."+
						" Make sure the template is pre-loaded in the $templateCache .");
				return "Template not found";
			},
			compile: function(scope, html){
				if(angular.isDefined(html)){
					return $compile(html)(scope);
				}
				$log.error("The requested template "+ html +" was not found in the template cache."+
						" Make sure the template is pre-loaded in the $templateCache .");
				return "Template not found";
			},
			interpolate: function(scope, html){
				if(angular.isDefined(html)){
					return $interpolate(html)(scope);
				}
				$log.error("The requested template "+ html +" was not found in the template cache."+
						" Make sure the template is pre-loaded in the $templateCache .");
				return "Template not found";
			},
			popoverOverlayActive: function(){
				return popoverOverlayCount > 0;
			},
			showPopoverOverlay: function(show){
				if(show){
					var zindex = 1055+(2*popoverOverlayCount);
					popoverOverlayCount = popoverOverlayCount +1;
					if(popoverOverlayCount > 0){
						angular.element('body').append('<div class="btn-med-sum-edit-overlay overlay medsum l'+popoverOverlayCount+'" style="z-index:'+zindex+'"></div>');
					}
				}else{
					var ov;
					if(popoverOverlayCount > 0){
						ov = $('.btn-med-sum-edit-overlay.l'+popoverOverlayCount);
						ov.remove();
						popoverOverlayCount = popoverOverlayCount - 1;
					}
				}
			}
		}
		return service;
	}]);

  var userAgent = navigator.userAgent || navigator.vendor || window.opera;
  var osType = {iOS:false, iPadPro:false, android:false, desktop:false, winPhone:false, windows:false, mac:false};
      // Windows Phone must come first because its UA also contains "Android"
    if (/windows phone/i.test(userAgent)) {
    	osType.winPhone = true;
    } else if (/android/i.test(userAgent)) {
    	osType.android=true;
    } else if (/android/i.test(userAgent)) {
    	osType.android=true;
    } else if (/iPad|iPhone|iPod/.test(userAgent) && !window.MSStream) {
    	// iOS detection from: http://stackoverflow.com/a/9039885/177710
    	osType.iOS=true;
    } else if (navigator.maxTouchPoints && navigator.maxTouchPoints > 2 && /MacIntel/.test(navigator.platform)) {
    	// hack for now, because safari on ipadpro is MacIntel... only way to tell not mac is no mac has touch.
    	osType.iOS=true;
    	osType.iPadPro=true;
    } else {
    	if (/windows/i.test(userAgent)) {
    		osType.windows=true;
    	} else if (/macintosh/i.test(userAgent)) {
    		osType.mac=true;
    	}
    	osType.desktop=true;
    }

	/**
	 * Returns and object values as an array.
	 * Useful in cases where an object is used as a map.
	 */
	OfysUtils = {
		DATEFORMAT: 'YYYY-MM-DD',
		DATETIMEFORMAT: 'YYYY-MM-DD HH:mm',
		DATETIMEFORMATISO: 'YYYY-MM-DDTHH:mm:ss',
		ofysTimeToString: function (input, noPadding) {
			if(input){
				input = input || 0;
				var hour = (input/60) | 0;
				var minutes = input%60;
				return (!noPadding && hour<10 ?'0':'')+hour+':'+(minutes<10?'0':'')+minutes;
			}
		},
		byteArrayToBase64: function(byteArray){
			return btoa(String.fromCharCode.apply(null, new Uint8Array(byteArray)));
		},
		singleClick: function(fn){
			return _.throttle(fn, 1000, {trailing: false});
		},
		parseJson: function (raw) {
			// Étapes de nettoyage
			const cleaned = raw
			  .replace(/^```json\s*/, '')  // supprime ```json au début
			  .replace(/```$/, '')         // supprime ``` à la fin
			  .trim();                     // supprime les espaces ou sauts de ligne
			
			// Conversion en objet JavaScript
			try {
			  const obj = JSON.parse(cleaned);
			  return obj;
			} catch (e) {
			  console.error("Erreur de parsing JSON:", e.message);
			}			
			
		  try {
	    	    const jsonObject = JSON.parse(raw);
				return jsonObject;	 
		  } catch (error) {
		    console.error('Erreur de parsing:', error);
		    return null;
		  }
		},
		tabCloseProf:function(profId){
			if(this.scheduleTabCloseProf){
				this.scheduleTabCloseProf(profId);
			}
		},
		serializer: function (replacer) {
			var stack = [], keys = []
			
			function cycleReplacer(key, value) {}
			
			return function(key, value) {
				if (stack.length > 0) {
				var thisPos = stack.indexOf(this)
				~thisPos ? stack.splice(thisPos + 1) : stack.push(this)
				~thisPos ? keys.splice(thisPos, Infinity, key) : keys.push(key)
				if (~stack.indexOf(value)) value = cycleReplacer.call(this, key, value)
				}
				else stack.push(value)
			
				return replacer == null ? value : replacer.call(this, key, value)
			}
		},
		safeStringify: function(obj){
			try{
				return JSON.stringify(obj);
			}catch(e){
				// The error is still printed for indication of objects that requires cleaning
				// but the second stringify should go through
				// since the second stringify is more expensive only doit if a circular refrence is detected.
				console.log('Objects requires more cleaning. The next stringify is more extensive and will certainly work! ' + e);
				return JSON.stringify(obj, OfysUtils.serializer(null))
			}
		},
		parseFloat: function(str){
			if(typeof str === "string"){
				var s = str.replace(',','.');
				if (s.length>0) {
					return parseFloat(s);
				}
			}else if( typeof str === 'number'){
				return parseFloat(str);
			}
		},
		extractFloat(value) {
		  // Regular expression to match floating-point numbers
		  const floatRegex = /[-+]?\d*\.?\d+/;
		  // Match the float value in the string
		  const match = value.match(floatRegex);
		  if (match) {
		    // Convert the matched value to a float
		    return parseFloat(match[0]);
		  }		
		  // If no match is found, return null or handle the error as needed
		  return null;
		},
		extractBloodPressure(bpString) {
		  // Regular expression to match two numbers separated by a slash
		  const bpRegex = /(\d+)\/(\d+)/;
		
		  // Match the systolic and diastolic values in the string
		  const match = bpString.match(bpRegex);
		
		  if (match) {
		    // Extract the systolic and diastolic values
		    const systolic = parseInt(match[1], 10);
		    const diastolic = parseInt(match[2], 10);
		
		    return { systolic, diastolic };
		  }
		
		  // If no match is found, handle the error as needed
		  return null;
		},
		extractLeadingInteger(str) {
		  // Regular expression to match the integer at the start of the string
		  const intRegex = /^\d+/;
		
		  // Match the integer in the string
		  const match = str.match(intRegex);
		
		  if (match) {
		    // Convert the matched value to an integer
		    return parseInt(match[0], 10);
		  }
		
		  // If no match is found, return null or handle the error as needed
		  return null;
		},
		/*			
			array : can be undefined or empty, will return "" if undefined or empty
			separator : can be undefined, default to ""
			toStringProvider : can be undefined, will use toString if undefined

			undefined and blank values are ignored
		*/
		joinArray: function(array, separator, toStringProvider) {			
			if (array === undefined) {
				return "";
			}
			if (array.length <= 0) {
				return "";
			}
			if (separator === undefined) {
				separator = "";
			}
			let text = "";		
			const alen = array.length;
			for (i = 0; i < alen; i++) {
				const e = array[i];
				if (e !== undefined) {					
					let str;
					if (toStringProvider === undefined) {
						str = e.toString();						
					} else {
						str = toStringProvider(e);					
					}
					if (str !== undefined && str !== "") {
						if (i == 0) {
							text = str;
						} else {
							text = text + separator + str;
						}
					}
				}
			}
			return text;
		},
		isMicrosoftBrowser: function () {
			       var match = navigator.userAgent.search(/(?:Edge|MSIE|Trident\/.*; rv:)/);
			       var isIE = false;

			       if (match !== -1) {
			         isIE = true;
			       }
			       return isIE;
		},
		isSafariBrowser: function(){
			var ua = navigator.userAgent.toLowerCase(); 
			if (ua.indexOf('safari') != -1) { 
				if (ua.indexOf('chrome') > -1) {
					return false;
			  	}else{
			   		return true;
				}
			} else {
				return false;
			}
		},
		MOBILE: window.matchMedia("(max-width: 1024px)"),
		isIos: osType.iOS===true,
		isPadPro: osType.iPadPro===true,
		isAndroid: osType.android===true,
		isWinPhone: osType.winPhone===true,
		isDesktop: osType.desktop===true,
		isMac: osType.mac===true,
		isWin: osType.windows===true,
		ObjectValuesAsArray: function(obj){
			var res = [];
			var keys = Object.keys(obj);

			for(var i = 0;i < keys.length; i++){
				res.push(obj[keys[i]]);
			}
			return res;
		},
		mapArrayToObject: function(keyFinder,arr ){
			var newObj = {};
			for(var i = 0 ; i < arr.length; i++){
				newObj[keyFinder(arr[i])] = arr[i];
			}
			return newObj;
		},
		isScrolledIntoView: function (elem)
		{
			var docViewTop = $(window).scrollTop();
			var docViewBottom = docViewTop + $(window).height();

			var elemTop = $(elem).offset().top;
			var elemBottom = elemTop + $(elem).height();

			return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
		},
		/**
		 * Adds a viewbag object to the passed object
		 * @argument elem : An array or Object
		 * 		if the elem is an array the viewbag is added to all object in the list
		 * 		if the elem is an object the viewbag is added to only that object.
		 * @argument execAdd: a function that receives the element and an empty viewbag object that it mutates and returns.
		 */
		addViewbag: function (elem, execAdd){
			if(Array.isArray(elem)){
				for(var i = 0; i < elem.length; i++){
					elem[i].viewbag = OfysUtils.getViewbag(elem[i],execAdd, {});
				}
			}else if(elem){
				elem.viewbag = OfysUtils.getViewbag(elem, {});
			}
			return elem;
		},
		getViewbag: function(elem, execAdd, vb){
			var bag = execAdd(elem, vb);
			if(bag){
				return bag;
			}else{
				throw new TypeError('getViewbag function must have a return value.');
			}
		},
		sameObj: function(obj, newObj, check){
			if((!!obj) != (!!newObj)){//one of the two objects is null
				return false;
			}
			var keys = Object.keys(obj);
			var keysnew = Object.keys(newObj);
			if(check == null || check.length == 0){
				var excludes = {};
				check = _.uniq(keys.concat(keysnew)).filter(function(e){return !!excludes[e] });
			}
			for (let i = 0; i < check.length; i++) {
				if(obj[check[i]] !== newObj[check[i]]){
					return false
				};
			}
			return true;
		},
		update: function(obj, newObj, exclusionList){
			var keys = Object.keys(obj);
			var delta = [];
			var excluded = {};
			exclusionList = exclusionList ? exclusionList: [];

			// if some object keys are in the exclusionList keep them in separate object so that to not override or delete them.
			for (let x = 0; x < exclusionList.length; x++) {
				if(obj[exclusionList[x]] !== undefined){
					excluded[exclusionList[x]] = obj[exclusionList[x]];
				}
			}
			exclusionList = Object.keys(newObj).concat(exclusionList);
			// Find all keys that are in the old object that should be deleted in the new object.
			for(var i = 0; i < keys.length; i++){
				if(exclusionList.indexOf(keys[i]) < 0){
					delta.push(keys[i]);
				}
			}

			//Delete all keys that should not be kept in the final ouput.
			for(var j = 0; j < delta.length; j++){
				delete obj[delta[j]];
			}
			$.extend(obj, newObj, excluded);
		},
		extendIfNotDefined: function(obj1, obj2){
			var keysObj2 = Object.keys(obj2);
			for(var i = 0; i < keysObj2.length; i++){
				if(!obj1[keysObj2[i]]){
					obj1[keysObj2[i]] = obj2[keysObj2[i]];
				}
			}
			return obj1;
		},
		//Check if two objects have the same values
		isEquivalent: function (a, b) {
			// Create arrays of property names
			var aProps = Object.getOwnPropertyNames(a);
			var bProps = Object.getOwnPropertyNames(b);

			// If number of properties is different,
			// objects are not equivalent
			if (aProps.length != bProps.length) {
				return false;
			}

			for (var i = 0; i < aProps.length; i++) {
				var propName = aProps[i];

				// If values of same property are not equal,
				// objects are not equivalent
				if (a[propName] !== b[propName]) {
					return false;
				}
			}

			// If we made it this far, objects
			// are considered equivalent
			return true;
		},
		throttle:function(fn){
			return _.throttle(fn, 1000, {trailing: false});
		},
		// o est l'objet, k est un arr des propriétés à conserver.
		deleteAllProps: function(o, k) {
			for(var propName in o) {
				if (k && $.inArray(propName, k)==-1) {
					delete o[propName];
				}
			}
		},
		findParameterWithValue: function(obj, value){
			var res = [];
			var keys = Object.keys(obj);

			for(var i = 0;i < keys.length; i++){
				if(obj[keys[i]] === value){
					return keys[i];
				}
			}
		},
	   clearAndAddToArray: function(actual, toAdd) {
		  actual.length = 0;
		  for (var i = 0; i < toAdd.length; i++) {
		    if (toAdd[i]) {
		    	actual.push(toAdd[i]);
		    }
		  }
	   },
	   cleanArray: function(actual) {
		   var newArray = new Array();
		   for (var i = 0; i < actual.length; i++) {
			   if (actual[i]) {
				   newArray.push(actual[i]);
			   }
		   }
		   return newArray;
	   },
	   remove: function(item, arr) {
		   var idx = $.inArray(item, arr);
		   if (idx!=-1) {
			   arr.splice(idx,1);
		   }
		  return arr;
	   },
	   removeStartsWith: function(item, arr) {
		   var idx = -1;
		   for(var i=0, j=arr.length;i<j;i++) {
			   if (arr[i].startsWith(item)) {
				   idx = i; break;
			   }
		   }
		   if (idx!=-1) {
			   arr.splice(idx,1);
		   }
		   return arr;
	   },
	   removeWithNoLigne: function(noLigne, arr) {
		   for (var o in arr) {
			   if (arr[o].noLigne==noLigne) {
				   var idx = $.inArray(arr[o], arr);
				   if (idx!=-1) {
					   arr.splice(idx,1);
				   }
			   }
		   }
		   return;
	   },
	   localDateFrom1970: function() {
		return Math.floor(moment().unix()/(3600*24));
	   },
	   stringToLocalDate: function(str){
		return Math.floor(moment(str).unix() / (3600*24));
	   },
	   daysFrom1970ToStr: function(days){
		return OfysUtils.daysFrom1970ToMoment(days).format("YYYY-MM-DD");
	   },
	   daysFrom1970ToMoment: function(days){
		return moment(new Date(0)).add(days+1, "days");
	   },
	   daysFrom1970 : function(dateStr) {
		   var date = dateStr == undefined ? new Date(): moment(dateStr).toDate();
		   var fullDaysSinceEpoch = Math.floor((date.getTime() - date.getTimezoneOffset()*60000)/8.64e7);
		   return fullDaysSinceEpoch;
	   },
	   longToDaysFrom1970 : function(l) {
		   var date = l == undefined ? new Date(): moment(l).toDate();
		   var fullDaysSinceEpoch = Math.floor((date.getTime() - date.getTimezoneOffset()*60000)/8.64e7);
		   return fullDaysSinceEpoch;
	   },
	   longToDaysFrom1970Str : function(l) {
			if (l===undefined) return undefined;
		   return moment(l).format("YYYY-MM-DD");
	   },
	   convertDateStringsToDates: function(input) {
		   var regexIso8601 = /^(\d{4}|\+\d{6})(?:-(\d{2})(?:-(\d{2})(?:T(\d{2}):(\d{2}):(\d{2})\.(\d{1,})(Z|([\-+])(\d{2}):(\d{2}))?)?)?)?$/;
		    // Ignore things that aren't objects.
		    if (typeof input !== "object") return input;
		    for (var key in input) {
		        if (!input.hasOwnProperty(key)) continue;
		        var value = input[key]; var match;
		        // Check for string properties which look like dates.
		        if (typeof value === "string" && (match = value.match(regexIso8601))) {
		            var milliseconds = Date.parse(match[0])
		            if (!isNaN(milliseconds)) {
		                input[key] = new Date(milliseconds);
		            }
		        } else if (typeof value === "object") {
		            // Recurse into object
		        	MyNamespace.helpers.convertDateStringsToDates(value);
		        }
		    }
	   },
	   abbreviate: function(str, max, suffix) {
		   if((str = str.replace(/^\s+|\s+$/g, '').replace(/[\r\n]*\s*[\r\n]+/g, ' ').replace(/[ \t]+/g, ' ')).length <= max) {
			   return str;
		   }
		  var abbr='',str=str.split(' '),suffix=(typeof suffix!=='undefined'?suffix:' ...'),max=(max-suffix.length);
		  for(var len = str.length, i = 0; i < len; i ++){
		    if((abbr + str[i]).length < max){
		      abbr += str[i] + ' ';
		    } else {break;}
		  }
		  return abbr.replace(/[ ]$/g, '') + suffix;
	   },
	   wordWrap: function(input, width, brk) {
		    brk = brk || '\n';
		    width = width || 80;
		    if (!input) { return input; }
		    if (input.length<width) return input;
		    var words = input.split(' ');
		    var lengths = [];
		    for (var i = 0; i < words.length; i++) {
		    	lengths.push(words[i].replace(/<.+>/g, '').replace(/&.+;/g, ' ').length);
		    }

		    var line = [], offset = 0, output = [];
		    for (var i = 0; i < words.length; i ++) {
		      if (offset + (lengths[i] + line.length - 1) < width) {
		        line.push(words[i]);
		        offset += lengths[i];
		      } else if (line.length===0) {
		    	line.push(words[i]);
		        offset = 0;
		      } else {
		        output.push(line.join(' '));
		        offset = 0; line = [], i -= 1;
		      }
		      if (i == words.length - 1) {
		    	  output.push(line.join(' '));
		      }
		    }
		    return output.join(brk);
	   },
	   extractProperties: function(propertiesFileContents){
		   var keyValuePairs=propertiesFileContents.split("\n");
		   properties ={};
		   for (i = 0; i < keyValuePairs.length; i++) {
			  if (keyValuePairs[i].startsWith('#') || keyValuePairs[i].length==0) continue;
		      var keyValueArr=keyValuePairs[i].trim().split("=");
		      var key=keyValueArr[0];
		      var value=keyValueArr[1];
		      properties[key]=value
		   }
		   return properties;
	   },
	   default: function(v, d) {
		   return (angular.isUndefined(v) || v==null || v=='') ? d : v;
	   },
	   isEmpty: function(v) {
		   return angular.isUndefined(v) || v==null || v=='';
	   },
	   isAllEmpty: function(o, v) {
		   // o = l'objet, v = array des propriétés à checker
		    for (var i = 0; i < v.length; i ++) {
		    	var obj = o[v[i]];
		    	if (angular.isDefined(obj) && obj!==null && obj!=='') return false;
		    }
		    return true;
	   },
	   isNotEmpty: function(v) {
			return angular.isDefined(v) && v!==null && v!=='';
	   },
	   isObject: function(v) {
			return $.isPlainObject(v);
	   },
	   compare: function (obj1, obj2) {
			//Loop through properties in object 1
			if ((this.isEmpty(obj1) && this.isNotEmpty(obj2)) ||
					(this.isEmpty(obj2) && this.isNotEmpty(obj1))) {
				return false;
			} else if (this.isEmpty(obj1) && this.isEmpty(obj2)) {
				return true;
			}
			for (var p in obj1) {
				//Check property exists on both objects
				if (obj1.hasOwnProperty(p) !== obj2.hasOwnProperty(p)) {
					return false;
				}

				switch (typeof (obj1[p])) {
					//Deep compare objects
					case 'object':
						if (!this.compare(obj1[p], obj2[p])) {
							return false;
						}
						break;
					//Compare function code
					case 'function':
						if (typeof (obj2[p]) == 'undefined' || (p != 'compare' && obj1[p].toString() != obj2[p].toString())) {
							return false;
						}
						break;
					//Compare values
					default:
						if (obj1[p] != obj2[p]) {
							return false;
						}
				}
			}

			//Check object 2 for any extra properties
			for (var p in obj2) {
				if (typeof (obj1[p]) == 'undefined' && typeof (obj2[p]) !== 'undefined')  {
					return false;
				}
			}
			return true;
		},
		isDate: function(x) {
		  return (null != x) && !isNaN(x) && ("undefined" !== typeof x.getDate);
		},
		versionUrl: function(v) {
			if (arguments.length) {
				versionUrl = v;
			}
			return versionUrl;
		},
		// Adds a searchTerm to the object in a searchable list to support fuzzy search eg: 
		// eg: hôpital pincourt vs Hopital PinCourt
		// with fuzzy search both could be found by searching for pinc hopital 
		fuzzyListSearch: function(l, term, searchTerm){
			if (searchTerm == undefined){
				searchTerm = "nameLc";
			}
			for(var i=0;i<l.length;i++) {
				if (l[i][term]) {
					l[i][searchTerm] = l[i][term].toLowerCase().removeAccentsLc();
				}
			}
			return l;
		},
		normaliseSearchField: function(str){
			return str.toLowerCase().removeAccentsLc();
		},
		searchRegExpArray: function(q, l) {
			var v = q.toLowerCase().removeAccentsLc();
			var searchTextRegExp;
			var len = l===undefined ? 3 : l;
			if (v && v.length>=len) {
				var x = v.split(' '); var len = x.length;
				searchTextRegExp = [];
				for(var i=0;i<len;i++) {
					searchTextRegExp.push(new RegExp(x[i], 'i'));
				}
			}
			return searchTextRegExp;
		},
		matchInRegExpArray: function(searchTextRegExp, string) {
			if (searchTextRegExp) {
				var len = searchTextRegExp.length, i=0, found=false;
				for (; i < len; i++) {
					if (!searchTextRegExp[i].test(string)) {
						return false;
					}
				}
				return true;
			}
			return true;
		},
		showNews: function() {
			var url = "https://ofys.ca/ofys_aide/fr/syra_news.html";
			if (versionUrl) {
				url = "https://ofys.ca/ofys_aide/fr/syra_news" + versionUrl + ".html";
			}
			if (typeof openHelp === "function") {
				openHelp(url);
			    // safe to use the function
			} else {
				window.open(url, url);
			}
		},
		openTextWindow : function(text) {
			// Calculer les dimensions de l'écran et de la fenêtre
			var screenX = window.screenX || window.screenLeft;
			var screenY = window.screenY || window.screenTop;
			var outerWidth = window.outerWidth;
			var outerHeight = window.outerHeight;

			var winWidth = 550;
			var winHeight = 600;
			var left = screenX + (outerWidth - winWidth) / 2;
			var top = screenY + (outerHeight - winHeight) / 2;

			// Ouvrir la fenêtre popup avec les positions calculées
			var win = window.open('', '_blank', `width=${winWidth},height=${winHeight},left=${left},top=${top},location=no,menubar=no,status=no,toolbar=no`);
			win.document.write(`
	            <html>
	                <head>
	                    <style>
	                        body { font-family: Arial, sans-serif; padding: 20px; }
	                        #textArea { width: 100%; height: 450px; margin-bottom: 10px; }
	                        button { padding: 10px 20px;width: 100%; background-color: #007BFF; color: white; border: none; cursor: pointer; }
	                    </style>
	                </head>
	                <body>
	                    <textarea id="textArea"  class="ia-texte" readonly>${text}</textarea>
	                    <button onclick="copyToClipboard()">Copier / Copy</button>
	                    <script>
	                        function copyToClipboard() {
	                            var textArea = document.getElementById('textArea');
	                            textArea.select();
	                            document.execCommand('copy');
	                            alert('Texte copié dans le presse-papier / Text copied into the clipboard.!');
	                            window.close();
	                        }
	                    </script>
	                </body>
	            </html>
	        `);
			// Assurer que la fenêtre est bien centrée
			win.moveTo(left, top);
		}
		
	 };

	$(document).keydown(function(event) {
	    if (event.which == "17" || event.which == "1"){
	    	OfysUtils.ctrlKeyPressed = true;	// or COMMAND sur Mac
	    }
	});

	$(document).keyup(function() {
	    OfysUtils.ctrlKeyPressed = false;
	});

})();