(function(){
	var labo = angular.module('labo', ['ngSanitize']);


	labo.factory('LabAccessor', ['DashAPI','MessageLink','PatientAccessor', 'model','$filter', 'DashWebSocket', 'QConfirm',
	                            function(DashAPI, MessageLink, PatientAccessor, model,$filter, DashWebSocket, QConfirm ) {

		function getLabPatientId (lab){
			if(lab.idPatient != null){
				return lab.idPatient;
			}else if(lab.patient && lab.patient.id != null){
				return lab.patient.id;
			}else{
				console.error("Could not find Patient id for the lab with id"+ lab.id)
			}
		}
		var accessor = {
			status:['UNSEEN','SEEN', 'TO_RESOLVE','SIGNED_BY_OTHER','OPEN_WITH_FILE'],
			categories: {SEARCH : "SEARCH", TO_RESOLVE: 'TO_RESOLVE',UNSEEN:'UNSEEN'},
			utils : {

				updateAllLabs: function (pd) {

					var list = [];
					if (pd.lab) {
						//keep only Non-CLaboReportHeaderFlat type
						for(var i = 0; i < pd.lab.length; i++){
							var e = pd.lab[i];
							if (e != undefined){
								if (e.className === 'CLaboReportHeaderFlat') {
									//dont add
								} else {
									list.push(e);
								}
							}
						}
					}
					if (pd.labdsq) {
						list = list.concat(pd.labdsq);
					}
					pd.lab = list.sort(PatientAccessor.sortOnDate);
				},

				getBaseLab: function (doc){
					if (doc && doc.success===false && doc.ms) {
						model.notice().fail(doc.ms);
					} else {
						//var currProf = model.user().profil;
						doc.notesHistory = doc.notesHistory.replaceAll("~VU_LE~",
								$filter('translate')('SeenOn'));
						doc.notesHistory = doc.notesHistory.replaceAll("~SIGNE_LE~",
								$filter('translate')('SignedOn'));
						doc.notesHistory = doc.notesHistory.replaceAll('<bp>',
						'<span class="multi-line-txt">').replaceAll('</bp>',
						'</span>');
						
						return doc;
					}
				},
			},
			openDocPdf : function (data, callback, error){
				function handleUrl(res){
					if(res && res.data && typeof res.data === "string"){
						window.open(res.data,'_blank');
					}
					if(callback !== undefined){
						callback(res);
					}
				}
				return DashAPI.post('/dashboard/Labo/ws/openDocPdf', data, handleUrl, error);
			},
			labView: function(data, callback, error){
				DashAPI.get('/dashboard/Labo/ws/labview?baseLaboId=' + data.labProfId + "&idText=" + data.idText + "&loadAllVesion=" + data.loadAllVesion + '&idPatient=' + data.idPatient, callback, error);
			},
			diff: function(data, callback, error){
				var labProfId;
				if (data.activeProf) {
					labProfId = data.activeProf.id;
				}
				DashAPI.get('/dashboard/Labo/ws/diff?baseLaboId=' + labProfId + "&idText=" + data.idText, callback, error);
			},
			allVersions: function(data, callback, error){
				DashAPI.get('/dashboard/Labo/ws/labVersions?labNo=' + data.labNo+ '&initial='+ data.initial + '&idPatient=' + data.idPatient, callback, error);
			},
			history : function (data, callback, error){
				DashAPI.get("/dashboard/Labo/ws/history?idField=" + data.idField +
						"&patientId=" + data.patientId, callback,error);
			},
			copyToClip : function (text, callback, error){
				DashAPI.get("/dashboard/Labo/ws/copyToClip?text=" + text , callback,error);
			},
			addLaboFilter : function (d, callback, error){
				DashAPI.get("/dashboard/Labo/ws/addLaboFilter?id=" + d.id + "&profId=" + d.idProf + "&patientId=" + d.idPat , callback,error);
			},
			addLaboFollow : function (d, callback, error){
				DashAPI.get("/dashboard/Labo/ws/addLaboFollow?code=" + d.code +"&loinc=" +d.loinc + "&profId=" + d.idProf + "&patientId=" + d.idPat , callback,error);
			},
			delLaboFollow : function (d, callback, error){
				DashAPI.get("/dashboard/Labo/ws/delLaboFollow?code=" + d.code +"&loinc=" +d.loinc + "&profId=" + d.idProf + "&patientId=" + d.idPat , callback,error);
			},
			review : function (params, callback, error){
				DashAPI.get('/dashboard/Labo/ws/review?idProf='+ params.id +
						"&status="+params.status, callback, error);
			},
			reviewCount : function (id, callback, error){
				DashAPI.get('/dashboard/Labo/ws/reviewCount?idProf='+ id, callback, error);
			},
			list : function (data, callback, error){
				DashAPI.get("/dashboard/Labo/ws/search?p=" + data.patient, callback, error);
			},
			byPatient : function (id, callback, error){
				DashAPI.get('/dashboard/Labo/ws/bypat?id=' + id +"&u=" + DashWebSocket.clientUid, callback, error);
			},
			byIds : function (data, callback, error){
				DashAPI.post('/dashboard/Labo/ws/byIds', data, callback, error);
			},
			assignOtherPatient : function (data, callback, error){
				DashAPI.get('/dashboard/Labo/ws/assignOtherPatient?id=' + data.id + "&idPatient=" + data.idPatient, callback, error);
			},
			search : function (q, callback, error){
				DashAPI.get("/dashboard/Labo/ws/search?q="+ q, callback, error);
			},
			open : function (id, callback, error){
				DashAPI.get('/dashboard/Labo/editor?baseLaboId='+ id, callback, error);
			},
			save : function (data, callback, error){
				return DashAPI.post("/dashboard/Labo/ws/save", data, callback, error);
			},
			saveEnumSet : function (data, callback, error){
				return DashAPI.post("/dashboard/Labo/ws/saveEnumSet", data, callback, error);
			},
			delAllAutoOpen : function (data, callback, error){
				return DashAPI.post("/dashboard/Labo/ws/delAllAutoOpen", data, callback, error);
			},
			sign : function (data, callback, error){
				return DashAPI.get("/dashboard/Labo/ws/sign?id="+ data, callback, error);
			},
			searchLabo : function(data, callback, error){
				return DashAPI.post("/dashboard/Labo/ws/searchLabo", data, callback, error)
			},
			printLabo : function (data, callback, error){
				return DashAPI.get("/dashboard/Labo/ws/printLabo?id="+ data, model.handlePrint(callback), error);
			},
			msgLinkMap:{},//Used for message/task link of current document.
			updateMessageLink: function (lab,scope){
				var labId ;
				if(lab.activeProf){
					labId = lab.activeProf.id;
				}else if(lab.profs && lab.profs.length > 0){
					labId = lab.profs[0].id;
				}
				var linkable;
				if (labId) {
					linkable = {
						patient: getLabPatientId(lab),
						linkType: MessageLink.linkTypes.labo,
						id: labId,
						lab: lab,
						pat: lab.patient
					};
					accessor.messageLinkKey = MessageLink.setLinkType(linkable, scope);
				} else {
					linkable = {
						patient: lab.idPatient,
						linkType: MessageLink.linkTypes.patient,
						id: lab.idPatient,
						pat: lab.patient
					};
					accessor.messageLinkKey = MessageLink.setLinkType(linkable, scope);
				}
				accessor.msgLinkMap[lab.uid] = accessor.messageLinkKey
			},
			doAddLaboFilter: function(lf, idProf, idPt, fct) {
				if (idPt && idProf && lf && lf.id) {
					var qconfirmOptions = {title: $filter('translate')('STOP_TO_SEE_THIS_CRITICAL_RESULT',{name: lf.n, val:lf.v, unit:lf.u })};
					QConfirm.open(qconfirmOptions).then(proceedWithAdding);
					function proceedWithAdding(proceed){
						if(proceed){
							accessor.addLaboFilter({id:lf.id, idPat:idPt, idProf: idProf}, 
							function(e){
								if (e.data && e.data.success===false) {
									model.notice().warn($filter('translate')(e.data.ms));
								} else {
									model.notice().success($filter('translate')('operationSuccess'));
									if (fct) fct(lf);							
								}
							}, function(e){
								model.notice().warn(e);	
							});							
						}
					}
				}
			},
			doAddLaboFollow: function(laboTypes, idProf, idPt) {
				if (idPt && idProf && (laboTypes[0].length>1 || laboTypes[1].length>3)) {
					var qconfirmOptions = {title: $filter('translate')('MSG_CONFIRM_ADD_LABO_FOLLOW',{name: laboTypes[2]})};
					QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(proceedWithAdding);
					function proceedWithAdding(proceed){
						if(proceed){
							accessor.addLaboFollow({code:laboTypes[0], loinc:laboTypes[1], idPat:idPt, idProf: idProf}, 
							function(e){
								if (e.data && e.data.success===false) {
									model.notice().warn($filter('translate')(e.data.ms));
								} else {
									model.notice().success($filter('translate')('operationSuccess'));											
								}
							}, function(e){
								model.notice().warn(e);	
							});							
						}
					}
				}
			}
		};

		return accessor;
	}]);

	labo.directive('labNote', ['$timeout', 'PatientAccessor', 'LabAccessor', 'MessageLink', 'model', '$filter', '$q', '$log', 'Event', 'QValidation', 'QConfirm', 'patientShowTitles', 'QuickView', 'ModificationStatus',
		function ($timeout, PatientAccessor, LabAccessor, MessageLink, model, $filter, $q, $log, Event, QValidation, QConfirm, patientShowTitles, QuickView, ModificationStatus) {
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/labo/lab_note.html?v=bi',
			scope: true,
			link: function(scope, element, attrs){
				scope.notefrm = {};
				scope.labo = {};
				scope.hideHeader = model.prefSettings('labo_hide_header');

				scope.model = model;
				scope.aiEnabled = function() {
					return model && model.user().sofia.enabled();
				}
				scope.$on('$destroy', function() {
			        $log.log('labNote destroy called');
			    });

				scope.isProf = function(){
					return model.user().isProf;
				};
				scope.isClinicianNotStagiaire = function(){
					return model.user().isClinicianNotStagiaire();
				};

				scope.isShowReset = function(){
					if (scope.labNote && (scope.labNote.patient || model.patient())) {
						if (scope.labNote.profs===undefined) return false;
						var pt = scope.labNote.patient ? scope.labNote.patient : model.patient().currPatient;
						var prof = model.user().profil;
						if (pt && prof && pt.treatingProfessionnal===prof.id && scope.labNote.profs) {
							for (var i = 0; i < scope.labNote.profs.length; i++) {
								var lp = scope.labNote.profs[i];
								if ($.inArray("TO_RESOLVE", lp.activeSt) >= 0 || $.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0) {
									return true;
								}
							}
						}
					}
					return false;
				};
				scope.isShowResetTosOtherProv = function(){
					if (scope.labNote===undefined || scope.labNote.profs===undefined) return false;
					var prof = model.user().profil;
					for (var i = 0; i < scope.labNote.profs.length; i++) {
						var lp = scope.labNote.profs[i];
						if (prof.id!==lp.idProf && ($.inArray("TO_RESOLVE", lp.activeSt) >= 0 || $.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0)) {
							return true;
						}
					}
					return false;
				};
				scope.isShowDelAllAutoOpen = function(){
					if (scope.labNote===undefined || scope.labNote.profs===undefined) return false;
					for (var i = 0; i < scope.labNote.profs.length; i++) {
						var lp = scope.labNote.profs[i];
						if ($.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0) {
							return true;
						}
					}
					return false;
				};
				scope.resetTosOfOthers = function() {
					var qconfirmOptions = {title: $filter('translate')('MSG_CONFIRM_RESET_TOS')};
					QConfirm.open(qconfirmOptions).then(proceedWithReset);
					function proceedWithReset(proceed){
						if(proceed){
							scope.saveEnumSet();
						}
					}
				};
				scope.delAllAutoOpen = function() {
					var qconfirmOptions = {title: $filter('translate')('MSG_CONFIRM_DEL_ALL_AUTO_OPEN')};
					QConfirm.open(qconfirmOptions).then(proceedWithReset);
					function proceedWithReset(proceed){
						if(proceed){
							scope.saveDelAllAutoOpen();
						}
					}
				};
				function addOrRemove(add, it, arr){
					var exist = $.inArray(it, arr.activeSt)>-1;
					if(add && !exist){
						arr.activeSt.push(it);
						arr.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}else if(!add && exist){
						arr.activeSt.splice(arr.activeSt.indexOf(it), 1);
						arr.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					arr.st = arr.activeSt;
				}

				function preSetSeen() {
					var frm = $.extend({}, scope.notefrm);
					frm.labNotes = [];
					//Angular $http doesn't seem to url encode line breaks
					// frm.note = frm.note ? frm.note.replaceAll("\n", '%0D%0A') : "";
					if (scope.labNote.profs && scope.labNote.activeProf) {
						frm.idPatient = scope.labNote.idPatient
						for (var i = 0; i < scope.labNote.profs.length; i++) {
							var lp = scope.labNote.profs[i];
							if (lp.idProf===scope.labNote.activeProf.idProf && lp.id===scope.labNote.activeProf.id) {
								// meme version.
								if (lp.seenDatetime===undefined) {
									lp.seenDatetime = new Date().getTime();
									addOrRemove(true,"SEEN", lp);
									addOrRemove(false,"UNSEEN", lp);
									lp.modificationStatus = ModificationStatus.STATUS_UPDATED;
									frm.labNotes.push(lp);
									//return LabAccessor.save(frm, documentSavedCallback);
								}
							}
						}
					}
					return frm;
				}

				function documentSavedCallbackAndNext(res){
					documentSavedCallback(res);
					nextDoc();
				}
				function nextDoc(){
					console.log("Going to next element");
					if(scope.viewOptions != undefined && scope.viewOptions.gotToNext != undefined){
						scope.viewOptions.gotToNext(scope.labNote);
					}
				}

				scope.nextDoc = nextDoc;

				scope.setSeen = function() {
					var frm = preSetSeen();
					if (frm.labNotes.length>0) {
						return LabAccessor.save(frm, documentSavedCallbackAndNext);
					}
				};
				scope.labDiff = function() {
					if (scope.labNote.showDiff === true) {
						scope.labNote.showDiff = false;
						scope.labNote.html = scope.labNote.htmlNoDiff;
						model.labDataUpdated(true);
					} else if (scope.labNote.htmlDiff) {
						scope.labNote.showDiff = true;
						scope.labNote.html = scope.labNote.htmlDiff;
						model.labDataUpdated(true);
					} else {
						return LabAccessor.diff(scope.labNote, function success(response){
							scope.labNote.showDiff = true;
							scope.labNote.htmlNoDiff = scope.labNote.html;
							scope.labNote.htmlDiff = response.data.html;
							scope.labNote.html = scope.labNote.htmlDiff;
							model.labDataUpdated(true);
						});
					}
				};
				scope.togglePatientSection = function() {
					scope.hideHeader==!scope.hideHeader;
					model.prefSettings('labo_hide_header', scope.hideHeader);
					var iframes = document.getElementsByClassName('frameViewer');
					for (var i = 0; i < iframes.length; i++) {
				        iframes[i].contentWindow.togglePatientSection(scope.hideHeader);
					}
				}
				scope.showPatientButton = function() {
					var q = model.qv();
					var isNotQv = q && q.group && Object.keys(q.group).length===0;
					if (isNotQv===false) {
						// sommaire ouvert? dans ce cas, on a un qv mais patient est différent habituellement
						if (scope.labNote && scope.labNote.idPatient) {
							if (q.group['pat' + scope.labNote.idPatient]==undefined) {
								isNotQv = true;
							}
						}
					}
					return isNotQv && (model.activeController()==='review' || model.activeController()==='actions');
				};
				scope.openLastEncounter = function(){
					// si dans dossier patient, le patient n'est pas avec labNote mais avec model.patient();
					var patient = scope.labNote.patient ? scope.labNote.patient : (model.patient() ? model.patient().currPatient : undefined);
					if (patient) {
						patientShowTitles.openActivity(patient, {mode: 'n', minimize: false, openLastEncounter:true}, patient, scope);
					}
				};
				scope.openPatientFile = function(){
					// si dans dossier patient, le patient n'est pas avec labNote mais avec model.patient();
					var patient = scope.labNote.patient ? scope.labNote.patient : (model.patient() ? model.patient().currPatient : undefined);
					if (patient) {
						patientShowTitles.openActivity(patient, {mode: 'n', minimize: false}, patient);
					}
				};

				function update(n, o, scope){
					if (model.labDataUpdated().doc) {
						scope.labNote = model.labDataUpdated().doc;	// est qvActData
						scope.labNote.save = scope.save;	// ai besoin de cet méthode dans les event close
						scope.labNote.cancel = scope.cancel;	// ai besoin de cet méthode dans les event close
						setNoteFrm(scope.labNote);
					}
					model.safeCall(addEventsEvent);
					if(scope.labNote){
						if(!scope.labNote.patient){
							scope.labNote.patient = getPatient();
						}
						scope.linkManager = MessageLink.linkManager(LabAccessor, scope.labNote, 
							scope.labNote.className == "CLaboResultsProfessionnal" ? scope.labNote.id: scope.labNote.uid, 
							scope);
							
						scope.labNote.onChangeActivity = function (params) {
							scope.linkManager.clear()
						}
					}
					scope.assignOtherPatient = {};
				}

				function getPatient(){
					if(scope.labNote.patient){
						return scope.labNote.patient;
					}else if(scope.quickViewData && scope.quickViewData.pat){
						return scope.quickViewData.pat;
					}else if(model.patient() && model.patient().currPatient){
						return model.patient().currPatient;
					}
				}
				function setNoteFrm(docNote){
					scope.notefrm.className = docNote.className;
					if (docNote.activeProf && docNote.activeProf.idProf) {
						scope.notefrm.id = docNote.activeProf.id;
						scope.notefrm.signedDatetime = docNote.activeProf.signedDatetime;
						scope.notefrm.note = docNote.activeProf.note;
						var st = docNote.activeProf&&docNote.activeProf.st ? docNote.activeProf.st : [];
						scope.notefrm.toResolve = $.inArray("TO_RESOLVE",  st) >= 0;
						scope.notefrm.openWithFile = $.inArray("OPEN_WITH_FILE", st) >= 0;
					}
				}

				function hasModification(){
					if (!scope.labNote)  return false;		// pas encore loadé
					var note = scope.notefrm.note ? scope.notefrm.note.replace(/(\r\n|\n|\r)/gm,"") : '';
					var st = scope.labNote.activeProf&&scope.labNote.activeProf.activeSt ? scope.labNote.activeProf.activeSt : [];
					var actNote = !scope.labNote.activeProf || !scope.labNote.activeProf.note ? '' : scope.labNote.activeProf.note.replace(/(\r\n|\n|\r)/gm,"");
					return  scope.docNoteForm.$dirty && (note!=actNote ||
						// scope.notefrm.id !== scope.labNote.id || EST DIFF CAR notefrm.id = idlabprof et non le id de labNote.
						scope.notefrm.toResolve !== $.inArray("TO_RESOLVE", st) >= 0 ||
						scope.notefrm.openWithFile !== $.inArray("OPEN_WITH_FILE", st) >= 0);
				}

				var isDirty = false;

				function registerDirty(){
					QValidation.registerDirty("lab_"+ scope.labNote.idText, scope.labNote.save, function(){
						scope.docNoteForm.$setPristine();
						return true;
					});
				}

				function unregisterDirty(){
					QValidation.unregisterDirty("lab_"+scope.labNote.idText);
					isDirty = false;
					// doit on appeler cette méthode ? Peut elle être responsable de la non refresh post save?
					if(scope.labNote.cancel) scope.labNote.cancel();
					if(scope.docNoteForm) {
						scope.docNoteForm.$setPristine();
					}
				}

				scope.isDirty = function(docNoteForm){	// docNoteForm pas utile? on a scope.docNoteForm...
					//If form changes dirty state register the dirty state
//					if(angular.isDefined(isDirty) && angular.isDefined(docNoteForm.$dirty) ){
					if(angular.isDefined(scope.docNoteForm.$dirty) ){
						var mod = hasModification();
						if(isDirty != mod){
							if(mod){
								registerDirty();
							}else{
								unregisterDirty();
							}
						}

						if(mod){
							isDirty = true;
						}else{
							isDirty = false;
						}
					}else{
						isDirty = scope.docNoteForm.$dirty;
					}
					if (scope.labNote) {
						if (scope.labNote.prop === undefined) scope.labNote.prop = {};
						scope.labNote.prop.readonly = !isDirty;	// pour savoir qu'a été modifié quand veut fermer.
					}
					return isDirty;
				};
				if(scope.qv){
					scope.qv.isDirty = function(){
						return isDirty;
					};
				}
				scope.open = function(id){
					LabAccessor.open(id, function(res){
						model.notice().ifEmbeded($filter('translate')('OpenLink2'));
					});
				};
				scope.isNotSigned = function(){
					if(angular.isDefined(scope.notefrm) && (scope.notefrm.className === "CLaboFile" || scope.notefrm.className === "CLaboResultsProfessionnal")) {
						return angular.isUndefined(scope.notefrm.signedDatetime);
					}else{
						return true;
					}
				};
				scope.sign = function(){
					if (model.prefSettings('user_settings_NoShowSignWarning')==false) {
						var qconfirmOptions = {title: $filter('translate')('RESULTS_TAKE_RESPONSIBILITY')};
						QConfirm.open(qconfirmOptions).then(proceedWithEdit);
						function proceedWithEdit(proceed){
							if(proceed){
								LabAccessor.sign(scope.notefrm.id, documentSavedCallback);
							}
						}
					} else {
						LabAccessor.sign(scope.notefrm.id, documentSavedCallback);
					}
				};
				scope.printLabo= function(){
					LabAccessor.printLabo(scope.notefrm.id);
				};

				function documentSavedCallback(res){
					if(res.data !== undefined && res.data !== null){
						var doc = LabAccessor.utils.getBaseLab(res.data);
						doc.activeProf.activeSt = doc.activeProf.st;
						// bcp de champs non utiles ici... on pourrait épurer les calls, mais en ai besoin dans old ui.
						delete doc.uid;
						delete doc.flag;
						delete doc.className;
						delete doc.html;
						delete doc.laboResults;
						delete doc.patient;
						delete doc.professionnal;
						if (scope.labNote.selectedProf && doc.activeProf && scope.labNote.selectedProf.idProf!==doc.activeProf.idProf) {
							delete doc.selectedProf;	// ne pas écraser celui en place
						}
						delete doc.profs;	// est un array vide ici. Je garde celui qui était dans labNote.
						doc.origVersion = angular.copy(doc);	// pour permettre cancel

						scope.labNote.activeProf = angular.copy(doc.activeProf);
						scope.labNote.className = "CLaboFile";
						angular.extend(scope.labNote, doc);
						// il faut remplacer le prof actif dans la liste pour que infobulle soit à jour.
						if(scope.labNote.profs !== undefined){
							var addedIt = false;
							for (var zz=0;zz<scope.labNote.profs.length; zz++) {
								var pp = scope.labNote.profs[zz];
								if (pp.id==scope.labNote.activeProf.id) {
									scope.labNote.profs[zz] = scope.labNote.activeProf;
									addedIt = true;
									break;
								}
								if (pp.id==scope.labNote.selectedProf.id) {
									scope.labNote.profs[zz] = scope.labNote.selectedProf;
									break;
								}
							}
							if (addedIt===false) {
								scope.labNote.profs.unshift(scope.labNote.activeProf);
							}
						}
						if (scope.labNote.selectedProf.idProf===scope.labNote.activeProf.idProf) {
							scope.labNote.selectedProf = scope.labNote.activeProf;
						}
						delete scope.labNote.title_html;
						scope.labNote.hasNote = OfysUtils.isNotEmpty(doc.note);
						if (scope.labNote.prop===undefined) scope.labNote.prop = {};
						scope.labNote.prop.readonly = true;	// pour savoir qu'a été modifié quand veut fermer.
						setNoteFrm(scope.labNote);
						model.patientDataUpdated(true);
						model.labDataUpdated(true, scope.labNote);
						model.notice().success($filter('translate')('docSuccessfulSave'));
					}else{
						model.notice().fail($filter('translate')('docFailedSave'));
					}
					if (scope.docNoteForm) scope.docNoteForm.$setPristine();
				}

				scope.assignOtherPatient = {};
				scope.patientSearchAssist = {
						assistId: "autocomplete_patient",
						nextTabOnTab: true,
						nextTabOnEnter: true,
						hasDetails: true,
						hasHeader: false,
						keepOnScreen: true,
						detailsOnLeft:true,
						listWidth: 300,
						descWidth: 400,
						minChar: 5,
						trigger: 'focus',
						getAsyncData: function(query, assist){
							query = query.replace(',', '');//make sure that composed names with commas are searchable too
							return $q(function(resolve, reject) {
								if(query.length > 4){
									PatientAccessor.search(b64EncodeUnicode(query), function(res){
										resolve(res.data);
									}, angular.noop);
								}else{
									resolve([]);
								}
							});
						},
						getKey: function(pat) {
							return pat.lastName + ", " +pat.firstName + ' (' + pat.birthDate + '/' + pat.gender + ")";
						},
						getDescription: PatientAccessor.generatePatientSearchDescription,
						selection: function(pat, assistObject) {
							scope.assignOtherPatient = pat;
							scope.assignOtherPatient.completeName = pat.lastName + ", " +pat.firstName + ' (' + pat.birthDate + '/' + pat.gender + ")";
							return scope.assignOtherPatient.completeName;
						}
					};
					scope.focusAssignPat = function () {
						$timeout(function(){
							scope.assignOtherPatient.assignOtherPatSearchFocus()
						}, 50);
					}
				scope.doAssignOtherPatient = function() {
					if (scope.assignOtherPatient.id) {
						LabAccessor.assignOtherPatient({id:scope.notefrm.id, idPatient:scope.assignOtherPatient.id}, function success(response, msglist){
							// response is undefined si success. Sinon
							if ((msglist && msglist.length>0) || (response && response.data && response.data.success===false)) {
								if (msglist && msglist.length>0) {
									model.notice().warn(msglist);
								} else {
									model.notice().warn(response.data.ms);
								}
							} else {
								scope.labNote.idPatient = scope.assignOtherPatient.id;
								scope.labNote.patient = scope.assignOtherPatient;
								model.actUpdated(true);
								model.notice().success($filter('translate')('docSuccessfulAssignOtherPatient'));
							}
						}, function(res) {
							model.notice().warn(res);
						});
					}
				};

				scope.save = function(){
					var frm = $.extend({}, scope.notefrm);
					frm.labNotes = [];
					//Angular $http doesn't seem to url encode line breaks
					// frm.note = frm.note ? frm.note.replaceAll("\n", '%0D%0A') : "";
					if (scope.labNote.profs && scope.labNote.activeProf) {
						frm.idPatient = scope.labNote.idPatient
						for (var i = 0; i < scope.labNote.profs.length; i++) {
							var lp = scope.labNote.profs[i];
							if (lp.idProf===scope.labNote.activeProf.idProf && lp.id!==scope.labNote.activeProf.id) {
								// autre version. Si valeurs différentes, il faut les mettre à jour
								var toResolve = $.inArray("TO_RESOLVE",  lp.activeSt) >= 0;
								var openWithFile = $.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0;
								if ((toResolve===true && frm.toResolve===false) || (openWithFile===true && frm.openWithFile===false)) {
									var ppv = $.extend({}, scope.notefrm);
									ppv.toResolve = frm.toResolve;
									ppv.openWithFile = frm.openWithFile;
									ppv.id = lp.id;
									frm.labNotes.push(ppv);
								}
							}
						}
					}
					return LabAccessor.save(frm, documentSavedCallback);
				};

				function documentSavedEnumSetCallback(res){
					if(res.data !== undefined) {
						if (res.data.severity=="OK"){
							if (res.data.data) {
								var ids = res.data.data;
								for (var i = 0; i < scope.labNote.profs.length; i++) {
									var lp = scope.labNote.profs[i];
									if (ids.indexOf(lp.id)!==-1) {
										lp.activeSt.length = 0;
										lp.st.length = 0;
									}
								}
								model.labDataUpdated(true);
							}
							model.notice().success($filter('translate')('docSuccessfulSave'));
						}else{
							model.notice().fail(res.data.message, $filter('translate')('docFailedSave'));
						}
					}else{
						model.notice().fail($filter('translate')('docFailedSave'));
					}
				}
				function documentSavedDellAutoOpenCallback(res){
					if(res.data !== undefined) {
						if (res.data.severity=="OK"){
							if (res.data.data) {
								var ids = res.data.data;
								if (scope.labNote.activeProf) {
									scope.labNote.activeProf.st.splice($.inArray("OPEN_WITH_FILE", scope.labNote.activeProf.st), 1);
								}
								for (var i = 0; i < scope.labNote.profs.length; i++) {
									var lp = scope.labNote.profs[i];
									if (ids.indexOf(lp.id)!==-1) {
										lp.activeSt.splice($.inArray("OPEN_WITH_FILE", lp.activeSt), 1);
										lp.st.splice($.inArray("OPEN_WITH_FILE", lp.st), 1);
									}
								}
								model.labDataUpdated(true);
							}
							model.notice().success($filter('translate')('docSuccessfulSave'));
						}else{
							model.notice().fail(res.data.message, $filter('translate')('docFailedSave'));
						}
					}else{
						model.notice().fail($filter('translate')('docFailedSave'));
					}
				}
				scope.saveEnumSet = function(){
					var enumToReset = {labNotes:[], idPatient:scope.labNote.idPatient};
					if (scope.labNote.profs && scope.labNote.activeProf) {
						for (var i = 0; i < scope.labNote.profs.length; i++) {
							var lp = scope.labNote.profs[i];
							if (lp.idProf!==scope.labNote.activeProf.idProf) {
								// prof est different du prof actif
								var toResolve = $.inArray("TO_RESOLVE", lp.activeSt) >= 0;
								var openWithFile = $.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0;
								if (toResolve===true || openWithFile===true) {
									enumToReset.labNotes.push(lp);
								}
							}
						}
					}
					if (enumToReset.labNotes.length>0) {
						return LabAccessor.saveEnumSet(enumToReset, documentSavedEnumSetCallback);
					} else {
						// nothing to reset
					}
				};

				scope.saveDelAllAutoOpen = function(){
					var enumToReset = {labNotes:[], idPatient:scope.labNote.idPatient};
					if (scope.labNote.profs) {
						for (var i = 0; i < scope.labNote.profs.length; i++) {
							var lp = scope.labNote.profs[i];
							if ($.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0) {
								enumToReset.labNotes.push(lp);
							}
						}
					}
					if (enumToReset.labNotes.length>0) {
						return LabAccessor.delAllAutoOpen(enumToReset, documentSavedDellAutoOpenCallback);
					} else {
						// nothing to reset
					}
				};

				scope.cancel = function(){
					scope.labNote = scope.labNote.origVersion;
					scope.labNote.save = scope.save;
					scope.labNote.cancel = scope.cancel;
					scope.labNote.origVersion = angular.copy(scope.labNote);

				};

				function addEventsEvent(){
					if(!scope.qv){
						return;// not in quickview mode
					}

					if(!QuickView.eventsActive(scope.qv)){
						return;// event have already been deleted (because of a close or one quickview that triggers another)
					}
					//Si c'est la première ouverture, créer la variable d'événements
					if(!scope.qv.ActiveEventsRef){
						scope.qv.ActiveEventsRef = {};
					}
					//Make sure previously created evens are not referred to
					//Very important to avoid leaks
					QuickView.removeAllEventHandlers(scope);

					function onMinimizeOrClose(event, fct) {
						var act = event.mObj.quickViewData.qvActData;
						if ((!scope.ignoreChanges) && (angular.isDefined(act.prop) && act.prop.readonly===false)) {
							event.stopPropagation();
							var newAct = event.newAct;//Continue activity change
							QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}).then(function(save){
								function continueAction(res){
									unregisterDirty();
									scope.ignoreChanges = true;
									//Makes sure the original action is called again in 'fct()'
									//- if changeActivity was the origianl action it should be recalled and
									//   the second time the validation message is not shown because scope.ignoreChanges === true
									if (fct) fct();
								}
								function saveFailedCanNotContinue(res){
									var errMsg = res.statusText ? res.statusText : "";
									model.notice().fail($filter('translate')('docFailedSaveErrMsg', {errMsg: errMsg}));
								}
								if(save){
									act.save().then(continueAction, saveFailedCanNotContinue);
								}else{
									continueAction();
								}
							});
						}
					}

					//L'événement existe donc il ne faut pas le recréer
					if(!scope.qv.ActiveEventsRef.onQvClose){
						//Ici elle est appeller ajouté aussi-tot que le viewer s'ouvre donc toujours active
						//Comme le scope n'est pas passé en parametre, le handler est seulement detruit quand le quickview est fermer
						scope.qv.ActiveEventsRef.onQvClose = Event.on(scope.qv.onQvClose,function(event){
							onMinimizeOrClose(event, scope.qv.$$close);
						});
					}

					if(!scope.qv.ActiveEventsRef.onQvMinimize){
						scope.qv.ActiveEventsRef.onQvMinimize = Event.on(scope.qv.onQvMinimize,function(event){
							onMinimizeOrClose(event);
							QuickView.removeAllEventHandlers(scope);
						}, scope);
					}

					//événement de changement d'activité
					if(!scope.qv.ActiveEventsRef.onQvActivityChange){
						scope.qv.ActiveEventsRef.onQvActivityChange = Event.on(scope.qv.onQvActivityChange,function(event){
							var newAct = event.newAct;
							onMinimizeOrClose(event, function(){
								if(scope.qv && scope.qv.$$changeActivity && scope.qv.$$changeActivity (newAct)){
									model.actUpdated(true);
									scope.ignoreChanges = false;
								}
								Event.removeEvent(scope.qv.ActiveEventsRef.onQvActivityChange);
								QuickView.removeAllEventHandlers(scope);
							});

						}, scope);
					}

					if(!scope.qv.ActiveEventsRef.onQvExternalize){
						scope.qv.ActiveEventsRef.onQvExternalize = Event.on(scope.qv.onQvExternalize,function(event){
							QuickView.removeAllEventHandlers(scope);
						}, scope);
					}
				}

				scope.$watch(function() {
					return model.labDataUpdated().val;
				}, update);
				
			}
		};
	}]);


	labo.directive('labDsqView', ['Notification','DashAPI','DashWebSocket','PatientUtils',
		function(Notification, DashAPI, DashWebSocket, PatientUtils){
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/labo/labo_dsq_view.html?v=bi',
				scope: true,
				link: function(scope, element, attrs){

					scope.resizeIframe = function(elem){
						var parentSection = $(elem[0]).parents("section")[0];
						var headerheight = $(parentSection).find(".popSide").outerHeight();
						if(headerheight === undefined)headerheight = 0;
						var height = $(parentSection).outerHeight() - headerheight;
						elem[0].style.height = (height - 8 ) + "px";
					};

					var dsqItemHandlerId = Notification.registerHandler('dsqLabItem', function(msg){
						var statusError = DashAPI.handleReturnObject(msg.data.status);
						if(msg.data && msg.data.obj && msg.data.obj.idPatient === scope.patient.id){
							if (statusError=='OK' || statusError=='WARNING') {
								var doc = msg.data.obj;
								if(doc){
									if(scope.lab && scope.lab.res){
										doc.valDsq = scope.lab.res;
									}
									// scope.lab.prop = ;//
									doc.prop = {readonly:false, edit: true, dsq: true};
									doc.t = 'urlframe';
									scope.dsqlab = doc;
								}else{
	
								}
							} else {
								// if (error) error();
							}
						}
					}, scope);

					function update(n, o){
						scope.lab = n;
						scope.dsqlab = null;
						if(scope.lab){
							var qvData = scope.$eval(attrs.quickViewData);
							scope.patient = qvData.pat;
							scope.searchCriteria = {patientId: scope.patient.id, labo: scope.lab.res };
							DashWebSocket.sendRequest("/dashboard/dsq/ws/lab/get", scope.searchCriteria);
						}
					}

					scope.$watch(attrs.labs, update);
				}
			};
	}]);


	labo.directive('labView', ['LabAccessor','model', '$filter','PatientAccessor','MessageLink', '$timeout', '$q', '$log', 'Event','QValidation','QConfirm','patientShowTitles',
	                           function(LabAccessor, model, $filter, PatientAccessor, MessageLink, $timeout, $q, $log, Event, QValidation, QConfirm, patientShowTitles){

		function setInitData(doc) {
			if (!doc.prop) doc.prop = {readonly:true};
		}

		function getAllVersions(doc, idText){
			if(doc){
				if(idText === undefined){
					idText = doc.idText;
				}
				var idPat = doc.patient ? doc.patient.id : doc.idPatient;
				LabAccessor.allVersions({labNo: doc.labNo, initial: idText, idPatient:idPat}, function(res){
					if (res.data) {
						if (res.data.success!==false) {
							doc.allVersions = $filter('orderBy')(res.data, '-entryDatetime');							
						}
					}
				});
			}
		}

		function getLaboId(doc){
			var laboId = {};
			if (doc.activeProf) {
				laboId.labProfId = doc.activeProf.id;
			} else {
				if (doc.profs && doc.profs.length>0) {
					for (var zz=0;zz<doc.profs.length; zz++) {
						var pp = doc.profs[zz];
						if (pp.idText==doc.idText) {
							laboId.labProfId = pp.id;
							break;
						}
					}
				}
				if (laboId.labProfId == undefined){
					// on a un doc.idText seulement. L'utiliser pour obtenir le labo
					laboId.idText = doc.idText ? doc.idText : (doc.idLabText ? doc.idLabText: undefined);
				}
			}
			laboId.idPatient = doc.patient ? doc.patient.id : doc.idPatient;
			return laboId;
		}

		function getData(scope, doc){
			if(doc.labNo && (model.prefSettings('user_settings_ShowAllLabs') || model.user().session.mustLoadAllLabVersion===true) && !doc.allVersions){
				getAllVersions(doc, doc.idText);
			}else if(!model.prefSettings('user_settings_ShowAllLabs') && doc.allVersions){
				delete doc.allVersions;
			}

			if (doc.prop) {
				// est en mode d'édition - donc a deja été chargé. Ne pas recharger le fichier - pas besoin car j'ai tout
				model.editModeUpdated(true);
				if(scope && scope.viewOptions && scope.viewOptions.hasHeader){
					model.labDataUpdated(true, doc);
				}
			} else if(doc.id != undefined){
				var laboId = getLaboId(doc);
				laboId.loadAllVesion = false;// model.prefSettings('user_settings_ShowAllLabs');	// me semble plus lent pour l'utilisateur si on passe true ici. On va obtenir ds un 2e temps
				LabAccessor.labView(laboId, function success(response){
					if (response.data && response.data.success==false) {
						model.notice().warn($filter('translate')('ERR_GET_DOC'));
						return;
					}
					if (doc.activeProf && doc.activeProf.st) {
						if (doc.notValidated) {
							doc.notValidated='OK';	// un delete n'est pas considéré instantanément dans le ui...
						}
					}
					var labo = LabAccessor.utils.getBaseLab(response.data);	// ici on recoit un CBaseLaboResultsProfessionnal et non un CLaboFile
					// doc.allVersions = $filter('orderBy')(response.data.prevLaboResultsProfVersion, '-entryDatetime');
					if (doc.activeProf===undefined) doc.activeProf = {};
					if (labo.professionnal) {//  && doc.activeProf.idProf===labo.professionnal.id) {
						doc.activeProf.id = labo.id;
						doc.activeProf.idProf = labo.professionnal.id;
						doc.activeProf.seenDatetime = labo.seenDatetime;
						doc.activeProf.note = labo.note;
						// le doc.activeProf.st a été bonifié dans le CLaboProf pour avoir la résultante de toutes les versions de laboProf d'un même prof
						// il est donc plus fiable et représentatif de ce qui est affiché dans la liste des labo
						doc.activeProf.st = labo.status;
						doc.activeProf.activeSt = doc.activeProf.st;
					}
					var addedIt = false;
					if (doc.profs) {
						for (var zz=0;zz<doc.profs.length; zz++) {
							var pp = doc.profs[zz];
							if (pp.id==doc.activeProf.id) {
								doc.profs[zz] = doc.activeProf;
								addedIt = true;
								break;
							}
							if (doc.selectedProf && pp.id==doc.selectedProf.id) {
								doc.profs[zz] = doc.selectedProf;
								break;
							}
						}
					} else {
						doc.profs = [];
					}
					if (addedIt===false && doc.profs.length>0) {
						doc.profs.unshift(doc.activeProf);
					}
					if (doc.selectedProf && doc.selectedProf.idProf===doc.activeProf.idProf) {
						doc.selectedProf = doc.activeProf;
					}

					doc.status = doc.activeProf.st;
					doc.note = doc.activeProf.note;
					if (labo.str && doc.req == undefined) doc.req = labo.str;
					if (labo.idLabText && doc.idText == undefined) doc.idText = labo.idLabText;
					doc.html = labo.html;
					doc.text = labo.text;
					doc.type = labo.type;
					if (labo.hasDocPdf) {
						doc.hasDocPdf = labo.hasDocPdf;
						doc.labNo = labo.labNo;
						doc.idPatient= labo.patient.id;
						doc.year = labo.year;
					}
					// doc.className = "CLaboFile";
					doc.hasPrevSeen = labo.previousLaboResultsSeen!==undefined;
					doc.notesHistory = labo.notesHistory;
					doc.origVersion = angular.copy(doc);	// pour permettre cancel
//					angular.extend(doc, labo);	// extend écrase trop de données.
					if(model.isIE && doc.type === 'html'){
						doc.type = "ie"+ doc.type;
					}
					setInitData(doc);
					model.editModeUpdated(true);
					if(scope && scope.viewOptions && scope.viewOptions.hasHeader){
						model.labDataUpdated(true, doc);
					}
				});
			}
		}

		function editProp(scope, doc){
			doc.prop.readonly = false;
			scope.quickViewData.editMode = true;
			model.editModeUpdated(true);
			model.labDataUpdated(true);
		}

		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/labo/labo_view.html?v=bi',
			scope: true,
			link: function(scope, element, attrs){
				var ieLaboLoadFixLoadCount = 0;
				var ieLaboLoadDocWritten = false;
				scope.reloadTryIeFix = true;

				var defaultOptions = {
					hasHeader: true
				}
				function setViewOptions(options){
					scope.viewOptions = angular.copy(defaultOptions)
					if(options){
						$.extend(scope.viewOptions, options)
					}
				}

				function update(n, o, scope){
					stackCopy = "";
					scope.labo = n;
					setViewOptions(scope.$eval(attrs.options));
					getData(scope, scope.labo);
					// LabAccessor.updateMessageLink(scope.labo, scope);
					ieLaboLoadDocWritten = false;
					//PatientAccessor.setCurrent(scope.labo.idPatient);	 // retrait de setCurrent
					if(model.isIE){
						ieUpdate();
					}
				}

				function ieUpdate(){
					scope.reloadTryIeFix = false;
					$timeout(function(){
						scope.reloadTryIeFix = true;
					}, 30);
				}

				scope.showVoirDocPdf = function() {
					return scope.labo.hasDocPdf==true;
				};

				scope.openDocPdf = function() {
					LabAccessor.openDocPdf({idPatient: scope.labo.idPatient, year: scope.labo.year, labNo:scope.labo.labNo});
				};

				scope.$watch(attrs.labs, update);

				var stackCopy = "";
				scope.resizeIframe = function(elem){
					elem[0].style.height = 0;
					elem[0].style.height = (elem[0].contentWindow.document.body.scrollHeight + 20)+ 'px';

					elem[0].contentWindow.jsToJavaLoadLab = function(idField){
						var idPt = scope.labo.idPatient ? scope.labo.idPatient :
							(scope.labo.patient ? scope.labo.patient.id : undefined);
						LabAccessor.history({idField: idField, patientId: idPt},
							function success(response){
								var data = response.data;
								data.valArray = eval('(' + data.valArray + ')');
								elem[0].contentWindow.pushDataTo(data.idField, data.values, data.valArray);
							});
					};

					elem[0].contentWindow.copyToCB  = function(copyString){
						if(copyString && copyString.length > 0 ){
							//Add copy string if not already contained.
							if(stackCopy.indexOf(copyString) < 0){
								stackCopy += (stackCopy === "" ? "":"\n") + copyString;
							}
						}else{//String to copy is invalid
							return;
						}
						var eventCB = arguments.callee.caller;
						var jsCopyFailed = ! copyToClipboard(eventCB.arguments[0].target, stackCopy);
						if(jsCopyFailed){ //Copy with java code
							LabAccessor.copyToClip(stackCopy.replaceAll("\n", '%0D%0A'), function(){}, function(){});
						}
					};
					elem[0].contentWindow.togglePatientSection = function(hide) {
						//var scrHeight = elem[0].contentWindow.document.body.scrollHeight;
						//console.log("scrHeight=" + scrHeight);
						elem[0].contentDocument.getElementsByName('section_patient')[0].style.display = (hide) ? 'none' : 'block';
						elem[0].style.height = (elem[0].contentWindow.document.body.scrollHeight + 20)+ 'px';
					}
					
					if(model.isIE){
						ieLaboReady(elem[0].contentWindow);
					}
					
					elem[0].contentWindow.addLaboFollow  = function(laboTypes){
						if(laboTypes && laboTypes.length <3 ){	// un array 
							return;
						}
						var idPt = scope.labo.idPatient ? scope.labo.idPatient :
							(scope.labo.patient ? scope.labo.patient.id : undefined);
						var idProf =  model.user().profil &&  model.user().profil.id ?  model.user().profil.id : undefined;
						if (idPt && idProf && (laboTypes[0].length>1 || laboTypes[1].length>3)) {
							LabAccessor.doAddLaboFollow(laboTypes, idProf, idPt);
						}
					};
					if (model.prefSettings('labo_hide_header')) {
						elem[0].contentWindow.togglePatientSection(true);
					}
					if(model.isIE){
						ieLaboReady(elem[0].contentWindow);
					}
				};

				function ieLaboReady(iframe){
					if(scope.labo && !ieLaboLoadDocWritten){
						ieLaboLoadDocWritten = true;
						var iframedoc = iframe.document;
						iframedoc.open();
				        iframedoc.write(scope.labo.html);
				        iframedoc.close();
						//Internet explorer hack since srcdoc in iframe does not work
						//Inject html. this method 'setFormHtml' is created in form_proxy.html
						//when eform is loaded the frame containing this function is loaded, calling this method rewrites the frame content.
//						scope.formWindow.document.setFormHtml(scope.form.html);

						//set the formReady callback that is called by the
						//form when it has been loaded
						// scope.formWindow.formReady = formReady;

						if(ieLaboLoadFixLoadCount > 5) {
							// console.log("Tried loading form "+ ieLaboLoadFixLoadCount + " times" );
						}
					}else if(ieLaboLoadFixLoadCount < 10){
						ieLaboLoadFixLoadCount += 1;
						$timeout(function(){
							ieLaboReady(iframe);
						}, 1);
					}
				}
				
				function copyToClipboard(elem, textToCopy) {
					  // create hidden text element, if it doesn't already exist
				    var targetId = "_hiddenCopyText_",target;
				    var isInput = false;
				    var origSelectionStart, origSelectionEnd;
				    if (isInput) {
				        // can just use the original source element for the selection and copy
				        target = elem;
				        origSelectionStart = elem.selectionStart;
				        origSelectionEnd = elem.selectionEnd;
				    } else {
				        // must use a temporary form element for the selection and copy
				        target = document.getElementById(targetId);
				        if (!target) {
				            target = document.createElement("textarea");
				            target.style.position = "absolute";
				            target.style.left = "-9999px";
				            target.style.top = "0";
				            target.id = targetId;
				            document.body.appendChild(target);
				        }
				        target.textContent = textToCopy;
				    }
				    // select the content
				    var currentFocus = document.activeElement;
				    target.focus();
				    target.setSelectionRange(0, target.value.length);

				    // copy the selection
				    var succeed;
				    try {
				    	  succeed = document.execCommand("copy");
				    } catch(e) {
				        succeed = false;
				    }
				    // restore original focus
				    if (currentFocus && typeof currentFocus.focus === "function") {
				        currentFocus.focus();
				    }

				    if (isInput) {
				        // restore prior selection
				        elem.setSelectionRange(origSelectionStart, origSelectionEnd);
				    } else {
				        // clear temporary content
				        target.textContent = "";
				    }
				    return succeed;
				}
			}
		};
	}]);
})();