(function(){
	var appointment = angular.module("appointment", ['widgets']);

	appointment.factory('AppointmentAccessor', ['DashAPI','MessageLink','model','$q','$filter',
		 function(DashAPI, MessageLink, model, $q, $filter) {
			 var translatables = [
			 'CE_CLIENT_A_UN_OU_DES_RENDEZ_VOUS_DANS_LE_FUTUR_',
			 'LA_PERIODE_NA_PAS_DE_TYPE_VEUILLEZ_SPECIFIER_UN_TYPE_DE_PERIODE',
			 'LE_NOM_DE_LA_PERIODE_LONGUEUR',
			 'LA_PERIODE_NA_PAS_DE_SITE',
			 'LA_PERIODE_NA_PAS_DHEURE_DE_DEBUT_ETOU_DE_FIN',
			 'ENTREZ_UNE_HEURE_DE_FIN_PLUS_GRANDE_QUE_LHEURE_DE_DEBUT_POUR_LA_PERIODE',
			 'CE_CLIENT_A_UN_OU_DES_RENDEZ_VOUS_DANS_LE_FUTUR_',
			 'ACTUALISER',
			 'ENTREZ_UN_TYPE_RENDEZ_VOUS',
			 'ENTREZ_LE_STATUT_DU_PATIENT',
			 'ENTREZ_LE_STATUT_DU_RENDEZ_VOUS',
			 'ENTREZ_LE_SITE_DU_RENDEZ_VOUS',
		 ];

		 function appDateParamString(data){
			return "?" + ["day","idProf","start", "end"].filter(
				function(e){return data[e] != undefined}).map(
					function(e){return e+"="+data[e];}).join("&");
		 }
		var appointmentTypesById;
		var activeAppointemntTypes;
		var periodTypesById;
		var activePeriodTypes;
		var accessor = {
			utils:{
				translateMsg: function (msg) {
					for (let i = 0; i < translatables.length; i++) {
						msg = msg.replace('~' + translatables[i] + '~', $filter("translate")(translatables[i]))
					}
					return msg;
				},

				isAbsentToday: function (recipient){
					if (recipient) {
						if(recipient.className == "CPersonGroup"){
							recipient.persons.forEach(function(baseUser){
								baseUser.personId = baseUser.idPerson;
								accessor.utils.setCalendarPresence(baseUser,recipient );
							});
						}else{
							accessor.utils.setCalendarPresence(recipient);
						}
					}
				},
				setCalendarPresence: function (recipient, group){
					if(recipient.personTypeInt == 2 || recipient.useAppt){//Professionals only
						var profIds = this.getProfIdFromUser(recipient).join(",");
						var t = moment().format("YYYY-MM-DD");
						if(profIds.length > 0){
							accessor.profIsAbsent({
								start:t,
								end:t,
								idProf:profIds
							}, function(res){
								if(res.baseAppointmentDates != undefined && res.baseAppointmentDates.length > 0
									&& res.baseAppointmentDates[0].messageTypes.length > 0 
									&& res.baseAppointmentDates[0].messageTypes[0].startsWith("ABSENT")
								){
									recipient.presence = res.baseAppointmentDates[0].messageTypes;
									if(group != undefined){
										group.atleastOneAbsent = true;
									}
								}
							});
						}
					}
				},
				getProfIdFromUser: function (recipient){
					var res = [];
					var recipientByPersonId = (recipient.persons != undefined ? recipient.persons : [recipient]).reduce(function(a,c){
						a[c.personId] = c;
						return a;
					}, {});
					var profByPersonId = model.store.profs.filter.appointment.list().reduce(function(a, c){
						a[c.idPerson] = c;
						return a;
					},{});
					var recips = Object.keys(recipientByPersonId);
					for (let i = 0; i < recips.length; i++) {
						if(profByPersonId[recips[i]] != undefined && profByPersonId[recips[i]].id != undefined){
							recipientByPersonId[recips[i]].prof = profByPersonId[recips[i]];
							res.push(profByPersonId[recips[i]].id);
						}
					}

					return res;
				}
			},
			activeAppointmentTypes:function(){
				if(activeAppointemntTypes == undefined){
					activeAppointemntTypes = model.clientPreferences().appointmentTypes.filter(function(e){
						return !e.isDeleted;
					});
				}
				return activeAppointemntTypes;
			},
			appointmentTypesById:function(){
				if(appointmentTypesById == undefined){
					appointmentTypesById = _.indexBy(model.clientPreferences().appointmentTypes, 'id');
				}
				return appointmentTypesById;
			},
			activePeriodTypes:function(){
				if(activePeriodTypes == undefined){
					activePeriodTypes = model.clientPreferences().appointmentPeriodTypes.filter(function(e){
						return !e.isDeleted;
					});
				}
				return activePeriodTypes;
			},
			periodTypesById:function(){
				if(periodTypesById == undefined){
					periodTypesById = _.indexBy(model.clientPreferences().appointmentPeriodTypes, 'id');
				}
				return periodTypesById;
			},
			list : function (data, callback, error){
				var params = data.day ? "day="+ data.day + (data.idProf ? "&idProf=" + data.idProf : ""):
					"patient=" + data.patient + (data.type? "&type=" + data.type : "");
				DashAPI.get("/dashboard/apps/ws/list?" + params , callback,error);
			},
			getStartOfWeek: function (date){
				return moment(date).startOf("week").format(OfysUtils.DATEFORMAT);
			},
			getEndOfWeek: function (date){
				return moment(date).endOf("week").format(OfysUtils.DATEFORMAT);
			},
			recall : function (data, callback, error){
				DashAPI.post("/dashboard/apps/ws/recall/list", data, callback,error);
			},
			openEdit: function (id, callback, error){
				var params = angular.isDefined(id)? ("?id="+ id):"";
				DashAPI.get("/dashboard/apps/ws/edit"+ params, callback,error);
			},
			setPatientStatus: function (data, callback, error){
				var params = "?apptId="+ data.apptId + "&statusId=" + data.statusId;
				DashAPI.get("/dashboard/apps/ws/setPatientStatus"+ params, callback,error);
			},
			setAppointmentStatus: function (data, callback, error){
				var params = "?apptId="+ data.apptId + "&statusId=" + data.statusId;
				DashAPI.get("/dashboard/apps/ws/setAppointmentStatus"+ params, callback,error);
			},
			searchPeriod: function (data, callback, error, config){
				return DashAPI.post("/dashboard/apps/ws/searchperiod", data, callback, error, config);
			},
			listPeriodTypes: function (data, callback, error, config){
				var paramString = data.id == undefined ? "" : "?id="+data.id
				return DashAPI.get("/dashboard/apps/ws/listPeriodTypes"+paramString, callback, error, config);
			},
			listAppointmentTypes: function (data, callback, error, config){
				var paramString = data.id == undefined ? "" : "?id="+data.id
				return DashAPI.get("/dashboard/apps/ws/listAppointmentTypes"+paramString, callback, error, config);
			},
			getDate: function (data, callback, error, config){
				return DashAPI.get("/dashboard/apps/ws/getDate" + appDateParamString(data), callback, error, config);
			},
			getCompleteDate: function (data, callback, error, config){
				return DashAPI.get("/dashboard/apps/ws/getCompleteDate" + appDateParamString(data), callback, error, config);
			},
			getBaseDates: function (data, callback, error, config){
				return DashAPI.get("/dashboard/apps/ws/getBaseDates"+appDateParamString(data), callback, error, config);
			},
			profIsAbsent: function (data, callback, error, config){
				return DashAPI.get("/dashboard/apps/ws/profIsAbsent"+appDateParamString(data), callback, error, config);
			},
			getProfessionalsWithSchedule: function (data, callback, error, config){
				var params = "?day="+ data
				return DashAPI.get("/dashboard/apps/ws/getProfessionalsWithSchedule"+params, callback, error, config);
			},
			deleteappointment: function (data, callback, error, config) {
				return DashAPI.post("/dashboard/apps/ws/deleteappointment", data, callback, error, config);
			},
			saveappointment: function (data, callback, error, config) {
				return DashAPI.post("/dashboard/apps/ws/saveappointment", data, callback, error, config);
			},
			saveschedule: function (data, callback, error, config) {
				return DashAPI.post("/dashboard/apps/ws/saveschedule", data, callback, error, config);
			},
			reserveappointment: function (data, callback, error, config) {
				return DashAPI.post("/dashboard/apps/ws/reserveappointment", data, callback, error, config);
			},
			extendReservation: function(data, callback, error, config){
				return DashAPI.post("/dashboard/apps/ws/extendReservation", data, callback, error, config);
			},
			deleteReservation: function (data, callback, error, config) {
				return DashAPI.post("/dashboard/apps/ws/deleteReservation", data, callback, error, config);
			},
			changeAppointmentDateMessage: function(data, callback, error, config) {
				return DashAPI.post("/dashboard/apps/ws/changeAppointmentDateMessage", data, callback, error, config);
			},
			changeAppointmentDateDeGardeType: function(data, callback, error, config) {
				return DashAPI.post("/dashboard/apps/ws/changeAppointmentDateDeGardeType", data, callback, error, config);
			},
			deleteAppointmentDateDeGardeType: function(data, callback, error, config) {
				return DashAPI.post("/dashboard/apps/ws/deleteAppointmentDateDeGardeType", data, callback, error, config);
			},
			findFuturAppointmentPatient: function (idPatient, callback, error, config){
				return DashAPI.get("/dashboard/apps/ws/findFuturAppointmentPatient?idPatient=" + idPatient, callback, error, config);
			},
			findPastAppointmentPatient: function (idPatient, callback, error, config){
				return DashAPI.get("/dashboard/apps/ws/findPastAppointmentPatient?idPatient=" + idPatient, callback, error, config);
			},
			sendEmails: function(data, callback, error, config){
				return DashAPI.post("/dashboard/apps/ws/sendEmails", data, callback, error, config)
			},
			appointementStatus : function (callback, error){
				if(accessor.allAppointementStatus){
					callback(accessor.allAppointementStatus);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus", function(res){
						delete res.data.className;
						accessor.allAppointementStatus = _.values(res.data);
					}, error);
				}
			},
			patientStatus : function (callback, error){
				if(accessor.allPatientStatus){
					callback(accessor.allPatientStatus);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus", function(res){
						delete res.data.className;
						accessor.allPatientStatus = _.values(res.data);
					}, error);
				}
			},
			msgLinkMap:{},//Used for message/task link of current document.
			updateMessageLink: function (patient, scope, uid){
				accessor.messageLinkKey = MessageLink.setLinkType({
					patient: patient.id,
					linkType: MessageLink.linkTypes.patient,
					id: patient.id,
					pat: patient
				},scope);
				accessor.msgLinkMap[uid] = accessor.messageLinkKey
			},
			clearMessageLink: function (){
				MessageLink.removeLinkType(accessor.messageLinkKey);
			}
		};

		var mustResolveBeforeLoad = [
			accessor.appointementStatus(angular.noop),
			accessor.patientStatus(angular.noop),
		];

		model.ready.then(function(){
			accessor.ready = $q.all(mustResolveBeforeLoad);
		});

		return accessor;
	}]);

	appointment.controller('AppointmentController',
		['$location','$scope','model', '$log','$q',
		'AppointmentAccessor','PatientAccessor','ModificationStatus',
		'$log', 'patientShowTitles','hotkeys','$timeout','$uibModal','QValidation','$filter','Rights',
		function($location,$scope, model, $log,$q,
			AppointmentAccessor, PatientAccessor,ModificationStatus,
			$log, patientShowTitles, hotkeys, $timeout, $uibModal, QValidation, $filter, Rights){
		//Has to be the first thing that this controller does.

		// not connected yet?
		if (!model.user().profil) return;

		model.activeController('rv');
		model.activeMenu('Appointments');
		$scope.profList = filterCurrentWorksite();

		function filterCurrentWorksite(){
			var res = model.store.profs.filter.appointment.list();
			if(model.prefSettings('user_settings_SiteAppointments')){
				var workSiteId = model.user().session.workSite.id;
				res = res.filter(function(e){
					if(e && e.sites && e.sites.length > 0){
						for (var i = 0; i < e.sites.length; i++) {
							if(e.sites[i].idSite === workSiteId){
								return true;
							}
						}
						return false;
					}else{
						// if the user does not have a session site.. always display
						return true;
					}
				});
			}
			return $filter('orderBy')(res, 'lastName');
		}

		$scope.focusable = {};

		hotkeys.add({
			combo: 'alt+r',
			description: 'Rechercher un rendez-vous',
			callback: function() {
				$scope.focusable.focusSearchInput();
			}
		});

		$scope.appListUpdated={val:0};

		$scope.focusable.onListReady = function(){
			$timeout(function(){
				if(model.appointment().currAppointment && model.appointment().currAppointment.lstScroll){
					model.appointment().currAppointment.lstScroll()
				}else{
					$scope.focusable.patientsListFocus();
				}
			}, 50);
		};

		//peut être vide si les options par defaut sont toute bonne
		//Voir le fichier DynaDate pour tous les options par défaut
		$scope.appointmentDynaDateOptions = {acceptFutureDate: true};

		$scope.$on("$destroy", function handler() {
	        $log.log("AppointmentController destroy");
	        // if (model.patient().currPatient.id) {
	        // 	model.patientsInQv(model.patient().currPatient.id, null);
	        // }
	    });

		$scope.popoverEdit = false;
		$scope.popoverEditMode = function(mode){
			$scope.popoverEdit = !$scope.popoverEdit;
		};
		$scope.editPatientPopoverOptions = {
			showExit: true,
            fromAppointment:true,
			exit:function(){
				$timeout(function() {
					angular.element('#btn-edit-patient').triggerHandler('click');
					$scope.popoverEdit = false;
				});
			}
		};
		$scope.patientData = function(pts, useBR) {
			var title = "";
			var lf = useBR===true ? "<br/>" : "\n";
			var arr = []
			for(i = 0; i < pts.length; i++){
				var pt = pts[i];
				arr.push(pt.lastName + ", " + pt.firstName + "(" + pt.birthDate + "/" + pt.gender + ")");
			}
			title = arr.join(lf);
			return title;
		};

		$scope.setPatientStatus = function(rdv, ptStatus) {
			$timeout(function(){
				rdv.patientStatus = ptStatus.key;
				var data = {apptId: rdv.id, statusId:ptStatus.index};
				AppointmentAccessor.setPatientStatus(data,
				function() {
					$log.log("succès setPatientStatus!");
					var newCol = model.patientStatusColors(rdv.patientStatus);
					rdv.ptStatColor[0] = newCol[0];
					rdv.ptStatColor[1] = newCol[1];
					rdv.ptStatColor[2] = newCol[2];
				}, function() {
					$log.log("Erreur setPatientStatus ...");
				});
			}, 100);
		};

		$scope.setCurrentApptProf = function(md) {
			model.currentApptMd(md);
			$scope.updateAppointments();
		};
		$scope.listSize = function() {
			return model.listApptSize();
		};
		
		$scope.isPLacedOrTriaged = function(rdv){
			return rdv.patientStatus === 'PLACED'
					|| rdv.patientStatus === 'TRIE'
					|| rdv.patientStatus ==='SEEN_INF'
					|| rdv.patientStatus === 'SEEN_RES'
					|| rdv.patientStatus === 'ATTENTE_REV'
		}

		$scope.pickDate = function(){
			var pic = $('#appointmentDateTime').data('DateTimePicker');
			pic.toggle();
		};

		$scope.compassnav = function(direction){
			var d = moment(model.appointment().currDate, OfysUtils.DATEFORMAT);
			if(direction === 'N'){
				model.appointment().currDate = d.add(1, 'days').format(OfysUtils.DATEFORMAT);
			}else if(direction === 'C'){
				model.appointment().currDate = moment().format(OfysUtils.DATEFORMAT);
			}else if(direction === 'S'){
				model.appointment().currDate = d.subtract(1, 'days').format(OfysUtils.DATEFORMAT);
			}
			$scope.updateAppointments();
		};

		// function patientsFromWorkSite(pts){
		// 	var workSiteId = model.user().session.workSite.id;
		// 	/* Checks if atleast one fo the patients in a list if in a the worksite */
		// 	for (var i = 0; i < pts.length; i++) {
		// 		var pt = pts[i]
		// 		if(pt.lstSites && pt.lstSites.length > 0){
		// 			for (var j = 0; j < pt.lstSites.length; j++) {
		// 			 	if(pt.lstSites[j].idSite === workSiteId){
		// 					 return true;
		// 				 }
		// 			}
		// 		}else{
		// 			return true;
		// 		}
		// 	}
		// 	return false
		// }

		$scope.updateAppointments = function(){
			//Only make calls if the date is valid
			if (model.currentApptMd().useAppointment!==true) return;

			if(!moment(model.appointment().currDate, OfysUtils.DATEFORMAT, true).isValid())return;
			
			param = {
				end: model.appointment().currDate,
				idProf: model.currentApptMd().id,
				start: model.appointment().currDate
			}

			AppointmentAccessor.getBaseDates(param, function success(response){
				if(response.baseAppointmentDates[0]){
					let msg = response.baseAppointmentDates[0].message
					let msgAll = response.baseAppointmentDates[0].messageAll
					if(msg && msgAll){
						model.appointment().currMsg = msg + '/' + msgAll
					} else {
						model.appointment().currMsg = msg ? msg : msgAll
					}
				} else {
					model.appointment().currMsg = undefined;
				}
			})

			AppointmentAccessor.list({day:model.appointment().currDate, idProf:model.currentApptMd().id},
					function success(response) {
				// if(model.prefSettings('user_settings_SiteAppointments') && response.data && response.data.length > 0){
				// 	response.data = response.data.filter(function(e){
				// 		if(e && e.patients && patientsFromWorkSite(e.patients)){
				// 			return true;
				// 		}
				// 		return false;
				// 	});
				// }
				model.appointment().currList = response.data;
				model.appointment().loaded = true;
				model.refreshCountsUpdated(true);
				model.apptLstUpdated(true);
			});
		};

		$scope.setAppStartTime = function(t) {
			return true;
		};

		$scope.getShowAppFilter = function() {
			var showCanceled = model.prefSettings('user_settings_ShowCanceledAppt')===true;
			if (showCanceled===true) {
				return {isDeleted:false};
			} else {
				return {patientStatus : '!CANCEL', isDeleted:false};
			}
		};

		$scope.firstPass = function(t) {
			var oldPas = $scope.prevAptTime;
			$scope.prevAptTime = t;
			var sh1 = oldPas<720 && t>=720;
			if (sh1===true) {
				return 1;
			}
			var sh2 = oldPas<1020 && t>=1020;
			if (sh2===true) {
				return 2;
			}
			return 3;
		};

		function securePatientUpdate(pat){
			return $q(function(resolve, reject){
			if(model.appointment().currAppointment.firstPatient){
				model.appointment().currAppointment.firstPatient.lockForUpdate = true;
				// model.patient().currPatient = null;
					$timeout(function(){
						model.appointment().currAppointment.firstPatient.lockForUpdate = false;
						model.appointment().currAppointment.firstPatient = pat;
						resolve();
					}, 0)
				}else{
					model.appointment().currAppointment.firstPatient = pat;
					resolve();
				}
			});
		}
		
		$scope.selectAppointment = function(rdv, pt){
			QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
				if(successful){
					if($scope.popoverEdit){
						$scope.editPatientPopoverOptions.exit();
					}
					$scope.patientConsentBlock = !Rights.userHasRight(pt);

					if($scope.patientConsentBlock){
						model.patient().currPatient = {};
						return;
					}


					function setAppointment(){
						$scope.model.patientAllDataTabs().activeTab='PatientData';
						model.appointment().currAppointment = rdv;
						// il me faut un patient pour la directive patientData.
						securePatientUpdate(pt==undefined ? model.appointment().currAppointment.patients[0]:pt).then(function(){
							PatientAccessor.setAsUsed(model.appointment().currAppointment.firstPatient.id);
							if(!pt){
								pt = model.appointment().currAppointment.firstPatient;
							}
							if(model.summaryExternalViewer && pt.viewbag && pt.viewbag.patData && pt.viewbag.patData.sum){
								patientShowTitles.externalSummary(pt);
							}
						})
					}

					//For the rare case where a patient has multiple appointments on the same day to make sure that
					//the patientdata watchers are activated the appointment is set to undefined and immediately set after.
					//if this is not done the watchers are never activated since the patient id does not change.
					if(pt && model.appointment().currAppointment && model.appointment().currAppointment.firstPatient &&
						pt.id === model.appointment().currAppointment.firstPatient.id){
						model.appointment().currAppointment = undefined;
						$timeout(setAppointment, 0);
					}else{
						setAppointment();
					}
				}
			});
		};
		
		$scope.updateHubAppointment = function(rdv){
			if(rdv.adhocPatient){
				rdv.adhocPatient.isAdhocPatient = true;
			}
			return {
				pt:rdv.adhocPatient,
				onSave: function(saved, options, s){
					rdv.patients = [saved];
					rdv.modificationStatus = ModificationStatus.STATUS_UPDATED;
					AppointmentAccessor.saveappointment([rdv], function (res) {
						if(res && res[0] && res[0].id){
							$scope.selectAppointment(res[0], res[0].patients[0] )
						}
						// console.log("Appointment saved successfully from Hub to local");
					}, function () {
						// console.log("Saving appointment from hub failed");
					}, {
					getMessage: function (status, msg) {
						return AppointmentAccessor.utils.translateMsg(msg);
					}
					});
					// scope.patientSearch.onSelect(saved);
					// s.patient = scope.addNewPatient();//TODO: make this code better.too much variable piping.
					// scope.newPatient = s.patient;
					// if(options && options.exit && options.widget
					//     && options.widget.api
					//     && options.widget.api.$isShown){
					//     options.exit();
					// }
					// console.log("saved");
				}
			}
		}


		function editPatientPopover(){
			var popoverScope = scope.$new();
			PatientAccessor.popoverApiInit(popoverScope)
			var modal = $popover($(info.el), {
				trigger:"contextmenu",
				autoClose: true,
				placement: "right",
				container: "body",
				keyboard: false,
				animation: "am-flip-x",
				templateUrl: "/dashboard/resources/ofys/pat/profil/patient_edit_popover.html?v=bi",
				scope: popoverScope
			});
		}

		if (!model.appointment().loaded) {
			$scope.updateAppointments();
		}

		$scope.isActive = function(rdv){
			return angular.isDefined(model.appointment().currAppointment) && model.appointment().currAppointment.id === rdv.id;
		};

		$scope.updateModelPatient = function(patient){
			model.patient().currPatient = patient;
			$location.path('/PatientsIndex');
		};
		$scope.showPatientHtml = function(pat) {
			return patientShowTitles.showPatientHtml(pat);
		};
		$scope.getCurrentDate = function(){
			var res = model.appointment().currDate;
			return res;
		};

		model.callDashBoardCount();

	}]);

	appointment.directive('appointmentSearch',
	['model', '$filter', 'utils','AppointmentAccessor', 'ModificationStatus', 'DashAPI', '$q', 'PrefAccessor','PatientUtils','Store',
		function (model, $filter,utils, AppointmentAccessor, ModificationStatus, DashAPI, $q, PrefAccessor, PatientUtils,Store) {
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				scope.utils = utils;
				scope.criteriaPreset = {
					simple: function () {
						var res = getDefaultCriteria();
						return res;
					}
				}
				scope.searchtype = "simple";

				scope.hourDynaDateOptions = {
					acceptFutureDate: true,
					format: 'HH:mm'
				};
				scope.beforehourDynaDateOptions = {
					acceptFutureDate: true,
					format: 'HH:mm'
				};
				scope.afterhourDynaDateOptions = {
					acceptFutureDate: true,
					format: 'HH:mm'
				};

				scope.beforedateDynaDateOptions = {
					acceptFutureDate: true
				};
				scope.afterdateDynaDateOptions = {
					acceptFutureDate: true
				};
				
				scope.switchSearchType = function(){
					getDefaultCriteria()
				}

				function getDefaultCriteria(){
					var res = {
						fromDate: moment().diff(moment.unix(0), 'days'),
						fromDateAfterHour: moment().diff(moment().startOf('day'), 'minutes'),
						sites: [],
						limit: 10,
						professionnals: []
						// toDate: moment().format("YYYY-MM-DD"),
					};
					if (scope.contextSite){
						res.sites.push(scope.contextSite.id);
						var siteSelect = scope.groupCriteria.find(function (e) {
							return e.name === 'siteSelector';
						})
						if (siteSelect && typeof siteSelect.select === 'function') {
							siteSelect.select(scope.contextSite)
						}
					}
					if (model.user().profil && model.user().isProf && !scope.fromAppointmentPage){
						res.professionnals.push(model.user().profil.id);
						var profSelect = scope.groupCriteria.find(function (e) {
							return e.name === 'profSelector';
						})
						if (profSelect && typeof profSelect.select === 'function') {
							var prof = model.store.profs.get(model.user().profil.id, function(prof){
								profSelect.select(prof);
							})
						}
					} else if (scope.fromAppointmentPage && !scope.store.schedule.multiSchedules){
						res.professionnals.push(scope.store.schedule.prof.id)
						var profSelect = scope.groupCriteria.find(function (e) {
							return e.name === 'profSelector';
						})
						profSelect.selectedList = []
						if (profSelect && typeof profSelect.select === 'function') {
							var prof = model.store.profs.get(scope.store.schedule.prof.id, function(prof){
								profSelect.select(prof);
							})
						}
					}
					updateFromDate(res);
					return res;
				}

				scope.reserve = function (period) {
					scope.reserved = period;
				}

				scope.cancleReservation = function () {
					delete scope.reserved;
				}

				function SearchPeriodResults(startTime,endTime,date,idProfessionnal,idSite,appPerType) {
					this.startTime = startTime
					this.endTime = endTime
					this.date = date
					this.idProfessionnal = idProfessionnal
					this.idSite = idSite
					this.appPerType = appPerType
				}

				SearchPeriodResults.prototype.getSiteStr = function () {
					if (!this.siteStr && this.idSite && model.user().sites[this.idSite]) {
						this.siteStr = model.user().sites[this.idSite].nameCommon
					}
					return this.siteStr
				}

				SearchPeriodResults.prototype.getProfStr = function () {
					var periodResults = this;
					if (!periodResults.profStr && periodResults.idProfessionnal) {
						model.store.profs.get(periodResults.idProfessionnal, function(prof){
							periodResults.profStr = prof.lastName + ", " + prof.firstName
						})
					}
					return this.profStr
				}

				SearchPeriodResults.prototype.getDateStr = function () {
					if (!this.dateStr) {
						var res = [];
						if (this.date) {
							res.push(dayFrom1970ToYYYMMDD(this.date, 'days'));
							res.push(MMToTime(this.startTime));
						}
						this.dateStr = res.join(" ")
					}
					return this.dateStr
				}

				SearchPeriodResults.prototype.toString = function () {
					var periodResults = this;
					if(!periodResults.str){
						var res = [];
						if (periodResults.date) {
							res.push(dayFrom1970ToYYYMMDD(periodResults.date));
							res.push(MMToTime(periodResults.startTime));
						}
						if (periodResults.idProfessionnal) {
							model.store.profs.get(periodResults.idProfessionnal, function(prof){
								res.push('('+prof.lastName + ", " + prof.firstName+ ')')
							});
						}
						if (periodResults.idSite && model.user().sites[periodResults.idSite]) {
							var site = model.user().sites[periodResults.idSite]
							res.push("| " + site.nameCommon)
						}
						periodResults.str = res.join(" ")
					}
					return periodResults.str
				}
				
				SearchPeriodResults.prototype.toScheduleString = function () {
					var periodResults = this;
					if(!periodResults.scheduleStr){
						var res = [];
						if (periodResults.date) {
							res.push(dayFrom1970ToYYYMMDD(periodResults.date));
							res.push(MMToTime(periodResults.startTime));
						}
						if (periodResults.idProfessionnal) {
							model.store.profs.get(periodResults.idProfessionnal, function(prof){
								res.push('('+prof.lastName + ", " + prof.firstName+ ')')
							});
						}
						if (periodResults.idSite && model.user().sites[periodResults.idSite]) {
							var site = model.user().sites[periodResults.idSite]
							res.push("| "+ this.appPerType +", " + site.nameCommon)
						}
						periodResults.scheduleStr = res.join(" ")
					}
					return periodResults.scheduleStr
				}

				scope.searchPeriod = function (criteria) {
					if(scope.reserved){
						if (scope.reserved.saving) {
							return;
						}
						scope.cancleReservation();
					}
					if (scope.availableAppointments) {
						scope.availableAppointments.length = 0;
					}
					if(scope.fromAppointmentPage && model.appointmentResearch().searchtype == 'simple'){
						criteria = {};
						criteria.fromDateStr = scope.store.schedule.currentDate()
						criteria.professionnals = [ scope.store.schedule.prof.id ];
					}
					criteria = criteria ? cleanCriteriaBeforeSearch(criteria) : cleanCriteriaBeforeSearch(scope.periodCriteria);
					criteria.searching = AppointmentAccessor.searchPeriod(criteria,function (appointments) {
						delete criteria.searching;
						scope.availableAppointments = appointments.map(function (e) {
							let appPerType;
							if(DashAPI.lang == "en"){
								appPerType = e.appPerTypeNameEn;
							} else {
								appPerType = e.appPerTypeNameFr;
							}
							return new SearchPeriodResults(e.startTime, e.endTime, e.date, e.idProfessionnal, e.idSite, appPerType)
						});
					}, angular.noop, {
						getMessage: function (status, msg) {
							return AppointmentAccessor.utils.translateMsg(msg);
						}
					});
				}
				
				scope.searchNextPeriod = function (criteria) {
					if(scope.reserved){
						if (scope.reserved.saving) {
							return;
						}
						scope.cancleReservation();
					}
					let date = dayFrom1970ToYYYMMDD(scope.availableAppointments[9].date, 'days');
					let time = MMToTime(scope.availableAppointments[9].endTime);
					if(model.appointmentResearch().searchtype == 'simple'){
						criteria = {};
						criteria.fromDateStr = date;
						criteria.fromDateAfterHourStr = time;
//						criteria.sites = [ scope.store.schedule.selectedProfSite.idSite ];
						criteria.professionnals = [ scope.store.schedule.prof.id ];
					} else {
						scope.periodCriteria.fromDateStr = date;
						scope.periodCriteria.fromDateAfterHourStr = time;
					}
					scope.availableAppointments.length = 0;
					criteria = criteria ? cleanCriteriaBeforeSearch(criteria) : cleanCriteriaBeforeSearch(scope.periodCriteria);
					criteria.searching = AppointmentAccessor.searchPeriod(criteria,function (appointments) {
						delete criteria.searching;
						scope.availableAppointments = appointments.map(function (e) {
							let appPerType;
							if(DashAPI.lang == "en"){
								appPerType = e.appPerTypeNameEn;
							} else {
								appPerType = e.appPerTypeNameFr;
							}
							return new SearchPeriodResults(e.startTime, e.endTime, e.date, e.idProfessionnal, e.idSite, appPerType)
						});
					}, angular.noop, {
						getMessage: function (status, msg) {
							return AppointmentAccessor.utils.translateMsg(msg);
						}
					});
				}

				var timeOfDay ={
					'AM': {
						beforeHourStr: '12:00',
						afterHourStr: ''
					},
					'PM': {
						beforeHourStr: '17:00',
						afterHourStr: '12:00'
					},
					'EV': {
						beforeHourStr: '',
						afterHourStr: '17:00'
					}
				}
				scope.setTimeOfDay = function (time) {
					scope.periodCriteria.timeOfDay = time
					$.extend(scope.periodCriteria, timeOfDay[time])
				}
				scope.clearTimeOfDay = function () {
					delete scope.periodCriteria.timeOfDay ;
				}

				scope.clearInTime = function () {
					if (!scope.periodCriteria.in){
						delete scope.periodCriteria.in;
					}
				}
				scope.setInTime = function (l) {
					if (scope.periodCriteria.in === l){
						delete scope.periodCriteria.in;
					}else{
						scope.periodCriteria.in = l;
					}
				}

				scope.setPlusMinus = function (l) {
					if (scope.periodCriteria.pm === l) {
						delete scope.periodCriteria.pm
					}else{
						scope.periodCriteria.pm = l;
					}
				}
				scope.clearPlusMinus = function () {
					if (!scope.periodCriteria.pmStr || scope.periodCriteria.pmStr === "") {
						delete scope.periodCriteria.pm;
					}
				}


				function cleanCriteriaBeforeSearch(criteria) {
					if(!scope.fromAppointmentPage || model.appointmentResearch().searchtype != 'simple'){
						for (var i = 0; i < scope.groupCriteria.length; i++) {
							scope.groupCriteria[i].getForCriteria(criteria);
						}
					}
					updateFromDate(criteria);
					updateDates(criteria, 'fromDateStr', 'fromDate');
					updateDates(criteria, 'toDateStr', 'toDate');
					updateHour(criteria, 'beforeHourStr', 'beforeHour');
					updateHour(criteria, 'afterHourStr', 'afterHour');
					updateHour(criteria, 'fromDateAfterHourStr', 'fromDateAfterHour');
					return criteria;
				}

				function updateFromDate(criteria) {
					var d = "";
					if (criteria.fromDateStr){
						d += criteria.fromDateStr;
					}else{
						d += moment().format("YYYY-MM-DD");
					}

					if (criteria.fromDateAfterHourStr){
						d += " " + criteria.fromDateAfterHourStr;
					}else{
						d += " " + moment().format("HH:mm");
					}
					var res;
					if (criteria.inStr && criteria.in) {
						res = moment().add(approximate(criteria.inStr, criteria.in), 'days')
					}else{
						criteria.inStr = "";
						delete criteria.in;
						res = moment(d, "YYYY-MM-DD HH:mm")
					}
					criteria.fromDateStr = res.format("YYYY-MM-DD")
					criteria.fromDateAfterHourStr = res.format("HH:mm")
					if (criteria.pmStr && criteria.pm){
						criteria.datePrecision = approximate(criteria.pmStr, criteria.pm)
					}else{
						delete criteria.datePrecision;
					}
					if (criteria.famillySearch) {
						criteria.famillyReferencePatientId = scope.patient.id;
					}else{
						delete criteria.famillyReferencePatientId;
					}
				}

				function updateDates(criteria, str, day){
					if (criteria[str]) {
						criteria[day] = YYYMMDDTodayFrom1970(criteria[str]);
					}else{
						delete criteria[day];
					}
				}
				var multiplier = {
					D: 1,
					W: 7,
					M: 30
				}
				function approximate(n, multiplierStr) {
					return n * 1 * multiplier[multiplierStr];
				}
				function updateHour(criteria, str, day){
					if (criteria[str]) {
						criteria[day] = TimeToMM(criteria[str]);
					}else{
						delete criteria[day];
					}
				}

				function dayFrom1970ToYYYMMDD(dayFrom1970) {
					// the plus one seems to be required otherwise the result has an offset of one day
					return moment.unix(0).add(dayFrom1970 + 1, 'days').format("YYYY-MM-DD");
				}

				function YYYMMDDTodayFrom1970(YYYMMDD) {
					return moment(YYYMMDD , "YYYY-MM-DD").diff(moment.unix(0), 'days')
				}

				function MMToTime(mmm) {
					return moment().startOf('day').add(mmm, 'm').format("HH:mm")
				}
				function TimeToMM(time) {
					var t = moment(time, "HH:mm");
					return t.diff(moment().startOf('day'), 'minutes');
				}

				function getAppointment(){
					if(scope.reserved){
						var res = {
							startTime: scope.reserved.startTime,
							endTime: scope.reserved.endTime,
							patientStatus: 'NONE',
							status: 'NORMAL',
							isDeleted: false,
							date: dayFrom1970ToYYYMMDD(scope.reserved.date),
							idProfessional: scope.reserved.idProfessionnal,
							idProfessionals: [scope.reserved.idProfessionnal],
							patients: [PatientUtils.getSuperCleanPatient(scope.patient)],
							typeAppointment: defaultappointmentType().id,
							idSite: scope.reserved.idSite,
							modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
						};
						return [res];
					}
				}

				function defaultappointmentType(){
					return model.clientPreferences().appointmentTypes.find(function (a) {
						return a.isDefault;
					})
				}

				scope.bookReservation = function () {
					var app = getAppointment();
					if (app && !scope.reserved.saving) {
						scope.reserved.saving = AppointmentAccessor.saveappointment(app, function (res) {
							delete scope.reserved.saving;
							scope.reserved.saved = res;
							scope.availableAppointments.splice(scope.availableAppointments.indexOf(scope.reserved),1)
						}, function () {
							delete scope.reserved.saving;
						}, {
						getMessage: function (status, msg) {
							return AppointmentAccessor.utils.translateMsg(msg);
						}
						});
					}
				}
				var allProfTypes ;

				function professionalGroupes(q) {
					return $q(function (resolve, reject) {
						function searchGroup(l){
							var res = l.filter(function (group) {
								return group.i18n.toLowerCase().indexOf(q) > -1
							})
							resolve(res);
						}
						if(allProfTypes !== undefined){
							resolve(allProfTypes);
						}else{
							DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.ofys.data.middle.dataobjects.professionnal.XProfessionnalType", function(res){
								allProfTypes = _.values(res.data);
								allProfTypes.sort((a,b) => (a.i18n > b.i18n) ? 1 : ((b.i18n > a.i18n) ? -1 : 0))
								searchGroup(allProfTypes);
							}, reject);
						}
					});
				}
				var allDaysOfWeek;
				function daysOfWeek(q) {
					return $q(function (resolve, reject) {
						function searchGroup(l){
							var res = l.filter(function (group) {
								return group.i18n.toLowerCase().indexOf(q) > -1
							})
							resolve(res);
						}
						if (allDaysOfWeek !== undefined) {
							resolve(allDaysOfWeek);
						}else{
							DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.util1.date.DayOfWeek", function (res) {
								allDaysOfWeek = _.sortBy(_.values(res.data), 'value');
								searchGroup(allDaysOfWeek);
							}, reject);
						}
					});
				}
				scope.groupCriteria = [];

				scope.groupCriteria.push({
					name: "groupSelector",
					list: professionalGroupes,
					selectable: false,
					selectorName:function (group) {
						return group.i18n;
					},
					getForCriteria: function (criteria) {
						criteria.professionnalGroups = [];
						if(this.selectedList.length > 0 && criteria){
							for (var i = 0; i < this.selectedList.length; i++) {
								criteria.professionnalGroups.push(this.selectedList[i].obj.value)
							}

						}
					},
					inputPlaceHolder: $filter("translate")("FILTER_BY_GROUP"),
				});
				
				scope.profList = $filter('orderBy')(model.store.profs.filter.appointment.list(), ['lastName', 'firstName']);
				
				scope.groupCriteria.push({
					name: "profSelector",
					list: scope.profList,
					selectable: false,
					selectorName:function (prof) {
						return prof.lastName + ', '+ prof.firstName;
					},
					getForCriteria: function (criteria) {
						criteria.professionnals = [];
						if (this.selectedList.length > 0 && criteria) {
							for (var i = 0; i < this.selectedList.length; i++) {
								criteria.professionnals.push(this.selectedList[i].obj.id)
							}

						}
					},
					inputPlaceHolder: $filter("translate")("FILTER_BY_PROF"),
				});

				scope.groupCriteria.push({
					name: "siteSelector",
					list: Store.sites.filter.workSites.list().sort((a,b) => (a.nameCommon.toLowerCase() > b.nameCommon.toLowerCase()) ? 1 : ((b.nameCommon.toLowerCase() > a.nameCommon.toLowerCase()) ? -1 : 0)),
					inputPlaceHolder: $filter("translate")("FILTER_BY_SITE"),
					selectable: false,
					selectorName: function (item) {
						return item.nameCommon;
					},
					getForCriteria: function (criteria) {
						criteria.sites = [];
						if (this.selectedList.length > 0 && criteria) {
							for (var i = 0; i < this.selectedList.length; i++) {
								criteria.sites.push(this.selectedList[i].obj.id)
							}

						}
					},
				});
				scope.periodList = model.clientPreferences().appointmentPeriodTypes.filter(period => !period.isDeleted)
				function periodList (q){
					return $q(function (resolve, reject){
						resolve(scope.periodList.sort((a,b) => {
							if (DashAPI.lang === 'fr') {
								return (a.french.toLowerCase() > b.french.toLowerCase()) ? 1 : ((b.french.toLowerCase() > a.french.toLowerCase()) ? -1 : 0);
							}else{
								return (a.english.toLowerCase() > b.english.toLowerCase()) ? 1 : ((b.english.toLowerCase() > a.english.toLowerCase()) ? -1 : 0);
							}
						}))
					})
					
				}
				function professionalGroupes(q) {
					return $q(function (resolve, reject) {
						function searchGroup(l){
							var res = l.filter(function (group) {
								return group.i18n.toLowerCase().indexOf(q) > -1
							})
							resolve(res);
						}
						if(allProfTypes !== undefined){
							resolve(allProfTypes);
						}else{
							DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.ofys.data.middle.dataobjects.professionnal.XProfessionnalType", function(res){
								allProfTypes = _.values(res.data);
								allProfTypes.sort((a,b) => (a.i18n > b.i18n) ? 1 : ((b.i18n > a.i18n) ? -1 : 0))
								searchGroup(allProfTypes);
							}, reject);
						}
					});
				}
				

				scope.groupCriteria.push({
					name: "periodSelector",
					list: periodList,
					selectable: false,
					selectorName:function (s) {
						if (DashAPI.lang === 'fr') {
							return s.french;
						}else{
							return s.english;
						}
					},
					getForCriteria: function (criteria) {
						criteria.periodTypes = [];
						if (this.selectedList.length > 0 && criteria) {
							for (var i = 0; i < this.selectedList.length; i++) {
								criteria.periodTypes.push(this.selectedList[i].obj.id)
							}

						}
					},
					inputPlaceHolder: $filter("translate")("FILTER_BY_PER"),
				});

				scope.groupCriteria.push({
					name: "dayOfWeeksSelector",
					list: daysOfWeek,
					selectable: false,
					selectorName: function (group) {
						return group.i18n;
					},
					getForCriteria: function (criteria) {
						if (this.selectedList.length > 0 && criteria) {
							criteria.dayOfWeeks = [];
							for (var i = 0; i < this.selectedList.length; i++) {
								criteria.dayOfWeeks.push(this.selectedList[i].obj.value)
							}

						}
					},
					inputPlaceHolder: $filter("translate")("FILTER_BY_DOW"),
				});

				PrefAccessor.contextSite(function (res) {
					scope.contextSite = res.data;
					scope.periodCriteria = getDefaultCriteria();
				});

			}
		}
	}]);

	appointment.directive('appView', ['model', '$filter', 'AppointmentAccessor','MessageLink',
	                               function(model, $filter, AppointmentAccessor, MessageLink){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/appointment/app_view.html?v=bi',
			scope: true,
			link: function(scope, element, attrs){
				scope.model = model;
				scope.serv = {};

				scope.formatDate = function(reqDate, dateFormat){
					moment.locale(model.prefSettings('language'));
					return moment(reqDate).format(dateFormat);
				}

				function update(){
					scope.apps = scope.$eval(attrs.apps);
					if(Array.isArray(scope.apps) ){
						if(scope.appointments.length > 0)scope.app = scope.apps[0];
					}else{
						scope.app = scope.apps;
					}
					scope.app.viewbag = {};
					var allTypes = model.clientPreferences().appointmentTypes;
					if(scope.app.typeAppointment){
						scope.app.viewbag.typeAppointment = allTypes.find(function(prof){
							return prof.id === scope.app.typeAppointment;
						});
					}
					model.apptUpdated(true);
					AppointmentAccessor.updateMessageLink(scope.quickViewData.pat, scope);
					scope.linkManager = MessageLink.linkManager(AppointmentAccessor, scope.quickViewData.pat, scope.app.uid, scope)
					scope.viewOptions = scope.$eval(attrs.options);
				};

                if(scope.qv){
					scope.qv.isDirty = function(){
						return false;//does not support modifications yet
					};
				}
				scope.$watch(attrs.apps, update);
			}
		}
	}]);


})();