/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.XCitizenship;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.Age;
import ca.infodata.ofys.ui.dashboard.models.CAddress;
import ca.infodata.ofys.ui.dashboard.models.CContactInformation;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CPersonSite;
import ca.infodata.ofys.ui.dashboard.models.CUser;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.ofys.util.Comparators;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.LocalDate;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public abstract class CPerson
extends CEditableDataObject {
    private static final long serialVersionUID = 1L;
    public String className;
    public CUser user;
    public Boolean isUser;
    public String lastName;
    public String searchLastName;
    public String midInitial;
    public String firstName;
    public String searchFirstName;
    public String gender;
    public Short race;
    public Short languageCode;
    public Short maritalStatus;
    public String birthDate;
    public String note;
    public String title;
    public Boolean isDeleted;
    public Integer idPerson;
    public Short age;
    public Age oAge;
    public String ageStr;
    public XCitizenship citizenship;
    public XImageDecorator decorators;
    public ArrayList<CContactInformation> lstContactInformation;
    public ArrayList<CAddress> lstAddress;
    public ArrayList<CPersonSite> lstSites;

    public CPerson() {
    }

    public CPerson(XPerson person) {
        this.init(person);
    }

    protected void init(XPerson person) {
        super.init((IEditableDataObject)person);
        this.className = ((Object)((Object)this)).getClass().getSimpleName();
        this.user = null == person.user ? null : new CUser(person.user);
        this.isUser = person.isUser;
        this.lastName = person.lastName;
        this.searchLastName = person.searchLastName;
        this.midInitial = person.midInitial;
        this.firstName = person.firstName;
        this.searchFirstName = person.searchFirstName;
        this.gender = person.gender;
        this.race = person.getRace();
        this.languageCode = person.getLanguageCode();
        this.maritalStatus = person.getMaritalStatus();
        this.birthDate = person.birthDate == null ? null : person.birthDate.formatHyphen();
        this.note = person.note;
        this.title = person.title;
        this.isDeleted = person.isDeleted;
        this.idPerson = person.idPerson;
        this.age = person.getAge();
        if (person.birthDate != null) {
            LocalDate now = LocalDate.today();
            this.oAge = new Age(person.getBirthDate(), now);
            this.ageStr = this.oAge.toStringNice();
        }
        this.citizenship = person.citizenship == null ? null : person.citizenship.clone();
        this.decorators = person.decorators;
        if (person.lstContactInformation == null || person.lstContactInformation.isEmpty()) {
            this.lstContactInformation = null;
        } else {
            this.lstContactInformation = new CEditableDataObjectList<CContactInformation>(person.lstContactInformation, CContactInformation.class);
            Collections.sort(this.lstContactInformation, new Comparator<CContactInformation>(){

                @Override
                public int compare(CContactInformation o1, CContactInformation o2) {
                    int i = Comparators.compareAscNullsFirst((Comparable)o1.importance, (Comparable)o2.importance);
                    if (i == 0) {
                        i = Comparators.compareAscNullsFirst((Comparable)o1.id, (Comparable)o2.id);
                    }
                    return i;
                }
            });
        }
        if (person.lstAddress == null || person.lstAddress.isEmpty()) {
            this.lstAddress = null;
        } else {
            this.lstAddress = new CEditableDataObjectList<CAddress>(person.lstAddress, CAddress.class);
            Collections.sort(this.lstAddress, new Comparator<CAddress>(){

                @Override
                public int compare(CAddress o1, CAddress o2) {
                    int i = Comparators.compareAscNullsFirst((Comparable)o1.importance, (Comparable)o2.importance);
                    if (i == 0) {
                        i = Comparators.compareAscNullsFirst((Comparable)o1.id, (Comparable)o2.id);
                    }
                    return i;
                }
            });
        }
        this.lstSites = person.lstSites == null || person.lstSites.isEmpty() ? null : new CEditableDataObjectList<CPersonSite>(person.lstSites, CPersonSite.class);
    }

    public XPerson x(XPerson res) {
        super.x((EditableDataObject)res);
        res.user = this.user == null ? null : this.user.x();
        res.isUser = this.isUser;
        res.lastName = this.lastName;
        res.searchLastName = this.searchLastName;
        res.midInitial = this.midInitial;
        res.firstName = this.firstName;
        res.searchFirstName = this.searchFirstName;
        res.gender = this.gender;
        res.race = this.race;
        res.languageCode = this.languageCode == null ? (short)-1 : this.languageCode;
        res.maritalStatus = this.maritalStatus;
        if (!"".equals(this.birthDate) && this.birthDate != null) {
            res.birthDate = Utils.dateToLocalDate(Date.valueOf(this.birthDate));
        }
        res.note = this.note;
        res.title = this.title;
        res.isDeleted = this.isDeleted;
        res.idPerson = MiscUtil.fromInt((Integer)this.idPerson);
        res.age = this.age;
        res.citizenship = this.citizenship != null ? this.citizenship.clone() : null;
        res.decorators = this.decorators;
        res.lstContactInformation = CEditableDataObjectList.x(this.lstContactInformation);
        res.lstAddress = CEditableDataObjectList.x(this.lstAddress);
        res.lstSites = CEditableDataObjectList.x(this.lstSites);
        return res;
    }
}

