/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.accessor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.IEncounterAccessor;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CSummary;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterModificationRequest;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPlan;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.dashboard.accessor.AbstractDashboardAccessorClient;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import ca.infodata.util1.date.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class EncounterSyncAccessorClient
extends AbstractDashboardAccessorClient {
    private static final Logger logger = Logger.getLogger(EncounterSyncAccessorClient.class.getName());
    private final IEncounterAccessor accessor = Application.get().getDataAccessors().getEncounterAccessor();

    public ReturnObject findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor(int encAnchorId) {
        return this.accessor.findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor(encAnchorId);
    }

    public ReturnObject findPatientEncStatusFactByDate(Integer onDate, Integer toDate) {
        ReturnObject response = this.accessor.findPatientEncStatusFactByDate(onDate, toDate);
        return response;
    }

    public ReturnObject findStatusFacture(String factId) {
        ReturnObject response = this.accessor.findStatusFacture(factId);
        return response;
    }

    public ReturnObject findEncountersIdByDate(Integer onDate) {
        ReturnObject response = this.accessor.findEncountersIdByDate(onDate);
        return response;
    }

    public ReturnObject findCEncountersByPatient(int patientId, boolean onlyLast5Last3y) {
        ReturnObject response = this.accessor.findCEncountersByPatient(patientId, onlyLast5Last3y);
        return response;
    }

    public ReturnObject getAllPrescriptionForThisPatientAndDates(Integer patId, LocalDate start, LocalDate end) {
        return this.accessor.findPrescriptions2(start, end, patId);
    }

    public ReturnObject findCodeByCode(String code, String classification) {
        return this.accessor.findCodeByCode(code, classification);
    }

    public ReturnObject findCode(String code, String classification) {
        return this.accessor.findCode(code, classification);
    }

    public CSummary findCSummaryByPatient(int id) {
        ReturnObject ro = this.accessor.findCSummaryByPatient(id);
        CSummary x = ro.getObj() instanceof byte[] ? (CSummary)LZMAClientSerialiser.deserialize((byte[])((byte[])ro.getObj()), (boolean)true) : (CSummary)ro.getObj();
        return x;
    }

    public XPlan savePlan(XPlan plan) {
        ReturnObject res = this.accessor.save((IDataObject)plan, true);
        return (XPlan)res.getObj();
    }

    public ReturnObject save(XEncounterModificationRequest objectToSave) {
        ReturnObject res = this.accessor.save((IDataObject)objectToSave, true);
        return res;
    }

    public ReturnObject saveEncLabel(String className, Integer id, Integer encLabel) {
        ReturnObject res = this.accessor.saveEncLabel(className, id, encLabel);
        return res;
    }

    public ReturnObject saveImportance(String tableName, Integer[] ids, Integer[] imps, Integer idPatient) {
        ReturnObject res = this.accessor.saveImportance(tableName, ids, imps, idPatient);
        return res;
    }

    public ReturnObject addToFavPrescription(Integer idProf, XPrescription rx) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            ro = this.accessor.addToFavPrescription(idProf, null, rx);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add prescription to favorites. " + rx, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage((Throwable)e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject addToFavPrescription(Integer idProf, Integer idRx) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            ro = this.accessor.addToFavPrescription(idProf, idRx, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add prescription to favorites. " + idRx, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage((Throwable)e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject findFavPrescription(Integer idProf) {
        ReturnObject res = this.accessor.findFavPrescription(idProf);
        return res;
    }

    public ReturnObject removeFromFavPrescription(Integer idRx) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            ro = this.accessor.removeFromFavPrescription(idRx);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to remove prescription from favorites. " + idRx, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage((Throwable)e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject searchPrescriptionByPatient(Integer idPt) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            LocalDate start = LocalDate.today().plusYear(-15);
            LocalDate end = LocalDate.today();
            ro = this.accessor.findPrescriptions2(start, end, idPt);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to searchInactivePrescription for " + idPt, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage((Throwable)e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject findDevicesNames(String text) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            ro = this.accessor.findDevicesNames(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find devices names with text " + text, e);
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage((Throwable)e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject findFollowUp() {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            ro = this.accessor.findFollowUp();
        }
        catch (Exception e) {
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage((Throwable)e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject saveFactType(Integer idEncounterAnchor, Integer idProf, Integer idPat, Integer idFactType, String factUid) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            ro = this.accessor.saveFactType(idEncounterAnchor, idProf, idPat, idFactType, factUid);
        }
        catch (Exception e) {
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage((Throwable)e));
            ro.setStatus(ms);
        }
        return ro;
    }

    public ReturnObject aiGenerateEncSumary(Integer idEncAnc, Integer idPat, String encAsJson) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            ro = this.accessor.aiGenerateEncSumary(idEncAnc, idPat, encAsJson);
        }
        catch (Exception e) {
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage((Throwable)e));
            ro.setStatus(ms);
        }
        return ro;
    }
}

