/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import ca.infodata.ofys.data.dataaccess.IConnectionInfoProvider;
import ca.infodata.ofys.data.dataaccess.ISessionProvider;
import ca.infodata.ofys.data.dataaccess.dx.DxRespond;
import ca.infodata.ofys.data.dataaccess.dx.IDXAccessor;
import ca.infodata.ofys.data.dataaccess.impl.BaseAccessor;
import ca.infodata.ofys.data.dataaccess.impl.RestfulClient;
import ca.infodata.util1.IPair;
import ca.infodata.util1.Pair;
import ca.infodata.util1.restful.KeyGenerator;
import ca.infodata.util1.restful.Response;
import ca.infodata.util1.restful.ResponseType;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class DXAccessor
extends BaseAccessor
implements IDXAccessor {
    private static final String path = "/ca.infodata.services.war/jaxrs/dx";
    private KeyGenerator keyGenerator;

    public DXAccessor(RestfulClient restfulClient, IConnectionInfoProvider connectionInfoProvider, ISessionProvider sessionProvider) {
        super(restfulClient, connectionInfoProvider, sessionProvider);
        this.setUseGzipContentEncodingFilter(true);
        this.keyGenerator = new KeyGenerator();
    }

    @Override
    public List<DxRespond> list(String application, String codeClient, String description, String langue) {
        WebResource r = this.buildResource(this.getSecureURI(path)).queryParam("desc", description).queryParam("lang", langue).queryParam("asHtml", String.valueOf(false));
        WebResource.Builder builder = r.accept(new String[]{"application/json"});
        this.addHeader(builder, application, codeClient);
        Response response = (Response)builder.get((GenericType)new ResponseType(DxRespond.class));
        this.processResponse(response);
        return (List)response.struct;
    }

    @Override
    public IPair<String, List<DxRespond>> listAsHtml(String application, String codeClient, String description, String langue) {
        WebResource r = this.buildResource(this.getSecureURI(path)).queryParam("desc", description).queryParam("lang", langue).queryParam("asHtml", String.valueOf(true));
        WebResource.Builder builder = r.accept(new String[]{"application/json"});
        this.addHeader(builder, application, codeClient);
        Response response = (Response)builder.get((GenericType)new ResponseType(DxRespond.class));
        this.processResponse(response);
        return Pair.newPair((Object)response.html, (Object)response.struct);
    }

    private WebResource.Builder addHeader(WebResource.Builder builder, String application, String codeClient) {
        String key = this.keyGenerator.generate(application, codeClient);
        return (WebResource.Builder)((WebResource.Builder)((WebResource.Builder)builder.header("client", (Object)codeClient)).header("application", (Object)application)).header("key", (Object)key);
    }
}

