/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.core.routes;

import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerResponse;
import ca.infodata.ofys.client.web.core.routes.DefaultRouteHandler;
import ca.infodata.ofys.client.web.core.routes.DefaultRouterFunction;
import ca.infodata.ofys.client.web.core.routes.HandlerFunction;
import ca.infodata.ofys.client.web.core.routes.NestedRouterFunction;
import ca.infodata.ofys.client.web.core.routes.RequestPredicate;
import ca.infodata.ofys.client.web.core.routes.RequestPredicateBuilder;
import ca.infodata.ofys.client.web.core.routes.RequestPredicates;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.util1.StringUtils;

public class RouterFunctions {
    public static RouterFunction<IServerResponse> route(RequestPredicate predicate, HandlerFunction<IServerResponse> handler) {
        if (predicate == null) {
            throw new IllegalArgumentException("route predicate cant be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("route handler cant be null");
        }
        return new DefaultRouterFunction<IServerResponse>(predicate, handler, IServerResponse.class);
    }

    public static RouterFunction<IServerResponse> route(RequestPredicateBuilder builder, HandlerFunction<IServerResponse> handler) {
        if (builder == null) {
            throw new IllegalArgumentException("route predicate builder cant be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("route handler cant be null");
        }
        return RouterFunctions.route(builder.build(), handler);
    }

    @SafeVarargs
    public static RouterFunction<?> routes(RequestPredicate predicate, RouterFunction<?> ... routes) {
        if (predicate == null) {
            throw new IllegalArgumentException("route predicate cant be null");
        }
        if (routes == null || routes.length == 0) {
            throw new IllegalArgumentException("route handler cant be null or empty");
        }
        return new NestedRouterFunction(predicate, routes);
    }

    @SafeVarargs
    public static RouterFunction<?> routes(String path, RouterFunction<?> ... routes) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("route path cant be blank");
        }
        if (routes == null || routes.length == 0) {
            throw new IllegalArgumentException("route handler cant be null or empty");
        }
        return new NestedRouterFunction(RequestPredicates.path(path), routes);
    }

    @SafeVarargs
    public static RouterFunction<?> routes(RouterFunction<?> ... routes) {
        if (routes == null || routes.length == 0) {
            throw new IllegalArgumentException("route handler cant be null or empty");
        }
        return new NestedRouterFunction(null, routes);
    }

    @SafeVarargs
    public static <T> RouterFunction<T> routes(RequestPredicateBuilder builder, RouterFunction<T> ... routes) {
        if (builder == null) {
            throw new IllegalArgumentException("route predicate builder cant be null");
        }
        if (routes == null || routes.length == 0) {
            throw new IllegalArgumentException("route handler cant be null or empty");
        }
        return new NestedRouterFunction(builder.build(), routes);
    }

    public static <T> RouterFunction<T> route(RequestPredicateBuilder builder, HandlerFunction<T> handler, Class<T> returnType) {
        if (builder == null) {
            throw new IllegalArgumentException("route predicate builder cant be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("route handler cant be null");
        }
        return new DefaultRouterFunction<T>(builder.build(), handler, returnType);
    }

    public static <T> RouterFunction<T> route(RequestPredicate predicate, HandlerFunction<T> handler, Class<T> returnType) {
        if (predicate == null) {
            throw new IllegalArgumentException("route predicate cant be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("route handler cant be null");
        }
        return new DefaultRouterFunction<T>(predicate, handler, returnType);
    }

    public static <T> RouterFunction<T> route(String path, HandlerFunction<T> handler, Class<T> returnType) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("route path cant be null or blank");
        }
        if (handler == null) {
            throw new IllegalArgumentException("route handler cant be null");
        }
        return new DefaultRouterFunction<T>(RequestPredicates.pathEnd(path), handler, returnType);
    }

    public static RouterFunction<ActionResult> routeAction(String path, HandlerFunction<ActionResult> handler) {
        return RouterFunctions.route(path, handler, ActionResult.class);
    }

    public static RouterFunction<ReturnObject> routeReturnObject(String path, HandlerFunction<ReturnObject> handler) {
        return RouterFunctions.route(path, handler, ReturnObject.class);
    }

    public static RouterFunction<ReturnObject> routeReturnObjectPublic(String path, HandlerFunction<ReturnObject> handlerFunction) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("route path cant be null or blank");
        }
        if (handlerFunction == null) {
            throw new IllegalArgumentException("route handler cant be null");
        }
        DefaultRouteHandler<ReturnObject> handler = new DefaultRouteHandler<ReturnObject>(handlerFunction, ReturnObject.class);
        handler.setPublic();
        return new DefaultRouterFunction<ReturnObject>(RequestPredicates.pathEnd(path), handler);
    }

    public static RouterFunction<ActionResult> routeActionPublic(RequestPredicate predicate, HandlerFunction<ActionResult> handlerFunction) {
        if (handlerFunction == null) {
            throw new IllegalArgumentException("route handler cant be null");
        }
        DefaultRouteHandler<ActionResult> handler = new DefaultRouteHandler<ActionResult>(handlerFunction, ActionResult.class);
        handler.setPublic();
        return new DefaultRouterFunction<ActionResult>(predicate, handler);
    }

    public static RouterFunction<ActionResult> routeAction(RequestPredicate predicate, HandlerFunction<ActionResult> handler) {
        return RouterFunctions.route(predicate, handler, ActionResult.class);
    }

    public static RouterFunction<ReturnObject> routeReturnObject(RequestPredicate predicate, HandlerFunction<ReturnObject> handler) {
        return RouterFunctions.route(predicate, handler, ReturnObject.class);
    }
}

