/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.core.routes;

import ca.infodata.ofys.client.web.core.routes.DefaultRequestPredicateBuilder;
import ca.infodata.ofys.client.web.core.routes.GETPredicate;
import ca.infodata.ofys.client.web.core.routes.POSTPredicate;
import ca.infodata.ofys.client.web.core.routes.PathPredicate;
import ca.infodata.ofys.client.web.core.routes.PostOrWsPredicate;
import ca.infodata.ofys.client.web.core.routes.RequestPredicate;
import ca.infodata.ofys.client.web.core.routes.RequestPredicateBuilder;
import ca.infodata.ofys.client.web.core.routes.WGPredicate;
import ca.infodata.ofys.client.web.core.routes.WSPredicate;

public class RequestPredicates {
    public static RequestPredicateBuilder builder() {
        return new DefaultRequestPredicateBuilder();
    }

    public static RequestPredicate wgp() {
        return new WGPredicate();
    }

    public static RequestPredicate wgp(String path) {
        return new WGPredicate(path, PathPredicate.PathStrategy.EXACT);
    }

    public static RequestPredicate wsp(String path) {
        return new PostOrWsPredicate(path, PathPredicate.PathStrategy.EXACT);
    }

    public static RequestPredicate ws() {
        return new WSPredicate();
    }

    public static RequestPredicate ws(String path) {
        return new WSPredicate(path, PathPredicate.PathStrategy.EXACT);
    }

    public static RequestPredicate get() {
        return new GETPredicate();
    }

    public static RequestPredicate get(String path) {
        return new GETPredicate(path, PathPredicate.PathStrategy.EXACT);
    }

    public static RequestPredicate path(String path) {
        return new PathPredicate(path, PathPredicate.PathStrategy.START_WITH);
    }

    public static RequestPredicate pathStart(String path) {
        return new PathPredicate(path, PathPredicate.PathStrategy.START_WITH);
    }

    public static RequestPredicate pathEnd(String path) {
        return new PathPredicate(path, PathPredicate.PathStrategy.EXACT);
    }

    public static RequestPredicate post() {
        return new POSTPredicate();
    }

    public static RequestPredicate post(String path) {
        return new POSTPredicate(path, PathPredicate.PathStrategy.EXACT);
    }
}

