/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.core;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.gson.GsonDelegate;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.IWebSocketFilter;
import ca.infodata.ofys.client.web.core.M;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.client.web.core.WebSocketResponse;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.util1.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerResponses {
    private static final Logger logger = Logger.getLogger(ServerResponses.class.getName());

    public static ActionResult toJsonActionResult(Object obj) {
        if (obj instanceof ActionResult) {
            return (ActionResult)obj;
        }
        if (obj instanceof M) {
            return ServerResponses.fromModel((M)obj);
        }
        return ServerResponses.fromModelObj(obj);
    }

    public static ActionResult fromModel(M modele) {
        ActionResult res = new ActionResult("json");
        res.toJson(true);
        res.setSkin("");
        res.setResponse(modele.get());
        return res;
    }

    public static ActionResult fromModelObj(Object modele) {
        M data = new M();
        data.put("data", modele);
        return ServerResponses.fromModel(data);
    }

    public static ActionResult SUCCESS() {
        ActionResult res = new ActionResult("json");
        res.toJson(true);
        res.setSkin("");
        res.setResponse(new M().put("success", true).get());
        return res;
    }

    public static ActionResult ERROR(String msg) {
        ActionResult res = new ActionResult("json");
        res.toJson(true);
        res.setSkin("");
        res.setResponse(new M().put("success", false).put("ms", msg).get());
        return res;
    }

    public static ActionResult REDIRECT(String location) {
        ActionResult res = new ActionResult();
        res.setSkinPath(location);
        return res;
    }

    public static ActionResult statusPage(String title, IStatus status) {
        try {
            String template = Application.get().getResourceDelegate().readAsString("StatusPageTemplate", StandardCharsets.UTF_8);
            if (StringUtils.isBlank((CharSequence)title)) {
                title = "Ofys Pro";
            }
            template = template.replace("{title}", title);
            template = template.replace("{severity}", status.getSeverity().name().toLowerCase());
            template = template.replace("{message}", StringUtils.defaultString((String)status.getMessage()).replace("\n", "<br>"));
            ActionResult res = new ActionResult();
            res.setSkin(template);
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendInfoMessageToClient(IWebSocketChannel channel, String msg) {
        Msg message = new Msg("INFO", msg);
        channel.send(new GsonDelegate(message));
    }

    public static void sendWarningMessageToClient(IWebSocketChannel channel, String msg) {
        Msg message = new Msg("WARN", msg);
        channel.send(new GsonDelegate(message));
    }

    public static void sendJsonToClient(Integer xClientId, String target, Object obj) {
        WebApplication.get().getWebSocketDelegate().send(s -> s.filter(c -> c != null && xClientId.equals(c.getXClientId())), new GsonDelegate(new WebSocketResponse(target, obj)));
    }

    public static void sendJsonToSessionId(Integer xSessionId, String target, Object obj) {
        WebApplication.get().getWebSocketDelegate().send(s -> s.filter(c -> c != null && xSessionId.equals(c.getXSessionId())), new GsonDelegate(new WebSocketResponse(target, obj)));
    }

    public static <T> void sendJsonToClient(IWebSocketFilter filter, String target, T obj) {
        WebApplication.get().getWebSocketDelegate().send(filter, new GsonDelegate(new WebSocketResponse(target, obj)));
    }

    public static <T> void sendJsonToClient(IWebSocketChannel channel, String target, T obj) {
        channel.send(new GsonDelegate(new WebSocketResponse(target, obj)));
    }

    public static ReturnObject print(IPrintController ctrl) {
        try {
            ReturnObject res = ServerResponses.OKReturnObject();
            res.setObj(ctrl.printSyncToUrl(null));
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur d'impression", e);
            return ServerResponses.ErrorReturnObject("Erreur d'impression");
        }
    }

    public static ReturnObject print(IPrintController ctrl, IServerRequest.Browser browser) {
        try {
            ReturnObject res = ServerResponses.OKReturnObject();
            res.setObj(ctrl.printSyncToUrl(browser));
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur d'impression", e);
            return ServerResponses.ErrorReturnObject("Erreur d'impression");
        }
    }

    public static ReturnObject OKReturnObject() {
        ReturnObject ro = new ReturnObject();
        MultiStatus st = new MultiStatus();
        st.setSeverity(IStatus.Severity.OK);
        ro.setStatus(st);
        return ro;
    }

    public static ReturnObject OKReturnObject(Object obj) {
        ReturnObject ro = new ReturnObject();
        ro.setObj(obj);
        MultiStatus st = new MultiStatus();
        st.setSeverity(IStatus.Severity.OK);
        ro.setStatus(st);
        return ro;
    }

    public static ReturnObject ErrorReturnObject() {
        ReturnObject ro = new ReturnObject();
        ro.setStatus(ServerResponses.ErrorMultiStatus(Application.get().getMessageService().getUNEXPECTED_ERROR_MESSAGE()));
        return ro;
    }

    public static ReturnObject ErrorReturnObject(String errorMsg) {
        ReturnObject ro = new ReturnObject();
        ro.setStatus(ServerResponses.ErrorMultiStatus(errorMsg));
        return ro;
    }

    public static ReturnObject ErrorReturnObject(String errorMsg, MultiStatus status) {
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = status == null ? ServerResponses.ErrorMultiStatus(errorMsg) : status;
        ro.setStatus(ms);
        return ro;
    }

    public static MultiStatus ErrorMultiStatus(String errorMsg) {
        MultiStatus st = new MultiStatus();
        st.setSeverity(IStatus.Severity.ERROR);
        st.setMessage(errorMsg);
        return st;
    }

    public static MultiStatus WarningMultiStatus(String errorMsg) {
        MultiStatus st = new MultiStatus();
        st.setSeverity(IStatus.Severity.WARNING);
        st.setMessage(errorMsg);
        return st;
    }

    public static MultiStatus InfoMultiStatus(String errorMsg) {
        MultiStatus st = new MultiStatus();
        st.setSeverity(IStatus.Severity.INFO);
        st.setMessage(errorMsg);
        return st;
    }

    public static MultiStatus MultiStatus(IStatus status) {
        MultiStatus st = new MultiStatus();
        st.setSeverity(IStatus.Severity.OK);
        st.add(status);
        return st;
    }

    public static class Msg {
        public final String severity;
        public final String message;

        public Msg(String s, String m) {
            this.severity = s;
            this.message = m;
        }
    }
}

