/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CSummarySuiviPrev;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XSuiviPrev;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XSuiviPrevPat;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XSuiviPrevPatDone;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XSuiviPrevProf;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientSuiviPrevText;
import ca.infodata.ofys.ui.dashboard.accessor.SuiviPrevSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CClientSuiviPrevText;
import ca.infodata.ofys.ui.dashboard.models.CSuiviPrev;
import ca.infodata.ofys.ui.dashboard.models.CSuiviPrevPat;
import ca.infodata.ofys.ui.dashboard.models.CSuiviPrevPatDone;
import ca.infodata.ofys.ui.dashboard.models.CSuiviPrevProf;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class SuiviPrevController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(SuiviPrevController.class.getName());
    private SuiviPrevSyncAccessorClient suiviPrevAccessor = new SuiviPrevSyncAccessorClient();

    public SuiviPrevController() {
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XSuiviPrevProf) {
            XSuiviPrevProf x = (XSuiviPrevProf)object;
            CSuiviPrevProf c = new CSuiviPrevProf(x);
            ServerResponses.sendJsonToClient(notification.getClientId(), "suiviprev.prof", (Object)c);
        } else if (object instanceof XSuiviPrevPat) {
            XSuiviPrevPat x = (XSuiviPrevPat)object;
            CSuiviPrevPat c = new CSuiviPrevPat(x);
            ServerResponses.sendJsonToClient(notification.getClientId(), "suiviprev.pat", (Object)c);
        }
    }

    private ReturnObject save(CSuiviPrevProf spp) {
        ReturnObject answer = this.suiviPrevAccessor.save(spp.x());
        XSuiviPrevProf x = (XSuiviPrevProf)answer.getObj();
        if (x != null) {
            CSuiviPrevProf c = new CSuiviPrevProf(x);
            answer.setObj((Object)c);
        }
        return answer;
    }

    private ReturnObject save(CClientSuiviPrevText spp) {
        ReturnObject answer = this.suiviPrevAccessor.save(spp.x());
        XClientSuiviPrevText x = (XClientSuiviPrevText)answer.getObj();
        if (x != null) {
            CClientSuiviPrevText c = new CClientSuiviPrevText(x);
            answer.setObj((Object)c);
        }
        return answer;
    }

    private ReturnObject save(CSuiviPrevPat cs) {
        ReturnObject answer = this.suiviPrevAccessor.save(cs.x());
        XSuiviPrevPat x = (XSuiviPrevPat)answer.getObj();
        if (x != null) {
            CSuiviPrevPat c = new CSuiviPrevPat(x);
            answer.setObj((Object)c);
        }
        return answer;
    }

    private ReturnObject save(CSuiviPrevPatDone cs) {
        ReturnObject answer = this.suiviPrevAccessor.save(cs.x());
        XSuiviPrevPatDone x = (XSuiviPrevPatDone)answer.getObj();
        if (x != null) {
            CSuiviPrevPatDone c = new CSuiviPrevPatDone(x);
            answer.setObj((Object)c);
        }
        return answer;
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard", RouterFunctions.routes("/suiviprev/ws", RouterFunctions.routeAction("/baseSuiviPrev", this::baseSuiviPrev), RouterFunctions.routeAction("/clientSuiviPrevText", this::clientSuiviPrevText), RouterFunctions.routeAction("/profSuiviPrev", this::profSuiviPrev), RouterFunctions.routeAction("/patSuiviPrev", this::patSuiviPrev), RouterFunctions.routeAction("/patDoneSuiviPrev", this::patDoneSuiviPrev), RouterFunctions.routeAction("/suiviPrevPatProf", this::suiviPrevByPatProf), RouterFunctions.routeReturnObject("/saveSuiviProf", req -> {
            CSuiviPrevProf c = req.getPostBody(CSuiviPrevProf.class);
            return this.save(c);
        }), RouterFunctions.routeReturnObject("/saveSuiviPat", req -> {
            CSuiviPrevPat c = req.getPostBody(CSuiviPrevPat.class);
            return this.save(c);
        }), RouterFunctions.routeReturnObject("/saveAdminRappelAutoText", req -> {
            CClientSuiviPrevText c = req.getPostBody(CClientSuiviPrevText.class);
            return this.save(c);
        }), RouterFunctions.routeReturnObject("/saveSuiviPatDone", req -> {
            CSuiviPrevPatDone c = req.getPostBody(CSuiviPrevPatDone.class);
            return this.save(c);
        })));
    }

    private ActionResult baseSuiviPrev(IServerRequest req) {
        List<XSuiviPrev> lstX = this.suiviPrevAccessor.getAllSuiviPrev();
        if (lstX != null) {
            ArrayList<CSuiviPrev> lstC = new ArrayList<CSuiviPrev>();
            for (XSuiviPrev x : lstX) {
                lstC.add(new CSuiviPrev(x));
            }
            return ServerResponses.toJsonActionResult(lstC);
        }
        return ServerResponses.toJsonActionResult(null);
    }

    private ActionResult clientSuiviPrevText(IServerRequest req) {
        List<XClientSuiviPrevText> lstX = this.suiviPrevAccessor.getAllClientSuiviPrevText();
        if (lstX != null) {
            ArrayList<CClientSuiviPrevText> lstC = new ArrayList<CClientSuiviPrevText>();
            for (XClientSuiviPrevText x : lstX) {
                lstC.add(new CClientSuiviPrevText(x));
            }
            return ServerResponses.toJsonActionResult(lstC);
        }
        return ServerResponses.toJsonActionResult(null);
    }

    private ActionResult profSuiviPrev(IServerRequest req) {
        Integer id = req.getRequiredQueryParam("idProf", Integer.class);
        List<XSuiviPrevProf> lstX = this.suiviPrevAccessor.getAllSuiviPrevProf(id);
        if (lstX != null) {
            ArrayList<CSuiviPrevProf> lstC = new ArrayList<CSuiviPrevProf>();
            for (XSuiviPrevProf x : lstX) {
                lstC.add(new CSuiviPrevProf(x));
            }
            return ServerResponses.toJsonActionResult(lstC);
        }
        return ServerResponses.toJsonActionResult(null);
    }

    private ActionResult patSuiviPrev(IServerRequest req) {
        Integer id = req.getRequiredQueryParam("idPat", Integer.class);
        List<XSuiviPrevPat> lstX = this.suiviPrevAccessor.getByPatient(id);
        if (lstX != null) {
            ArrayList<CSuiviPrevPat> lstC = new ArrayList<CSuiviPrevPat>();
            for (XSuiviPrevPat x : lstX) {
                lstC.add(new CSuiviPrevPat(x));
            }
            return ServerResponses.toJsonActionResult(lstC);
        }
        return ServerResponses.toJsonActionResult(null);
    }

    private ActionResult patDoneSuiviPrev(IServerRequest req) {
        Integer id = req.getRequiredQueryParam("idPat", Integer.class);
        List<XSuiviPrevPatDone> lstX = this.suiviPrevAccessor.getAllSuiviPrevPatDone(id);
        if (lstX != null) {
            ArrayList<CSuiviPrevPatDone> lstC = new ArrayList<CSuiviPrevPatDone>();
            for (XSuiviPrevPatDone x : lstX) {
                lstC.add(new CSuiviPrevPatDone(x));
            }
            return ServerResponses.toJsonActionResult(lstC);
        }
        return ServerResponses.toJsonActionResult(null);
    }

    private ActionResult suiviPrevByPatProf(IServerRequest req) {
        if (req.hasQueryParam("idPat") && req.hasQueryParam("idProf")) {
            int idProf;
            int idPat = req.getQueryParam("idPat", Integer.class);
            List<CSummarySuiviPrev> x = this.suiviPrevAccessor.findSuivPrevByPatientAndProf(idPat, idProf = req.getQueryParam("idProf", Integer.class).intValue());
            if (x != null) {
                return ServerResponses.toJsonActionResult(x);
            }
            return ServerResponses.toJsonActionResult(null);
        }
        return ServerResponses.ERROR("Invalid arguments. Missing required parameters.");
    }
}

