/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.base64.Base64DecodedString;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.encounter.XPrescriptionFormatter;
import ca.infodata.ofys.client.modules.encounter.pdf.PrescriptionPdfLinkController;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.controller.DSQController;
import ca.infodata.ofys.client.web.controller.PatientController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.JsonAsMap;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.client.web.core.WebSocketFilterByRequest;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.LightweightReport;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.ReportProperties;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedReport;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.consultation.XConsultationRequest;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CSummary;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergy;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocumentType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterModificationRequest;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterSummaryPrint;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabitFrequency;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabitType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XNoteType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPlan;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XFavPrescription;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyOrderableDrugForm;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyRouteOfAdministration;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XUserPreferences;
import ca.infodata.ofys.data.middle.dataobjects.properties.IReportProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.BillingsPrint;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.BillingsPrintProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.FaxData;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.FaxDataProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.OutputProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrintMode;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.RxDevicePrint;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.dashboard.accessor.EncounterSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CBaseProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CEncounterRequest;
import ca.infodata.ofys.ui.dashboard.models.CEnumWithValue;
import ca.infodata.ofys.ui.dashboard.models.CFavPrescription;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CPatientImage;
import ca.infodata.ofys.ui.dashboard.models.CPatientImageProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CSite;
import ca.infodata.ofys.ui.dashboard.models.DataForRenalDosing;
import ca.infodata.ofys.ui.dashboard.models.DataForRxAllergies;
import ca.infodata.ofys.ui.dashboard.models.DataResponseForRxAllergies;
import ca.infodata.ofys.ui.dashboard.models.PrescriptionPdfLinkInput;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import ca.infodata.rxdrugref.IRxDrugRefAccessor;
import ca.infodata.rxdrugref.RxElement;
import ca.infodata.rxdrugref.SEARCH_ELEMENT_TYPECODE;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import ca.infodata.util1.date.LocaleProvider;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class EncounterController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(EncounterController.class.getName());
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final EncounterSyncAccessorClient encounterAccessor = new EncounterSyncAccessorClient();
    private final IRxDrugRefAccessor rxDrugRef;
    private final DSQController dsqController;

    public EncounterController(PatientController patientController, DSQController dsqController) {
        this.dsqController = dsqController;
        this.rxDrugRef = Application.get().getDataAccessors().getRxDrugRefAccessor();
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XEncounter) {
            // empty if block
        }
    }

    public boolean openEdit(Integer id) {
        return true;
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/encs/ws", RouterFunctions.routeReturnObject("/list", this::list), RouterFunctions.routeReturnObject("/listStatusFactureOnDate", this::listStatusFactureOnDate), RouterFunctions.routeReturnObject("/listStatusFacture", this::listStatusFacture), RouterFunctions.routeReturnObject("/listOnDate", this::listOnDate), RouterFunctions.routeReturnObject("/listLast5Last3y", this::listLast5Last3y), RouterFunctions.routeReturnObject("/sum/print", this::summaryPrint), RouterFunctions.routeReturnObject("/enc/image/post", this::encounterAddImage), RouterFunctions.routeReturnObject("/enc/printBilling/post", this::billingPrint), RouterFunctions.routeReturnObject("/enc/print/post", this::encounterPrint), RouterFunctions.routeReturnObject("/enc/printrx/post", this::rxPrint), RouterFunctions.routeReturnObject("/enc/printdirect/post", this::directPrint), RouterFunctions.routeReturnObject("/enc/printdirectRxAndForms/post", this::directPrintRxAndForms), RouterFunctions.routeReturnObject("/consult/print", this::consultPrint), RouterFunctions.routeAction("/sum", this::summary), RouterFunctions.routeAction("/aiGenEncSum/post", this::aiGenerateEncSumary), RouterFunctions.routeAction("/favPrescription", this::favPrescription), RouterFunctions.routeReturnObject("/findDxCodeByCode", this::findDxCodeByCode), RouterFunctions.routeReturnObject("/searchDx", this::searchDx), RouterFunctions.routeReturnObject("/searchDevices", this::searchDevices), RouterFunctions.routeReturnObject("/findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor", this::findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor), RouterFunctions.routeAction("/searchRxForce", this::searchRxForce), RouterFunctions.routeAction("/searchAllergy", this::searchAllergy), RouterFunctions.routeAction("/searchInactiveRx", this::searchInactiveRx), RouterFunctions.routeAction("/enumlist", this::enumList), RouterFunctions.routeAction("/enumlistobj", this::enumListObj), RouterFunctions.routeAction("/allEnumListObj", this::allEnumListObj), RouterFunctions.routeAction("/sumnotess", req -> ServerResponses.toJsonActionResult(Utils.getEnumList(XNoteType.class, true))), RouterFunctions.routeAction("/enctypes", req -> ServerResponses.toJsonActionResult(Utils.getEnumList(XEncounterType.class, true))), RouterFunctions.routeAction("/plan/post", this::planPost), RouterFunctions.routeReturnObject("/sum/importance/post", this::importancePost), RouterFunctions.routeReturnObject("/sum/save/post", this::summaryPost), RouterFunctions.routeReturnObject("/sum/saveImpDsq/post", this::summaryImportDsqPost), RouterFunctions.routeReturnObject("/enc/save/post", this::encounterPost), RouterFunctions.routeAction("/enc/saveFactType", this::encounterSaveFactType), RouterFunctions.routeReturnObject("/enc/presave/post", this::presavePost), RouterFunctions.routeReturnObject("/enc/presave/get", this::presaveGet), RouterFunctions.routeReturnObject("/enc/presave/delete", this::presaveDelete), RouterFunctions.routeAction("/drugByDin", this::drugByDIN), RouterFunctions.routeAction("/renalDosing/post", this::getRenalDosing), RouterFunctions.routeAction("/analyseAllergies/post", this::analyseAllergies), RouterFunctions.routeReturnObject("/enc/favrx/get", this::favrx), RouterFunctions.routeReturnObject("/addFavIdRx/get", this::addFavIdRx), RouterFunctions.routeReturnObject("/addFavRx/post", this::addFavRx), RouterFunctions.routeReturnObject("/delFavIdRx/get", this::delFavIdRx), RouterFunctions.routeAction("/prescriptionexceptionpdf", this::prescriptionExceptionPdf), RouterFunctions.routeAction("/rxinteractions", this::rxinteractions), RouterFunctions.routeAction("/doseCalculatorData", this::doseCalculator), RouterFunctions.routeAction("/edit", this::edit), RouterFunctions.routeAction("/followUpChartRx", this::followUpChartRx), RouterFunctions.routeReturnObject("/followups/new", this::followup), RouterFunctions.routeReturnObject("/followups", this::followup), RouterFunctions.routeAction("/prescriptor/searchDrug", this::searchDrugReference), RouterFunctions.routeAction("/prescriptor/selectDrug/post", this::selectDrug));
    }

    private ReturnObject followup(IServerRequest req) {
        return this.encounterAccessor.findFollowUp();
    }

    private ActionResult prescriptionExceptionPdf(IServerRequest req) throws Exception {
        PrescriptionPdfLinkInput input = req.getPostBody(PrescriptionPdfLinkInput.class);
        input.data.prof = new CBaseProfessionnal(Application.get().getPersonPluginController().getSessionProfessionnal());
        input.data.site = new CSite(Application.get().getSitePluginController().getContextSite());
        PrescriptionPdfLinkController controller = new PrescriptionPdfLinkController(input.url, input.data.x());
        byte[] filledPdf = controller.fillAcroFields();
        if (filledPdf == null) {
            if (Application.get().getApplicationUiPlugin().isOfysProWeb()) {
                return ServerResponses.toJsonActionResult(input.url);
            }
            Application.get().getApplicationUiPlugin().programLaunch(input.url);
        } else {
            String filledPdfUrl = WebApplication.get().getWebResourcesDelegate().newHtmlPdfResource(filledPdf).getUrl();
            if (Application.get().getApplicationUiPlugin().isOfysProWeb()) {
                return ServerResponses.toJsonActionResult(filledPdfUrl);
            }
            Application.get().getApplicationUiPlugin().programLaunch(filledPdfUrl);
        }
        return ServerResponses.SUCCESS();
    }

    private ActionResult doseCalculator(IServerRequest req) {
        String drugName = req.getQueryParam("drugName");
        String strength = req.getQueryParam("strength");
        Vector<Map<String, Object>> res = null;
        if (drugName != null && strength != null) {
            res = this.rxDrugRef.getPedDosingInformation(drugName, strength);
        }
        return ServerResponses.toJsonActionResult(res);
    }

    private ActionResult rxinteractions(IServerRequest req) {
        GetInteractions interactions = req.getPostBody(GetInteractions.class);
        List profile = CEncounter.Prescription.ctoxList(interactions.profile);
        FoundNotFoundRx fnf = this.getDinFromProfile(profile);
        List<String> atcs = this.rxDrugRef.getAtcsFromDins(fnf.dins);
        List<Map<String, Object>> res = this.rxDrugRef.getInteractions(atcs);
        return ServerResponses.toJsonActionResult(res);
    }

    private FoundNotFoundRx getDinFromProfile(List<XPrescription> profile) {
        FoundNotFoundRx res = new FoundNotFoundRx();
        res.dins = new HashSet<String>(profile.size());
        res.rxNotFound = new HashSet<String>();
        for (XPrescription prescription : profile) {
            Integer din = prescription.getDin();
            if (din != null) {
                res.dins.add(prescription.getDin().toString());
                continue;
            }
            XPrescription xp = prescription;
            if (xp.getStrength().getDrugType().equals((Object)XDrugType.FOURNITURE)) continue;
            res.rxNotFound.add(XPrescriptionFormatter.getFormattedText(prescription, xp.isActiveNow(), CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM));
        }
        return res;
    }

    private ReturnObject list(IServerRequest req) {
        Integer id = req.getRequiredQueryParam("idPt", Integer.class);
        return this.findEncounter(id, false);
    }

    private ReturnObject listStatusFacture(IServerRequest req) {
        String uid = req.getRequiredQueryParam("factUid", String.class);
        return this.findStatusFacture(uid);
    }

    private ReturnObject listStatusFactureOnDate(IServerRequest req) {
        Integer onDate = req.getRequiredQueryParam("modOnDate", Integer.class);
        Integer toDate = req.getRequiredQueryParam("modToDate", Integer.class);
        if (toDate == null) {
            toDate = onDate;
        }
        return this.findPatientEncStatusFactByDate(onDate, toDate);
    }

    private ReturnObject listOnDate(IServerRequest req) {
        Integer onDate = req.getRequiredQueryParam("modOnDate", Integer.class);
        return this.findEncounterOnDate(onDate);
    }

    private ReturnObject listLast5Last3y(IServerRequest req) {
        Integer id = req.getRequiredQueryParam("idPt", Integer.class);
        return this.findEncounter(id, true);
    }

    private ReturnObject consultPrint(IServerRequest req) throws Exception {
        Integer id = req.getRequiredQueryParam("id", Integer.class);
        XConsultationRequest e = new XConsultationRequest();
        e.setId(id);
        IPrintController ctrl = Application.get().getPrintControllerFactory().newPrintController((Serializable)e);
        ctrl.getSelection().add((IReport)new LightweightReport("encounter_consultation", "Consultation", PrintMode.ACTUAL_SIZE));
        return ServerResponses.print(ctrl);
    }

    private ReturnObject summaryPrint(IServerRequest req) throws Exception {
        Integer id = req.getRequiredQueryParam("idPt", Integer.class);
        XEncounterSummaryPrint e = new XEncounterSummaryPrint(id);
        IPrintController ctrl = Application.get().getPrintControllerFactory().newPrintController((Serializable)e);
        ctrl.getSelection().add((IReport)new LightweightReport("encounter_summary", "Sommaire", PrintMode.ACTUAL_SIZE));
        return ServerResponses.print(ctrl);
    }

    private ReturnObject directPrintRxAndForms(IServerRequest req) throws Exception {
        EncounterFaxPrint faxPrint = req.getPostBody(CUidObject.class).getObject(EncounterFaxPrint.class);
        List lstDoc = faxPrint.enc.getLstDoc();
        Int2ObjectAVLTreeMap mapDocs = new Int2ObjectAVLTreeMap();
        if (lstDoc != null && !lstDoc.isEmpty()) {
            for (CEncounter.Docs docs : lstDoc) {
                if (docs.getAtype() != 2) continue;
                mapDocs.put(docs.getIdDocument().intValue(), (Object)docs);
            }
        }
        int numberDoc = mapDocs.size();
        if (faxPrint.enc.getLstPrescription() != null && !faxPrint.enc.getLstPrescription().isEmpty() || faxPrint.enc.getLstDevice() != null && !faxPrint.enc.getLstDevice().isEmpty()) {
            ++numberDoc;
        }
        if (numberDoc > 0) {
            XFinishedReport finishedReport = new XFinishedReport(null);
            finishedReport.setProperties(new ReportProperties());
            finishedReport.getProperties().put((IReportProperty)new OutputProperty("pdf"));
            FaxDataProperty faxProp = null;
            if (faxPrint.faxdata != null) {
                faxPrint.faxdata.idSite = Application.get().getSitePluginController().getContextSite().getId();
                faxProp = new FaxDataProperty("faxData", faxPrint.faxdata);
                faxPrint.faxdata.docName = "Rx";
                finishedReport.getProperties().put("faxData", (Serializable)faxProp);
            }
            ArrayList pdfUrl = new ArrayList(numberDoc);
            if (faxPrint.enc.getLstPrescription() != null && !faxPrint.enc.getLstPrescription().isEmpty() || faxPrint.enc.getLstDevice() != null && !faxPrint.enc.getLstDevice().isEmpty()) {
                ReturnObject returnObject;
                ObjectIterator e = faxPrint.enc.x();
                IPrintController printController = Application.get().getPrintControllerFactory().newPrintController((Serializable)e);
                printController.setNip(faxPrint.nip);
                LightweightReport lightweightReport = new LightweightReport("encounter_prescription_default_format", "Ordonnances format par d\u00e9faut", PrintMode.ACTUAL_SIZE);
                lightweightReport.setFinishedReport(finishedReport);
                lightweightReport.setNumberOfDocuments(new Integer(numberDoc));
                printController.getSelection().add((IReport)lightweightReport);
                if (faxProp != null) {
                    lightweightReport.getProperties().put("faxData", (Serializable)faxProp);
                }
                this.setPageWithItems(faxPrint);
                if (faxPrint.pageWithItems != null && !faxPrint.pageWithItems.isEmpty()) {
                    lightweightReport.getProperties().put("page_with_items", faxPrint.pageWithItems);
                }
                if ((returnObject = ServerResponses.print(printController)) != null && returnObject.getObj() != null && returnObject.getObj() instanceof List) {
                    pdfUrl.addAll((List)returnObject.getObj());
                }
            }
            for (CEncounter.Docs doc : mapDocs.values()) {
                ReturnObject returnObject;
                IDDataObject data = new IDDataObject(doc.getIdDocument(), XEformData.class, XEformData.class.getName());
                IPrintController printController = Application.get().getPrintControllerFactory().newPrintController((Serializable)data, "form");
                printController.setNip(faxPrint.nip);
                LightweightReport report = new LightweightReport("eformdata", Messages.getString((String)"FORMULAIRE", (String[])new String[0]), PrintMode.ACTUAL_SIZE);
                report.setFinishedReport(finishedReport);
                report.setNumberOfDocuments(new Integer(numberDoc));
                report.getProperties().put("includeAddedLinks", (Serializable)Boolean.valueOf(true));
                report.getProperties().put("joinAsOneDocument", (Serializable)Boolean.valueOf(true));
                printController.getSelection().add((IReport)report);
                if (faxProp != null) {
                    faxPrint.faxdata.docName = doc.description + "(" + doc.entryDateS + ")";
                    report.getProperties().put("faxData", (Serializable)faxProp);
                }
                if ((returnObject = ServerResponses.print(printController)) == null || returnObject.getObj() == null || !(returnObject.getObj() instanceof List)) continue;
                pdfUrl.addAll((List)returnObject.getObj());
            }
            ReturnObject res = ServerResponses.OKReturnObject();
            res.setObj(pdfUrl);
            return res;
        }
        return ServerResponses.ErrorReturnObject(Messages.getString((String)"NOTHING_TO_PRINT", (String[])new String[0]));
    }

    private void setPageWithItems(EncounterFaxPrint faxPrint) {
        if (faxPrint.pageWithItems != null) {
            ArrayList<RxDevicePrint> lstDel = new ArrayList<RxDevicePrint>(1);
            for (RxDevicePrint dp : faxPrint.pageWithItems) {
                int total = (dp.rx == null ? 0 : dp.rx.size()) + (dp.device == null ? 0 : dp.device.size());
                if (total != 0) continue;
                lstDel.add(dp);
            }
            if (lstDel.size() > 0) {
                faxPrint.pageWithItems.removeAll(lstDel);
            }
        } else if (Application.get().getPersonPluginController().getPrintRxDevSep()) {
            faxPrint.pageWithItems = new ArrayList();
            if (faxPrint.enc.getLstPrescription() != null) {
                RxDevicePrint rxDR_rx = new RxDevicePrint();
                for (CEncounter.Prescription rx : faxPrint.enc.getLstPrescription()) {
                    if (Boolean.TRUE.equals(rx.isDeleted())) continue;
                    rxDR_rx.rx.add(rx.id);
                }
                if (!rxDR_rx.rx.isEmpty()) {
                    faxPrint.pageWithItems.add(rxDR_rx);
                }
            }
            if (faxPrint.enc.getLstDevice() != null) {
                RxDevicePrint rxDR_dev = new RxDevicePrint();
                for (CEncounter.Device dev : faxPrint.enc.getLstDevice()) {
                    if (Boolean.TRUE.equals(dev.isDeleted())) continue;
                    rxDR_dev.device.add(dev.id);
                }
                if (!rxDR_dev.device.isEmpty()) {
                    faxPrint.pageWithItems.add(rxDR_dev);
                }
            }
        }
    }

    private ReturnObject directPrint(IServerRequest req) throws Exception {
        EncounterFaxPrint faxPrint = req.getPostBody(CUidObject.class).getObject(EncounterFaxPrint.class);
        XEncounter e = faxPrint.enc.x();
        IPrintController ctrl = Application.get().getPrintControllerFactory().newPrintController((Serializable)e);
        ctrl.setNip(faxPrint.nip);
        LightweightReport lightweightReport = new LightweightReport("encounter_summary_with_note", "Sommaire complet avec note", PrintMode.ACTUAL_SIZE);
        lightweightReport.getProperties().put("include_history", (Serializable)Boolean.FALSE);
        lightweightReport.getProperties().put((IReportProperty)new OutputProperty("pdf"));
        FaxDataProperty faxProp = null;
        if (faxPrint.faxdata != null) {
            faxPrint.faxdata.idSite = Application.get().getSitePluginController().getContextSite().getId();
            faxPrint.faxdata.docName = "Visit";
            faxProp = new FaxDataProperty("faxData", faxPrint.faxdata);
            lightweightReport.getProperties().put("faxData", (Serializable)faxProp);
        }
        ctrl.getSelection().add((IReport)lightweightReport);
        return ServerResponses.print(ctrl);
    }

    private ReturnObject rxPrint(IServerRequest req) throws Exception {
        EncounterFaxPrint faxPrint = req.getPostBody(CUidObject.class).getObject(EncounterFaxPrint.class);
        if (faxPrint.enc.getLstPrescription() != null && !faxPrint.enc.getLstPrescription().isEmpty() || faxPrint.enc.getLstDevice() != null && !faxPrint.enc.getLstDevice().isEmpty()) {
            LightweightReport report = new LightweightReport("encounter_prescription_default_format", "Ordonnances format par d\u00e9faut", PrintMode.ACTUAL_SIZE);
            this.setPageWithItems(faxPrint);
            if (faxPrint.pageWithItems != null && !faxPrint.pageWithItems.isEmpty()) {
                report.getProperties().put("page_with_items", faxPrint.pageWithItems);
            }
            FaxDataProperty faxProp = null;
            if (faxPrint.faxdata != null) {
                faxPrint.faxdata.idSite = Application.get().getSitePluginController().getContextSite().getId();
                faxPrint.faxdata.docName = "RX";
                faxProp = new FaxDataProperty("faxData", faxPrint.faxdata);
                report.getProperties().put("faxData", (Serializable)faxProp);
            }
            XEncounter e = faxPrint.enc.x();
            IPrintController ctrl = Application.get().getPrintControllerFactory().newPrintController((Serializable)e);
            ctrl.setNip(faxPrint.nip);
            ctrl.getSelection().add((IReport)report);
            return ServerResponses.print(ctrl);
        }
        return ServerResponses.ErrorReturnObject(Messages.getString((String)"NOTHING_TO_PRINT", (String[])new String[0]));
    }

    private ReturnObject encounterAddImage(IServerRequest req) throws Exception {
        CUidObject postBody = req.getPostBody(CUidObject.class);
        CEncounter enc = postBody.getObject(CEncounter.class);
        XEncounter e = enc.x();
        byte[] picture = postBody.get("image_data", byte[].class);
        String docName = postBody.get2("image_name", () -> "IMG" + System.currentTimeMillis(), String.class);
        if (picture == null) {
            throw new Exception("Adding file failed. No image in body");
        }
        CEncounter.Docs xdoc = new CEncounter.Docs();
        XPatientImageProfessionnal xpip = new XPatientImageProfessionnal();
        xpip.setProfessionnal(e.getProfessionnal());
        xpip.setDateAssigned(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
        xpip.setStatus(EnumSet.of(XPatientImageProfessionnalStatus.SEEN));
        xpip.setNew();
        xpip.setTag();
        CPatientImage patientImage = new CPatientImage();
        patientImage.picture = picture;
        patientImage.patient = new CPatient(e.getPatient());
        patientImage.date = LocalDate.today().formatHyphen();
        patientImage.datetimeScanned = System.currentTimeMillis();
        patientImage.name = docName;
        patientImage.result = XPatientImageResultType.SO;
        patientImage.profs.add(new CPatientImageProfessionnal(xpip));
        patientImage.modificationStatus = "STATUS_NEW";
        patientImage.setTag();
        xdoc.entryDate = LocalDate.today().toTimeInMillisUTC();
        xdoc.atype = XDocumentType.SCAN.getValue();
        xdoc.modificationStatus = "STATUS_NEW";
        xdoc.setTag();
        enc.addToLst(xdoc);
        return ServerResponses.OKReturnObject();
    }

    private ReturnObject billingPrint(IServerRequest req) throws Exception {
        BillingsPrint billingPrint = req.getPostBody(CUidObject.class).getObject(BillingsPrint.class);
        IPrintController ctrl = Application.get().getPrintControllerFactory().newPrintController((Serializable)billingPrint);
        LightweightReport lightweightReport = new LightweightReport("billing_encounter", "Facturation", PrintMode.ACTUAL_SIZE);
        lightweightReport.getProperties().put((IReportProperty)new OutputProperty(billingPrint.destination == 1 ? "pdf" : "csv"));
        BillingsPrintProperty printProperty = new BillingsPrintProperty("billingsPrint", billingPrint);
        lightweightReport.getProperties().put("billingsPrint", (Serializable)printProperty);
        FaxDataProperty faxProp = null;
        if (billingPrint.faxdata != null) {
            billingPrint.faxdata.idSite = Application.get().getSitePluginController().getContextSite().getId();
            billingPrint.faxdata.docName = "FACT/BILL";
            faxProp = new FaxDataProperty("faxData", billingPrint.faxdata);
            lightweightReport.getProperties().put("faxData", (Serializable)faxProp);
        }
        ctrl.getSelection().add((IReport)lightweightReport);
        return ServerResponses.print(ctrl);
    }

    private ReturnObject encounterPrint(IServerRequest req) {
        CEncounter enc = req.getPostBody(CUidObject.class).getObject(CEncounter.class);
        XEncounter e = enc.x();
        Application.get().getApplicationUiPlugin().openEncounterPrintDialog(e);
        return ServerResponses.OKReturnObject();
    }

    private ActionResult summary(IServerRequest req) {
        if (req.hasQueryParam("idPt")) {
            int id = req.getQueryParam("idPt", Integer.class);
            CSummary x = this.encounterAccessor.findCSummaryByPatient(id);
            if (x != null) {
                CSummary.CSummaryMapArg arg = new CSummary.CSummaryMapArg();
                arg.drugNameFormat = EncounterController.getDrugNameFormat();
                arg.profNameResolver = new ProviderAR<Integer, String>(){

                    public String get(Integer idProf) {
                        XBaseProfessionnal prof;
                        if (idProf != null && (prof = Application.get().getPersonPluginController().getBaseProfessionnal(idProf)) != null) {
                            return String.format("%s (%s)", prof.getName(), prof.getCode());
                        }
                        return "-";
                    }
                };
                x.map(arg);
                Integer sessionIdUser = Application.get().getGlobalInstances().getSessionIdUser();
                ArrayList<CSummary.Plan> lstPrivatePlan = new ArrayList<CSummary.Plan>();
                for (CSummary.Plan p : x.getLstPlan()) {
                    if (p.getIdUserAnchor() == null || sessionIdUser.equals(p.getIdUserAnchor())) continue;
                    lstPrivatePlan.add(p);
                }
                if (!lstPrivatePlan.isEmpty()) {
                    x.getLstPlan().removeAll(lstPrivatePlan);
                }
                return ServerResponses.toJsonActionResult(x);
            }
            return ServerResponses.toJsonActionResult(new CSummary());
        }
        return ServerResponses.ERROR("Invalid arguments. Missing required parameters.");
    }

    private ActionResult searchInactiveRx(IServerRequest req) {
        HashMap mapRx = new HashMap(0);
        HashMap mapRxWithReason = new HashMap(0);
        if (req.hasQueryParam("idPt")) {
            Integer patientId = req.getRequiredQueryParam("idPt", Integer.class);
            try {
                ArrayList<CEncounter.Prescription> lstRx = new ArrayList<CEncounter.Prescription>(0);
                ReturnObject prescriptionByPatient = this.encounterAccessor.searchPrescriptionByPatient(patientId);
                if (prescriptionByPatient != null && prescriptionByPatient.getStatus().isOK() && prescriptionByPatient.getObj() != null && prescriptionByPatient.getObj() instanceof List) {
                    List rx = (List)prescriptionByPatient.getObj();
                    for (XPrescription x : rx) {
                        if (x.getStrength() == null || x.isActiveNow()) continue;
                        lstRx.add(new CEncounter.Prescription(x));
                    }
                    ArrayList lstRxToRemove = new ArrayList(0);
                    Collections.sort(lstRx, new Comparator<CEncounter.Prescription>(){

                        @Override
                        public int compare(CEncounter.Prescription o1, CEncounter.Prescription o2) {
                            String generic1 = o1.getBaseDrugName() == null ? "" : o1.getBaseDrugName().toLowerCase();
                            String generic2 = o2.getBaseDrugName() == null ? "" : o2.getBaseDrugName().toLowerCase();
                            String commercial1 = o1.getName() == null ? "" : o1.getName().toLowerCase();
                            String commercial2 = o2.getName() == null ? "" : o2.getName().toLowerCase();
                            int i = generic1.compareTo(generic2);
                            if (i == 0) {
                                i = (generic1 + commercial1).compareTo(generic2 + commercial2);
                            }
                            if (i == 0) {
                                i = o1.getStartDate().compareTo(o2.getStartDate());
                            }
                            if (i == 0 && o1.getEndDate() != null) {
                                i = o1.getEndDate().compareTo(o2.getEndDate());
                            }
                            return i;
                        }
                    });
                    CEncounter.Prescription lastPrescr = null;
                    String lastKey = null;
                    String lastForcePoso = null;
                    for (CEncounter.Prescription p : lstRx) {
                        List<CEncounter.Prescription> lWithReason;
                        List<CEncounter.Prescription> l;
                        String gen = p.getBaseDrugName() == null ? "" : p.getBaseDrugName().trim().toLowerCase();
                        String com = p.getName() == null ? "" : p.getName().trim().toLowerCase();
                        String k = gen + (com.length() > 0 ? " / " + com : "");
                        if ((k = k.substring(0, 1).toUpperCase() + k.substring(1)).equals(lastKey)) {
                            if ((p.getStrength() + p.getPosology()).equals(lastForcePoso) && lastPrescr != null && p.getStopDateSD() != null && p.getStopDateSD().equals(lastPrescr.getStopDateSD())) continue;
                            if (p.getStartDateSD().equals(p.getStopDateSD())) {
                                p.setStartDate(null);
                                p.setEndDate(null);
                                p.setStartDateSD(null);
                                p.setEndDateSD(null);
                            }
                        }
                        if (mapRx.containsKey(k)) {
                            l = (List)mapRx.get(k);
                        } else {
                            l = new ArrayList();
                            mapRx.put(k, l);
                        }
                        if (mapRxWithReason.containsKey(k)) {
                            lWithReason = (List)mapRxWithReason.get(k);
                        } else {
                            lWithReason = new ArrayList();
                            mapRxWithReason.put(k, lWithReason);
                        }
                        if (p.getAllergy() != null && p.getAllergy() > 0 || ca.infodata.util1.StringUtils.isNotEmpty((String)p.getStopReason())) {
                            lWithReason.add(p);
                        }
                        l.add(p);
                        lastPrescr = p;
                        lastKey = k;
                        lastForcePoso = p.getStrength() + p.getPosology();
                    }
                    ArrayList toRemove = new ArrayList();
                    Set entrySet = mapRxWithReason.entrySet();
                    for (Map.Entry e : entrySet) {
                        if (!((List)e.getValue()).isEmpty()) continue;
                        toRemove.add(e.getKey());
                    }
                    for (String k : toRemove) {
                        mapRxWithReason.remove(k);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error", e);
            }
            return ServerResponses.toJsonActionResult(new Object[]{mapRx, mapRxWithReason});
        }
        return ServerResponses.ERROR("Invalid arguments. Missing required parameters.");
    }

    private ActionResult favPrescription(IServerRequest req) {
        if (req.hasQueryParam("idProf")) {
            Integer id = req.getQueryParam("idProf", Integer.class);
            ReturnObject res = this.encounterAccessor.findFavPrescription(id);
            if (res.getObj() == null) {
                res.setStatus(ServerResponses.WarningMultiStatus("favPrescription: Aucun r\u00e9sultat."));
            } else {
                List prescriptions = (List)res.getObj();
                ArrayList<CFavPrescription> cPrescr = new ArrayList<CFavPrescription>(prescriptions.size());
                for (XFavPrescription x : prescriptions) {
                    cPrescr.add(new CFavPrescription(x));
                }
                res.setObj(cPrescr);
            }
            return ServerResponses.toJsonActionResult(res);
        }
        return ServerResponses.ERROR("Invalid arguments. Missing required parameters.");
    }

    private ReturnObject findDxCodeByCode(IServerRequest req) {
        String classification = req.getQueryParam("class");
        String code = req.getQueryParam("code", Base64DecodedString.BLANK, Base64DecodedString.class).getDecoded();
        ReturnObject res = this.encounterAccessor.findCodeByCode(code, classification);
        if (res.getObj() == null) {
            // empty if block
        }
        return res;
    }

    private ReturnObject searchDx(IServerRequest req) {
        String q = req.getQueryParam("q", Base64DecodedString.BLANK, Base64DecodedString.class).getDecoded();
        String codeType = req.getQueryParam("code");
        ReturnObject res = this.encounterAccessor.findCode(q, codeType);
        return res;
    }

    private ActionResult searchRxForce(IServerRequest req) {
        String q = req.getQueryParam("q", Base64DecodedString.BLANK, Base64DecodedString.class).getDecoded();
        String commercialName = req.getQueryParam("n", Base64DecodedString.BLANK, Base64DecodedString.class).getDecoded();
        Vector<Map<String, Object>> res = this.rxDrugRef.listTeneursForIngredient(q, commercialName);
        return ServerResponses.toJsonActionResult(res);
    }

    private ActionResult searchAllergy(IServerRequest req) {
        HashSet<SEARCH_ELEMENT_TYPECODE> searchInTypes = new HashSet<SEARCH_ELEMENT_TYPECODE>();
        String q = req.getQueryParam("q", Base64DecodedString.BLANK, Base64DecodedString.class).getDecoded();
        String types = req.getQueryParam("types");
        if (types != null) {
            String[] st;
            for (String typecode : st = types.split(",")) {
                searchInTypes.add(SEARCH_ELEMENT_TYPECODE.valueOf(typecode));
            }
        }
        List<RxElement> allergies = this.rxDrugRef.searchElements(q, searchInTypes);
        return ServerResponses.toJsonActionResult(allergies);
    }

    private ActionResult enumList(IServerRequest req) throws ClassNotFoundException {
        String className = req.getQueryParam("className");
        String enumType = req.getQueryParam("enumType");
        Class clazz = className.equals("ca.infodata.ofys.data.middle.dataobjects.Messages.XPatientStatus") ? XPatientStatus.class : Class.forName(className);
        if (enumType != null && enumType.equals("true")) {
            Map<String, Object> enumList = Utils.getEnumList(clazz, false);
            return ServerResponses.toJsonActionResult(enumList);
        }
        Map<String, Object> enumList = Utils.getEnumList(clazz, true);
        enumList.remove("className");
        if (XLifeHabitType.class.equals(clazz)) {
            HashMap mapHabs = new HashMap(enumList.size());
            for (Map.Entry<String, Object> el : enumList.entrySet()) {
                HashMap<String, String> m1 = new HashMap<String, String>();
                if (!NumberUtils.isNumber((String)el.getKey())) continue;
                XLifeHabitType t = XLifeHabitType.from((Integer)Integer.parseInt(el.getKey()));
                for (XLifeHabitFrequency lh : XLifeHabitFrequency.values()) {
                    String no = lh.getValue() + "";
                    String name = lh.toString(t);
                    m1.put(no, name);
                }
                mapHabs.put(el.getKey() + "~" + (String)el.getValue(), m1);
            }
            return ServerResponses.toJsonActionResult(mapHabs);
        }
        return ServerResponses.toJsonActionResult(enumList);
    }

    private ActionResult enumListObj(IServerRequest req) throws ClassNotFoundException {
        String className = req.getRequiredQueryParam("className");
        Class<?> clazz = Class.forName(className);
        Map<String, CEnumWithValue> enumList = Utils.getEnumListObj(clazz);
        enumList.remove("className");
        return ServerResponses.toJsonActionResult(enumList);
    }

    private ActionResult allEnumListObj(IServerRequest req) throws ClassNotFoundException {
        Map enums = req.getPostBody(HashMap.class);
        System.out.println(enums);
        HashMap<String, Map<String, CEnumWithValue>> res = new HashMap<String, Map<String, CEnumWithValue>>();
        for (String enumName : enums.keySet()) {
            Class<?> clazz = Class.forName((String)enums.get(enumName));
            Map<String, CEnumWithValue> enumList = Utils.getEnumListObj(clazz);
            enumList.remove("className");
            res.put(enumName, enumList);
        }
        return ServerResponses.toJsonActionResult(res);
    }

    private ActionResult planPost(IServerRequest req) {
        CUidObject cuidObject = null;
        try {
            cuidObject = req.getPostBody(CUidObject.class);
            CSummary.Plan plan = cuidObject.getObject(CSummary.Plan.class);
            XPatient pt = new XPatient();
            pt.setId(plan.getIdPatientAnchor());
            pt.setDecorators(null);
            pt.setLstPatientProfessionnal(null);
            pt.setPatientIdentifier(null);
            pt.setB2bInformation(null);
            pt.setLstPatientAlerts(null);
            pt.setConsentement(null);
            pt.setLstContactInformation(null);
            pt.setLstAddress(null);
            pt.setLstSites(null);
            pt.allIds = null;
            pt.setNeutral();
            plan.patientTemp = pt;
            XPlan x = new XPlan(plan);
            x = this.encounterAccessor.savePlan(x);
            CSummary.Plan savedPlan = new CSummary.Plan(x);
            return ServerResponses.toJsonActionResult(savedPlan);
        }
        catch (JsonSyntaxException e) {
            return ServerResponses.toJsonActionResult(ServerResponses.ERROR("Erreur de sauvegarde. Format de sauvegarde invalide"));
        }
    }

    private ReturnObject importancePost(IServerRequest req) {
        CImportance[] imps = req.getPostBody(CUidObject.class).getObject(CImportance[].class);
        String type = "";
        Integer idPatient = null;
        int n = 0;
        CImportance[] cImportanceArray = imps;
        int n2 = cImportanceArray.length;
        if (n < n2) {
            CImportance[] ci = cImportanceArray[n];
            idPatient = ci.idPatient;
            switch (ci.type) {
                case "lstDx": 
                case "lstProb": {
                    type = "encounter.diagnostic";
                    break;
                }
                case "lstIntervention": {
                    type = "encounter.intervention";
                    break;
                }
            }
        }
        Integer[] ids = new Integer[imps.length];
        Integer[] imp = new Integer[imps.length];
        int i = 0;
        for (CImportance cImportance : imps) {
            ids[i] = cImportance.id;
            imp[i] = cImportance.importance;
            ++i;
        }
        ReturnObject ro = this.encounterAccessor.saveImportance(type, ids, imp, idPatient);
        return ro;
    }

    private ReturnObject summaryPost(IServerRequest req) throws Exception {
        CSummary sum = req.getPostBody(CUidObject.class).getObject(CSummary.class);
        sum.setIdSite(Application.get().getSitePluginController().getContextSite().getId());
        XEncounterModificationRequest x = new XEncounterModificationRequest(sum, XEncounterType.MODIF_SOMM);
        ReturnObject ro = this.encounterAccessor.save(x);
        if (ro == null) {
            throw new AbortException("Erreur inconnue lors de la sauvegarde.");
        }
        XEncounterModificationRequest savedEncModReq = (XEncounterModificationRequest)ro.getObj();
        if (savedEncModReq == null) {
            logger.log(Level.SEVERE, "Sauvegarde du sommaire a \u00e9chou\u00e9 XEncounterModificationRequest de retour est null");
            return ServerResponses.ErrorReturnObject("XEncounterModificationRequest de retour est null");
        }
        CSummary savedC = new CSummary(savedEncModReq);
        sum.replaceSavedObjectsInSource(savedC);
        ro.setObj((Object)sum);
        return ro;
    }

    private ReturnObject summaryImportDsqPost(IServerRequest req) throws Exception {
        CSummary sum = req.getPostBody(CUidObject.class).getObject(CSummary.class);
        sum.setIdSite(Application.get().getSitePluginController().getContextSite().getId());
        XEncounterModificationRequest x = new XEncounterModificationRequest(sum, XEncounterType.IMP_RX);
        ReturnObject ro = this.encounterAccessor.save(x);
        if (ro == null) {
            throw new AbortException("Erreur inconnue lors de la sauvegarde.");
        }
        XEncounterModificationRequest savedEncModReq = (XEncounterModificationRequest)ro.getObj();
        if (savedEncModReq == null) {
            logger.log(Level.SEVERE, "Sauvegarde du sommaire Import DSQ a \u00e9chou\u00e9 XEncounterModificationRequest de retour est null");
            return ServerResponses.ErrorReturnObject("XEncounterModificationRequest de retour est null");
        }
        CSummary savedC = new CSummary(savedEncModReq);
        sum.replaceSavedObjectsInSource(savedC);
        ro.setObj((Object)sum);
        return ro;
    }

    private ReturnObject encounterPost(IServerRequest req) throws Exception {
        ReturnObject ro = null;
        CUidObject cUidObject = req.getPostBody(CUidObject.class);
        try {
            XEncounterModificationRequest x;
            XSite site;
            boolean newProf;
            CEncounterRequest encReq = cUidObject.getObject(CEncounterRequest.class);
            CEncounter enc = encReq.encounter;
            enc.modificationStatus = ModificationStatus.STATUS_NEUTRAL.name();
            if (enc.getEncounterType() != null && !XEncounterType.from((Integer)enc.getEncounterType()).toString().equals(enc.getEncounterTypeS())) {
                enc.modificationStatus = ModificationStatus.STATUS_UPDATED.name();
            }
            XBaseProfessionnal professionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
            long now = DateUtil.now();
            boolean bl = newProf = professionnal != null && !professionnal.getId().equals(enc.getProfessionnal());
            if (newProf) {
                enc.setProfessionnal(professionnal.getId());
                enc.setDatetime(Long.valueOf(now));
                enc.modificationStatus = ModificationStatus.STATUS_UPDATED.name();
            }
            if ((site = Application.get().getSitePluginController().getContextSite()) != null && !site.getId().equals(enc.getSite())) {
                enc.setSite(site.getId());
                enc.setDatetime(Long.valueOf(now));
                enc.modificationStatus = ModificationStatus.STATUS_UPDATED.name();
            }
            if (enc.getId() == null && enc.modificationStatus.equals(ModificationStatus.STATUS_NEUTRAL.name())) {
                enc.setDatetime(Long.valueOf(now));
                enc.modificationStatus = ModificationStatus.STATUS_UPDATED.name();
            }
            if (enc.getLstNote() != null) {
                Integer sessionIdUser = Application.get().getGlobalInstances().getSessionIdUser();
                for (CEncounter.EncounterNote p : enc.getLstNote()) {
                    if (Boolean.TRUE.equals(p.isPrivate)) {
                        if (p.getIdUserAnchor() != null) continue;
                        p.setIdUserAnchor(sessionIdUser);
                        p.modificationStatus = ModificationStatus.STATUS_UPDATED.name();
                        continue;
                    }
                    if (p.getIdUserAnchor() == null) continue;
                    p.setIdUserAnchor(null);
                    p.modificationStatus = ModificationStatus.STATUS_UPDATED.name();
                }
            }
            if ((ro = this.encounterAccessor.save(x = new XEncounterModificationRequest(enc))) == null) {
                throw new Exception("Erreur inconnue lors de la sauvegarde.");
            }
            if (!ro.getStatus().isOkToProceed()) {
                throw new StatusException((IStatus)ro.getStatus());
            }
            XEncounterModificationRequest savedEncModReq = (XEncounterModificationRequest)ro.getObj();
            if (savedEncModReq != null) {
                savedEncModReq.setIdPatient(enc.getIdPatientAnchor());
                savedEncModReq.getEncounter().idPatient = enc.getIdPatientAnchor();
                try {
                    IWebSocketChannel wsChannel = WebApplication.get().getWebSocketDelegate().get(new WebSocketFilterByRequest(req));
                    this.dsqController.exportPrescriptionsAsync(savedEncModReq, wsChannel);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to export encounter prescription to dsq async ", e);
                    ro.getStatus().add((IStatus)new Status(IStatus.Severity.WARNING, "Export prescription dsq \u00e9chou\u00e9"));
                }
                CEncounter savedC = new CEncounter(savedEncModReq);
                if (newProf) {
                    CEncounter.Profs prof = new CEncounter.Profs();
                    prof.idProfessionnalAnchor = professionnal.getId();
                    prof.entryDate = savedC.getDatetime();
                    prof.entryDateS = CEncounter.getStringDateTimeFromLong((Long)savedC.getDatetime());
                    prof.profNom = EncounterController.getProfName(prof.idProfessionnalAnchor);
                    enc.getLstProf().add(prof);
                }
                enc.init(savedEncModReq.getEncounter());
                enc.replaceSavedObjectsInSource(savedC);
                return ServerResponses.OKReturnObject(enc);
            }
            logger.log(Level.SEVERE, "Sauvegarde de la rencontre \u00e9chou\u00e9 XEncounterModificationRequest de retour est null");
            return ServerResponses.ErrorReturnObject("XEncounterModificationRequest de retour est null");
        }
        catch (StatusException e) {
            logger.log(Level.INFO, "Encounter save error", e);
            return ro;
        }
    }

    private ActionResult encounterSaveFactType(IServerRequest req) {
        String factUid;
        Integer idFactType;
        Integer idPat;
        Integer idProf;
        Integer idEncAnc = req.getQueryParam("idEncAnc", Integer.class);
        ReturnObject saveFactType = this.encounterAccessor.saveFactType(idEncAnc, idProf = req.getQueryParam("idProf", Integer.class), idPat = req.getQueryParam("idPat", Integer.class), idFactType = req.getQueryParam("idFactType", Integer.class), factUid = req.getQueryParam("factUid", String.class));
        if (saveFactType.getStatus().isOK()) {
            return ServerResponses.SUCCESS();
        }
        return ServerResponses.ERROR(saveFactType.getStatus().getMessage());
    }

    private ActionResult getRenalDosing(IServerRequest req) {
        String renalDosingHtml = "";
        try {
            DataForRenalDosing data = req.getPostBody(CUidObject.class).getObject(DataForRenalDosing.class);
            if (data.din != null) {
                List<Map<Integer, Object>> list;
                String rxName = data.rxName;
                int din = data.din;
                Boolean isBlack = Boolean.TRUE.equals(data.isBlack);
                String sex = data.sex != null ? data.sex : XPerson.Gender.INCONNU.id;
                int age = data.age == null ? 0 : data.age;
                double weight = data.weight == null ? 0.0 : data.weight;
                double creatinine = data.creatinine == null ? 0.0 : data.creatinine;
                String lang = LocaleProvider.getLocale().getLanguage();
                String dxCim10 = "";
                if (data.lstDx != null) {
                    for (CEncounter.Dx xdx : data.lstDx) {
                        if (xdx.cim10Code == null) continue;
                        dxCim10 = (dxCim10.length() > 0 ? dxCim10 + "~" : "") + xdx.cim10Code + ";" + lang;
                    }
                }
                if ((list = this.rxDrugRef.getRenalDosingInformation(din + ";" + lang, age, sex, isBlack, weight, creatinine, dxCim10)) != null) {
                    for (Map<Integer, Object> map : list) {
                        byte[] bb = (byte[])map.get("html");
                        String html = new String(bb, UTF8_CHARSET);
                        renalDosingHtml = ca.infodata.util1.StringUtils.replaceOnce((String)html, (String)"[RX_NAME]", (String)rxName).replaceAll("\ufffd", "\u00e9");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error getting renal dosing. " + req.printDebugInfo(), e);
        }
        return ServerResponses.toJsonActionResult(renalDosingHtml);
    }

    /*
     * WARNING - void declaration
     */
    private ActionResult analyseAllergies(IServerRequest req) {
        try {
            DataForRxAllergies data = req.getPostBody(CUidObject.class).getObject(DataForRxAllergies.class);
            List<Object> atcs = new ArrayList();
            if (data.prescription != null && data.prescription.getDin() != null) {
                atcs = this.rxDrugRef.getAtcsFromDins(Arrays.asList(data.prescription.getDin().toString()));
            }
            logger.fine("atcs = " + atcs);
            ArrayList<CEncounter.Allergies> inCauseAllergies = new ArrayList<CEncounter.Allergies>();
            ArrayList<CEncounter.Allergies> allergiesNotFound = new ArrayList<CEncounter.Allergies>();
            if (atcs.size() > 0) {
                List<CEncounter.Allergies> allergies = data.lstAllergies;
                ArrayList<XAllergy> allergiesCopy = new ArrayList<XAllergy>(allergies.size());
                for (CEncounter.Allergies allergies2 : allergies) {
                    allergiesCopy.add(allergies2.x());
                }
                List<CEncounter.Intolerances> intolerances = data.lstIntolerances;
                for (CEncounter.Intolerances a : intolerances) {
                    allergiesCopy.add(a.x());
                }
                ArrayList<RxElement> arrayList = new ArrayList<RxElement>(allergiesCopy.size());
                HashMap mapRxElementAllergy = new HashMap();
                Iterator iterator = allergiesCopy.iterator();
                while (iterator.hasNext()) {
                    RxElement rxElement;
                    XAllergy allergie = (XAllergy)iterator.next();
                    if (allergie.getDin() != null) {
                        void var14_20;
                        rxElement = new RxElement(allergie.getDin().toString(), allergie.getDrugrefDescType() == null ? new Integer(13) : allergie.getDrugrefDescType().id, allergie.getDrugrefDesc());
                        rxElement.din = allergie.getDin();
                        List list = (List)mapRxElementAllergy.get(rxElement);
                        List<String> atcsFromDins = this.rxDrugRef.getAtcsFromDins(Arrays.asList(allergie.getDin().toString()));
                        if (list == null) {
                            ArrayList arrayList2 = new ArrayList();
                            if (atcsFromDins != null && !atcsFromDins.isEmpty()) {
                                rxElement.atc = atcsFromDins.get(0);
                                mapRxElementAllergy.put(rxElement, arrayList2);
                            }
                        }
                        var14_20.add(allergie);
                        arrayList.add(rxElement);
                        iterator.remove();
                        continue;
                    }
                    if (allergie.getDrugrefId() != null && allergie.getDrugrefDescType() != null && allergie.getDrugrefDesc() != null) {
                        void var14_23;
                        rxElement = new RxElement(allergie.getDrugrefId(), allergie.getDrugrefDescType().id, allergie.getDrugrefDesc());
                        List list = (List)mapRxElementAllergy.get(rxElement);
                        if (list == null) {
                            ArrayList arrayList3 = new ArrayList();
                            mapRxElementAllergy.put(rxElement, arrayList3);
                        }
                        var14_23.add(allergie);
                        arrayList.add(rxElement);
                        iterator.remove();
                        continue;
                    }
                    CEncounter.Allergies alg = new CEncounter.Allergies();
                    alg.convertc((Object)allergie);
                    allergiesNotFound.add(alg);
                    iterator.remove();
                }
                HashSet inCauseDrugrefIds = new HashSet();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(new JoinList("\n^^*", arrayList).toString());
                }
                if (arrayList.size() > 0) {
                    for (String string : atcs) {
                        List<Map<String, Object>> list = this.rxDrugRef.getAllergyWarnings(string, arrayList);
                        for (Map<String, Object> map : list) {
                            inCauseDrugrefIds.addAll((List)map.get("warnings"));
                        }
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("$$" + new JoinList("\n$$", inCauseDrugrefIds));
                }
                for (String string : inCauseDrugrefIds) {
                    RxElement rxElement = new RxElement(string, null, null);
                    List list = (List)mapRxElementAllergy.get(rxElement);
                    if (list != null) {
                        for (XAllergy x : list) {
                            CEncounter.Allergies alg = new CEncounter.Allergies();
                            alg.convertc((Object)x);
                            inCauseAllergies.add(alg);
                        }
                        continue;
                    }
                    logger.info("no allergies for drugrefid " + string);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("@@" + new JoinList("\n@@", inCauseAllergies));
                }
            }
            DataResponseForRxAllergies dataResp = new DataResponseForRxAllergies();
            dataResp.lstAllergies = inCauseAllergies;
            dataResp.lstAllergiesNotFound = allergiesNotFound;
            return ServerResponses.toJsonActionResult(dataResp);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in encounter analyseAllergies", e);
            return ServerResponses.toJsonActionResult("");
        }
    }

    private ReturnObject presavePost(IServerRequest req) {
        CEncounter enc = req.getPostBody(CUidObject.class).getObject(CEncounter.class);
        Application.get().getPreSaveController().addModifiedEncounter(enc);
        return ServerResponses.OKReturnObject();
    }

    private ReturnObject presaveGet(IServerRequest req) {
        Integer patientId = req.getQueryParam("idPt", Integer.class);
        if (patientId != null) {
            CEncounter enc = Application.get().getPreSaveController().getEncounterByPatient(patientId);
            if (enc != null) {
                enc.uid = Utils.getNewAtomicInteger();
                return new ReturnObject((Serializable)enc);
            }
        } else {
            ReturnObject res = new ReturnObject();
            res.setObj(Application.get().getPreSaveController().getAllEncounters());
            return res;
        }
        return ServerResponses.OKReturnObject();
    }

    private ReturnObject presaveDelete(IServerRequest req) throws Exception {
        try {
            Integer patientId = req.getRequiredQueryParam("idPt", Integer.class);
            if (patientId != null) {
                Application.get().getPreSaveController().deleteEncountersByPatient(patientId);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error deleting patient encounter presave store.", e);
            throw e;
        }
        return ServerResponses.OKReturnObject();
    }

    private ActionResult drugByDIN(IServerRequest req) {
        String din = req.getQueryParam("din");
        if (din != null) {
            Map<String, Object> drug = this.rxDrugRef.getByDin(din);
            return ServerResponses.toJsonActionResult(drug);
        }
        return ServerResponses.toJsonActionResult(Collections.emptyMap());
    }

    private ReturnObject favrx(IServerRequest req) {
        Integer idProf = req.getRequiredQueryParam("idProf", Integer.class);
        ReturnObject res = this.encounterAccessor.findFavPrescription(idProf);
        List prescriptions = (List)res.getObj();
        ArrayList<CFavPrescription> cPrescr = new ArrayList<CFavPrescription>(prescriptions.size());
        for (XFavPrescription x : prescriptions) {
            cPrescr.add(new CFavPrescription(x));
        }
        res.setObj(cPrescr);
        return res;
    }

    private ReturnObject addFavIdRx(IServerRequest req) {
        Integer idProf = req.getRequiredQueryParam("idProf", Integer.class);
        Integer idRx = req.getRequiredQueryParam("idRx", Integer.class);
        ReturnObject res = this.encounterAccessor.addToFavPrescription(idProf, idRx);
        XFavPrescription prescriptions = (XFavPrescription)res.getObj();
        CFavPrescription cFav = new CFavPrescription(prescriptions);
        res.setObj((Object)cFav);
        return res;
    }

    private ReturnObject addFavRx(IServerRequest req) {
        try {
            CUidObject cUidObject = req.getPostBody(CUidObject.class);
            CEncounter.DevicePrescription p = null;
            if (CEncounter.Prescription.class.getCanonicalName().equals(cUidObject.getType())) {
                p = (CEncounter.DevicePrescription)cUidObject.getObject(CEncounter.Prescription.class);
            } else if (CEncounter.Device.class.getCanonicalName().equals(cUidObject.getType())) {
                p = (CEncounter.DevicePrescription)cUidObject.getObject(CEncounter.Device.class);
            }
            if (p != null && p.getIdProfessionnalAnchor() != null && ca.infodata.util1.StringUtils.isNotBlank((String)p.name)) {
                XPrescription x = p instanceof CEncounter.Prescription ? ((CEncounter.Prescription)p).x() : ((CEncounter.Device)p).x();
                ReturnObject res = this.encounterAccessor.addToFavPrescription(p.getIdProfessionnalAnchor(), x);
                if (res.getObj() == null) {
                    res.setStatus(ServerResponses.WarningMultiStatus("addFavRx: Aucun r\u00e9sultat."));
                } else {
                    XFavPrescription prescriptions = (XFavPrescription)res.getObj();
                    CFavPrescription cFav = new CFavPrescription(prescriptions);
                    res.setObj((Object)cFav);
                }
                return res;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add favorite. " + req.printDebugInfo(), e);
        }
        return ServerResponses.ErrorReturnObject("Erreur ajout de favoris");
    }

    private ReturnObject delFavIdRx(IServerRequest req) {
        try {
            Integer idRx = req.getRequiredQueryParam("idRx", Integer.class);
            ReturnObject res = this.encounterAccessor.removeFromFavPrescription(idRx);
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to delete favorite. params=" + req.getQueryParams(), e);
            return ServerResponses.ErrorReturnObject("Erreur de suppression de favoris");
        }
    }

    private ActionResult followUpChartRx(IServerRequest req) {
        Integer patId = req.getRequiredQueryParam("patId", Integer.class);
        LocalDate start = req.getRequiredQueryParam("start", LocalDate.class);
        LocalDate end = req.getRequiredQueryParam("end", LocalDate.class);
        return ServerResponses.toJsonActionResult(this.showChartPrescription(patId, start, end));
    }

    public Map<String, String> showChartPrescription(Integer patId, LocalDate start, LocalDate end) {
        LocalDate activeEndRxDate;
        HashMap<String, String> res = new HashMap<String, String>();
        LocalDate activeStartRxDate = start.plusMonth(-18);
        ReturnObject prescriptions = this.encounterAccessor.getAllPrescriptionForThisPatientAndDates(patId, activeStartRxDate, activeEndRxDate = end.plusDay(-2));
        if (prescriptions != null) {
            List activeRxList = (List)prescriptions.getObj();
            activeRxList.removeIf(p -> p.getStrength() == null || p.getStrength().getGenericName() == null);
            Collections.sort(activeRxList, new Comparator<XPrescription>(){

                @Override
                public int compare(XPrescription a0, XPrescription a1) {
                    int compare = a0.getStrength().getGenericName().compareTo(a1.getStrength().getGenericName());
                    if (compare == 0) {
                        int compDate = a0.getStartDate().compareTo((IPartialDate)a1.getStartDate());
                        if (compDate == 0) {
                            LocalDate end0 = a0.getPresumedDateToRenvew();
                            LocalDate end1 = a1.getPresumedDateToRenvew();
                            return end0.compareTo((IPartialDate)end1);
                        }
                        return compDate;
                    }
                    return compare;
                }
            });
            String rxGantt = null;
            String rxName = null;
            LocalDateRange range = new LocalDateRange(start, end, RangeNotation.CLOSED);
            int yAxis = 1;
            HashMap<String, Integer> mapDrugNameYaxis = new HashMap<String, Integer>();
            HashMap mapDrugNameWithAllDateRange = new HashMap();
            for (XPrescription px : activeRxList) {
                if (px.getStrength() == null || XDrugType.FOURNITURE.equals((Object)px.getStrength().getDrugType())) continue;
                LocalDate dateStart = px.getStartDate();
                LocalDate localDate = px.getPresumedDateToRenvew();
                if (!localDate.after((IPartialDate)start) || !dateStart.before((IPartialDate)end) || localDate.dayFrom1970 - dateStart.dayFrom1970 <= 2) continue;
                String drugName = ca.infodata.util1.StringUtils.abbreviateToWord((String)px.getCommercialDrugNameStrengthPosol(), (int)40).replaceAll("\n", "<br>") + "~~~" + dateStart.dayFrom1970;
                String drugNameOnly = px.getStrength().getGenericName();
                if (!mapDrugNameYaxis.containsKey(drugNameOnly)) {
                    mapDrugNameYaxis.put(drugNameOnly, new Integer(yAxis++));
                }
                LocalDate c1 = dateStart;
                LocalDate c2 = localDate;
                LocalDateRange range2 = new LocalDateRange(c1, c2, RangeNotation.CLOSED);
                try {
                    if (range.intersect((Range)range2)) {
                        LocalDateRange rangeToAdd = new LocalDateRange(c1, c2, RangeNotation.CLOSED);
                        if (mapDrugNameWithAllDateRange.containsKey(drugNameOnly)) {
                            ((Map)mapDrugNameWithAllDateRange.get(drugNameOnly)).put(drugName, rangeToAdd);
                        } else {
                            HashMap<String, LocalDateRange> mapRxDateRange = new HashMap<String, LocalDateRange>();
                            mapRxDateRange.put(drugName, rangeToAdd);
                            mapDrugNameWithAllDateRange.put(drugNameOnly, mapRxDateRange);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (mapDrugNameWithAllDateRange.size() <= 15) continue;
            }
            ArrayList<String> lstRxTicks = new ArrayList<String>();
            ArrayList<String> lstDNDR = new ArrayList<String>();
            for (Map.Entry entry : mapDrugNameYaxis.entrySet()) {
                int yx = (Integer)entry.getValue();
                lstRxTicks.add("[" + yx + ",\"" + (String)entry.getKey() + "\"]");
                Map mmm = (Map)mapDrugNameWithAllDateRange.get(entry.getKey());
                if (mmm == null) continue;
                for (Map.Entry rxDR : mmm.entrySet()) {
                    StringBuilder sb = new StringBuilder();
                    LocalDateRange ii = (LocalDateRange)rxDR.getValue();
                    String dn = ((String)rxDR.getKey()).split("~~~")[0];
                    long dd1 = ((LocalDate)ii.start).toTimeInMillisUTC();
                    long dd2 = ((LocalDate)ii.end).toTimeInMillisUTC();
                    sb.append("[").append(dd1).append(",").append(yx).append(",").append(dd2).append(",").append("\"" + dn + "\"").append("]");
                    System.out.println("add:" + sb.toString());
                    lstDNDR.add(sb.toString());
                }
            }
            String ganttStr = "[" + new JoinList(",", lstDNDR).toString() + "]";
            rxGantt = "[{\"label\":\"\", \"data\":" + ganttStr + ", \"gantt\":{\"connectSteps\":{\"show\":false} } }]";
            rxName = "[" + new JoinList(",", lstRxTicks).toString() + "]";
            res.put("rxGantt", rxGantt);
            res.put("rxName", rxName);
        }
        return res;
    }

    private ActionResult searchDrugReference(IServerRequest req) {
        String q = req.getQueryParam("q", Base64DecodedString.BLANK, Base64DecodedString.class).getDecoded();
        Boolean s = req.getQueryParam("s", Boolean.FALSE, Boolean.class);
        return ServerResponses.toJsonActionResult(this.searchDrugReference(q, s));
    }

    private ReturnObject searchDevices(IServerRequest req) {
        String q = req.getQueryParam("q", Base64DecodedString.BLANK, Base64DecodedString.class).getDecoded();
        ReturnObject ro = this.encounterAccessor.findDevicesNames(q);
        return ro;
    }

    public ActionResult selectDrug(IServerRequest req) {
        String pkey = req.getQueryParam("id");
        CEncounter.Prescription p = req.getPostBody(CUidObject.class).getObject(CEncounter.Prescription.class);
        CEncounter.Prescription res = new CEncounter.Prescription(this.mergeSelectedDrugWithCurrent(this.rxDrugRef.getDrug(pkey), p.x(), this.rxDrugRef));
        if (res.getBaseDrugType() == null) {
            res.setBaseDrugType(Integer.valueOf(XDrugType.REGULAR.value));
        }
        if (XDrugType.NARCOTIC.getValue() == res.getBaseDrugType().intValue()) {
            res.setRx(Integer.valueOf(0));
        }
        return ServerResponses.toJsonActionResult(res);
    }

    private XPrescription mergeSelectedDrugWithCurrent(Map<String, Object> selectedDrug, XPrescription current, IRxDrugRefAccessor rxDrugRefObj) {
        Set<String> ahfsSet;
        XPrescription.RxData rxPrescr;
        Integer din;
        String strength = "";
        List component = (List)selectedDrug.get("components");
        String genericName = (String)selectedDrug.get("name");
        String commercialName = (String)selectedDrug.get("product");
        try {
            din = Integer.parseInt((String)selectedDrug.get("regional_identifier"));
        }
        catch (Exception e) {
            din = null;
        }
        Vector rxPrescrVector = (Vector)selectedDrug.get("data");
        ArrayList<XPrescription.RxData> lstRx = null;
        if (rxPrescrVector != null && rxPrescrVector.size() > 0) {
            lstRx = new ArrayList<XPrescription.RxData>(rxPrescrVector.size());
            for (Hashtable map : rxPrescrVector) {
                rxPrescr = new XPrescription.RxData((String)map.get("p"), (String)map.get("f"), (Integer)map.get("q"), (Integer)map.get("j"), (Integer)map.get("r"));
                lstRx.add(rxPrescr);
            }
        }
        if (lstRx != null) {
            current.lstRxData.addAll(lstRx);
        }
        Vector routeVector = (Vector)selectedDrug.get("drugRoute");
        String sRoute = "";
        if (routeVector != null && !routeVector.isEmpty() && (rxPrescr = routeVector.iterator()).hasNext()) {
            String sr;
            sRoute = sr = (String)rxPrescr.next();
        }
        XMyRouteOfAdministration routeAdmin = null;
        if (ca.infodata.util1.StringUtils.isNotEmpty((String)sRoute)) {
            routeAdmin = XMyRouteOfAdministration.getRoute((String)sRoute);
        }
        if (routeAdmin == null) {
            routeAdmin = XMyRouteOfAdministration.getRoute((String)((String)selectedDrug.get("drugForm")));
        }
        routeAdmin = routeAdmin == null ? XMyRouteOfAdministration.PO : routeAdmin;
        XMyOrderableDrugForm format = XMyOrderableDrugForm.getDrugForm((String)((String)selectedDrug.get("drugForm")));
        format = format == null ? XMyOrderableDrugForm.PILL : format;
        ArrayList<XDrugStrength> lstXDrugStrength = new ArrayList<XDrugStrength>();
        if (component != null) {
            if (component.size() == 1) {
                for (Object map : component) {
                    int fi;
                    Double fStrength = (Double)map.get("strength");
                    double fl = fStrength;
                    strength = fl == (double)(fi = fStrength.intValue()) ? String.valueOf(fi) : String.valueOf(fl);
                    strength = strength + map.get("unit");
                }
            } else {
                genericName = "";
                String totalStr = "";
                for (Map map : component) {
                    int fi;
                    Double fStrength = (Double)map.get("strength");
                    double fl = fStrength;
                    strength = fl == (double)(fi = fStrength.intValue()) ? String.valueOf(fi) : String.valueOf(fl);
                    totalStr = totalStr + strength + map.get("unit") + "-";
                    genericName = genericName + (String)map.get("name") + " / ";
                }
                strength = StringUtils.removeEnd((String)totalStr, (String)"-");
                genericName = StringUtils.removeEnd((String)genericName, (String)" / ");
            }
            XDrugStrength xDS = new XDrugStrength();
            xDS.setName(strength);
            lstXDrugStrength.add(xDS);
        }
        ObjectListenerManager.disable((Object)current);
        XDrugStrength drug = current.getStrength();
        if (drug == null) {
            drug = new XDrugStrength();
        }
        drug.setGenericName(genericName);
        drug.setCommercialName(commercialName);
        drug.setCompleteName(null);
        drug.setDin(din);
        drug.setStrength(strength);
        XDrugType type = XDrugType.REGULAR;
        if (din != null && (ahfsSet = rxDrugRefObj.getAhfsFromDin(din)) != null) {
            drug.setAhfs(ahfsSet);
            for (String ss : ahfsSet) {
                if (!"28:08.08".equals(ss)) continue;
                type = XDrugType.NARCOTIC;
            }
        }
        drug.setDrugType(type);
        current.setStrength(drug);
        current.setFormat(format);
        current.setRoute(routeAdmin);
        current.setDin(din);
        return current;
    }

    private ActionResult edit(IServerRequest req) {
        Integer id = req.getRequiredQueryParam("id", Integer.class);
        return this.openEdit(id) ? ServerResponses.SUCCESS() : ServerResponses.ERROR("Could not open view");
    }

    protected ReturnObject findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor(IServerRequest req) {
        Integer idAnchor = req.getRequiredQueryParam("idAnchor", Integer.class);
        return this.findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor(idAnchor);
    }

    protected ReturnObject findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor(int encAnchorId) {
        ReturnObject ro = this.encounterAccessor.findAllNotesIncludingRevisionsAndDeletedByEncounterAnchor(encAnchorId);
        if (ro.getObj() != null) {
            List res = (List)ro.getObj();
            if (res != null) {
                Integer sessionIdUser = Application.get().getGlobalInstances().getSessionIdUser();
                for (CEncounter.EncounterNote p : res) {
                    if (p.getIdUserAnchor() == null || sessionIdUser.equals(p.getIdUserAnchor())) continue;
                    p.note = Messages.getString((String)"PrivateNoteOf", (String[])new String[0]);
                    p.isPrivate = Boolean.TRUE;
                    p.isReadOnly = Boolean.TRUE;
                }
            }
        } else {
            return ServerResponses.ErrorReturnObject("Aucune note trouv\u00e9e");
        }
        return ro;
    }

    protected ReturnObject findStatusFacture(String factId) {
        ReturnObject ro = this.encounterAccessor.findStatusFacture(factId);
        if (ro.getObj() == null) {
            return ServerResponses.ErrorReturnObject("Facture non trouv\u00e9e");
        }
        return ro;
    }

    protected ReturnObject findPatientEncStatusFactByDate(Integer onDate, Integer toDate) {
        ReturnObject ro = this.encounterAccessor.findPatientEncStatusFactByDate(onDate, toDate);
        if (ro.getObj() == null) {
            return ServerResponses.ErrorReturnObject("Aucune rencontre trouv\u00e9e");
        }
        return ro;
    }

    protected ReturnObject findEncounterOnDate(Integer onDate) {
        ReturnObject ro = this.encounterAccessor.findEncountersIdByDate(onDate);
        if (ro.getObj() == null) {
            return ServerResponses.ErrorReturnObject("Aucune rencontre trouv\u00e9e");
        }
        return ro;
    }

    private static String getProfName(Integer idProf) {
        XBaseProfessionnal prof;
        if (idProf != null && (prof = Application.get().getPersonPluginController().getBaseProfessionnal(idProf)) != null) {
            return String.format("%s (%s)", prof.getName(), prof.getCode());
        }
        return null;
    }

    protected ReturnObject findEncounter(int patientId, boolean onlyLast5Last3t) {
        ReturnObject ro = this.encounterAccessor.findCEncountersByPatient(patientId, onlyLast5Last3t);
        if (ro.getObj() != null) {
            List res;
            if (ro.getObj() instanceof byte[]) {
                res = (List)LZMAClientSerialiser.deserialize((byte[])((byte[])ro.getObj()), (boolean)true);
                ro.setObj((Object)res);
            } else {
                res = (List)ro.getObj();
            }
            CEncounter.CEncounterMapArg arg = new CEncounter.CEncounterMapArg();
            arg.profNameResolver = new ProviderAR<Integer, String>(){

                public String get(Integer idProf) {
                    return EncounterController.getProfName(idProf);
                }
            };
            Integer sessionIdUser = Application.get().getGlobalInstances().getSessionIdUser();
            for (CEncounter x : res) {
                x.uid = Utils.getNewAtomicInteger();
                x.map(arg);
                if (x.getLstNote() == null) continue;
                for (CEncounter.EncounterNote p : x.getLstNote()) {
                    if (p.getIdUserAnchor() == null) continue;
                    p.isPrivate = Boolean.TRUE;
                    if (sessionIdUser.equals(p.getIdUserAnchor())) continue;
                    p.note = "\u2256*" + Messages.getString((String)"PrivateNoteOf", (String[])new String[0]) + "*";
                    p.isReadOnly = Boolean.TRUE;
                }
            }
        } else {
            return ServerResponses.ErrorReturnObject("Aucune rencontre trouv\u00e9e");
        }
        return ro;
    }

    public static List<CEncounter.Prescription> getActivePrescriptions(long referenceTime, List<CEncounter.Prescription> prescriptions) {
        ArrayList<CEncounter.Prescription> list = new ArrayList<CEncounter.Prescription>();
        if (prescriptions != null) {
            ArrayList<CEncounter.Prescription> filteredPrescriptions = new ArrayList<CEncounter.Prescription>(prescriptions);
            LocalDate today = LocalDate.today();
            for (CEncounter.Prescription p : filteredPrescriptions) {
                LocalDate referenceDate = LocalDate.fromTimeInMillisLOCAL((Long)referenceTime);
                if (p.getStopDate() != null && LocalDate.fromTimeInMillisLOCAL((Long)p.getStopDate()).beforeOrEquals(referenceDate) || p.getEndDate() != null && LocalDate.fromTimeInMillisLOCAL((Long)p.getEndDate()).before((IPartialDate)referenceDate)) continue;
                LocalDate presumedDateToRenvew = null;
                if (Boolean.TRUE.equals(p.getToReprescribeB()) && (presumedDateToRenvew = p.getPresumedDateToRenew()) != null && LocalDate.fromTimeInMillisLOCAL((Long)referenceTime).after((IPartialDate)presumedDateToRenvew)) continue;
                if (presumedDateToRenvew == null) {
                    presumedDateToRenvew = p.getPresumedDateToRenew();
                }
                LocalDate endDate = null;
                if (p.getEndDate() != null) {
                    endDate = LocalDate.fromTimeInMillisLOCAL((Long)p.getEndDate());
                    if (presumedDateToRenvew == null || endDate.before((IPartialDate)presumedDateToRenvew)) {
                        presumedDateToRenvew = endDate;
                    }
                }
                if (presumedDateToRenvew != null) {
                    p.expiredDateSD = (presumedDateToRenvew.equals((Object)endDate) ? "" : "~") + presumedDateToRenvew.formatHyphen();
                    if (p.getStopDate() == null && today.plusDay(1).after((IPartialDate)presumedDateToRenvew)) {
                        p.expiredStatus = 1;
                        if (today.plusMonth(-6).after((IPartialDate)presumedDateToRenvew)) {
                            p.expiredStatus = 2;
                        }
                    }
                }
                if (p.getId() != null) {
                    boolean isReferenced = false;
                    for (CEncounter.Prescription p2 : prescriptions) {
                        if (p2.getIdPrevPrescription() == null || !p2.getIdPrevPrescription().equals(p.getId())) continue;
                        isReferenced = true;
                        break;
                    }
                    if (isReferenced) continue;
                    list.add(p);
                    continue;
                }
                list.add(p);
            }
        }
        return list;
    }

    public static XPrescriptionDrugNameFormat getDrugNameFormat() {
        XUserPreferences userPreferences;
        XUser user;
        XPrescriptionDrugNameFormat format = null;
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null && (user = session.getUser()) != null && (userPreferences = user.getUserPreferences()) != null) {
            format = userPreferences.getDrugNameFormatSummary();
        }
        if (format == null) {
            format = XPrescriptionDrugNameFormat.COMMERCIAL_AND_GENERIC;
        }
        return format;
    }

    public Vector<Map<String, Object>> searchDrugReference(String rx, Boolean showOnlyStrength) {
        Vector<Object> arrProposals = null;
        if (rx != null && rx.trim().length() > 2) {
            String med = ca.infodata.util1.StringUtils.removeAccent((String)rx.toUpperCase());
            arrProposals = Boolean.TRUE.equals(showOnlyStrength) ? this.rxDrugRef.listTeneursForIngredient(med, null) : (med.charAt(0) == '+' ? this.rxDrugRef.getDrugsFromTherapeuticClass(med.substring(1) + ";fr") : this.rxDrugRef.searchDrugs(med));
        }
        return arrProposals == null ? new Vector() : arrProposals;
    }

    private ActionResult aiGenerateEncSumary(IServerRequest req) {
        CUidObject postBody = req.getPostBody(CUidObject.class);
        CEncounter enc = postBody.getObject(CEncounter.class);
        Integer idEncAnc = req.getQueryParam("idEncAnc", Integer.class);
        Integer idPat = req.getQueryParam("idPat", Integer.class);
        String encInJsonString = req.getQueryParam("encInJsonString", String.class);
        ReturnObject ro = this.encounterAccessor.aiGenerateEncSumary(idEncAnc, idPat, encInJsonString);
        String encSum = null;
        if (ro.getStatus().isOK() && ro.getObj() != null && ro.getObj() instanceof byte[]) {
            encSum = (String)LZMAClientSerialiser.deserialize((byte[])((byte[])ro.getObj()), (boolean)false);
        }
        if (encSum != null) {
            return ServerResponses.toJsonActionResult(encSum);
        }
        return ServerResponses.ERROR("Sommaire vide");
    }

    public static class CImportance
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Integer id;
        public Integer idPatient;
        public Integer importance;
        public String type;

        public String toString() {
            return this.id + ":" + this.importance + ":" + this.type;
        }
    }

    public class EncounterFaxPrint {
        public CEncounter enc;
        public String nip;
        public FaxData faxdata;
        public ArrayList<RxDevicePrint> pageWithItems;
    }

    class FoundNotFoundRx {
        Set<String> dins;
        Set<String> rxNotFound;

        FoundNotFoundRx() {
        }
    }

    class GetInteractions {
        ArrayList<CEncounter.Prescription> profile;

        GetInteractions() {
        }
    }

    public static class CUidObject
    extends JsonAsMap {
        public CUidObject() {
        }

        public CUidObject(Map<String, Object> source) {
            super(source);
        }

        public String getUid() {
            return this.get("u", String.class);
        }

        public void setUid(String uid) {
            this.put("u", uid);
        }

        public Object getObject() {
            return this.get("o", Object.class);
        }

        public <T> T getObject(Class<T> c) {
            return this.get("o", c);
        }

        public void setObject(Object o) {
            this.put("o", o);
        }

        public String getType() {
            return this.get("t", String.class);
        }

        public void setType(String t) {
            this.put("t", t);
        }
    }
}

