/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.city.City;
import ca.infodata.ofys.city.FindCityCriteria;
import ca.infodata.ofys.city.ICityIndex;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.XCitizenship;
import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.ui.dashboard.accessor.CompletionComboSyncAccessor;
import ca.infodata.ofys.ui.dashboard.models.CCitizenship;
import ca.infodata.ofys.ui.dashboard.models.CCity;
import ca.infodata.ofys.ui.dashboard.models.CCountry;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CProvince;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompletionController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(CompletionController.class.getName());
    private CompletionComboSyncAccessor completionAccessor = new CompletionComboSyncAccessor();

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/Complete/ws", RouterFunctions.routeAction("/data", req -> {
            String type = req.getQueryParam("type");
            List<?> data = this.completionAccessor.findAllCompletionComboType(type);
            return ServerResponses.toJsonActionResult(this.convertToC(data));
        }), RouterFunctions.routeAction("/city", req -> {
            String q = req.getQueryParam("q");
            Integer limit = req.getQueryParam("limit", Integer.class);
            List<City> cities = this.getCityCompletion(q, limit);
            return ServerResponses.toJsonActionResult(cities);
        }));
    }

    public List convertToC(List xList) {
        CEditableDataObjectList<Object> res = null;
        if (xList.size() > 0) {
            if (xList.get(0) instanceof XCity) {
                res = new CEditableDataObjectList<CCity>(xList, CCity.class);
            } else if (xList.get(0) instanceof XProvince) {
                res = new CEditableDataObjectList<CProvince>(xList, CProvince.class);
            } else if (xList.get(0) instanceof XCountry) {
                res = new CEditableDataObjectList<CCountry>(xList, CCountry.class);
            } else if (xList.get(0) instanceof XCitizenship) {
                ArrayList<CCitizenship> rescitizen = new ArrayList<CCitizenship>();
                for (int i = 0; i < xList.size(); ++i) {
                    rescitizen.add(new CCitizenship((XCitizenship)xList.get(i)));
                }
                return rescitizen;
            }
        } else {
            res = new CEditableDataObjectList();
        }
        return res;
    }

    public List<City> getCityCompletion(String q, int limit) {
        try {
            FindCityCriteria c = new FindCityCriteria();
            c.setText(q);
            c.setLimit(limit);
            if (Application.get().getGlobalInstances().isNBClient()) {
                c.setOrdering(ICityIndex.ORDERING.NB);
            } else {
                c.setOrdering(ICityIndex.ORDERING.QC);
            }
            return Application.get().getCityIndex().findCities(c);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error finding city", e);
            return null;
        }
    }
}

