/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.template;

import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.TypeDeDonnee;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DList
extends DField {
    public String separator = ", ";
    public String[] items = new String[0];
    public Boolean multiple;
    public TypeDeDonnee typeDeDonnee = TypeDeDonnee.S_O;
    public int defaultItem = -1;
    public static Pattern pattern = Pattern.compile("<list\\s*" + nameRegExp + "(separator=\\\"([\\s\\w,:/-/.]+)\\\")?\\s*(multiple=(0|1))?\\s*(typeDeDonnee=(\\d+))?\\s*(required)?\\s*(defaultItem=(\\d+))?>(" + regExpForItems + ")</list>");

    public DList() {
    }

    public DList(String name, String separator, boolean required, Boolean multiple, TypeDeDonnee typeDonnee, String ... e) {
        this.name = name;
        this.separator = StringUtils.isEmpty((String)separator) ? " " : separator;
        this.multiple = multiple;
        this.typeDeDonnee = typeDonnee == null ? TypeDeDonnee.S_O : typeDonnee;
        this.required = required;
        if (e != null) {
            this.items = e;
        }
    }

    public static List<DField> parse(String text) {
        ArrayList<DField> list = new ArrayList<DField>();
        Matcher matcher = pattern.matcher(text);
        int start = 0;
        while (matcher.find(start)) {
            DList d = new DList();
            d.start = matcher.start();
            d.end = matcher.end();
            d.name = matcher.group(2);
            d.separator = matcher.group(4);
            d.multiple = matcher.group(6) == null ? null : new Boolean(Integer.parseInt(matcher.group(6)) == 1);
            d.typeDeDonnee = matcher.group(8) == null ? null : TypeDeDonnee.from(Integer.parseInt(matcher.group(8)));
            d.required = StringUtils.isNotBlank((String)matcher.group(9));
            String defItem = matcher.group(11);
            try {
                d.defaultItem = defItem == null ? -1 : Integer.parseInt(defItem);
            }
            catch (NumberFormatException e) {
                d.defaultItem = -1;
            }
            String elements = matcher.group(12);
            d.items = elements.split(";");
            list.add(d);
            start = matcher.end();
        }
        return list;
    }

    @Override
    public String format() {
        String s = "<list name=\"" + this.name + "\" ";
        if (StringUtils.isEmpty((String)this.separator)) {
            this.separator = " ";
        }
        s = s + "separator=\"" + this.separator + "\" ";
        if (this.multiple != null) {
            s = s + "multiple=" + (this.multiple != false ? 1 : 0) + " ";
        }
        if (this.typeDeDonnee != null) {
            s = s + "typeDeDonnee=" + this.typeDeDonnee.getValue() + " ";
        }
        if (this.required) {
            s = s + "required ";
        }
        s = this.defaultItem != -1 ? s + "defaultItem=" + this.defaultItem : s.trim();
        s = s + ">";
        s = s + new JoinList(";", (Object[])this.items);
        s = s + "</list>";
        return s;
    }

    @Override
    public String formatMedo() {
        String s = "${" + this.name + ";";
        s = s + new JoinList("/", (Object[])this.items);
        s = s + "}";
        return s;
    }
}

