/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.GetImagingResultExamReportController;
import ca.infodata.ofys.client.web.controller.DocumentsController;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedDocument;
import ca.infodata.ofys.data.middle.dataobjects.dsq.imaging.XImagingResultExamResponse;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.dashboard.models.CDsqRequest;
import ca.infodata.ofys.ui.dashboard.models.CImagingResultExam;
import ca.infodata.ofys.ui.dashboard.models.CPatientImage;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetImagingResultExamReportControllerWeb {
    private static final Logger logger = Logger.getLogger(GetImagingResultExamReportControllerWeb.class.getName());
    private static final String channelName = "dsq.doc.item";
    private final DocumentsController documentsController;
    private final GetImagingResultExamReportController imageController;
    private final Integer idPatient;
    private final IWebSocketChannel wsChannel;

    public GetImagingResultExamReportControllerWeb(Integer idPatient, IWebSocketChannel wsChannel, GetCandidateController findCandidateController, DocumentsController documentsController) {
        this.idPatient = idPatient;
        this.wsChannel = wsChannel;
        this.documentsController = documentsController;
        this.imageController = new GetImagingResultExamReportController(idPatient, findCandidateController){

            @Override
            protected void callback(DsqCallback<XImagingResultExamResponse> dsqCallback, int reportIndex) {
                GetImagingResultExamReportControllerWeb.this.callback(dsqCallback, reportIndex);
            }
        };
    }

    public void get(CDsqRequest dsqRequest) throws Exception {
        if (dsqRequest == null) {
            throw new NullPointerException("dsqRequest");
        }
        if (dsqRequest.patientId == null) {
            throw new NullPointerException("dsqRequest.patientId");
        }
        if (!dsqRequest.patientId.equals(this.idPatient)) {
            throw new IllegalArgumentException("dsqRequest.patientId != controller.patient.id");
        }
        try {
            this.imageController.setStudyIdentifier(dsqRequest.dsqImagingResultExam.res.id);
            this.imageController.setReportIndex(dsqRequest.index == null ? 0 : dsqRequest.index);
            MultiStatus status = this.imageController.valid();
            if (status.isOK()) {
                this.imageController.get();
            } else {
                ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject(status));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while getting imaging result exam report", e);
            Status status = new Status(IStatus.Severity.ERROR, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]));
            ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject((Serializable)status));
        }
    }

    protected void callback(DsqCallback<XImagingResultExamResponse> dsqCallback, int reportIndex) {
        XImagingResultExamResponse response;
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        if (dsqCallback.exception != null) {
            MultiStatus ms1 = new MultiStatus();
            ms1.setSeverity(IStatus.Severity.ERROR);
            ms1.setMessage(dsqCallback.message + dsqCallback.exception.getMessage().trim());
            ms.add((IStatus)ms1);
        }
        if ((response = (XImagingResultExamResponse)dsqCallback.result) != null) {
            CPatientImage cimage = new CPatientImage();
            try {
                cimage.idPatient = this.idPatient;
                cimage.name = response.imagingResultExam.code.text;
                cimage.dsqImagingResultExam = new CImagingResultExam(((XImagingResultExamResponse)dsqCallback.result).imagingResultExam);
                cimage.picture = ((XFinishedDocument)response.viewReport.getDocuments().get((int)reportIndex)).data;
                String docId = "DSQImagingResultExam" + ((XImagingResultExamResponse)dsqCallback.result).imagingResultExam.id.extension + "_reportIndex" + reportIndex;
                cimage = this.documentsController.getCPatientImage(docId, cimage);
                ms.setSeverity(IStatus.Severity.OK);
                ro.setObj((Object)cimage);
            }
            catch (Exception e) {
                ms.setSeverity(IStatus.Severity.ERROR);
                ms.setMessage("Erreur de g\u00e9n\u00e9ration du document DSQ. Si le probl\u00e8me persiste veuillez contacter infodata");
                logger.log(Level.SEVERE, "Failed to generate print pdf for dsq imaging result exam header.", e);
            }
        }
        ro.setStatus(ms);
        ServerResponses.sendJsonToClient(this.wsChannel, channelName, ro);
    }
}

