/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.job;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IJob;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.JobStatus;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Job
implements IJob<Void>,
IProgressMonitor,
Runnable {
    private static final Logger logger = Logger.getLogger(Job.class.getName());
    private JobStatus status;
    private int totalWork;
    private final String name;
    private final Consumer<IProgressMonitor> consumer;
    private final Supplier<?> supplier;
    private long delay;
    private TimeUnit delayUnit;

    public Job(String name) {
        this(name, null, null);
    }

    public Job(String name, Consumer<IProgressMonitor> consumer) {
        this(name, null, consumer);
    }

    public Job(String name, Supplier<?> supplier) {
        this(name, supplier, null);
    }

    protected Job(String name, Supplier<?> supplier, Consumer<IProgressMonitor> consumer) {
        this.name = name;
        this.supplier = supplier;
        this.consumer = consumer;
        this.status = JobStatus.INITIALIZED;
        this.delay = 0L;
        this.delayUnit = null;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getDelayUnit() {
        return this.delayUnit;
    }

    public void setDelayUnit(TimeUnit delayUnit) {
        this.delayUnit = delayUnit;
    }

    @Override
    public final Void call() throws Exception {
        if (this.consumer != null) {
            this.consumer.accept(this);
        } else if (this.supplier != null) {
            this.supplier.get();
        } else {
            this.runWithException();
        }
        return null;
    }

    @Override
    public final void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to execute Job " + this, e);
            this.changeStatus(JobStatus.FAILED);
        }
    }

    protected void runWithException() throws Exception {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JobStatus getStatus() {
        return this.status;
    }

    @Override
    public JobStatus getState() {
        return this.status;
    }

    @Override
    public void beginTask(String taskName, int totalWork) {
        this.totalWork = totalWork;
        this.changeStatus(JobStatus.RUNNING);
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    @Override
    public void worked(int worked) {
        ++this.totalWork;
        this.changeStatus(JobStatus.RUNNING);
    }

    @Override
    public void subTask(String subTaskName) {
        this.changeStatus(JobStatus.RUNNING);
    }

    @Override
    public IProgressMonitor subMonitor(int totalWork) {
        this.totalWork += totalWork;
        return this;
    }

    @Override
    public void done() {
        this.changeStatus(JobStatus.DONE);
    }

    @Override
    public void cancel() {
        this.changeStatus(JobStatus.CANCELING);
    }

    @Override
    public void changeStatus(JobStatus newStatus) {
        switch (newStatus) {
            case DONE: {
                if (this.status == JobStatus.CANCELING) {
                    this.status = JobStatus.CANCELED;
                    break;
                }
                this.status = JobStatus.DONE;
                break;
            }
            default: {
                this.status = newStatus;
            }
        }
    }

    @Override
    public void schedule() throws Exception {
        this.scheduleAfter(this.delay, this.delayUnit);
    }

    @Override
    public void scheduleAfter(long delay, TimeUnit delayUnit) throws Exception {
        if (delay > 0L && delayUnit != null) {
            Application.get().getJobExecutor().schedule(this, delay, delayUnit);
        } else {
            Application.get().getJobExecutor().schedule(this);
        }
    }

    @Override
    public boolean isCanceled() {
        return this.getState() == JobStatus.CANCELED;
    }

    public String toString() {
        return "Job [status=" + (Object)((Object)this.status) + ", totalWork=" + this.totalWork + ", name=" + this.name + ", consumer=" + this.consumer + ", supplier=" + this.supplier + "]";
    }

    @Override
    public void log(Level level, String message) {
    }
}

