/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.gson.impl;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.TimeZoneProvider;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

public class CalendarTypeAdapter
extends TypeAdapter<Calendar> {
    public Calendar read(JsonReader reader) throws IOException {
        String source = null;
        try {
            source = reader.nextString();
            if (StringUtils.isBlank((CharSequence)source)) {
                return null;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        try {
            return this.readDefaultFormat(source);
        }
        catch (Exception e) {
            try {
                return this.readAlternativeFormat(source);
            }
            catch (Exception e2) {
                try {
                    return this.readAlternativeFormat2(source);
                }
                catch (Exception e3) {
                    throw new IOException(e);
                }
            }
        }
    }

    private Calendar readDefaultFormat(String source) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf.parse(source);
        Calendar calendar = Calendar.getInstance(TimeZoneProvider.getTimeZone(), LocaleProvider.getLocale());
        calendar.setTime(date);
        return calendar;
    }

    private Calendar readAlternativeFormat(String source) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        Date date = sdf.parse(source);
        Calendar calendar = Calendar.getInstance(TimeZoneProvider.getTimeZone(), LocaleProvider.getLocale());
        calendar.setTime(date);
        return calendar;
    }

    private Calendar readAlternativeFormat2(String source) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdf.parse(source);
        Calendar calendar = Calendar.getInstance(TimeZoneProvider.getTimeZone(), LocaleProvider.getLocale());
        calendar.setTime(date);
        return calendar;
    }

    public void write(JsonWriter writer, Calendar value) throws IOException {
        if (value == null) {
            writer.nullValue();
        } else {
            String text = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss", (TimeZone)TimeZoneProvider.getTimeZone(), (Locale)LocaleProvider.getLocale()).format(value);
            writer.value(text);
        }
    }
}

