/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.subscribe;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscriptionBuilder;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5RetainHandling;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5SubscribeBuilder;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscription;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class MqttSubscribeBuilder<B extends MqttSubscribeBuilder<B>> {
    private final @NotNull ImmutableList.Builder<MqttSubscription> subscriptionsBuilder;
    @NotNull
    private MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.NO_USER_PROPERTIES;
    private  @Nullable MqttSubscriptionBuilder.Default firstSubscriptionBuilder;

    protected MqttSubscribeBuilder() {
        this.subscriptionsBuilder = ImmutableList.builder();
    }

    MqttSubscribeBuilder(@NotNull MqttSubscribe subscribe) {
        List subscriptions = subscribe.getSubscriptions();
        this.subscriptionsBuilder = ImmutableList.builder(subscriptions.size() + 1);
        this.subscriptionsBuilder.addAll(subscriptions);
    }

    @NotNull
    protected abstract B self();

    @NotNull
    public B addSubscription(@Nullable Mqtt5Subscription subscription) {
        this.buildFirstSubscription();
        this.subscriptionsBuilder.add(Checks.notImplemented(subscription, MqttSubscription.class, "Subscription"));
        return this.self();
    }

    public  @NotNull MqttSubscriptionBuilder.Nested<B> addSubscription() {
        return new MqttSubscriptionBuilder.Nested<MqttSubscribeBuilder>(this::addSubscription);
    }

    @NotNull
    public B addSubscriptions(Mqtt5Subscription ... subscriptions) {
        Checks.notNull(subscriptions, "Subscriptions");
        this.buildFirstSubscription();
        this.subscriptionsBuilder.ensureFree(subscriptions.length);
        for (Mqtt5Subscription subscription : subscriptions) {
            this.addSubscription(subscription);
        }
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B addSubscriptions(@Nullable @Nullable Collection<@Nullable ? extends Mqtt5Subscription> subscriptions) {
        Checks.notNull(subscriptions, "Subscriptions");
        this.buildFirstSubscription();
        this.subscriptionsBuilder.ensureFree(subscriptions.size());
        subscriptions.forEach(this::addSubscription);
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B addSubscriptions(@Nullable @Nullable Stream<@Nullable ? extends Mqtt5Subscription> subscriptions) {
        Checks.notNull(subscriptions, "Subscriptions");
        this.buildFirstSubscription();
        subscriptions.forEach(this::addSubscription);
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B userProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = MqttChecks.userProperties(userProperties);
        return this.self();
    }

    public @NotNull MqttUserPropertiesImplBuilder.Nested<B> userProperties() {
        return new MqttUserPropertiesImplBuilder.Nested<MqttSubscribeBuilder>(this.userProperties, this::userProperties);
    }

    private  @NotNull MqttSubscriptionBuilder.Default getFirstSubscriptionBuilder() {
        if (this.firstSubscriptionBuilder == null) {
            this.firstSubscriptionBuilder = new MqttSubscriptionBuilder.Default();
        }
        return this.firstSubscriptionBuilder;
    }

    private void buildFirstSubscription() {
        if (this.firstSubscriptionBuilder != null) {
            this.subscriptionsBuilder.add((MqttSubscription)this.firstSubscriptionBuilder.build());
            this.firstSubscriptionBuilder = null;
        }
    }

    @NotNull
    public B topicFilter(@Nullable String topicFilter) {
        this.getFirstSubscriptionBuilder().topicFilter(topicFilter);
        return this.self();
    }

    @NotNull
    public B topicFilter(@Nullable MqttTopicFilter topicFilter) {
        this.getFirstSubscriptionBuilder().topicFilter(topicFilter);
        return this.self();
    }

    public @NotNull MqttTopicFilterImplBuilder.Nested<B> topicFilter() {
        return new MqttTopicFilterImplBuilder.Nested<MqttSubscribeBuilder>(this::topicFilter);
    }

    @NotNull
    public B qos(@Nullable MqttQos qos) {
        this.getFirstSubscriptionBuilder().qos(qos);
        return this.self();
    }

    @NotNull
    public B noLocal(boolean noLocal) {
        this.getFirstSubscriptionBuilder().noLocal(noLocal);
        return this.self();
    }

    @NotNull
    public B retainHandling(@Nullable Mqtt5RetainHandling retainHandling) {
        this.getFirstSubscriptionBuilder().retainHandling(retainHandling);
        return this.self();
    }

    @NotNull
    public B retainAsPublished(boolean retainAsPublished) {
        this.getFirstSubscriptionBuilder().retainAsPublished(retainAsPublished);
        return this.self();
    }

    private void ensureAtLeastOneSubscription() {
        Checks.state(this.subscriptionsBuilder.getSize() > 0, "At least one subscription must be added.");
    }

    @NotNull
    public MqttSubscribe build() {
        this.buildFirstSubscription();
        this.ensureAtLeastOneSubscription();
        return new MqttSubscribe(this.subscriptionsBuilder.build(), this.userProperties);
    }

    public static abstract class Publishes<P>
    extends MqttSubscribeBuilder<Publishes<P>>
    implements Mqtt5SubscribeBuilder.Publishes.Start.Complete<P>,
    Mqtt5SubscribeBuilder.Publishes.Args<P> {
        protected boolean manualAcknowledgement;

        @Override
        @NotNull
        protected Publishes<P> self() {
            return this;
        }

        @Override
        @NotNull
        public Publishes<P> manualAcknowledgement(boolean manualAcknowledgement) {
            this.manualAcknowledgement = manualAcknowledgement;
            return this;
        }
    }

    public static class Send<P>
    extends MqttSubscribeBuilder<Send<P>>
    implements Mqtt5SubscribeBuilder.Send.Start.Complete<P> {
        @NotNull
        private final Function<? super MqttSubscribe, P> parentConsumer;

        public Send(@NotNull Function<? super MqttSubscribe, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        protected Send<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P send() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Nested<P>
    extends MqttSubscribeBuilder<Nested<P>>
    implements Mqtt5SubscribeBuilder.Nested.Start.Complete<P> {
        @NotNull
        private final Function<? super MqttSubscribe, P> parentConsumer;

        public Nested(@NotNull Function<? super MqttSubscribe, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        protected Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applySubscribe() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttSubscribeBuilder<Default>
    implements Mqtt5SubscribeBuilder.Start.Complete {
        public Default() {
        }

        Default(@NotNull MqttSubscribe subscribe) {
            super(subscribe);
        }

        @Override
        @NotNull
        protected Default self() {
            return this;
        }
    }
}

