/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.connect;

import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuthBuilder;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictionsBuilder;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublishBuilder;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.mqtt5.auth.Mqtt5EnhancedAuthMechanism;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuth;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5ConnectBuilder;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5ConnectRestrictions;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import java.util.function.Function;

public abstract class MqttConnectBuilder<B extends MqttConnectBuilder<B>> {
    private int keepAlive = 60;
    private boolean cleanStart = true;
    private long sessionExpiryInterval = 0L;
    @NotNull
    private MqttConnectRestrictions restrictions = MqttConnectRestrictions.DEFAULT;
    @Nullable
    private MqttSimpleAuth simpleAuth;
    @Nullable
    private Mqtt5EnhancedAuthMechanism enhancedAuthMechanism;
    @Nullable
    private MqttWillPublish willPublish;
    @NotNull
    private MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.NO_USER_PROPERTIES;

    MqttConnectBuilder() {
    }

    MqttConnectBuilder(@NotNull MqttConnect connect) {
        this.keepAlive = connect.getKeepAlive();
        this.cleanStart = connect.isCleanStart();
        this.sessionExpiryInterval = connect.getSessionExpiryInterval();
        this.restrictions = connect.getRestrictions();
        this.simpleAuth = connect.getRawSimpleAuth();
        this.enhancedAuthMechanism = connect.getRawEnhancedAuthMechanism();
        this.willPublish = connect.getRawWillPublish();
        this.userProperties = connect.getUserProperties();
    }

    @NotNull
    abstract B self();

    @NotNull
    public B keepAlive(int keepAlive) {
        this.keepAlive = Checks.unsignedShort(keepAlive, "Keep alive");
        return this.self();
    }

    @NotNull
    public B noKeepAlive() {
        this.keepAlive = 0;
        return this.self();
    }

    @NotNull
    public B cleanStart(boolean cleanStart) {
        this.cleanStart = cleanStart;
        return this.self();
    }

    @NotNull
    public B sessionExpiryInterval(long sessionExpiryInterval) {
        this.sessionExpiryInterval = Checks.unsignedInt(sessionExpiryInterval, "Session expiry interval");
        return this.self();
    }

    @NotNull
    public B noSessionExpiry() {
        this.sessionExpiryInterval = 0xFFFFFFFFL;
        return this.self();
    }

    @NotNull
    public B restrictions(@Nullable Mqtt5ConnectRestrictions restrictions) {
        this.restrictions = Checks.notImplemented(restrictions, MqttConnectRestrictions.class, "Connect restrictions");
        return this.self();
    }

    public  @NotNull MqttConnectRestrictionsBuilder.Nested<B> restrictions() {
        return new MqttConnectRestrictionsBuilder.Nested<MqttConnectBuilder>(this.restrictions, this::restrictions);
    }

    @NotNull
    public B simpleAuth(@Nullable Mqtt5SimpleAuth simpleAuth) {
        this.simpleAuth = Checks.notImplementedOrNull(simpleAuth, MqttSimpleAuth.class, "Simple auth");
        return this.self();
    }

    public @NotNull MqttSimpleAuthBuilder.Nested<B> simpleAuth() {
        return new MqttSimpleAuthBuilder.Nested<MqttConnectBuilder>(this::simpleAuth);
    }

    @NotNull
    public B enhancedAuth(@Nullable Mqtt5EnhancedAuthMechanism enhancedAuthMechanism) {
        this.enhancedAuthMechanism = enhancedAuthMechanism;
        return this.self();
    }

    @NotNull
    public B willPublish(@Nullable Mqtt5Publish willPublish) {
        this.willPublish = willPublish == null ? null : Checks.notImplemented(willPublish, MqttPublish.class, "Will publish").asWill();
        return this.self();
    }

    public  @NotNull MqttPublishBuilder.WillNested<B> willPublish() {
        return new MqttPublishBuilder.WillNested<MqttConnectBuilder>(this::willPublish);
    }

    @NotNull
    public B userProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = MqttChecks.userProperties(userProperties);
        return this.self();
    }

    public @NotNull MqttUserPropertiesImplBuilder.Nested<B> userProperties() {
        return new MqttUserPropertiesImplBuilder.Nested<MqttConnectBuilder>(this.userProperties, this::userProperties);
    }

    @NotNull
    public MqttConnect build() {
        return new MqttConnect(this.keepAlive, this.cleanStart, this.sessionExpiryInterval, this.restrictions, this.simpleAuth, this.enhancedAuthMechanism, this.willPublish, this.userProperties);
    }

    public static class Send<P>
    extends MqttConnectBuilder<Send<P>>
    implements Mqtt5ConnectBuilder.Send<P> {
        @NotNull
        private final Function<? super MqttConnect, P> parentConsumer;

        public Send(@NotNull Function<? super MqttConnect, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Send<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P send() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Nested<P>
    extends MqttConnectBuilder<Nested<P>>
    implements Mqtt5ConnectBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttConnect, P> parentConsumer;

        public Nested(@NotNull Function<? super MqttConnect, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        public Nested(@NotNull MqttConnect connect, @NotNull Function<? super MqttConnect, P> parentConsumer) {
            super(connect);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyConnect() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttConnectBuilder<Default>
    implements Mqtt5ConnectBuilder {
        public Default() {
        }

        Default(@NotNull MqttConnect connect) {
            super(connect);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

