/*
 * Decompiled with CFR 0.152.
 */
package parser;

import ca.infodata.readhl7.MessageHandler;
import ca.infodata.readhl7.UtilDateUtilities;
import ca.infodata.readhl7.tools.Utils;
import ca.infodata.util1.JoinList;
import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.ExtraComponents;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Variable;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v26.datatype.ED;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.model.v26.datatype.XPN;
import ca.uhn.hl7v2.model.v26.datatype.XTN;
import ca.uhn.hl7v2.model.v26.group.ORU_R01_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v26.message.ORU_R01;
import ca.uhn.hl7v2.parser.CanonicalModelClassFactory;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class ORU_R01v26Handler
implements MessageHandler {
    private final boolean isTest = false;
    ORU_R01 msg = null;
    private Terser terser;
    Logger logger = Logger.getLogger(ORU_R01v26Handler.class.getName());

    @Override
    public void init(String hl7Body) throws HL7Exception {
        DefaultHapiContext context = new DefaultHapiContext();
        CanonicalModelClassFactory mcf = new CanonicalModelClassFactory("2.6");
        context.setModelClassFactory(mcf);
        PipeParser p = context.getPipeParser();
        p.getParserConfiguration().setValidating(false);
        this.msg = (ORU_R01)p.parse(hl7Body);
        this.terser = new Terser(this.msg);
        try {
            context.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getMsgType() {
        return "ORU_R01";
    }

    @Override
    public String getPrelDate() {
        try {
            ArrayList<String> lst = new ArrayList<String>();
            List<ORU_R01_ORDER_OBSERVATION> orderObserv = this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONAll();
            for (ORU_R01_ORDER_OBSERVATION ord : orderObserv) {
                String s = this.getString(ord.getOBR().getObr7_ObservationDateTime().getValue());
                boolean b = StringUtils.isNotEmpty(s) ? lst.add(s) : false;
                s = this.getString(ord.getORC().getOrc9_DateTimeOfTransaction().getValue());
                b = StringUtils.isNotEmpty(s) ? lst.add(s) : false;
            }
            Collections.sort(lst);
            return this.formatDateTime((String)lst.get(0));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not retrieve message date", e);
            return "";
        }
    }

    @Override
    public String getMsgDate() {
        try {
            ArrayList<String> lst = new ArrayList<String>();
            String s = this.getString(this.msg.getMSH().getMsh7_DateTimeOfMessage().getValue());
            boolean b = StringUtils.isNotEmpty(s) ? lst.add(s) : false;
            List<ORU_R01_ORDER_OBSERVATION> orderObserv = this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONAll();
            for (ORU_R01_ORDER_OBSERVATION ord : orderObserv) {
                s = this.getString(ord.getOBR().getObr6_RequestedDateTime().getValue());
                b = StringUtils.isNotEmpty(s) ? lst.add(s) : false;
                s = this.getString(ord.getOBR().getObr8_ObservationEndDateTime().getValue());
                b = StringUtils.isNotEmpty(s) ? lst.add(s) : false;
                s = this.getString(ord.getORC().getOrc15_OrderEffectiveDateTime().getValue());
                b = StringUtils.isNotEmpty(s) ? lst.add(s) : false;
            }
            Collections.sort(lst);
            return this.formatDateTime((String)lst.get(lst.size() - 1));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not retrieve message date", e);
            return "";
        }
    }

    @Override
    public String getMsgPriority() {
        return "";
    }

    @Override
    public int getOBRCount() {
        return this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
    }

    @Override
    public int getOBXCount(int i) {
        try {
            return this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATIONReps();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBRName(int i) {
        try {
            String obr3 = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getUniversalServiceIdentifier().getText().getValue());
            String obr26_0 = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getParentResult().getParentObservationIdentifier().getText().getValue());
            return obr3 + (obr26_0.length() == 0 ? "" : " " + obr26_0);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getTimeStamp(int i, int j) {
        try {
            String status = "";
            try {
                status = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationResultStatus().getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (status.equalsIgnoreCase("I")) {
                return "";
            }
            status = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getDateTimeOfTheAnalysis().getValue());
            if (StringUtils.isEmpty(status)) {
                status = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getDateTimeOfTheObservation().getValue());
            }
            return this.formatDateTime(status);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean isOBXAbnormal(int i, int j) {
        try {
            return this.getOBXAbnormalFlag(i, j).equals("A");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getOBXAbnormalFlag(int i, int j) {
        try {
            IS[] af = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getAbnormalFlags();
            StringBuilder sb = new StringBuilder();
            for (IS is : af) {
                Variable var;
                String data = null;
                ExtraComponents ec = is.getExtraComponents();
                if (ec != null && !ec.isEmpty() && (var = ec.getComponent(0)) != null && !var.isEmpty()) {
                    data = var.getData().toString();
                }
                if (data == null) {
                    sb.append(is.getValue()).append(" ");
                    continue;
                }
                sb.append(data).append(" ");
            }
            return this.getString(sb.toString().trim());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBRSpecimen(int i) {
        try {
            String collMethod = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getObr15_SpecimenSource().getSpecimenCollectionMethod().getValue());
            String source = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getObr15_SpecimenSource().getSpecimenSourceNameOrCode().getCwe2_Text().getValue());
            String site = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getObr15_SpecimenSource().getSps4_BodySite().getCwe2_Text().getValue());
            String spec = new ca.infodata.readhl7.tools.JoinList(" - ", source, site, collMethod).toString().trim();
            if (spec.toLowerCase().equals("whole blood") || spec.toLowerCase().equals("urine")) {
                return "";
            }
            return spec;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getObservationHeader(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getDiagnosticServSectID().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXIdentifier(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXLoincIdentifier(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getAlternateIdentifier().getValueOrEmpty());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXValueType(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getValueType().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXName(int i, int j) {
        try {
            String name = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getText().getValueOrEmpty());
            if (name.length() == 0) {
                name = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getComponent(0).toString());
            }
            return name;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResult(int i, int j) {
        String result = "";
        try {
            JoinList sb = new JoinList(this.getOBXValueType(i, j).equals("TX") ? "\n" : " ");
            int m = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationValueReps();
            for (int k = 0; k < m; ++k) {
                String s = Terser.get(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 1, 1);
                String ss = Terser.get(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 2, 1);
                String sss = Terser.get(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 3, 1);
                String ssss = Terser.get(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 4, 1);
                if (ss != null) {
                    s = s != null && s.matches("[+#A-Z0-9,]*") ? ss : (s == null ? "" : s + " ") + ss;
                }
                if (s != null) {
                    sb.add(s);
                }
                if (sss != null && !sss.endsWith("TDCHU")) {
                    sb.add(sss);
                }
                if (ssss == null) continue;
                sb.add(ssss);
            }
            result = sb.toString();
        }
        catch (Exception e) {
            return "";
        }
        return result;
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getReferencesRange().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXUnits(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getUnits().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResultStatus(int i, int j) {
        String status = "";
        try {
            status = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationResultStatus().getValue());
            if (status.equalsIgnoreCase("I")) {
                status = "Attente";
            } else if (status.equalsIgnoreCase("F")) {
                status = "Final";
            } else if (status.equalsIgnoreCase("C")) {
                status = "Comm.";
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx result status", e);
            return status;
        }
        return status;
    }

    @Override
    public String getOBXEquipment(int i, int j) {
        String s = "";
        try {
            EI[] equipmentInstanceIdentifier = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getEquipmentInstanceIdentifier();
            if (equipmentInstanceIdentifier != null && equipmentInstanceIdentifier.length > 0) {
                s = equipmentInstanceIdentifier[0].getEi2_NamespaceID().getValue();
                s = StringUtils.isBlank(s) ? equipmentInstanceIdentifier[0].getEntityIdentifier().getValue() : s;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx result status", e);
            return s;
        }
        return s;
    }

    @Override
    public int getOBXFinalResultCount() {
        int obrCount = this.getOBRCount();
        int count = 0;
        for (int i = 0; i < obrCount; ++i) {
            int obxCount = this.getOBXCount(i);
            for (int j = 0; j < obxCount; ++j) {
                if (!this.getOBXResultStatus(i, j).equals("Final")) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        try {
            for (int i = 0; i < this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONReps(); ++i) {
                String currentHeader = this.getObservationHeader(i, 0);
                if (headers.contains(currentHeader)) continue;
                headers.add(currentHeader);
            }
            return headers;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not create header list", e);
            return null;
        }
    }

    @Override
    public int getOBRCommentCount(int i) {
        try {
            return this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getNTEReps();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBRComment(int i, int j) {
        try {
            int m = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getNTE(j).getComment().length;
            JoinList jl = new JoinList("\n");
            for (int l = 0; l < m; ++l) {
                String s = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getNTE(j).getComment(l).getValue();
                jl.add(s);
            }
            return Utils.replaceCharToHtmlChar(jl.toString());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getOBXCommentCount(int i, int j) {
        int count = 0;
        try {
            String comment;
            count = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTEReps();
            if (count == 1 && (comment = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE().getComment(0).getValue()) == null) {
                count = 0;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx comment count", e);
        }
        return count;
    }

    @Override
    public String getOBXComment(int i, int j, int k) {
        try {
            int m = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(k).getComment().length;
            JoinList jl = new JoinList("~");
            for (int l = 0; l < m; ++l) {
                String s = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(k).getComment(l).getValue();
                jl.add(s);
            }
            return jl.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXUserCheck(int i, int j) {
        try {
            String userAccCheck = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getUserDefinedAccessChecks().getValue();
            if (StringUtils.isBlank(userAccCheck) || userAccCheck.length() < 4) {
                return "";
            }
            if (userAccCheck.length() > 80) {
                userAccCheck = WordUtils.wrap(userAccCheck, 70);
            }
            return Utils.replaceCharToHtmlChar(userAccCheck);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getPatientName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public String getFirstName() {
        String name = null;
        XPN pid5_PatientName = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientName(0);
        if (pid5_PatientName != null) {
            try {
                this.getClass();
                name = pid5_PatientName.getGivenName().getValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (name == null) {
            name = "Prenom???";
        }
        return name;
    }

    @Override
    public String getLastName() {
        String name = null;
        XPN pid5_PatientName = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientName(0);
        if (pid5_PatientName != null) {
            try {
                this.getClass();
                name = pid5_PatientName.getFamilyName().getSurname().getValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (name == null) {
            name = "Nom???";
        }
        return name;
    }

    @Override
    public String getDOB() {
        try {
            return this.formatDateTime(this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getDateTimeOfBirth().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAge() {
        String age = "N/A";
        String dob = this.getDOB();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = formatter.parse(dob);
            String serviceD = this.getServiceDate();
            Date serviceDate = null;
            if (serviceD != null && (serviceDate = UtilDateUtilities.StringToDate(serviceD)) == null) {
                serviceDate = UtilDateUtilities.getDateFromString(serviceD, "yyyy-MM-dd");
            }
            age = UtilDateUtilities.calcAgeAtDate(date, serviceDate);
        }
        catch (ParseException e) {
            this.logger.log(Level.SEVERE, "Could not get age", e);
        }
        return age;
    }

    @Override
    public String getSex() {
        return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAdministrativeSex().getValue());
    }

    @Override
    public String getHealthNum() {
        try {
            String id;
            int i;
            String nam = null;
            for (i = 0; i < 4 && (id = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList(i).getAssigningAuthority().getNamespaceID().getValue()) != null; ++i) {
                if (!id.startsWith("RAMQ") && !"CANQC".equals(id)) continue;
                nam = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList(i).getIDNumber().getValue();
                break;
            }
            if (nam != null) {
                return nam;
            }
            while (i < 4 && (id = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList(i).getIdentifierTypeCode().getValue()) != null) {
                if (id.startsWith("RAMQ") || "CANQC".equals(id)) {
                    nam = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList(i).getIDNumber().getValue();
                    break;
                }
                ++i;
            }
            if (nam != null) {
                return nam;
            }
            nam = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPid19_SSNNumberPatient().getValue();
            if (nam != null) {
                return nam;
            }
            return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAlternatePatientIDPID()[0].getIDNumber().getValue());
        }
        catch (Exception e) {
            try {
                return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientID().getIDNumber().getValue());
            }
            catch (Exception e1) {
                this.logger.log(Level.SEVERE, "Exception finding health number", e1);
                return "";
            }
        }
    }

    @Override
    public String getFileNum() {
        try {
            int i;
            String no = null;
            String nam = this.getHealthNum();
            ArrayList<String> lst = new ArrayList<String>();
            for (i = 0; i < this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierListReps(); ++i) {
                no = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList(i).getIDNumber().getValue();
                if (!StringUtils.isNotEmpty(no) || no.equals(nam)) continue;
                lst.add(no);
            }
            for (i = 0; i < this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAlternatePatientIDPIDReps(); ++i) {
                no = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAlternatePatientIDPID(i).getIDNumber().getValue();
                if (!StringUtils.isNotEmpty(no) || no.equals(nam)) continue;
                lst.add(no);
            }
            if (!lst.isEmpty()) {
                return new JoinList(", ", lst).toString();
            }
        }
        catch (Exception e) {
            try {
                return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientID().getIDNumber().getValue());
            }
            catch (Exception e1) {
                this.logger.log(Level.SEVERE, "Exception finding health number", e1);
                return "";
            }
        }
        return "";
    }

    @Override
    public String getHomePhone() {
        StringBuilder phone = new StringBuilder(20);
        int i = 0;
        try {
            XTN telHome = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPid13_PhoneNumberHome(i);
            if (telHome != null) {
                if (telHome.getLocalNumber().getValue() != null) {
                    while (i < 5 && telHome != null && telHome.getLocalNumber().getValue() != null) {
                        if (i == 0) {
                            phone.append(this.getPhone(telHome));
                        } else {
                            phone.append(", ").append(this.getPhone(telHome));
                        }
                        telHome = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPid13_PhoneNumberHome(++i);
                    }
                } else {
                    phone.append(telHome.getComponent(0));
                }
            } else {
                return "";
            }
            return phone.toString();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return phone number", e);
            return "";
        }
    }

    private String getPhone(XTN t) {
        return t.getAreaCityCode().getValue() + " " + t.getLocalNumber().getValue();
    }

    @Override
    public String getWorkPhone() {
        StringBuilder phone = new StringBuilder(20);
        int i = 0;
        try {
            XTN telWork = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPid14_PhoneNumberBusiness(i);
            while (i < 5 && telWork != null && telWork.getLocalNumber().getValue() != null) {
                if (i == 0) {
                    phone.append(this.getPhone(telWork));
                } else {
                    phone.append(", ").append(this.getPhone(telWork));
                }
                telWork = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPid14_PhoneNumberBusiness(++i);
            }
            return phone.toString();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return phone number", e);
            return "";
        }
    }

    @Override
    public String getPatientLocation() {
        String loc;
        try {
            loc = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc13_EntererSLocation().getFacility().getNamespaceID().getValue();
            if (StringUtils.isEmpty(loc)) {
                loc = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc17_EnteringOrganization().getCwe1_Identifier().getValue();
            }
            if (StringUtils.isEmpty(loc)) {
                loc = this.getString(this.msg.getMSH().getMsh3_SendingApplication().getHd1_NamespaceID().getValue());
            }
        }
        catch (Exception e) {
            loc = this.getString(this.msg.getMSH().getMsh3_SendingApplication().getHd1_NamespaceID().getValue());
        }
        return loc;
    }

    @Override
    public String getServiceDate() {
        try {
            List<ORU_R01_ORDER_OBSERVATION> orderObserv = this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONAll();
            ArrayList<String> lst = new ArrayList<String>();
            for (ORU_R01_ORDER_OBSERVATION ord : orderObserv) {
                String s = this.getString(ord.getOBR().getObr6_RequestedDateTime().getValue());
                if (StringUtils.isNotEmpty(s)) {
                    lst.add(s);
                    break;
                }
                s = this.getString(ord.getOBR().getObr7_ObservationDateTime().getValue());
                if (StringUtils.isNotEmpty(s)) {
                    lst.add(s);
                    break;
                }
                s = this.getString(ord.getORC().getOrc9_DateTimeOfTransaction().getValue());
                if (StringUtils.isNotEmpty(s)) {
                    lst.add(s);
                    break;
                }
                s = this.getString(ord.getORC().getOrc15_OrderEffectiveDateTime().getValue());
                if (StringUtils.isNotEmpty(s)) {
                    lst.add(s);
                    break;
                }
                s = this.getString(ord.getOBR().getObr8_ObservationEndDateTime().getValue());
                if (!StringUtils.isNotEmpty(s)) continue;
                lst.add(s);
                break;
            }
            Collections.sort(lst);
            return this.formatDateTime((String)lst.get(0));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOrderStatus() {
        try {
            boolean hasAtLeastOne;
            boolean hasInProgress = false;
            boolean hasPartial = false;
            boolean hasFinal = false;
            boolean hasCorrected = false;
            boolean hasCancelled = false;
            int obrCount = this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
            for (int i = 0; i < obrCount; ++i) {
                String vs = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getORC().getOrc5_OrderStatus().getValue());
                if (!StringUtils.isNotBlank(vs)) continue;
                if (vs.equals("A")) {
                    hasPartial = true;
                    continue;
                }
                if (vs.equals("IP")) {
                    hasInProgress = true;
                    continue;
                }
                if (vs.equals("CM")) {
                    hasFinal = true;
                    continue;
                }
                if (vs.equals("CA")) {
                    hasCancelled = true;
                    continue;
                }
                if (!vs.equals("C")) continue;
                hasCorrected = true;
            }
            boolean bl = hasAtLeastOne = hasPartial || hasInProgress || hasFinal || hasCancelled || hasCorrected;
            if (!hasAtLeastOne) {
                for (int i = 0; i < obrCount; ++i) {
                    String s = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getResultStatus().getValue());
                    if (s.startsWith("C")) {
                        hasCorrected = true;
                        continue;
                    }
                    if (s.equals("F")) {
                        hasFinal = true;
                        continue;
                    }
                    if (s.equals("X")) {
                        hasCancelled = true;
                        continue;
                    }
                    hasPartial = true;
                }
            }
            String status = hasCorrected ? "C" : (hasInProgress ? "I" : (hasPartial ? "P" : (hasCancelled ? "A" : (hasFinal ? "F" : ""))));
            return status;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception retrieving order status", e);
            return "";
        }
    }

    @Override
    public String getClientRef() {
        String docNum = "";
        try {
            for (int i = 0; i < 5 && !this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i).getIDNumber().getValue()).equals(""); ++i) {
                docNum = i == 0 ? this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i).getIDNumber().getValue()) : docNum + ", " + this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i).getIDNumber().getValue());
            }
            return docNum;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor id numbers", e);
            return "";
        }
    }

    @Override
    public String getAccessionNum() {
        String accessionNum = "";
        try {
            accessionNum = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getPlacerOrderNumber().getEntityIdentifier().getValue());
            String fillOrder = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getFillerOrderNumber().getEntityIdentifier().getValue());
            if (StringUtils.isNotEmpty(fillOrder) && !accessionNum.equals(fillOrder)) {
                String comma = StringUtils.isNotEmpty(accessionNum) && StringUtils.isNotEmpty(fillOrder) ? ", " : "";
                accessionNum = accessionNum + comma + fillOrder;
            }
            if (StringUtils.isEmpty(accessionNum)) {
                accessionNum = this.msg.getMSH().getMessageControlID().getValueOrEmpty();
            }
            return accessionNum;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return accession number", e);
            return "";
        }
    }

    @Override
    public String getDocName() {
        StringBuilder docName = new StringBuilder(100);
        int i = 0;
        try {
            if (this.msg != null && this.msg.getPATIENT_RESULT() != null && this.msg.getPATIENT_RESULT().getORDER_OBSERVATION() != null && this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR() != null) {
                XCN provider;
                int oOP;
                int reps;
                String temp = this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i));
                while (i < 10 && temp != null && !"".equals(temp) && !"null".equals(temp)) {
                    if (i == 0) {
                        docName.append(temp);
                    } else if (docName.indexOf(temp) == -1) {
                        docName.append(", ").append(temp);
                    }
                    reps = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(++i).getOBR().getOrderingProviderReps();
                    oOP = 0;
                    provider = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getOrderingProvider(oOP++);
                    while (provider.getIDNumber().isEmpty() && ++oOP < reps) {
                        provider = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getOrderingProvider(oOP);
                    }
                    temp = this.getFullDocName(provider);
                }
                if (docName.length() == 0) {
                    i = 0;
                    temp = this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc12_OrderingProvider(i));
                    while (i < 10 && temp != null && !"".equals(temp) && !"null".equals(temp)) {
                        if (i == 0) {
                            docName.append(temp);
                        } else if (docName.indexOf(temp) == -1) {
                            docName.append(", ").append(temp);
                        }
                        reps = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(++i).getORC().getOrc12_OrderingProviderReps();
                        oOP = 0;
                        provider = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getORC().getOrc12_OrderingProvider(oOP++);
                        while (provider.getIDNumber().isEmpty() && ++oOP < reps) {
                            provider = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getORC().getOrc12_OrderingProvider(oOP);
                        }
                        temp = this.getFullDocName(provider);
                    }
                }
            }
            return docName.toString();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor names", e);
            return docName.toString();
        }
    }

    @Override
    public String getCCDocs() {
        StringBuilder docName = new StringBuilder(100);
        int i = 0;
        try {
            String temp = this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i));
            while (i < 10 && temp != null && !"".equals(temp) && !"null".equals(temp)) {
                if (i == 0) {
                    docName.append(temp);
                } else if (docName.indexOf(temp) == -1) {
                    docName.append(", ").append(temp);
                }
                temp = this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(++i));
            }
            return docName.toString();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return cc'ed doctors", e);
            return docName.toString();
        }
    }

    @Override
    public ArrayList<String> getDocNums() {
        ArrayList<String> docNums = new ArrayList<String>();
        try {
            String id;
            String providerId = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(0).getIDNumber().getValue();
            docNums.add(providerId);
            for (int i = 0; i < 10 && (id = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getResultCopiesTo(i).getIDNumber().getValue()) != null; ++i) {
                if (docNums.contains(id)) continue;
                docNums.add(id);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor nums", e);
        }
        return docNums;
    }

    @Override
    public String audit() {
        return "";
    }

    @Override
    public String getSpecimenName(int j) {
        return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(j).getSPECIMEN().getSPM().getSpm7_SpecimenCollectionMethod().getCwe2_Text().getValue());
    }

    @Override
    public String[] getDspLines() {
        String[] lines = null;
        try {
            String ln;
            String s = this.msg.getMessage().encode();
            int l = 1;
            StringReader reader = new StringReader(s);
            BufferedReader br = new BufferedReader(reader);
            ArrayList<String> lst = new ArrayList<String>();
            String dsp = "DSP|" + l + "||";
            while ((ln = br.readLine()) != null) {
                if (!ln.startsWith(dsp)) continue;
                lst.add(ln.substring(dsp.length()).replaceAll(" ", "&nbsp;"));
                dsp = "DSP|" + ++l + "||";
            }
            lines = lst.toArray(new String[0]);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return dsp lines", e);
        }
        return lines;
    }

    @Override
    public String getPdfFromObx55(int j) {
        String s = "";
        int obxReps = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(j).getSPECIMEN().getOBXReps();
        for (int i = 0; i < obxReps + 1; ++i) {
            int valueReps = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(j).getSPECIMEN().getOBX(i).getObx5_ObservationValueReps();
            if (valueReps <= 0) continue;
            for (int k = 0; k < valueReps + 1; ++k) {
                ED ed;
                Varies value = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(j).getSPECIMEN().getOBX(i).getObx5_ObservationValue(k);
                Type type = value.getData();
                if (type == null || !(type instanceof ED) || (ed = (ED)type).getEd5_Data() == null) continue;
                s = ed.getEd5_Data().getValue();
            }
        }
        return s;
    }

    private String getFullDocName(XCN docSeg) {
        if (docSeg == null) {
            return null;
        }
        StringBuilder docName = new StringBuilder(30);
        if (docSeg.getGivenName().getValue() != null) {
            if (docName.length() == 0) {
                docName.append(docSeg.getGivenName().getValue());
            } else {
                docName.append(" ").append(docSeg.getGivenName().getValue());
            }
        }
        if (docSeg.getSecondAndFurtherGivenNamesOrInitialsThereof().getValue() != null) {
            if (docName.length() == 0) {
                docName.append(docSeg.getSecondAndFurtherGivenNamesOrInitialsThereof().getValue());
            } else {
                docName.append(" ").append(docSeg.getSecondAndFurtherGivenNamesOrInitialsThereof().getValue());
            }
        }
        if (docSeg.getFamilyName().getSurname() != null && docSeg.getFamilyName().getSurname().getValue() != null) {
            if (docName.length() == 0) {
                docName.append(docSeg.getFamilyName().getSurname().getValue());
            } else {
                docName.append(" ").append(docSeg.getFamilyName().getSurname().getValue());
            }
        }
        if (docSeg.getXcn1_IDNumber().getValue() != null) {
            if (docName.length() == 0) {
                docName.append(docSeg.getXcn1_IDNumber().getValue());
            } else {
                docName.append(" (").append(docSeg.getXcn1_IDNumber().getValue()).append(")");
            }
        }
        return docName.toString();
    }

    private String formatDateTime(String plain) {
        if (plain == null || plain.trim().length() == 0) {
            return "";
        }
        String dateStr = plain.contains("-") ? plain.split("-")[0] : plain;
        String dateFormat = "yyyyMMddHHmmss";
        dateFormat = dateFormat.substring(0, dateStr.length());
        String stringFormat = "yyyy-MM-dd HH:mm";
        int charAt = dateFormat.charAt(dateFormat.length() - 1);
        if (charAt == 115) {
            charAt = 109;
        }
        int lastIndexOf = stringFormat.lastIndexOf(charAt);
        stringFormat = stringFormat.substring(0, lastIndexOf + 1);
        Date date = UtilDateUtilities.StringToDate(dateStr, dateFormat);
        return UtilDateUtilities.DateToString(date, stringFormat);
    }

    private String getString(String retrieve) {
        if (retrieve != null) {
            retrieve.replaceAll("^", " ");
            return retrieve.trim();
        }
        return "";
    }

    @Override
    public String getPerformingOrganisation(int i, int j) {
        String org = "";
        try {
            XON organizationName = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getPerformingOrganizationName();
            if (organizationName == null || organizationName.isEmpty()) {
                return org;
            }
            org = this.getString(organizationName.getXon1_OrganizationName().getValue());
            XAD organizationAddress = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObx24_PerformingOrganizationAddress();
            if (organizationAddress == null || organizationAddress.isEmpty()) {
                return org;
            }
            org = org + "\n" + organizationAddress.getStreetAddress().getSad1_StreetOrMailingAddress().getValue() + ", " + organizationAddress.getCity().getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return org;
    }
}

