/*
 * Decompiled with CFR 0.152.
 */
package parser;

import ca.infodata.readhl7.UtilDateUtilities;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.message.ORU_R01;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import parser.DefaultGenericHandler;

public class ICLHandler
extends DefaultGenericHandler {
    Logger logger = Logger.getLogger(ICLHandler.class.getName());
    ORU_R01 msg = null;

    @Override
    public void init(String hl7Body) throws HL7Exception {
        PipeParser p = new PipeParser();
        ((Parser)p).setValidationContext(new NoValidation());
        this.msg = (ORU_R01)((Parser)p).parse(hl7Body.replaceAll("\n", "\r\n"));
    }

    @Override
    public String getMsgType() {
        return "ICL";
    }

    @Override
    public String getMsgPriority() {
        return "";
    }

    @Override
    public String getMsgDate() {
        return this.formatDateTime(this.getString(this.msg.getMSH().getDateTimeOfMessage().getTimeOfAnEvent().getValue()));
    }

    @Override
    public String getPatientName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public String getFirstName() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPatientName()[0].getGivenName().getValue());
    }

    @Override
    public String getLastName() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPatientName()[0].getGivenName().getValue());
    }

    @Override
    public String getDOB() {
        try {
            return this.formatDateTime(this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getDateOfBirth().getTimeOfAnEvent().getValue())).substring(0, 10);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAge() {
        String age = "N/A";
        String dob = this.getDOB();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = formatter.parse(dob);
            age = UtilDateUtilities.calcAge(date);
        }
        catch (ParseException e) {
            this.logger.log(Level.SEVERE, "Could not get age", e);
        }
        return age;
    }

    @Override
    public String getSex() {
        try {
            return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getSex().getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception finding sex", e);
            return "";
        }
    }

    @Override
    public String getHealthNum() {
        try {
            return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPatientIDInternalID(0).getID().getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception finding health number", e);
            return "";
        }
    }

    @Override
    public String getHomePhone() {
        String phone = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue()).equals("")) {
                phone = i == 0 ? this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue()) : phone + ", " + this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue());
                ++i;
            }
            return phone;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception finding phone number", e);
            return "";
        }
    }

    @Override
    public String getWorkPhone() {
        String phone = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue()).equals("")) {
                phone = i == 0 ? this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue()) : phone + ", " + this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue());
                ++i;
            }
            return phone;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception finding work phone number", e);
            return "";
        }
    }

    @Override
    public String getPatientLocation() {
        return this.getString(this.msg.getMSH().getSendingFacility().getNamespaceID().getValue());
    }

    @Override
    public String getAccessionNum() {
        try {
            int obrCount = this.msg.getRESPONSE().getORDER_OBSERVATIONReps();
            String accessionNum = this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getFillerOrderNumber().getEntityIdentifier().getValue());
            if (accessionNum != "") {
                return accessionNum.substring(0, accessionNum.indexOf("-"));
            }
            for (int j = 1; j < obrCount; ++j) {
                accessionNum = this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(j).getOBR().getFillerOrderNumber().getEntityIdentifier().getValue());
                if (accessionNum == "") continue;
                return accessionNum.substring(0, accessionNum.indexOf("-"));
            }
            return "";
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return accession number", e);
            return "";
        }
    }

    @Override
    public int getOBRCount() {
        return this.msg.getRESPONSE().getORDER_OBSERVATIONReps();
    }

    @Override
    public String getOBRName(int i) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBR().getUniversalServiceIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getObservationHeader(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBR().getUniversalServiceIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getOBRCommentCount(int i) {
        try {
            int count = this.msg.getRESPONSE().getORDER_OBSERVATION(i).getNTEReps();
            return count;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBRComment(int i, int j) {
        try {
            String obrComment = this.getString(Terser.get(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getNTE(j), 3, 0, 1, 1)) + " " + this.getString(Terser.get(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getNTE(j), 3, 0, 2, 1)).trim();
            return obrComment;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getServiceDate() {
        try {
            String srvcDate = this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getObservationDateTime().getTimeOfAnEvent().getValue();
            if (srvcDate != null) {
                return this.formatDateTime(srvcDate);
            }
            int obrCount = this.msg.getRESPONSE().getORDER_OBSERVATIONReps();
            for (int j = 1; j < obrCount; ++j) {
                srvcDate = this.msg.getRESPONSE().getORDER_OBSERVATION(j).getOBR().getObservationDateTime().getTimeOfAnEvent().getValue();
                if (srvcDate == null) continue;
                return this.formatDateTime(srvcDate);
            }
            return this.formatDateTime(this.msg.getMSH().getDateTimeOfMessage().getTimeOfAnEvent().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOrderStatus() {
        try {
            String status = "F";
            int obrCount = this.msg.getRESPONSE().getORDER_OBSERVATIONReps();
            for (int i = 0; i < obrCount; ++i) {
                if (!this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBR().getResultStatus().getValue()).equals("P")) continue;
                status = "P";
            }
            return status;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception retrieving order status", e);
            return "";
        }
    }

    @Override
    public String getClientRef() {
        String docNum = "";
        try {
            Terser terser = new Terser(this.msg);
            docNum = terser.get("/.ORC-12-1");
            return docNum;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception returning client ref number", e);
            return "";
        }
    }

    @Override
    public String getDocName() {
        String docLastName = "";
        String docFirstName = "";
        try {
            Terser terser = new Terser(this.msg);
            docLastName = terser.get("/.ORC-12-2");
            docFirstName = terser.get("/.ORC-12-3");
            return docFirstName + " " + docLastName;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception returning doctor name", e);
            return "";
        }
    }

    @Override
    public String getCCDocs() {
        String docName = "";
        int i = 0;
        try {
            while (!this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i)).equals("")) {
                docName = i == 0 ? this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i)) : docName + ", " + this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i));
                ++i;
            }
            return docName;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception returning cc'ed doctors", e);
            return "";
        }
    }

    @Override
    public ArrayList<String> getDocNums() {
        ArrayList<String> nums = new ArrayList<String>();
        try {
            Terser terser = new Terser(this.msg);
            String docNum = terser.get("/.ORC-12-1");
            if (docNum != null) {
                nums.add(docNum);
            }
            int i = 0;
            while ((docNum = terser.get("/.OBR-28(" + i + ")-1")) != null) {
                nums.add(docNum);
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception returning docNums", e);
        }
        return nums;
    }

    @Override
    public int getOBXCount(int i) {
        int count = 0;
        try {
            String test;
            count = this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATIONReps();
            if (count == 1 && (test = this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(0).getOBX().getObservationIdentifier().getText().getValue()) == null) {
                count = 0;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx count", e);
            count = 0;
        }
        return count;
    }

    @Override
    public String getOBXIdentifier(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getIdentifier().getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx identifier", e);
            return "";
        }
    }

    @Override
    public String getOBXName(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getText().getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx name", e);
            return "";
        }
    }

    @Override
    public String getOBXResult(int i, int j) {
        try {
            return this.getString(Terser.get(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, 0, 1, 1));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx result", e);
            return "";
        }
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getReferencesRange().getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx reference range", e);
            return "";
        }
    }

    @Override
    public String getOBXUnits(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getUnits().getIdentifier().getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx units", e);
            return "";
        }
    }

    @Override
    public String getOBXResultStatus(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservResultStatus().getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx results status", e);
            return "";
        }
    }

    @Override
    public int getOBXFinalResultCount() {
        try {
            int obrCount = this.getOBRCount();
            int count = 0;
            for (int i = 0; i < obrCount; ++i) {
                int obxCount = this.getOBXCount(i);
                for (int j = 0; j < obxCount; ++j) {
                    String status = this.getOBXResultStatus(i, j);
                    if (!status.equalsIgnoreCase("F") && !status.equalsIgnoreCase("C")) continue;
                    ++count;
                }
            }
            String orderStatus = this.getOrderStatus();
            if (orderStatus.equalsIgnoreCase("F")) {
                count += 100;
            } else if (orderStatus.equalsIgnoreCase("C")) {
                count += 150;
            }
            return count;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx final result count", e);
            return 0;
        }
    }

    @Override
    public String getTimeStamp(int i, int j) {
        try {
            return this.formatDateTime(this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getDateTimeOfTheObservation().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean isOBXAbnormal(int i, int j) {
        try {
            return this.getOBXAbnormalFlag(i, j).equals("H") || this.getOBXAbnormalFlag(i, j).equals("L") || this.getOBXAbnormalFlag(i, j).equals("HH") || this.getOBXAbnormalFlag(i, j).equals("LL");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getOBXAbnormalFlag(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getAbnormalFlags(0).getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx abnormal flag", e);
            return "";
        }
    }

    @Override
    public int getOBXCommentCount(int i, int j) {
        try {
            int count = this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTEReps();
            return count;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx comment count", e);
            return 0;
        }
    }

    @Override
    public String getOBXComment(int i, int j, int k) {
        try {
            String obxComment = this.getString(Terser.get(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(k), 3, 0, 1, 1)) + " " + this.getString(Terser.get(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(k), 3, 0, 2, 1)).trim();
            return obxComment;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        try {
            for (int i = 0; i < this.msg.getRESPONSE().getORDER_OBSERVATIONReps(); ++i) {
                String currentHeader = this.getObservationHeader(i, 0);
                int arraySize = headers.size();
                if (arraySize != 0 && currentHeader.equals(headers.get(arraySize - 1))) continue;
                headers.add(currentHeader);
            }
            return headers;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not create header list", e);
            return null;
        }
    }

    @Override
    public String audit() {
        return "";
    }

    private String getFullDocName(XCN docSeg) {
        String docName = "";
        if (docSeg.getPrefixEgDR().getValue() != null) {
            docName = docSeg.getPrefixEgDR().getValue();
        }
        if (docSeg.getGivenName().getValue() != null) {
            docName = docName.equals("") ? docSeg.getGivenName().getValue() : docName + " " + docSeg.getGivenName().getValue();
        }
        if (docSeg.getMiddleInitialOrName().getValue() != null) {
            docName = docName + " " + docSeg.getMiddleInitialOrName().getValue();
        }
        if (docSeg.getFamilyName().getValue() != null) {
            docName = docName + " " + docSeg.getFamilyName().getValue();
        }
        if (docSeg.getSuffixEgJRorIII().getValue() != null) {
            docName = docName + " " + docSeg.getSuffixEgJRorIII().getValue();
        }
        if (docSeg.getDegreeEgMD().getValue() != null) {
            docName = docName + " " + docSeg.getDegreeEgMD().getValue();
        }
        return docName;
    }

    @Override
    protected String getString(String retrieve) {
        if (retrieve != null) {
            return retrieve.trim().replaceAll("\\\\\\.br\\\\", "<br />");
        }
        return "";
    }
}

