/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.StreamSource;
import ca.uhn.hl7v2.protocol.TransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public abstract class SocketStreamSource
implements StreamSource {
    public abstract Socket getSocket();

    @Override
    public abstract void connect() throws TransportException;

    @Override
    public void disconnect() throws TransportException {
        try {
            if (this.isConnected()) {
                this.getOutboundStream().close();
                this.getInboundStream().close();
                this.getSocket().close();
            }
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public OutputStream getOutboundStream() throws TransportException {
        this.checkConnected();
        try {
            return this.getSocket().getOutputStream();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private void checkConnected() throws TransportException {
        if (!this.isConnected()) {
            throw new TransportException("The socket is not connected");
        }
    }

    private boolean isConnected() {
        boolean is = false;
        if (this.getSocket() != null && this.getSocket().isConnected() && !this.getSocket().isClosed()) {
            is = true;
        }
        return is;
    }

    @Override
    public InputStream getInboundStream() throws TransportException {
        this.checkConnected();
        try {
            return this.getSocket().getInputStream();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }
}

