/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FixFieldDataType {
    public static final String DEFAULT_OBX2_TYPE_PROP = "ca.uhn.hl7v2.model.varies.default_obx2_type";
    public static final String INVALID_OBX2_TYPE_PROP = "ca.uhn.hl7v2.model.varies.invalid_obx2_type";
    public static final String ESCAPE_SUBCOMPONENT_DELIM_IN_PRIMITIVE = "ca.uhn.hl7v2.model.varies.escape_subcomponent_delim_in_primitive";
    private static final Logger LOG = LoggerFactory.getLogger(Varies.class);

    private FixFieldDataType() {
    }

    public static void fixOBX5(Segment segment, ModelClassFactory factory, ParserConfiguration parserConfiguration) throws HL7Exception {
        String invalidOBX2Type;
        if (!segment.getName().contains("OBX")) {
            throw new IllegalArgumentException("Expected OBX segment, but was: " + segment.getName());
        }
        String defaultOBX2Type = parserConfiguration.getDefaultObx2Type();
        if (defaultOBX2Type == null) {
            defaultOBX2Type = System.getProperty(DEFAULT_OBX2_TYPE_PROP);
        }
        if ((invalidOBX2Type = parserConfiguration.getInvalidObx2Type()) == null) {
            invalidOBX2Type = System.getProperty(INVALID_OBX2_TYPE_PROP);
        }
        FixFieldDataType.fix(segment, 2, 5, defaultOBX2Type, invalidOBX2Type, factory, parserConfiguration);
    }

    public static void fixMFE4(Segment segment, ModelClassFactory factory, ParserConfiguration parserConfiguration) throws HL7Exception {
        if (!segment.getName().contains("MFE") && Version.versionOf(segment.getMessage().getVersion()).isGreaterThan(Version.V23)) {
            throw new IllegalArgumentException("Expected MFE segment, but was: " + segment.getName());
        }
        FixFieldDataType.fix(segment, 5, 4, null, null, factory, parserConfiguration);
    }

    public static void fix(Segment segment, int typeField, int dataField, String defaultType, String invalidType, ModelClassFactory factory, ParserConfiguration parserConfiguration) throws HL7Exception {
        try {
            Type[] reps;
            Primitive type = (Primitive)segment.getField(typeField, 0);
            for (Type rep : reps = segment.getField(dataField)) {
                Type[] subComponentsInFirstField;
                boolean escapeSubcomponentDelimInPrimitive;
                Type newTypeInstance;
                Varies v = (Varies)rep;
                if (type.getValue() == null && defaultType != null) {
                    LOG.debug("setting default {}-{} type to {}", segment.getName(), typeField, defaultType);
                    type.setValue(defaultType);
                }
                if (type.getValue() == null) {
                    if (v.getData() == null || v.getData() instanceof Primitive && ((Primitive)v.getData()).getValue() == null) continue;
                    throw new HL7Exception(String.format("A datatype for %s-%n must be specified in %s-%n.", segment.getName(), dataField, segment.getName(), typeField), ErrorCode.REQUIRED_FIELD_MISSING);
                }
                String version = segment.getMessage().getVersion();
                String typeValue = type.getValue();
                Class<? extends Type> c = factory.getTypeClass(typeValue, version);
                if (c == null) {
                    if (invalidType != null) {
                        c = factory.getTypeClass(invalidType, version);
                    }
                    if (c == null) {
                        Primitive obx1 = (Primitive)segment.getField(1, 0);
                        HL7Exception h = new HL7Exception("'" + type.getValue() + "' in record " + obx1.getValue() + " is invalid for version " + version, ErrorCode.DATA_TYPE_ERROR);
                        h.setSegmentName(segment.getName());
                        h.setFieldPosition(typeField);
                        throw h;
                    }
                }
                try {
                    Constructor<? extends Type> constr = c.getConstructor(Message.class);
                    newTypeInstance = constr.newInstance(v.getMessage());
                }
                catch (NoSuchMethodException e) {
                    Constructor<? extends Type> constr = c.getConstructor(Message.class, Integer.class);
                    newTypeInstance = constr.newInstance(v.getMessage(), 0);
                }
                boolean bl = escapeSubcomponentDelimInPrimitive = parserConfiguration.isEscapeSubcomponentDelimiterInPrimitive() || FixFieldDataType.escapeSubcomponentDelimInPrimitive();
                if (newTypeInstance instanceof Primitive && (subComponentsInFirstField = FixFieldDataType.getFirstComponentSubcomponentsOnlyIfMoreThanOne(v)) != null && escapeSubcomponentDelimInPrimitive) {
                    StringBuilder firstComponentValue = new StringBuilder();
                    for (Type stype : subComponentsInFirstField) {
                        if (firstComponentValue.length() != 0) {
                            char subComponentSeparator = EncodingCharacters.getInstance(segment.getMessage()).getSubcomponentSeparator();
                            firstComponentValue.append(subComponentSeparator);
                        }
                        firstComponentValue.append(stype.encode());
                    }
                    FixFieldDataType.setFirstComponentPrimitiveValue(v, firstComponentValue.toString());
                }
                v.setData(newTypeInstance);
            }
        }
        catch (HL7Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new HL7Exception(e.getClass().getName() + " trying to set data type of " + segment.getName() + "-" + dataField, e);
        }
    }

    private static boolean escapeSubcomponentDelimInPrimitive() {
        String property = System.getProperty(ESCAPE_SUBCOMPONENT_DELIM_IN_PRIMITIVE);
        return property == null || "true".equalsIgnoreCase(property);
    }

    private static void setFirstComponentPrimitiveValue(Varies v, String theValue) throws DataTypeException {
        Composite c = (Composite)v.getData();
        Type firstComponent = c.getComponent(0);
        FixFieldDataType.setFirstComponentPrimitiveValue(firstComponent, theValue);
    }

    private static void setFirstComponentPrimitiveValue(Type theFirstComponent, String theValue) throws DataTypeException {
        if (theFirstComponent instanceof Varies) {
            Varies firstComponentVaries = (Varies)theFirstComponent;
            if (((Varies)theFirstComponent).getData() instanceof Composite) {
                Type[] subComponents = ((Composite)firstComponentVaries.getData()).getComponents();
                FixFieldDataType.setFirstComponentPrimitiveValue(subComponents[0], theValue);
                for (int i = 1; i < subComponents.length; ++i) {
                    FixFieldDataType.setFirstComponentPrimitiveValue(subComponents[i], "");
                }
            } else {
                Primitive p = (Primitive)firstComponentVaries.getData();
                p.setValue(theValue);
            }
        } else if (theFirstComponent instanceof Composite) {
            Type[] subComponents = ((Composite)theFirstComponent).getComponents();
            FixFieldDataType.setFirstComponentPrimitiveValue(subComponents[0], theValue);
            for (int i = 1; i < subComponents.length; ++i) {
                FixFieldDataType.setFirstComponentPrimitiveValue(subComponents[i], "");
            }
        } else {
            ((Primitive)theFirstComponent).setValue(theValue);
        }
    }

    private static Type[] getFirstComponentSubcomponentsOnlyIfMoreThanOne(Varies v) throws DataTypeException {
        Varies firstComponentVaries;
        Composite c;
        Type firstComponent;
        if (v.getData() instanceof Composite && (firstComponent = (c = (Composite)v.getData()).getComponent(0)) instanceof Varies && (firstComponentVaries = (Varies)firstComponent).getData() instanceof Composite) {
            return ((Composite)firstComponentVaries.getData()).getComponents();
        }
        return null;
    }
}

