/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.group.RPA_I08_RESULTS;
import ca.uhn.hl7v2.model.v281.segment.NTE;
import ca.uhn.hl7v2.model.v281.segment.OBR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RPA_I08_OBSERVATION
extends AbstractGroup {
    public RPA_I08_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(RPA_I08_RESULTS.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPA_I08_OBSERVATION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RPA_I08_RESULTS getRESULTS() {
        RPA_I08_RESULTS retVal = this.getTyped("RESULTS", RPA_I08_RESULTS.class);
        return retVal;
    }

    public RPA_I08_RESULTS getRESULTS(int rep) {
        RPA_I08_RESULTS retVal = this.getTyped("RESULTS", rep, RPA_I08_RESULTS.class);
        return retVal;
    }

    public int getRESULTSReps() {
        return this.getReps("RESULTS");
    }

    public List<RPA_I08_RESULTS> getRESULTSAll() throws HL7Exception {
        return this.getAllAsList("RESULTS", RPA_I08_RESULTS.class);
    }

    public void insertRESULTS(RPA_I08_RESULTS structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULTS", structure, rep);
    }

    public RPA_I08_RESULTS insertRESULTS(int rep) throws HL7Exception {
        return (RPA_I08_RESULTS)super.insertRepetition("RESULTS", rep);
    }

    public RPA_I08_RESULTS removeRESULTS(int rep) throws HL7Exception {
        return (RPA_I08_RESULTS)super.removeRepetition("RESULTS", rep);
    }
}

