/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DT;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.PL;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.model.v28.datatype.XCN;
import ca.uhn.hl7v2.model.v28.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PV2
extends AbstractSegment {
    public PV2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Prior Pending Location");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Accommodation Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Admit Reason");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Transfer Reason");
            this.add(ST.class, false, 0, 0, new Object[]{this.getMessage()}, "Patient Valuables");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Patient Valuables Location");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Visit User Code");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expected Admit Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expected Discharge Date/Time");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Estimated Length of Inpatient Stay");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Actual Length of Inpatient Stay");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Visit Description");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Referral Source Code");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Previous Service Date");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Employment Illness Related Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Purge Status Code");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Purge Status Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Special Program Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Retention Indicator");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expected Number of Insurance Plans");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Visit Publicity Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Visit Protection Indicator");
            this.add(XON.class, false, 0, 0, new Object[]{this.getMessage()}, "Clinic Organization Name");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Patient Status Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Visit Priority Code");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Previous Treatment Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Expected Discharge Disposition");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Signature on File Date");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "First Similar Illness Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Patient Charge Adjustment Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Recurring Service Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Billing Media Code");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expected Surgery Date and Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Military Partnership Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Military Non-Availability Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Newborn Baby Indicator");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Baby Detained Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Mode of Arrival Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Recreational Drug Use Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Admission Level of Care Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Precaution Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Patient Condition Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Living Will Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Organ Donor Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Advance Directive Code");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Patient Status Effective Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expected LOA Return Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expected Pre-admission Testing Date/Time");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Notify Clergy Code");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Advance Directive Last Verified Date");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PV2 - this is probably a bug in the source code generator.", e);
        }
    }

    public PL getPriorPendingLocation() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getPv21_PriorPendingLocation() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getAccommodationCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getPv22_AccommodationCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getAdmitReason() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getPv23_AdmitReason() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getTransferReason() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getPv24_TransferReason() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public ST[] getPatientValuables() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public ST[] getPv25_PatientValuables() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public int getPatientValuablesReps() {
        return this.getReps(5);
    }

    public ST getPatientValuables(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getPv25_PatientValuables(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPv25_PatientValuablesReps() {
        return this.getReps(5);
    }

    public ST insertPatientValuables(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertPv25_PatientValuables(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removePatientValuables(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removePv25_PatientValuables(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST getPatientValuablesLocation() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getPv26_PatientValuablesLocation() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE[] getVisitUserCode() {
        CWE[] retVal = (CWE[])this.getTypedField(7, new CWE[0]);
        return retVal;
    }

    public CWE[] getPv27_VisitUserCode() {
        CWE[] retVal = (CWE[])this.getTypedField(7, new CWE[0]);
        return retVal;
    }

    public int getVisitUserCodeReps() {
        return this.getReps(7);
    }

    public CWE getVisitUserCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public CWE getPv27_VisitUserCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPv27_VisitUserCodeReps() {
        return this.getReps(7);
    }

    public CWE insertVisitUserCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE insertPv27_VisitUserCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE removeVisitUserCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public CWE removePv27_VisitUserCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public DTM getExpectedAdmitDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getPv28_ExpectedAdmitDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getExpectedDischargeDateTime() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getPv29_ExpectedDischargeDateTime() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getEstimatedLengthOfInpatientStay() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getPv210_EstimatedLengthOfInpatientStay() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getActualLengthOfInpatientStay() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getPv211_ActualLengthOfInpatientStay() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getVisitDescription() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getPv212_VisitDescription() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public XCN[] getReferralSourceCode() {
        XCN[] retVal = (XCN[])this.getTypedField(13, new XCN[0]);
        return retVal;
    }

    public XCN[] getPv213_ReferralSourceCode() {
        XCN[] retVal = (XCN[])this.getTypedField(13, new XCN[0]);
        return retVal;
    }

    public int getReferralSourceCodeReps() {
        return this.getReps(13);
    }

    public XCN getReferralSourceCode(int rep) {
        XCN retVal = (XCN)this.getTypedField(13, rep);
        return retVal;
    }

    public XCN getPv213_ReferralSourceCode(int rep) {
        XCN retVal = (XCN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getPv213_ReferralSourceCodeReps() {
        return this.getReps(13);
    }

    public XCN insertReferralSourceCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(13, rep);
    }

    public XCN insertPv213_ReferralSourceCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(13, rep);
    }

    public XCN removeReferralSourceCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(13, rep);
    }

    public XCN removePv213_ReferralSourceCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(13, rep);
    }

    public DT getPreviousServiceDate() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getPv214_PreviousServiceDate() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getEmploymentIllnessRelatedIndicator() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getPv215_EmploymentIllnessRelatedIndicator() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getPurgeStatusCode() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getPv216_PurgeStatusCode() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public DT getPurgeStatusDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getPv217_PurgeStatusDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getSpecialProgramCode() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getPv218_SpecialProgramCode() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getRetentionIndicator() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getPv219_RetentionIndicator() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public NM getExpectedNumberOfInsurancePlans() {
        NM retVal = (NM)this.getTypedField(20, 0);
        return retVal;
    }

    public NM getPv220_ExpectedNumberOfInsurancePlans() {
        NM retVal = (NM)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getVisitPublicityCode() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getPv221_VisitPublicityCode() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getVisitProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getPv222_VisitProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public XON[] getClinicOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(23, new XON[0]);
        return retVal;
    }

    public XON[] getPv223_ClinicOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(23, new XON[0]);
        return retVal;
    }

    public int getClinicOrganizationNameReps() {
        return this.getReps(23);
    }

    public XON getClinicOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(23, rep);
        return retVal;
    }

    public XON getPv223_ClinicOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(23, rep);
        return retVal;
    }

    public int getPv223_ClinicOrganizationNameReps() {
        return this.getReps(23);
    }

    public XON insertClinicOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(23, rep);
    }

    public XON insertPv223_ClinicOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(23, rep);
    }

    public XON removeClinicOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(23, rep);
    }

    public XON removePv223_ClinicOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(23, rep);
    }

    public CWE getPatientStatusCode() {
        CWE retVal = (CWE)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE getPv224_PatientStatusCode() {
        CWE retVal = (CWE)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE getVisitPriorityCode() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getPv225_VisitPriorityCode() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public DT getPreviousTreatmentDate() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public DT getPv226_PreviousTreatmentDate() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getExpectedDischargeDisposition() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getPv227_ExpectedDischargeDisposition() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public DT getSignatureOnFileDate() {
        DT retVal = (DT)this.getTypedField(28, 0);
        return retVal;
    }

    public DT getPv228_SignatureOnFileDate() {
        DT retVal = (DT)this.getTypedField(28, 0);
        return retVal;
    }

    public DT getFirstSimilarIllnessDate() {
        DT retVal = (DT)this.getTypedField(29, 0);
        return retVal;
    }

    public DT getPv229_FirstSimilarIllnessDate() {
        DT retVal = (DT)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getPatientChargeAdjustmentCode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getPv230_PatientChargeAdjustmentCode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getRecurringServiceCode() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getPv231_RecurringServiceCode() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public ID getBillingMediaCode() {
        ID retVal = (ID)this.getTypedField(32, 0);
        return retVal;
    }

    public ID getPv232_BillingMediaCode() {
        ID retVal = (ID)this.getTypedField(32, 0);
        return retVal;
    }

    public DTM getExpectedSurgeryDateAndTime() {
        DTM retVal = (DTM)this.getTypedField(33, 0);
        return retVal;
    }

    public DTM getPv233_ExpectedSurgeryDateAndTime() {
        DTM retVal = (DTM)this.getTypedField(33, 0);
        return retVal;
    }

    public ID getMilitaryPartnershipCode() {
        ID retVal = (ID)this.getTypedField(34, 0);
        return retVal;
    }

    public ID getPv234_MilitaryPartnershipCode() {
        ID retVal = (ID)this.getTypedField(34, 0);
        return retVal;
    }

    public ID getMilitaryNonAvailabilityCode() {
        ID retVal = (ID)this.getTypedField(35, 0);
        return retVal;
    }

    public ID getPv235_MilitaryNonAvailabilityCode() {
        ID retVal = (ID)this.getTypedField(35, 0);
        return retVal;
    }

    public ID getNewbornBabyIndicator() {
        ID retVal = (ID)this.getTypedField(36, 0);
        return retVal;
    }

    public ID getPv236_NewbornBabyIndicator() {
        ID retVal = (ID)this.getTypedField(36, 0);
        return retVal;
    }

    public ID getBabyDetainedIndicator() {
        ID retVal = (ID)this.getTypedField(37, 0);
        return retVal;
    }

    public ID getPv237_BabyDetainedIndicator() {
        ID retVal = (ID)this.getTypedField(37, 0);
        return retVal;
    }

    public CWE getModeOfArrivalCode() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public CWE getPv238_ModeOfArrivalCode() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public CWE[] getRecreationalDrugUseCode() {
        CWE[] retVal = (CWE[])this.getTypedField(39, new CWE[0]);
        return retVal;
    }

    public CWE[] getPv239_RecreationalDrugUseCode() {
        CWE[] retVal = (CWE[])this.getTypedField(39, new CWE[0]);
        return retVal;
    }

    public int getRecreationalDrugUseCodeReps() {
        return this.getReps(39);
    }

    public CWE getRecreationalDrugUseCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(39, rep);
        return retVal;
    }

    public CWE getPv239_RecreationalDrugUseCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(39, rep);
        return retVal;
    }

    public int getPv239_RecreationalDrugUseCodeReps() {
        return this.getReps(39);
    }

    public CWE insertRecreationalDrugUseCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(39, rep);
    }

    public CWE insertPv239_RecreationalDrugUseCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(39, rep);
    }

    public CWE removeRecreationalDrugUseCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(39, rep);
    }

    public CWE removePv239_RecreationalDrugUseCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(39, rep);
    }

    public CWE getAdmissionLevelOfCareCode() {
        CWE retVal = (CWE)this.getTypedField(40, 0);
        return retVal;
    }

    public CWE getPv240_AdmissionLevelOfCareCode() {
        CWE retVal = (CWE)this.getTypedField(40, 0);
        return retVal;
    }

    public CWE[] getPrecautionCode() {
        CWE[] retVal = (CWE[])this.getTypedField(41, new CWE[0]);
        return retVal;
    }

    public CWE[] getPv241_PrecautionCode() {
        CWE[] retVal = (CWE[])this.getTypedField(41, new CWE[0]);
        return retVal;
    }

    public int getPrecautionCodeReps() {
        return this.getReps(41);
    }

    public CWE getPrecautionCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(41, rep);
        return retVal;
    }

    public CWE getPv241_PrecautionCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(41, rep);
        return retVal;
    }

    public int getPv241_PrecautionCodeReps() {
        return this.getReps(41);
    }

    public CWE insertPrecautionCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(41, rep);
    }

    public CWE insertPv241_PrecautionCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(41, rep);
    }

    public CWE removePrecautionCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(41, rep);
    }

    public CWE removePv241_PrecautionCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(41, rep);
    }

    public CWE getPatientConditionCode() {
        CWE retVal = (CWE)this.getTypedField(42, 0);
        return retVal;
    }

    public CWE getPv242_PatientConditionCode() {
        CWE retVal = (CWE)this.getTypedField(42, 0);
        return retVal;
    }

    public CWE getLivingWillCode() {
        CWE retVal = (CWE)this.getTypedField(43, 0);
        return retVal;
    }

    public CWE getPv243_LivingWillCode() {
        CWE retVal = (CWE)this.getTypedField(43, 0);
        return retVal;
    }

    public CWE getOrganDonorCode() {
        CWE retVal = (CWE)this.getTypedField(44, 0);
        return retVal;
    }

    public CWE getPv244_OrganDonorCode() {
        CWE retVal = (CWE)this.getTypedField(44, 0);
        return retVal;
    }

    public CWE[] getAdvanceDirectiveCode() {
        CWE[] retVal = (CWE[])this.getTypedField(45, new CWE[0]);
        return retVal;
    }

    public CWE[] getPv245_AdvanceDirectiveCode() {
        CWE[] retVal = (CWE[])this.getTypedField(45, new CWE[0]);
        return retVal;
    }

    public int getAdvanceDirectiveCodeReps() {
        return this.getReps(45);
    }

    public CWE getAdvanceDirectiveCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(45, rep);
        return retVal;
    }

    public CWE getPv245_AdvanceDirectiveCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(45, rep);
        return retVal;
    }

    public int getPv245_AdvanceDirectiveCodeReps() {
        return this.getReps(45);
    }

    public CWE insertAdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(45, rep);
    }

    public CWE insertPv245_AdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(45, rep);
    }

    public CWE removeAdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(45, rep);
    }

    public CWE removePv245_AdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(45, rep);
    }

    public DT getPatientStatusEffectiveDate() {
        DT retVal = (DT)this.getTypedField(46, 0);
        return retVal;
    }

    public DT getPv246_PatientStatusEffectiveDate() {
        DT retVal = (DT)this.getTypedField(46, 0);
        return retVal;
    }

    public DTM getExpectedLOAReturnDateTime() {
        DTM retVal = (DTM)this.getTypedField(47, 0);
        return retVal;
    }

    public DTM getPv247_ExpectedLOAReturnDateTime() {
        DTM retVal = (DTM)this.getTypedField(47, 0);
        return retVal;
    }

    public DTM getExpectedPreAdmissionTestingDateTime() {
        DTM retVal = (DTM)this.getTypedField(48, 0);
        return retVal;
    }

    public DTM getPv248_ExpectedPreAdmissionTestingDateTime() {
        DTM retVal = (DTM)this.getTypedField(48, 0);
        return retVal;
    }

    public CWE[] getNotifyClergyCode() {
        CWE[] retVal = (CWE[])this.getTypedField(49, new CWE[0]);
        return retVal;
    }

    public CWE[] getPv249_NotifyClergyCode() {
        CWE[] retVal = (CWE[])this.getTypedField(49, new CWE[0]);
        return retVal;
    }

    public int getNotifyClergyCodeReps() {
        return this.getReps(49);
    }

    public CWE getNotifyClergyCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(49, rep);
        return retVal;
    }

    public CWE getPv249_NotifyClergyCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(49, rep);
        return retVal;
    }

    public int getPv249_NotifyClergyCodeReps() {
        return this.getReps(49);
    }

    public CWE insertNotifyClergyCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(49, rep);
    }

    public CWE insertPv249_NotifyClergyCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(49, rep);
    }

    public CWE removeNotifyClergyCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(49, rep);
    }

    public CWE removePv249_NotifyClergyCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(49, rep);
    }

    public DT getAdvanceDirectiveLastVerifiedDate() {
        DT retVal = (DT)this.getTypedField(50, 0);
        return retVal;
    }

    public DT getPv250_AdvanceDirectiveLastVerifiedDate() {
        DT retVal = (DT)this.getTypedField(50, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new DTM(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new XCN(this.getMessage());
            }
            case 13: {
                return new DT(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new DT(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 19: {
                return new NM(this.getMessage());
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 22: {
                return new XON(this.getMessage());
            }
            case 23: {
                return new CWE(this.getMessage());
            }
            case 24: {
                return new CWE(this.getMessage());
            }
            case 25: {
                return new DT(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new DT(this.getMessage());
            }
            case 28: {
                return new DT(this.getMessage());
            }
            case 29: {
                return new CWE(this.getMessage());
            }
            case 30: {
                return new CWE(this.getMessage());
            }
            case 31: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 32: {
                return new DTM(this.getMessage());
            }
            case 33: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 34: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 35: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 36: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 37: {
                return new CWE(this.getMessage());
            }
            case 38: {
                return new CWE(this.getMessage());
            }
            case 39: {
                return new CWE(this.getMessage());
            }
            case 40: {
                return new CWE(this.getMessage());
            }
            case 41: {
                return new CWE(this.getMessage());
            }
            case 42: {
                return new CWE(this.getMessage());
            }
            case 43: {
                return new CWE(this.getMessage());
            }
            case 44: {
                return new CWE(this.getMessage());
            }
            case 45: {
                return new DT(this.getMessage());
            }
            case 46: {
                return new DTM(this.getMessage());
            }
            case 47: {
                return new DTM(this.getMessage());
            }
            case 48: {
                return new CWE(this.getMessage());
            }
            case 49: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

