/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.segment.SPM;
import ca.uhn.hl7v2.model.v28.segment.TCC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class TCU_U10_TEST_CONFIGURATION
extends AbstractGroup {
    public TCU_U10_TEST_CONFIGURATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, false, false, false);
            this.add(TCC.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating TCU_U10_TEST_CONFIGURATION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public SPM getSPM() {
        SPM retVal = this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public TCC getTCC() {
        TCC retVal = this.getTyped("TCC", TCC.class);
        return retVal;
    }

    public TCC getTCC(int rep) {
        TCC retVal = this.getTyped("TCC", rep, TCC.class);
        return retVal;
    }

    public int getTCCReps() {
        return this.getReps("TCC");
    }

    public List<TCC> getTCCAll() throws HL7Exception {
        return this.getAllAsList("TCC", TCC.class);
    }

    public void insertTCC(TCC structure, int rep) throws HL7Exception {
        super.insertRepetition("TCC", structure, rep);
    }

    public TCC insertTCC(int rep) throws HL7Exception {
        return (TCC)super.insertRepetition("TCC", rep);
    }

    public TCC removeTCC(int rep) throws HL7Exception {
        return (TCC)super.removeRepetition("TCC", rep);
    }
}

