/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.group.OPL_O37_INSURANCE;
import ca.uhn.hl7v2.model.v28.group.OPL_O37_OBSERVATIONS_ON_PATIENT;
import ca.uhn.hl7v2.model.v28.segment.AL1;
import ca.uhn.hl7v2.model.v28.segment.ARV;
import ca.uhn.hl7v2.model.v28.segment.PD1;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OPL_O37_PATIENT
extends AbstractGroup {
    public OPL_O37_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(PRT.class, false, true, false);
            this.add(ARV.class, false, true, false);
            this.add(OPL_O37_OBSERVATIONS_ON_PATIENT.class, false, true, false);
            this.add(OPL_O37_INSURANCE.class, false, true, false);
            this.add(AL1.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPL_O37_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ARV getARV() {
        ARV retVal = this.getTyped("ARV", ARV.class);
        return retVal;
    }

    public ARV getARV(int rep) {
        ARV retVal = this.getTyped("ARV", rep, ARV.class);
        return retVal;
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public OPL_O37_OBSERVATIONS_ON_PATIENT getOBSERVATIONS_ON_PATIENT() {
        OPL_O37_OBSERVATIONS_ON_PATIENT retVal = this.getTyped("OBSERVATIONS_ON_PATIENT", OPL_O37_OBSERVATIONS_ON_PATIENT.class);
        return retVal;
    }

    public OPL_O37_OBSERVATIONS_ON_PATIENT getOBSERVATIONS_ON_PATIENT(int rep) {
        OPL_O37_OBSERVATIONS_ON_PATIENT retVal = this.getTyped("OBSERVATIONS_ON_PATIENT", rep, OPL_O37_OBSERVATIONS_ON_PATIENT.class);
        return retVal;
    }

    public int getOBSERVATIONS_ON_PATIENTReps() {
        return this.getReps("OBSERVATIONS_ON_PATIENT");
    }

    public List<OPL_O37_OBSERVATIONS_ON_PATIENT> getOBSERVATIONS_ON_PATIENTAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATIONS_ON_PATIENT", OPL_O37_OBSERVATIONS_ON_PATIENT.class);
    }

    public void insertOBSERVATIONS_ON_PATIENT(OPL_O37_OBSERVATIONS_ON_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATIONS_ON_PATIENT", structure, rep);
    }

    public OPL_O37_OBSERVATIONS_ON_PATIENT insertOBSERVATIONS_ON_PATIENT(int rep) throws HL7Exception {
        return (OPL_O37_OBSERVATIONS_ON_PATIENT)super.insertRepetition("OBSERVATIONS_ON_PATIENT", rep);
    }

    public OPL_O37_OBSERVATIONS_ON_PATIENT removeOBSERVATIONS_ON_PATIENT(int rep) throws HL7Exception {
        return (OPL_O37_OBSERVATIONS_ON_PATIENT)super.removeRepetition("OBSERVATIONS_ON_PATIENT", rep);
    }

    public OPL_O37_INSURANCE getINSURANCE() {
        OPL_O37_INSURANCE retVal = this.getTyped("INSURANCE", OPL_O37_INSURANCE.class);
        return retVal;
    }

    public OPL_O37_INSURANCE getINSURANCE(int rep) {
        OPL_O37_INSURANCE retVal = this.getTyped("INSURANCE", rep, OPL_O37_INSURANCE.class);
        return retVal;
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<OPL_O37_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", OPL_O37_INSURANCE.class);
    }

    public void insertINSURANCE(OPL_O37_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public OPL_O37_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (OPL_O37_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public OPL_O37_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (OPL_O37_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public AL1 getAL1() {
        AL1 retVal = this.getTyped("AL1", AL1.class);
        return retVal;
    }

    public AL1 getAL1(int rep) {
        AL1 retVal = this.getTyped("AL1", rep, AL1.class);
        return retVal;
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }
}

