/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.group.OPL_O37_ORDER_RELATED_OBSERVATION;
import ca.uhn.hl7v2.model.v28.group.OPL_O37_TIMING;
import ca.uhn.hl7v2.model.v28.segment.DG1;
import ca.uhn.hl7v2.model.v28.segment.OBR;
import ca.uhn.hl7v2.model.v28.segment.ORC;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.model.v28.segment.TCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OPL_O37_OBSERVATION_REQUEST
extends AbstractGroup {
    public OPL_O37_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(OBR.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(OPL_O37_TIMING.class, false, true, false);
            this.add(TCD.class, false, false, false);
            this.add(DG1.class, false, true, false);
            this.add(OPL_O37_ORDER_RELATED_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPL_O37_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public PRT getPRT2() {
        PRT retVal = this.getTyped("PRT2", PRT.class);
        return retVal;
    }

    public PRT getPRT2(int rep) {
        PRT retVal = this.getTyped("PRT2", rep, PRT.class);
        return retVal;
    }

    public int getPRT2Reps() {
        return this.getReps("PRT2");
    }

    public List<PRT> getPRT2All() throws HL7Exception {
        return this.getAllAsList("PRT2", PRT.class);
    }

    public void insertPRT2(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT2", structure, rep);
    }

    public PRT insertPRT2(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT2", rep);
    }

    public PRT removePRT2(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT2", rep);
    }

    public OPL_O37_TIMING getTIMING() {
        OPL_O37_TIMING retVal = this.getTyped("TIMING", OPL_O37_TIMING.class);
        return retVal;
    }

    public OPL_O37_TIMING getTIMING(int rep) {
        OPL_O37_TIMING retVal = this.getTyped("TIMING", rep, OPL_O37_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<OPL_O37_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", OPL_O37_TIMING.class);
    }

    public void insertTIMING(OPL_O37_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public OPL_O37_TIMING insertTIMING(int rep) throws HL7Exception {
        return (OPL_O37_TIMING)super.insertRepetition("TIMING", rep);
    }

    public OPL_O37_TIMING removeTIMING(int rep) throws HL7Exception {
        return (OPL_O37_TIMING)super.removeRepetition("TIMING", rep);
    }

    public TCD getTCD() {
        TCD retVal = this.getTyped("TCD", TCD.class);
        return retVal;
    }

    public DG1 getDG1() {
        DG1 retVal = this.getTyped("DG1", DG1.class);
        return retVal;
    }

    public DG1 getDG1(int rep) {
        DG1 retVal = this.getTyped("DG1", rep, DG1.class);
        return retVal;
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public OPL_O37_ORDER_RELATED_OBSERVATION getORDER_RELATED_OBSERVATION() {
        OPL_O37_ORDER_RELATED_OBSERVATION retVal = this.getTyped("ORDER_RELATED_OBSERVATION", OPL_O37_ORDER_RELATED_OBSERVATION.class);
        return retVal;
    }

    public OPL_O37_ORDER_RELATED_OBSERVATION getORDER_RELATED_OBSERVATION(int rep) {
        OPL_O37_ORDER_RELATED_OBSERVATION retVal = this.getTyped("ORDER_RELATED_OBSERVATION", rep, OPL_O37_ORDER_RELATED_OBSERVATION.class);
        return retVal;
    }

    public int getORDER_RELATED_OBSERVATIONReps() {
        return this.getReps("ORDER_RELATED_OBSERVATION");
    }

    public List<OPL_O37_ORDER_RELATED_OBSERVATION> getORDER_RELATED_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("ORDER_RELATED_OBSERVATION", OPL_O37_ORDER_RELATED_OBSERVATION.class);
    }

    public void insertORDER_RELATED_OBSERVATION(OPL_O37_ORDER_RELATED_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_RELATED_OBSERVATION", structure, rep);
    }

    public OPL_O37_ORDER_RELATED_OBSERVATION insertORDER_RELATED_OBSERVATION(int rep) throws HL7Exception {
        return (OPL_O37_ORDER_RELATED_OBSERVATION)super.insertRepetition("ORDER_RELATED_OBSERVATION", rep);
    }

    public OPL_O37_ORDER_RELATED_OBSERVATION removeORDER_RELATED_OBSERVATION(int rep) throws HL7Exception {
        return (OPL_O37_ORDER_RELATED_OBSERVATION)super.removeRepetition("ORDER_RELATED_OBSERVATION", rep);
    }
}

