/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.group.CCU_I20_PROBLEM_OBSERVATION;
import ca.uhn.hl7v2.model.v28.group.CCU_I20_ROLE_PROBLEM;
import ca.uhn.hl7v2.model.v28.segment.PRB;
import ca.uhn.hl7v2.model.v28.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCU_I20_PROBLEM
extends AbstractGroup {
    public CCU_I20_PROBLEM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PRB.class, true, false, false);
            this.add(VAR.class, false, true, false);
            this.add(CCU_I20_ROLE_PROBLEM.class, false, true, false);
            this.add(CCU_I20_PROBLEM_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCU_I20_PROBLEM - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public PRB getPRB() {
        PRB retVal = this.getTyped("PRB", PRB.class);
        return retVal;
    }

    public VAR getVAR() {
        VAR retVal = this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public CCU_I20_ROLE_PROBLEM getROLE_PROBLEM() {
        CCU_I20_ROLE_PROBLEM retVal = this.getTyped("ROLE_PROBLEM", CCU_I20_ROLE_PROBLEM.class);
        return retVal;
    }

    public CCU_I20_ROLE_PROBLEM getROLE_PROBLEM(int rep) {
        CCU_I20_ROLE_PROBLEM retVal = this.getTyped("ROLE_PROBLEM", rep, CCU_I20_ROLE_PROBLEM.class);
        return retVal;
    }

    public int getROLE_PROBLEMReps() {
        return this.getReps("ROLE_PROBLEM");
    }

    public List<CCU_I20_ROLE_PROBLEM> getROLE_PROBLEMAll() throws HL7Exception {
        return this.getAllAsList("ROLE_PROBLEM", CCU_I20_ROLE_PROBLEM.class);
    }

    public void insertROLE_PROBLEM(CCU_I20_ROLE_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("ROLE_PROBLEM", structure, rep);
    }

    public CCU_I20_ROLE_PROBLEM insertROLE_PROBLEM(int rep) throws HL7Exception {
        return (CCU_I20_ROLE_PROBLEM)super.insertRepetition("ROLE_PROBLEM", rep);
    }

    public CCU_I20_ROLE_PROBLEM removeROLE_PROBLEM(int rep) throws HL7Exception {
        return (CCU_I20_ROLE_PROBLEM)super.removeRepetition("ROLE_PROBLEM", rep);
    }

    public CCU_I20_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION() {
        CCU_I20_PROBLEM_OBSERVATION retVal = this.getTyped("PROBLEM_OBSERVATION", CCU_I20_PROBLEM_OBSERVATION.class);
        return retVal;
    }

    public CCU_I20_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION(int rep) {
        CCU_I20_PROBLEM_OBSERVATION retVal = this.getTyped("PROBLEM_OBSERVATION", rep, CCU_I20_PROBLEM_OBSERVATION.class);
        return retVal;
    }

    public int getPROBLEM_OBSERVATIONReps() {
        return this.getReps("PROBLEM_OBSERVATION");
    }

    public List<CCU_I20_PROBLEM_OBSERVATION> getPROBLEM_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM_OBSERVATION", CCU_I20_PROBLEM_OBSERVATION.class);
    }

    public void insertPROBLEM_OBSERVATION(CCU_I20_PROBLEM_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM_OBSERVATION", structure, rep);
    }

    public CCU_I20_PROBLEM_OBSERVATION insertPROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (CCU_I20_PROBLEM_OBSERVATION)super.insertRepetition("PROBLEM_OBSERVATION", rep);
    }

    public CCU_I20_PROBLEM_OBSERVATION removePROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (CCU_I20_PROBLEM_OBSERVATION)super.removeRepetition("PROBLEM_OBSERVATION", rep);
    }
}

