/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.segment.IAM;
import ca.uhn.hl7v2.model.v28.segment.IAR;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A60_ADVERSE_REACTION_GROUP
extends AbstractGroup {
    public ADT_A60_ADVERSE_REACTION_GROUP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IAM.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(IAR.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A60_ADVERSE_REACTION_GROUP - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public IAM getIAM() {
        IAM retVal = this.getTyped("IAM", IAM.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public IAR getIAR() {
        IAR retVal = this.getTyped("IAR", IAR.class);
        return retVal;
    }

    public IAR getIAR(int rep) {
        IAR retVal = this.getTyped("IAR", rep, IAR.class);
        return retVal;
    }

    public int getIARReps() {
        return this.getReps("IAR");
    }

    public List<IAR> getIARAll() throws HL7Exception {
        return this.getAllAsList("IAR", IAR.class);
    }

    public void insertIAR(IAR structure, int rep) throws HL7Exception {
        super.insertRepetition("IAR", structure, rep);
    }

    public IAR insertIAR(int rep) throws HL7Exception {
        return (IAR)super.insertRepetition("IAR", rep);
    }

    public IAR removeIAR(int rep) throws HL7Exception {
        return (IAR)super.removeRepetition("IAR", rep);
    }
}

