/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.segment.OBR;
import ca.uhn.hl7v2.model.v27.segment.OBX;
import ca.uhn.hl7v2.model.v27.segment.ODS;
import ca.uhn.hl7v2.model.v27.segment.PR1;
import ca.uhn.hl7v2.model.v27.segment.RXO;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCR_I16_CLINICAL_ORDER_DETAIL
extends AbstractGroup {
    public CCR_I16_CLINICAL_ORDER_DETAIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, true);
            this.add(RXO.class, true, false, true);
            this.add(ODS.class, true, false, true);
            this.add(PR1.class, true, false, true);
            this.add(OBX.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCR_I16_CLINICAL_ORDER_DETAIL - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public RXO getRXO() {
        RXO retVal = this.getTyped("RXO", RXO.class);
        return retVal;
    }

    public ODS getODS() {
        ODS retVal = this.getTyped("ODS", ODS.class);
        return retVal;
    }

    public PR1 getPR1() {
        PR1 retVal = this.getTyped("PR1", PR1.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

