/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.RSP_K31_RESPONSE;
import ca.uhn.hl7v2.model.v26.segment.DSC;
import ca.uhn.hl7v2.model.v26.segment.ERR;
import ca.uhn.hl7v2.model.v26.segment.MSA;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.QAK;
import ca.uhn.hl7v2.model.v26.segment.QPD;
import ca.uhn.hl7v2.model.v26.segment.RCP;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RSP_K31
extends AbstractMessage {
    public RSP_K31() {
        this(new DefaultModelClassFactory());
    }

    public RSP_K31(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(QAK.class, true, false);
            this.add(QPD.class, true, false);
            this.add(RCP.class, true, false);
            this.add(RSP_K31_RESPONSE.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_K31 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public QPD getQPD() {
        return this.getTyped("QPD", QPD.class);
    }

    public RCP getRCP() {
        return this.getTyped("RCP", RCP.class);
    }

    public RSP_K31_RESPONSE getRESPONSE() {
        return this.getTyped("RESPONSE", RSP_K31_RESPONSE.class);
    }

    public RSP_K31_RESPONSE getRESPONSE(int rep) {
        return this.getTyped("RESPONSE", rep, RSP_K31_RESPONSE.class);
    }

    public int getRESPONSEReps() {
        return this.getReps("RESPONSE");
    }

    public List<RSP_K31_RESPONSE> getRESPONSEAll() throws HL7Exception {
        return this.getAllAsList("RESPONSE", RSP_K31_RESPONSE.class);
    }

    public void insertRESPONSE(RSP_K31_RESPONSE structure, int rep) throws HL7Exception {
        super.insertRepetition("RESPONSE", structure, rep);
    }

    public RSP_K31_RESPONSE insertRESPONSE(int rep) throws HL7Exception {
        return (RSP_K31_RESPONSE)super.insertRepetition("RESPONSE", rep);
    }

    public RSP_K31_RESPONSE removeRESPONSE(int rep) throws HL7Exception {
        return (RSP_K31_RESPONSE)super.removeRepetition("RESPONSE", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

